/*
 * Copyright (c) 1994-97 by Jaroslav Kysela (Perex soft)
 */

#include "version.h"

#define VERSION_AND_COPYRIGHT \
"Version " GUS_VERSION ", Copyright (c) 1994-97 by Jaroslav Kysela (Perex soft)"

#define GUS_CARDS		8	/* number of supported GUS cards - don't change - minor numbers */

#undef __DRIVER_MAIN__
#undef __DRIVER_STRU__

#include "config.h"
#ifndef GUSCFG_MAJOR			/* standard configuration */
#define GUSCFG_MAJOR		14
#endif
#ifdef GUSCFG_ALL
#define GUSCFG_GUSSTD
#define GUSCFG_GUSDB16
#define GUSCFG_GUSMAX
#define GUSCFG_GUSPNP
#endif

#if defined( GUSCFG_GUSSTD )
#define GUSCFG_GF1PCM
#define GUSCFG_ICSMIX
#endif
#if defined( GUSCFG_GUSDB16 ) || defined( GUSCFG_GUSMAX ) || defined( GUSCFG_GUSPNP )
#define GUSCFG_CODEC
#endif
#if defined( GUSCFG_GUSPNP )
#define GUSCFG_PNP
#define GUSCFG_INTERWAVE
#endif
#if defined( GUSCFG_MIDI ) || defined( GUSCFG_USS )
#define GUSCFG_MIDI_DEVICES
#endif

#if !defined( GUSCFG_DEBUG )
#undef GUSCFG_DEBUG_MEMORY
#endif

/*
 *  ==========================================================================
 */

#ifdef LINUX

#define __KERNEL__
#define MODULE

#define LinuxVersionCode( v, p, s ) (((v)<<16)|((p)<<8)|(s))

#include <linux/config.h>
#include <linux/version.h>
#if defined( CONFIG_MODVERSIONS )
#define MODVERSIONS
#include <linux/modversions.h>
#endif
#ifndef GUS_MAIN_OBJECT_FILE
#define __NO_VERSION__
#endif
#include <linux/module.h>

#if LinuxVersionCode( 2, 0, 0 ) > LINUX_VERSION_CODE
#error "This driver is designed only for Linux 2.0.0 and highter."
#endif
#if LinuxVersionCode( 2, 1, 0 ) <= LINUX_VERSION_CODE
#define LINUX_2_1
#endif

#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/malloc.h>

#include <linux/ioport.h>

#include <asm/io.h>
#include <asm/irq.h>
#include <asm/dma.h>
#include <asm/segment.h>
#ifdef LINUX_2_1
#include <asm/uaccess.h>
#endif
#include <asm/system.h>
#include <asm/string.h>

#include <linux/interrupt.h>
#include <linux/fs.h>
#include <linux/fcntl.h>
#ifdef LINUX_2_1
#include <linux/vmalloc.h>
#endif

#ifdef __MAX_POLL_TABLE_ENTRIES		/* new kernel with poll() */
#include <linux/poll.h>
#define GUS_POLL
#else
#undef GUS_POLL
#endif

#if LinuxVersionCode( 2, 1, 35 ) >= LINUX_VERSION_CODE
#define in_interrupt() intr_count
#endif

#include "gus.h"

#define PRINTK printk

#define OUTB( value, reg ) outb( value, reg )
#define OUTW( value, reg ) outw( value, reg )
#define INB( reg ) inb( reg )
#define INW( reg ) inw( reg )
#define OUTSB( reg, ptr, count ) outsb( reg, ptr, count )
#define OUTSW( reg, ptr, count ) outsw( reg, ptr, count )
#define INSB( reg, ptr, count ) insb( reg, ptr, count )
#define INSW( reg, ptr, count ) insw( reg, ptr, count )
static inline void CLI( unsigned long *flags ) { save_flags( *flags ); cli(); }
static inline void STI( unsigned long *flags ) { restore_flags( *flags ); }

#define MB() 			/* 386+ architecture doesn't need io sync */

#define SLEEP_DEFINE( ident ) \
  struct wait_queue *sleeper_##ident; \
  unsigned long end_jiffies_##ident; \
  unsigned short sleeper_lock_##ident;
#define SLEEP_PREPARE( card, ident ) \
  card -> sleeper_##ident = NULL;
#define SLEEP( card, ident, time ) \
  card -> end_jiffies_##ident = current -> timeout = jiffies + time; \
  interruptible_sleep_on( &card -> sleeper_##ident );
#define SLEEPU( card_number, ident, time ) \
  card -> end_jiffies_##ident = current -> timeout = jiffies + time; \
  sleep_on( &card -> sleeper_##ident );
#ifdef GUS_POLL
#define SLEEP_POLL( card, ident, table ) \
  poll_wait( &card -> sleeper_##ident, table )
#else
#define SLEEPS( card, ident, table ) \
  select_wait( &card -> sleeper_##ident, table );
#endif
#define TABORT( ident ) \
  ( current -> signal & ~current -> blocked )
#define WAKEUP( card, ident ) wake_up( &card -> sleeper_##ident );
#define GETLOCK( card, ident ) card -> sleeper_lock_##ident
#define TIMEOUT( card, ident ) ( card -> end_jiffies_##ident < jiffies )
#define TIMEOUT_VALUE( card, ident ) ( card -> end_jiffies_##ident - jiffies )

#define VERIFY_AREA verify_area

#define MEMCPY memcpy
#define MEMSET memset
#define MEMMOVE memmove

#ifdef LINUX_2_1
#define MEMCPY_FROMFS copy_from_user
#define MEMCPY_TOFS copy_to_user
#else
#define MEMCPY_FROMFS memcpy_fromfs
#define MEMCPY_TOFS memcpy_tofs
#endif

#define VMALLOC vmalloc
#define VFREE vfree

#ifdef LINUX_2_1

static inline void put_fs_byte( unsigned char val, char *ptr ) { put_user( val, ptr ); }
static inline void put_fs_word( unsigned short val, short *ptr ) { put_user( val, ptr ); }
static inline unsigned char get_fs_byte( unsigned char *ptr ) { unsigned char val; get_user( val, ptr ); return val; }
static inline unsigned short get_fs_word( unsigned short *ptr ) { unsigned short val; get_user( val, ptr ); return val; }

#else

#define get_fs_int		get_fs_long
#define put_fs_int		put_fs_long

#endif

#define IOCTL_IN( arg )		gus_ioctl_in( (long *)arg )
#define IOCTL_OUT( arg, val )	gus_ioctl_out( (long *)arg, val )

#define SA_GUS_FLAGS		(SA_INTERRUPT)
#define gus_request_irq		request_irq
#define gus_free_irq		free_irq

#else

#error Unknown system!!!

#endif

/*
 *  ==========================================================================
 */

#include "misc.h"
#include "stru.h"
#define __DRIVER_MAIN__
#include "gf1.h"
#include "codec.h"
#include "runtime_conf.h"

#define SNDSTAT_STRING \
"GUS driver - compatibility text for gmod : 3.0\n"

/* MINOR numbers */ 

/*
 * Now is minor numbers same as in OSS (lite). We doesn't now swap
 * device numbers if we use both drivers in one system.
 * Thanks to Dan Merillat for his idea.
 */

#define GUS_MINOR_MIXER		0	/* /dev/mixer - OSS 3.XX compatible */
#ifdef GUSCFG_USS
#define GUS_MINOR_SEQUENCER	1	/* /dev/sequencer - OSS 3.XX compatible */
#define	GUS_MINOR_MIDI		2	/* /dev/midi - native midi interface - USS 3.XX compatible */
#endif
#define GUS_MINOR_PCM_8		3	/* /dev/dsp - 8bit PCM - OSS 3.XX compatible */
#define GUS_MINOR_AUDIO		4	/* /dev/audio - SunSparc compatible */
#define GUS_MINOR_PCM_16	5	/* /dev/dsp16 - 16bit PCM - OSS 3.XX compatible */
#define GUS_MINOR_SNDSTAT	6	/* /dev/sndstat - for compatibility with USS */
#undef  GUS_MINOR_RESERVED7	7	/* reserved for future use */
#ifdef GUSCFG_USS
#define GUS_MINOR_MUSIC		8	/* /dev/music - OSS 3.XX compatible */
#endif

#define GUS_MINOR_USS_MASK	0x000f

#define GUS_MINOR_GBEGIN	192

#define GUS_MINOR_GDEVMASK	0x07
#define GUS_MINOR_GSYNTH	(192/8)	/* /dev/gusX - gus synth */
#define GUS_MINOR_GSYNTH_CTL	(200/8)	/* /dev/gusctlX - gus synth control */
#define GUS_MINOR_GINSMAN	(208/8)	/* /dev/insmanX - instrument manager */
#define GUS_MINOR_GMIXER	(216/8)	/* /dev/gusmixerX - gus mixer */
#define GUS_MINOR_GPCM		(224/8)	/* /dev/guspcmX - gus pcm */
#define GUS_MINOR_GMIDI_RAW	(232/8)	/* /dev/gusmidiX - gus midi raw */

#define GUS_MINOR_GMIDI		240	/* /dev/gusmidi - gus midi */
#define GUS_MINOR_GINFO		255	/* /dev/gusinfo - show information about gus device driver */

/* sleep & wakeup state */

#define WK_NONE			0x00
#define WK_LOCK			0x01		/* lock this DMA channel */
#define WK_WAKEUP		0x02		/* DMA transfer done */
#define WK_SLEEP		0x04		/* DMA sleep */

/* kernel / user space */

#define SP_KERNEL		0x00
#define SP_USER			0x01
#define SP_KERNEL_WAVE_USER	0x02		/* special for USS Sequencer */

/* --- */

struct gus_info_buffer {
  int stop;
  char *buffer;
  char *curr;
  unsigned int size;
};

typedef struct gus_info_buffer gus_info_buffer_t;

/* device.c */

extern int gus_ioctl_in( long *addr );
extern int gus_ioctl_out( long *addr, int value );

/* memory.c */

extern void gus_malloc_init( void );
extern void gus_malloc_done( void );
extern void *gus_malloc( unsigned long size );
extern void gus_free( void *obj, unsigned long size );
extern char *gus_malloc_strdup( char *string, int space );
extern void gus_free_str( char *string );
extern char *gus_malloc_pages( unsigned long size, int *pg, int dma );
extern void gus_free_pages( char *ptr, unsigned long size );
extern int gus_dma_malloc( gus_card_t *card, int dma_number, char *owner, int lock );
extern void gus_dma_free( gus_card_t *card, int dma_number, int lock );
extern void gus_memory_info( gus_info_buffer_t *buffer );
#ifdef GUSCFG_DEBUG_MEMORY
extern void gus_memory_debug( gus_info_buffer_t *buffer );
#endif

/* init.c */

extern int gus_cards_count;
extern gus_card_t *gus_cards[ GUS_CARDS ];
extern gus_card_t *gus_cards_irq_index[ 16 ];

extern void gus_driver_init( void );
extern void gus_card_init( gus_card_t *card, struct GUS_STRU_CFG *cfg, int card_number );
extern int gus_probe( gus_card_t *card );
extern int gus_init_pre( gus_card_t *card );
extern int gus_init( gus_card_t *card );
extern void gus_done( gus_card_t *card );
#ifdef GUSCFG_INTERWAVE
extern void gus_init_set_enhanced_mode( gus_card_t *card, int enable );
#endif
extern void gus_init_set_pcm_memory( gus_card_t *card, int enable );
#ifdef GUSCFG_INTERWAVE
extern void gus_init_set_pcm_fifo( gus_card_t *recrd, int record, int value );
#endif
extern int gus_info( gus_card_t *card, gus_mem_t *alloc, struct GUS_STRU_INFO *info );
extern int get_info_init( gus_info_buffer_t *buffer );

/* gus_irq.c */

extern int gus_intr_count;
extern void gus_int_disable__1( void );
extern void gus_int_enable__1( void );

static inline void gus_int_disable( void )
{
  if ( !gus_intr_count )
    gus_int_disable__1();
}

static inline void gus_int_enable( void )
{
  if ( !gus_intr_count )
    gus_int_enable__1();
}

extern void gus_interrupt( int irq, void *dev_id, struct pt_regs *regs );
#ifdef GUSCFG_GUSDB16
extern void gus_interrupt_db16( int irq, void *dev_id, struct pt_regs *regs );
#endif

/* gf1_engine.c */

extern void gus_engine_init( gus_card_t *card );
extern void gus_engine_voice_program( gus_card_t *card, gus_voice_t *voice, unsigned int program );
extern void gus_engine_channel_program( gus_card_t *card, gus_channel_t *channel, unsigned int program );
extern void gus_engine_channel_program_drum( gus_card_t *card, gus_channel_t *channel, unsigned int program );
extern gus_voice_t *gus_voice_alloc( gus_card_t *card, gus_note_t *note, unsigned char priority, void (*steal_notify)( gus_card_t *card, gus_voice_t *voice ) );
extern void gus_voice_free( gus_card_t *card, gus_voice_t *voice );
extern gus_note_t *gus_note_alloc( gus_card_t *card, gus_channel_t *channel );
extern void gus_note_free( gus_card_t *card, gus_note_t *note );
extern void gus_voice_and_note_free( gus_card_t *card, gus_voice_t *voice );
extern void gus_engine_process_effects( gus_card_t *card );
extern void gus_engine_process_voices( gus_card_t *card );
extern void gus_engine_midi_go_note_stop( gus_card_t *card, gus_note_t *note, int wait );
extern void gus_engine_midi_go_note_off( gus_card_t *card, gus_note_t *note );
extern void gus_engine_midi_note_on( gus_card_t *card, gus_channel_t *channel, unsigned char note, unsigned char volume, unsigned char priority );
extern void gus_engine_midi_note_off( gus_card_t *card, gus_channel_t *channel, unsigned char note, unsigned char volume );
extern void gus_engine_midi_recompute_volume( gus_card_t *card, gus_channel_t *channel );
extern void gus_engine_midi_pitchbend( gus_card_t *card, gus_channel_t *channel, unsigned short pitchbend );
extern void gus_engine_midi_control( gus_card_t *card, gus_channel_t *channel, unsigned char p1, unsigned char p2 );
extern void gus_engine_voices_init( gus_card_t *card, int soft );
extern int gus_engine_reset( gus_card_t *card, int voices, unsigned int dynamic );
extern int gus_engine_reset_voices( gus_card_t *card, int voices, unsigned int dynamic, int soft );
extern void gus_engine_invalidate_instrument( gus_card_t *card, gus_instrument_t *instrument );
extern int gus_engine_set_ultraclick( gus_card_t *card, gus_ultraclick_t *ultraclick, int space );
extern int gus_engine_get_ultraclick( gus_card_t *card, gus_ultraclick_t *ultraclick, int space );
extern int gus_engine_open( gus_card_t *card );
extern void gus_engine_close( gus_card_t *card );

/* gf1_synth.c */
 
extern void gus_gf1_process_events( gus_card_t *card );

extern int gus_ioctl_gf1( struct file *file, unsigned int cmd, unsigned long arg );
extern int gus_open_gf1( unsigned short minor, struct file *file );
extern void gus_release_gf1( struct file *file );
extern int gus_read_gf1( struct file *file, char *buf, int count );
extern int gus_write_gf1( struct file *file, char *buf, int count );
#ifdef GUS_POLL
extern unsigned int gus_poll_gf1( struct file *file, poll_table *wait );
#else
extern int gus_select_gf1( struct file *file, int sel_type, select_table *wait );
#endif

extern int gus_ioctl_gf1_ctl( struct file *file, unsigned int cmd, unsigned long arg );
extern int gus_open_gf1_ctl( unsigned short minor, struct file *file );
extern void gus_release_gf1_ctl( struct file *file );
extern int gus_read_gf1_ctl( struct file *file, char *buf, int count );
extern int gus_write_gf1_ctl( struct file *file, char *buf, int count );

#ifdef GUSCFG_USS
extern int gus_seq_read_gf1( struct file *file, char *buf, int count );
#endif

/* gf1_simple.c */

extern void gus_gf1_simple_init( gus_card_t *card );

/* gf1_patch.c */

extern void gus_gf1_patch_init( gus_card_t *card );

/* gf1_interwave.c */

extern void gus_gf1_interwave_init( gus_card_t *card );

/* gf1_utils.c */

extern unsigned short gus_lvol_to_gvol_raw( unsigned int vol );
extern unsigned int gus_gvol_to_lvol_raw( unsigned short gf1_vol );
extern unsigned short gus_translate_freq( gus_card_t *card, unsigned int freq2 );
extern unsigned short gus_translate_voice_volume( gus_card_t *card, unsigned short volume );
extern short gus_compute_vibrato( short cents, unsigned short fc_register );
extern unsigned short gus_compute_pitchbend( unsigned short pitchbend, unsigned short sens );
extern unsigned short gus_compute_freq( unsigned int freq, unsigned int rate, unsigned short mix_rate );
extern unsigned int gus_compute_patch_rate( gus_wave_t *wave );
extern gus_wave_t *gus_select_patch_wave( gus_wave_t *start, unsigned int freq );
extern void gus_gf1_init_dma_transfer( gus_card_t *card, unsigned int addr, unsigned char *buf, int count, short w_unsigned, short w_16bit );
extern void gus_gf1_done_dma_transfer( gus_card_t *card );
extern void gus_gf1_init_rdma_transfer( gus_card_t *card, unsigned char *buf, int count, unsigned char rctrl_reg );
extern void gus_gf1_done_rdma_transfer( gus_card_t *card );
extern void gus_set_effects_volume( gus_card_t *card, gus_voice_t *voice, unsigned short one, unsigned short three, int both );

/* gf1_lfo.c */

extern void gus_lfo_effect_interrupt( gus_card_t *card, gus_voice_t *voice );
extern void gus_lfo_init( gus_card_t *card );
extern void gus_lfo_done( gus_card_t *card );
extern void gus_lfo_program( gus_card_t *card, int voice, int lfo_type, struct GUS_STRU_IW_LFO_PROGRAM *program );
extern void gus_lfo_enable( gus_card_t *card, int voice, int lfo_type );
extern void gus_lfo_disable( gus_card_t *card, int voice, int lfo_type );
extern void gus_lfo_change_freq( gus_card_t *card, int voice, int lfo_type, int freq );
extern void gus_lfo_change_depth( gus_card_t *card, int voice, int lfo_type, int depth );
extern void gus_lfo_setup( gus_card_t *card, int voice, int lfo_type, int freq, int current_depth, int depth, int sweep, int shape );
extern void gus_lfo_shutdown( gus_card_t *card, int voice, int lfo_type );
extern void gus_lfo_command( gus_card_t *card, int voice, unsigned char *command );

/* gf1_effects */
extern int gus_effects_reset( gus_card_t *card );
extern int gus_effects_setup( gus_card_t *card, struct GUS_STRU_EFFECT *effects, int space );

/* gf1_timer.c */

extern void gus_gf1_timer_init( gus_card_t *card );
extern int gus_timer_set_master( gus_card_t *master );
extern int gus_timer_res_master( gus_card_t *master );
extern int gus_timer_set_slave( gus_card_t *master, gus_card_t *slave );
extern int gus_timer_res_slave( gus_card_t *master, gus_card_t *slave );
extern void gus_timer_wait( gus_card_t *card );
extern void gus_timer_restart( gus_card_t *card );
extern int gus_timer_base( gus_card_t *card, int base );
extern int gus_timer_tempo( gus_card_t *card, int tempo );
extern int gus_timer_ioctl( gus_card_t *card, unsigned int cmd, unsigned long arg );
extern int gus_timer_open( gus_card_t *card, char *owner );
extern void gus_timer_close( gus_card_t *card );
extern void gus_timer_info( gus_card_t *card, gus_info_buffer_t *buffer );

/* gf1_memory.c */

extern unsigned gus_memory_manager_malloc( gus_card_t *card, gus_mem_t *alloc, char *name, int size, int w_16, int align );
extern int gus_memory_manager_mfree( gus_card_t *card, gus_mem_t *alloc, unsigned int address );
extern int gus_memory_init( gus_card_t *card, gus_mem_t *alloc );
extern int gus_memory_done( gus_card_t *card, gus_mem_t *alloc );
extern int gus_memory_reset( gus_card_t *card, gus_mem_t *alloc, int mode, int close_flag );
extern void gus_memory_reset_daemon( gus_card_t *card, gus_mem_t *alloc, int close_flag );
extern unsigned int gus_memory_free_size( gus_card_t *card, gus_mem_t *alloc );
extern unsigned int gus_memory_free_block( gus_card_t *card, gus_mem_t *alloc, short w_16 );
extern void gus_download_over_poke( gus_card_t *card, unsigned int mem_ptr, unsigned char *ptr, unsigned int length, unsigned short invert, unsigned short w_16, int space );
extern void gus_download_over_dma( gus_card_t *card, unsigned int mem_ptr, unsigned char *ptr, unsigned int length, unsigned short invert, unsigned short w_16, int space );
extern int gus_memory_block_alloc( gus_card_t *card, struct GUS_STRU_MEMORY_BLOCK *block, int lock, int space );
extern int gus_memory_block_free( gus_card_t *card, struct GUS_STRU_MEMORY_BLOCK *block, int lock, int space );
extern int gus_memory_get_name( gus_card_t *card, gus_mem_t *alloc, struct GUS_STRU_INSTRUMENT_NAME *instrument, int space );
extern int gus_memory_list( gus_card_t *card, gus_mem_t *alloc, struct GUS_STRU_MEMORY_LIST *list, int space );
extern int gus_memory_alloc( gus_card_t *card, gus_mem_t *alloc, struct GUS_STRU_INSTRUMENT *instrument, int test_mode, int space );
extern int gus_memory_free( gus_card_t *card, gus_mem_t *alloc, struct GUS_STRU_INSTRUMENT *instrument, int space );
extern int gus_memory_pack( gus_card_t *card, gus_mem_t *alloc );
extern int gus_memory_dump( gus_card_t *card, struct GUS_STRU_MEMORY_DUMP *dump, int space );
extern gus_instrument_t *gus_instrument_look( gus_mem_t *alloc, unsigned int instrument );
#ifdef GUSCFG_DEBUG_MEMORY
extern void gus_memory_manager_debug( gus_card_t *card, gus_info_buffer_t *buffer, gus_mem_t *alloc );
#endif
#ifdef GUSCFG_DEBUG_INSTRUMENTS
extern void gus_memory_debug_instruments( gus_card_t *card, gus_info_buffer_t *buffer, gus_mem_t *alloc );
#endif

/* gf1_reset.c */

extern void gus_set_default_handlers( gus_card_t *card, unsigned int what );
extern void gus_gf1_ignore_irq_status( gus_card_t *card, unsigned char status );
extern void gus_gf1_smart_stop_voice( gus_card_t *card, short voice );
extern void gus_gf1_stop_voice( gus_card_t *card, short voice );
extern void gus_gf1_clear_voices( gus_card_t *card, short v_min, short v_max );
extern void gus_gf1_stop_voices( gus_card_t *card, short v_min, short v_max );
extern int gus_gf1_start( gus_card_t *card );
extern void gus_gf1_stop( gus_card_t *card );
extern void gus_gf1_open( gus_card_t *card, unsigned short mode );
extern void gus_gf1_close( gus_card_t *card, unsigned short mode );

/* gf1_daemon.c */

extern int gus_gf1_daemon_request_sample( gus_card_t *card, unsigned int instrument );
extern void gus_gf1_daemon_preload( gus_card_t *card, char *bank_name );
extern void gus_gf1_daemon_midi_emul_change( gus_card_t *card );
extern void gus_gf1_daemon_free_block( gus_card_t *card );
#ifdef GUSCFG_USS
extern void gus_gf1_daemon_iw_effect( gus_card_t *card );
#endif
extern void gus_gf1_daemon_wait( gus_card_t *card );

extern void gus_gf1_daemon_init( gus_card_t *card );
extern int gus_open_gf1_daemon( unsigned short minor, struct file *file );
extern void gus_release_gf1_daemon( struct file *file );
extern int gus_ioctl_gf1_daemon( struct file *file, unsigned int cmd, unsigned long arg );
extern int gus_read_gf1_daemon( struct file *file, char *buf, int count );
extern int gus_write_gf1_daemon( struct file *file, char *buf, int count );
#ifdef GUS_POLL
extern unsigned int gus_poll_gf1_daemon( struct file *file, poll_table *wait );
#else
extern int gus_select_gf1_daemon( struct file *file, int sel_type, select_table *wait );
#endif

/* mixer.c */

extern void gus_mixer_init( gus_card_t *card );
extern void mixer_init( gus_card_t *card );
extern void codec_set_mute( gus_card_t *card, unsigned char dev, short left, short right );
extern int gus_ioctl_mixer( gus_card_t *card, struct file *file, unsigned int cmd, unsigned long arg );
extern int gus_open_mixer( unsigned short minor, struct file *file );
extern void gus_release_mixer( struct file *file );
extern void gus_mixer_update_level( gus_card_t *card, int device, int left, int right, int lmute, int rmute );

/* pcm.c */

extern void gus_pcm_init( gus_card_t *card );
extern void gus_pcm_set_dma_struct( gus_card_t *card, int dma_number, struct GUS_STRU_PCM_CHANNEL *pchn );
extern int gus_ioctl_pcm( struct file *file, unsigned int cmd, unsigned long arg );
extern int gus_open_pcm( unsigned short minor, struct file *file );
extern void gus_release_pcm( struct file *file );
extern int gus_read_pcm( struct file *file, char *buf, int count );
extern int gus_write_pcm( struct file *file, char *buf, int count );
#ifdef GUS_POLL
extern unsigned int gus_poll_pcm( struct file *file, poll_table *wait );
#else
extern int gus_select_pcm( struct file *file, int sel_type, select_table *wait );
#endif
extern int gus_mmap_pcm( struct inode *inode, struct file *file, struct vm_area_struct *vma );
extern void gus_pcm_info( gus_card_t *card, gus_info_buffer_t *buffer );

/* gf1_pcm.c */

#ifdef GUSCFG_GF1PCM
extern void gus_init_gf1_pcm( gus_card_t *card );
extern void gus_gf1_pcm_volume_update( gus_card_t *card );
extern void gus_gf1_pcm_interrupt( gus_card_t *card, unsigned char status, short only_sampling );
#endif

/* codec_pcm.c */

#ifdef GUSCFG_CODEC
extern void gus_init_codec_pcm( gus_card_t *card, int image );
extern int codec_init( gus_card_t *card );
extern void codec_interrupt( gus_card_t *card, unsigned char status );
extern void gus_codec_info( gus_card_t *card, gus_info_buffer_t *buffer );
#endif

/* midi.c */

#ifdef GUSCFG_MIDI_DEVICES
extern void gus_init_midi( gus_card_t *card );
extern void gus_midi_interrupt( void );
extern int gus_open_midi( struct file *file );
extern void gus_release_midi( struct file *file );
extern int gus_ioctl_midi( struct file *file, unsigned int cmd, unsigned long arg );
extern int gus_read_midi( struct file *file, char *buf, int count );
extern int gus_write_midi( struct file *file, char *buf, int count );
#ifdef GUS_POLL
extern unsigned int gus_poll_midi( struct file *file, poll_table *wait );
#else
extern int gus_select_midi( struct file *file, int sel_type, select_table *wait );
#endif
#endif

/* gf1_midi.c */

#ifdef GUSCFG_MIDI_DEVICES
extern int gus_gf1_midi_engine_reset( gus_card_t *card );
extern void gus_init_gf1_midi( gus_card_t *card );
#endif

/* gf1_uart.c */

#ifdef GUSCFG_MIDI
extern void gf1_uart_interrupt( gus_card_t *card, unsigned char status );
extern void gus_init_gf1_uart( gus_card_t *card );
#endif

/* info.c */

extern int gus_iprintf( gus_info_buffer_t *buffer, char *fmt, ... );
extern int gus_read_info( char *buf, off_t *offset, int count );
extern int gus_write_info( char *buf, int count );
extern int gus_open_info( void );
extern void gus_release_info( void );
extern int gus_read_sndstat( char *buf, off_t *offset, int count );
extern int gus_open_sndstat( void );
extern void gus_release_sndstat( void );

/* sequencer.c */

#ifdef GUSCFG_USS
extern void gus_sequencer_init( gus_card_t *card );
extern void gus_sequencer_tick( void );
extern void gus_sequencer_process_events( int timer );
extern int gus_lseek_sequencer( struct file *file, off_t offset, int orig );
extern int gus_read_sequencer( struct file *file, char *buf, int count );
extern int gus_write_sequencer( struct file *file, char *buf, int count );
extern int gus_open_sequencer( unsigned short minor, struct file *file );
extern void gus_release_sequencer( struct file *file );
#ifdef GUS_POLL
extern unsigned int gus_poll_sequencer( struct file *file, poll_table *wait );
#else
extern int gus_select_sequencer( struct file *file, int sel_type, select_table *wait );
#endif
extern int gus_ioctl_sequencer( struct file *file, unsigned int cmd, unsigned long arg );
extern void gus_sequencer_info( gus_info_buffer_t *buffer );
extern int gus_open_oss_midi( unsigned short minor, struct file *file );
extern void gus_release_oss_midi( struct file *file );
#endif

/* --- */

#ifdef GUSCFG_DEBUG
#define PRINTD( args... ) PRINTK( ##args )
#else
#define PRINTD( args... ) /* nothing */
#endif
