/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 */

#ifdef GUSCFG_CODEC


#ifdef __DRIVER_STRU__

struct GUS_STRU_CODEC_IMAGE {
  unsigned char lic;			/* left input control register */
  unsigned char ric;			/* right input control register */
  unsigned char la1ic;			/* left GF1 input control register */
  unsigned char ra1ic;			/* right GF1 input control register */
  unsigned char la2ic;			/* left CD input control register */
  unsigned char ra2ic;			/* right CD input control register */
  unsigned char loc;			/* left output control register */
  unsigned char roc;			/* right output control register */
  unsigned char pdfr;			/* clock and data format - playback */
  unsigned char ic;			/* interface control */
  unsigned char pc;			/* pin control */
  unsigned char ti;			/* test and initialization */
  unsigned char mi;			/* miscellaneaous information */
  unsigned char lbc;			/* digital mix */
  unsigned char pbru;			/* playback upper base count */
  unsigned char pbrl;			/* playback lower base count */
  unsigned char afei;			/* alternate #1 feature enabled */
  unsigned char afeii;			/* alternate #2 feature enabled */
  unsigned char llic;			/* left line input control */
  unsigned char rlic;			/* right line input control */
  unsigned char tlb;			/* timer low byte */
  unsigned char thb;			/* timer high byte */
  unsigned char la3ic;			/* left MIC input control register (PnP only) */
  unsigned char ra3ic;			/* right MIC input control register (PnP only) */
  unsigned char afs;			/* irq status register */
  unsigned char lamic;			/* left line output control register (PnP only) */
  unsigned char mioc;			/* mono input/output control */
  unsigned char ramic;			/* right line output control register (PnP only) */
  unsigned char cdfr;			/* clock and data format - record */
  unsigned char pdfr_var;	 	/* playback variable frequency */
  unsigned char cbru;			/* record upper count */
  unsigned char cbrl;			/* record lower count */
};

/* defines for codec.mode */

#define CODEC_MODE_NONE         0x0000
#define CODEC_MODE_PLAY		0x0001
#define CODEC_MODE_RECORD	0x0002
#define CODEC_MODE_OPEN		(CODEC_MODE_PLAY|CODEC_MODE_RECORD)

struct GUS_STRU_CODEC {
  unsigned int port;		/* port of CODEC chip */
  unsigned short irq;		/* IRQ number of CODEC chip */
  unsigned char version;	/* version of CODEC chip */
  unsigned short mode;		/* see to CODEC_MODE_XXXX */
  struct GUS_STRU_CODEC_IMAGE image;

  /* needed by codec_pcm.c */

#ifdef GUSCFG_INTERRUPTS_PROFILE
  unsigned int interrupt_stat_playback;
  unsigned int interrupt_stat_record;
  unsigned int interrupt_stat_timer;
#endif
  unsigned int record_overflow;

  unsigned short pflags;
  unsigned short rflags;

  int mce_bit;

  int playback_fifo_size;		/* -1 = disabled */
  int record_fifo_size;			/* -1 = disabled */
  gus_mem_block_t *playback_fifo_block;
  gus_mem_block_t *record_fifo_block;
  unsigned short interwave_fifo_reg;
  unsigned char interwave_serial_port;
};
                        
#endif /* __DRIVER_STRU__ */


#ifdef __DRIVER_MAIN__

/* IO ports */

#define CODECP( card, x ) ( card -> codec.port + c_d_c_CODEC##x )

#define c_d_c_CODECREGSEL	0
#define c_d_c_CODECREG		1
#define c_d_c_CODECSTATUS	2
#define c_d_c_CODECPIO		3

/* codec registers */

#define CODEC_LEFT_INPUT	0x00	/* left input control register */
#define CODEC_RIGHT_INPUT	0x01	/* right input control register */
#define CODEC_GF1_LEFT_INPUT	0x02	/* left GF1 input control register */
#define CODEC_GF1_RIGHT_INPUT	0x03	/* right GF1 input control register */
#define CODEC_CD_LEFT_INPUT	0x04	/* left CD input control register */
#define CODEC_CD_RIGHT_INPUT	0x05	/* right CD input control register */
#define CODEC_LEFT_OUTPUT	0x06	/* left output control register */
#define CODEC_RIGHT_OUTPUT	0x07	/* right output control register */
#define CODEC_PLAYBK_FORMAT	0x08	/* clock and data format - playback */
#define CODEC_IFACE_CTRL	0x09	/* interface control */
#define CODEC_PIN_CTRL		0x0a	/* pin control */
#define CODEC_TEST_INIT		0x0b	/* test and initialization */
#define CODEC_MISC_INFO		0x0c	/* miscellaneaous information */
#define CODEC_LOOPBACK		0x0d	/* digital mix */
#define CODEC_PLY_UPR_CNT	0x0e	/* playback upper base count */
#define CODEC_PLY_LWR_CNT	0x0f	/* playback lower base count */
#define CODEC_ALT_FEATURE_1	0x10	/* alternate #1 feature enabled */
#define CODEC_ALT_FEATURE_2	0x11	/* alternate #2 feature enabled */
#define CODEC_LEFT_LINE_IN	0x12	/* left line input control */
#define CODEC_RIGHT_LINE_IN	0x13	/* right line input control */
#define CODEC_TIMER_LOW		0x14	/* timer low byte */
#define CODEC_TIMER_HIGH	0x15	/* timer high byte */
#define CODEC_LEFT_MIC_INPUT	0x16	/* left MIC input control register (PnP only) */
#define CODEC_RIGHT_MIC_INPUT	0x17	/* right MIC input control register (PnP only) */
#define CODEC_IRQ_STATUS	0x18	/* irq status register */
#define CODEC_LINE_LEFT_OUTPUT	0x19	/* left line output control register (PnP only) */
#define CODEC_MONO_CTRL		0x1a	/* mono input/output control */
#define CODEC_LINE_RIGHT_OUTPUT	0x1b	/* right line output control register (PnP only) */
#define CODEC_REC_FORMAT	0x1c	/* clock and data format - record */
#define CODEC_PLY_VAR_FREQ	0x1d	/* playback variable frequency */
#define CODEC_REC_UPR_CNT	0x1e	/* record upper count */
#define CODEC_REC_LWR_CNT	0x1f	/* record lower count */

/* some redefinitions for me */

#define CODEC_INPUT		CODEC_LEFT_INPUT
#define CODEC_GF1_INPUT		CODEC_GF1_LEFT_INPUT
#define CODEC_CD_INPUT		CODEC_CD_LEFT_INPUT
#define CODEC_OUTPUT		CODEC_LEFT_OUTPUT
#define CODEC_LINE_INPUT	CODEC_LEFT_LINE_IN
#define CODEC_MIC_INPUT		CODEC_MONO_CTRL
#define CODEC_MICE_INPUT	CODEC_LEFT_MIC_INPUT	/* stereo MIC */
#define CODEC_MASTER_OUTPUT	CODEC_LINE_LEFT_OUTPUT

/* definitions for codec register select port - CODECP( REGSEL ) */

#define CODEC_INIT		0x80	/* CODEC is initializing */
#define CODEC_MCE		0x40	/* mode change enable */
#define CODEC_TRD		0x20	/* transfer request disable */

/* definitions for codec irq status */

#define CODEC_PLAYBACK_IRQ	0x10
#define CODEC_RECORD_IRQ	0x20
#define CODEC_TIMER_IRQ		0x40
#define CODEC_ALL_IRQS		0x70

/* definitions for CODEC_LEFT_INPUT and CODEC_RIGHT_INPUT registers */

#define CODEC_ENABLE_MIC_GAIN	0x20

#define CODEC_MIXS_LINE		0x00
#define CODEC_MIXS_GF1		0x40
#define CODEC_MIXS_MIC		0x80
#define CODEC_MIXS_BOTH		0xc0

/* definitions for clock and data format register - CODEC_PLAYBK_FORMAT */

#define CODEC_LINEAR_8		0x00	/* 8-bit unsigned data */
#define CODEC_ALAW_8		0x60	/* 8-bit A-law companded */
#define CODEC_ULAW_8		0x20	/* 8-bit U-law companded */
#define CODEC_LINEAR_16		0x40	/* 16-bit twos complement data - little endian */
#define CODEC_LINEAR_16_BIG	0xc0	/* 16-bit twos complement data - big endian */
#define CODEC_ADPCM_16		0xa0	/* 16-bit ADPCM */
#define CODEC_STEREO		0x10	/* stereo mode */
/* bits 3-1 define frequency divisor */
#define CODEC_XTAL1		0x00	/* 24.576 crystal */
#define CODEC_XTAL2		0x01	/* 16.9344 crystal */

/* definitions for interface control register - CODEC_IFACE_CTRL */

#define CODEC_RECORD_PIO	0x80	/* record PIO enable */
#define CODEC_PLAYBACK_PIO	0x40	/* playback PIO enable */
#define CODEC_AUTOCALIB		0x08	/* auto calibrate */
#define CODEC_SINGLE_DMA	0x04	/* use single DMA channel */
#define CODEC_RECORD_ENABLE	0x02	/* record enable */
#define CODEC_PLAYBACK_ENABLE	0x01	/* playback enable */

/* definitions for pin control register - CODEC_PIN_CTRL */

#define CODEC_IRQ_ENABLE	0x02	/* enable IRQ */
#define CODEC_XCTL1		0x40	/* external control #1 */
#define CODEC_XCTL0		0x80	/* external control #0 */

/* definitions for test and init register - CODEC_TEST_INIT */

#define CODEC_CALIB_IN_PROGRESS 0x20	/* auto calibrate in progress */

/* definitions for misc control register - CODEC_MISC_INFO */

#define CODEC_MODE2		0x40	/* MODE 2 */
#define CODEC_MODE3		0x6c	/* MODE 3 - enhanced mode */

/* definitions for alternate feature 1 register - CODEC_ALT_FEATURE_1 */

#define	CODEC_DACZ		0x01	/* zero DAC when underrun */
#define CODEC_TIMER_ENABLE	0x40	/* codec timer enable */
#define CODEC_OLB		0x80	/* output level bit */

/* some structures */

struct GUS_STRU_CODEC_FREQ {
  unsigned int hertz;
  unsigned int rate;
  unsigned char bits;
};

/* some functions */

extern void codec_outm( gus_card_t *card, unsigned char reg, unsigned char mask, unsigned char value );
extern void codec_out( gus_card_t *card, unsigned char reg, unsigned char value );
extern unsigned char codec_in( gus_card_t *card, unsigned char reg );

#ifdef GUSCFG_DEBUG
extern void codec_debug( gus_card_t *card );
#endif

#endif /* __DRIVER_MAIN__ */


#endif /* GUSCFG_CODEC */
