/*
 *  instrument configuration header file
 */

#include <stdarg.h>
#include "../../../../include/libgus.h"
#include "../../../../include/gusfiles.h"

/* defines */

#define IT_NONE			0x0000
#define IT_GF1_PATCH		0x0001
#define IT_IW_ROM		0x0002
#define IT_IW_FILE		0x0003
#define IT_COUNT		3

/* configuration structures */

struct gf1path {
  char *path;
  struct gf1path *next;
};

#define IWF_DOWNLOAD		0x0001
#define IWF_ROM			0x0002
#define IWF_TEMP		0x0004

struct iwfile {
  unsigned short flags;
  unsigned short number;
  int handle;
  union {
    struct {
      unsigned char *name;
      unsigned char *data;
    } file;
    struct {
      unsigned short bank;
      unsigned short file;
      unsigned char *name;
    } rom;
  } spec;
  struct iwfile *next;
};

#define IF_NONE			0x0000
#define IF_ALIAS		0x0001
#define IF_8BIT			0x0002
#define IF_PATCH_DISABLE	((1 << IT_GF1_PATCH) << 7)
#define IF_IWROM_DISABLE	((1 << IT_IW_ROM) << 7)
#define IF_IWFILE_DISABLE	((1 << IT_IW_FILE) << 7)
#define IF_DISABLE_ALL		(IF_PATCH_DISABLE|IF_IWROM_DISABLE|IF_IWFILE_DISABLE)
#define IF_DISABLED( x )	((1 << x) << 7)

#define IFA_PATCH		(1 << IT_GF1_PATCH)
#define IFA_IWROM		(1 << IT_IW_ROM)
#define IFA_IWFILE		(1 << IT_IW_FILE)
#define IFA_TEST( x )		(1 << x)

struct instrument {
  unsigned char *name;
  unsigned short number;
  unsigned short flags;
  union {
    struct {
      unsigned short aliases;
      union {
        struct {
          unsigned char filename[ 8 ];
          unsigned char exclusion;
          unsigned short exclusion_group;
        } spec;
        struct {
          unsigned short bank;
          unsigned short prog;
        } alias;
      } patch;
      union {
        struct {
          unsigned short file;
          unsigned char bank;
          unsigned char prog;
        } spec;
        struct {
          unsigned short bank;
          unsigned short prog;
        } alias;
      } iwrom;
      union {
        struct {
          unsigned short file;
          unsigned char bank;
          unsigned char prog;
        } spec;
        struct {
          unsigned short bank;
          unsigned short prog;
        } alias;
      } iwfile;
    } spec;
    struct {
      unsigned short bank;
      unsigned short prog;
    } alias;
  } data;
  struct instrument *next;
}; 

#define BF_NONE			0x0000
#define BF_PARENT		0x0001

struct bank {
  unsigned char *name;
  unsigned short number;
  unsigned short flags;
  unsigned short parent;
  unsigned short preffered[ IT_COUNT ];
  struct instrument *first;
  struct bank *next;
};

struct preload_download {
  unsigned short bank;
  unsigned short min, max;
  struct preload_download *next;
};

struct preload_aliases {
  unsigned short bank;
  unsigned short min, max;
  unsigned short dest_bank;
  unsigned short dest_prog;
  struct preload_aliases *next;
};

#define PF_NONE			0x0000
#define PF_8BIT 		0x0001
#define PF_FFFF_WHOLE		0x0002

struct preload_format {
  unsigned short type;		/* see to IT_XXXX constants */
  unsigned short flags;		/* see to PF_XXXX constants */
  struct preload_download *download;
  struct preload_aliases *aliases;
  union {
#if 0
    struct {
    } patch;
#endif
    struct {
      unsigned short file;
    } iwrom;
    struct {
      unsigned short file;
    } iwfile;
  } spec;
  struct preload_format *next;
};

struct preload {
  unsigned char *name;
  struct preload_format *formats;
  struct preload *next;
};

struct gus_icfg_config {
  char *filename;
  struct bank *banks;
  struct gf1path *gf1_paths;
  struct iwfile *iwfiles;
  struct preload *preload_banks;
  int line_count;
  int key;
  /* --- */
  int fd;
  int ffff_access;
  int card;
  int pnp_flag;
  int midi_emul;
  gus_info_t info_data;
  int (*memory_alloc)( struct gus_icfg_config *cfg, gus_instrument_t *instrument );
  int (*memory_loaded)( struct gus_icfg_config *cfg, unsigned int instrument );
  void (*error)( int key, char *file, int line, char *format, va_list va );
  void (*warning)( int key, char *file, int line, char *format, va_list va );
  /* --- */
  struct gus_icfg_config *next;
};

/* icfg.c */

#ifndef NO_DPRINTF
#ifdef DEBUG
void __gus_icfg_dprintf( char *format, ... );
#define gus_dprintf( args... ) __gus_icfg_dprintf( ##args )
#else
#define gus_dprintf( args... ) /* nothing */
#endif
#endif
struct gus_icfg_config *gus_icfg_config;
void gus_icfg_error( char *format, ... );
void gus_icfg_warning( char *format, ... );

char *gus_icfg_look_for_patch_file( char *file, char *extension );

int gus_icfg_open( int key );
int gus_icfg_close( int key );
int gus_icfg_select( int key );
int gus_icfg_load( void );
void gus_icfg_unload( void );
int gus_icfg_preload( char *bank_name );
int gus_icfg_download( unsigned int instrument );

/* lexer.c */

void gus_icfg_lexer_init( void );
void gus_icfg_lexer_done( void );
void gus_icfg_lexer_defines_add( char *s );
void gus_icfg_lexer_defines_remove( char *s );
int gus_icfg_lexer_defines_test( char *s );

/* parser.c */

void gus_icfg_parser_init( void );
void gus_icfg_parser_done( void );
