/*
 * Gravis UltraSound FFFF format dumper
 * Copyright (c) 1997 by Jaroslav Kysela (Perex soft)
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <libgus.h>

static void help( void )
{
  fprintf( stderr, "Usage: ffffdump [-c <card #>] [-o] [ffff_file] <[dat_file]>\n" );
  fprintf( stderr, "\n" );
  fprintf( stderr, "   -c <card #>   select card # (1-%i)\n", gus_cards() );
  fprintf( stderr, "   -o            FFFF ROM\n" );
  fprintf( stderr, "\n" );
}

static void dump( int handle )
{
  int bank, prog;
  gus_instrument_t *instr;
  
  for ( bank = 0; bank < 256; bank++ )
    for ( prog = 0; prog < 256; prog++ )
      {
        instr = gus_instr_alloc();
        if ( !instr ) perror( "instr alloc" );
        if ( !gus_instr_ffff_load( instr, handle, bank, prog ) )
          printf( "instrument %i/%i found..\n", bank, prog );
        gus_instr_free( instr );
      }
  fflush( stdout );
}

int main( int argc, char *argv[] )
{
  int card = 0, rom = 0, gusfd, handle, bank, file;
  char *fff_file = NULL;
  char dat_file[ 512 ];
  gus_info_t info;

  while ( 1 )
    {
      int c;
      
      if ( ( c = getopt( argc, argv, "c:ho" ) ) < 0 ) break;
      switch ( c ) {
        case '?':
        case 'h':
          help();
          exit( 0 );
        case 'c':
          card = atoi( optarg );
          if ( card < 1 || card > gus_cards() )
            {
              help();
              exit( 0 );
            }
          card--;
          break;
        case 'o':
          rom = 1;
          break;
      }
    }
  if ( optind >= argc )
    rom = 1;
   else
    {
      rom = 0;
      fff_file = argv[ optind++ ];
    }
  if ( rom )
    {
      if ( gus_open( card, 512, 0 ) < 0 )
        {
          perror( "gus_open" );
          exit( 0 );
        }  
      gusfd = gus_get_handle();
      gus_info( &info, 1 );
      for ( bank = 0; bank < info.memory_rom_banks; bank++ )
        {
          file = 0;
          while ( 1 )
            {
              if ( ( handle = gus_instr_ffff_open_rom( gusfd, 0, bank, file ) ) < 0 )
                break;
              printf( "DUMP ROM - bank %i, file %i:\n", bank, file );
              dump( handle );
              gus_instr_ffff_close( handle );
              file++;
            }
        }
    }
   else
    {
      if ( optind >= argc )
        {
          strcpy( dat_file, fff_file );
          while ( dat_file[ strlen( dat_file ) - 1 ] != '.' )
            dat_file[ strlen( dat_file ) - 1 ] = 0;
          strcat( dat_file, "dat" );
        }
       else
        strcpy( dat_file, argv[ optind++ ] );
      if ( ( handle = gus_instr_ffff_open( fff_file, dat_file ) ) < 0 )
        perror( "ffff_open" );
      printf( "DUMP FILE - '%s':\n", fff_file );
      dump( handle );
      gus_instr_ffff_close( handle );
    }
  gus_close( card );
  return 0;
}
