/*
 * Gravis UltraSound memory dumper
 * Copyright (c) 1996 by Jaroslav Kysela (Perex soft)
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <libgus.h>

#define BLOCK_SIZE	(8*1024)

static void help( void )
{
  fprintf( stderr, "Usage: memdump [-c <card #>] [-o]\n" );
  fprintf( stderr, "\n" );
  fprintf( stderr, "   -c <card #>   select card # (1-%i)\n", gus_cards() );
  fprintf( stderr, "   -o            dump ROM\n" );
  fprintf( stderr, "\n" );
}

int main( int argc, char *argv[] )
{
  gus_info_t info;
  struct GUS_STRU_MEMORY_DUMP dump;
  char *block;
  int card = 0, rom = 0, size;
  unsigned int pos, page, address, page_size;

  while ( 1 )
    {
      int c;
      
      if ( ( c = getopt( argc, argv, "c:ho" ) ) < 0 ) break;
      switch ( c ) {
        case '?':
        case 'h':
          help();
          exit( 0 );
        case 'c':
          card = atoi( optarg );
          if ( card < 1 || card > gus_cards() )
            {
              help();
              exit( 0 );
            }
          card--;
          break;
        case 'o':
          rom = 1;
          break;
      }
    }
  block = (char *)malloc( BLOCK_SIZE );
  if ( !block )
    {
      fprintf( stderr, "out of memory\n" );
      exit( 0 );
    }
  if ( gus_open( card, 512, 0 ) < 0 )
    {
      perror( "gus_open" );
      exit( 0 );
    }  
  gus_info( &info, 1 );
  size = rom ? info.memory_rom_size * info.memory_rom_banks: info.memory_size;
  address = pos = 0;
  for ( page = 0; page < 4; page++ )
    {
      if ( rom && page >= info.memory_rom_banks ) break;
      address = rom ? page * 4L * 1024L * 1024L : info.memory_banks[ page ].address;
      page_size = rom ? info.memory_rom_size : info.memory_banks[ page ].size;
      while ( page_size > 0 )
        {
          fprintf( stderr, "\rdump %s: %i/%i               ", rom ? "ROM" : "RAM", pos, size );
          dump.flags = rom ? GUS_MEMORY_DUMP_ROM : GUS_MEMORY_DUMP_RAM;
          dump.address = address;
          dump.size = BLOCK_SIZE;
          dump.dump = block;
          if ( gus_memory_dump( &dump ) < 0 )
            {
              perror( "gus_memory_dump" );
              gus_close( card );
              exit( 0 );
            }
          fwrite( block, BLOCK_SIZE, 1, stdout );
          page_size -= BLOCK_SIZE;
          address += BLOCK_SIZE;
          pos += BLOCK_SIZE;
        }
    }
  fprintf( stderr, "\rdump %s: done %i bytes\n", rom ? "ROM" : "RAM", size );
  gus_close( card );
  free( block );
  return 0;
}
