#
#   Makefile for VIWD.386
#
#   Author: tfe
#

!if "$(DEBUG)" == "YES"
DEBUG_VIWD    =   TRUE            
!else
!endif

OUTPUT  =   aux



#
# for VIWD.386 build
#

!IFDEF DEBUG_VIWD

!if "$(TIMEVOICE)" == "YES"
VAS =   masm5 -p -w2 -Mx -Zi -DDEBUG -DTIMEVOICE
!else if "$(TIMEIRQ)" == "YES"
VAS =   masm5 -p -w2 -Mx -Zi -DDEBUG -DTIMEIRQ
!else if "$(TIMEDMA)" == "YES"
VAS =   masm5 -p -w2 -Mx -Zi -DDEBUG -DTIMEDMA
!else if "$(TIMETVOICE)" == "YES"
VAS =	masm5 -p -w2 -Mx -Zi -DDEBUG -DTIMETVOICE
!else
VAS =   masm5 -p -w2 -Mx -Zi -DDEBUG
!endif
VLN =   link386 /MA /LI
VRC =   rc -v -DDEBUG
VZZ =   VIWD: ***** DEBUG ***** DEBUG ***** DEBUG ***** DEBUG *****

!ELSE

VAS =   masm5 -p -w2 -Mx -DRELEASE
VLN =   link386
VRC =   rc -v -DRELEASE
VZZ =   VIWD: **** RELEASE *** RELEASE *** RELEASE *** RELEASE ****

!ENDIF


VMISC   =   VIWD.def  VIWD.lnk

VINCS   =   VIWD.inc
VSRCS   =   VIWD.asm iwirq.asm iwio.asm iwapi.asm
VOBJS   =   VIWD.obj iwirq.obj iwio.obj iwapi.obj


#
# now the rules
#

all         :   VIWD.386
		@echo ================= BUILD COMPLETE ===================
		@echo $(VZZ)
		@echo ================= BUILD COMPLETE ===================

dist: viwd.386
	copy viwd.386 $(IWPROJ)\dist\windows

# VIWD.386

VIWD.386  :   $(VOBJS) VIWD.def
		$(VLN) @VIWD.lnk
		addhdr VIWD.386
!if "$(DEBUG)" == "YES"
		msym VIWD
!endif
#                mapsym32 VIWD
		@echo $(VZZ)
		@echo $(VZZ)
		@echo $(VZZ)

VIWD.obj  :   VIWD.asm  VIWD.inc
		$(VAS) $*,,$*,$*;

iwirq.obj:   iwirq.asm  VIWD.inc
		$(VAS) $*,,$*,$*;

iwio.obj:   iwio.asm  VIWD.inc
		$(VAS) $*,,$*,$*;

iwapi.obj:   iwapi.asm  VIWD.inc
		$(VAS) $*,,$*,$*;

VIWD.lst  :   VIWD.asm  VIWD.inc
		$(VAS) $*;

iwirq.lst:   iwirq.asm  VIWD.inc
		$(VAS) $*;

iwio.lst:   iwio.asm  VIWD.inc
		$(VAS) $*;

iwapi.lst:   iwapi.asm  VIWD.inc
		$(VAS) $*;


# MISC JUNK

clean   :
	    rm -f  *.386
	    rm -f  *.lib
	    rm -f  *.dll
	    rm -f  *.exe
	    rm -f  *.res
	    rm -f  *.obj
	    rm -f  *.sym
	    rm -f  *.map
	    rm -f  *.lst
	    rm -f  *.zip
	    rm -f  *.crf

zip     :   clean
	    pkzip -a VIWD.zip *.*

ship    :   all
	    rm -f  *.lib
	    rm -f  *.res
	    rm -f  *.obj
	    rm -f  *.sym
	    rm -f  *.map
	    rm -f  *.lst
	    rm -f  *.zip
	    touch *.*
	    pkzip -a VIWD .zip *.*
