/***************************************************************************
*   NAME:  DIGINTR.H $Revision: 1.5 $
**  COPYRIGHT:
**  "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: digintr.h $
* Revision 1.5  1995/09/29 13:45:55  teckert
* Added ifdef's to prevent redefinition warning and function declaration in
* the midiout source module.
* Revision 1.4  1995/09/28 17:05:40  teckert
* Added iwReloadPatchMap() declaration and error defines
* Revision 1.3  1995/04/20 07:37:34  teckert
* Added iwSoundOpen and iwSoundClose
* Revision 1.2  1995/03/01 17:46:06  teckert
* Added file header
* Revision 1.1  1995/02/23 15:14:59  sdsmith
* Initial revision
***************************************************************************/
/* error codes */
#define OK          0
#define NO_MORE_VOICES      -1
#define BASE_NOT_FOUND      1
#define BAD_IRQ         2
#define BAD_DMA         3
#define OS_LOADED       4
#define NOT_LOADED      5
#define NO_MEMORY       6
#define DMA_BUSY        7
#define NO_MORE_HANDLERS    8
#define DMA_HUNG        9
#define CARD_NOT_FOUND      10
#define CARD_BEING_USED     11
#define NO_MORE_INTERRUPTS  12
#define BAD_TIMER       13
#define BAD_PATCH       14
#define OLD_PATCH       15
#define DOS_ERROR       16
#define FILE_NOT_FOUND      17
#define CODEC_NOT_FOUND         18
#define ICS_MIXER_NOT_FOUND     19

/* Ultrasound Memory Access Functions */

DWORD   FAR PASCAL iwGetMem(DWORD dwSize);
void    FAR PASCAL iwFreeMem(DWORD dwAddr);
DWORD   FAR PASCAL iwMemAvail(void);
DWORD   FAR PASCAL iwMemLargestAvail(void);
BYTE    FAR PASCAL iwPeek(DWORD dwAddr);
void    FAR PASCAL iwPoke(DWORD dwAddr, BYTE bData);

/* DMA flags */ 
#define IW_RECORD  0 /* use dma control or sample control */
#define IW_DMA     1

/* DMA control bits */
#define DMA_READ        0x02
#define DMA_RATE_DIV_1  0x08
#define DMA_RATE_DIV_2  0x10
#define DMA_DATA_16     0x40 /* width of data */
#define DMA_INVERT_MSB  0x80

int     FAR PASCAL iwDramTransfer(DWORD dwDest, LPSTR lpSource, DWORD dwSize, WORD wDmaControl, WORD wDmaFlags);
  
  
/* Error Message Function */

void    FAR PASCAL iwGetErrorString(int nError, LPSTR lpBuffer, int nLength);
				 
				 
/* Digital Music Functions */

/* sound effects and digital music types */
#ifndef IW_SND_LOOP_MASK
#define IW_SND_LOOP_MASK   3
#define IW_SND_8BIT        4
#define IW_SND_BACKWARD    8
#endif

#define IW_SND_LOOP_NONE   0
#define IW_SND_LOOP        1
#define IW_SND_LOOP_BIDIR  2

#define IW_SOUND_PLAYING       2
#define IW_SOUND_ACTIVE        1

typedef struct IW_SOUND_tag {    
	DWORD dwPosition;
	DWORD dwStartLoop;
	DWORD dwEndLoop;
	unsigned char  bType;    
}IW_SOUND;
typedef IW_SOUND FAR *LPIW_SOUND;

int	FAR PASCAL iwSoundOpen(void);
int	FAR PASCAL iwSoundClose(void);
int     FAR PASCAL iwSoundStart(LPIW_SOUND lpSound, int nVolume, DWORD dwPeriod, WORD wPan,
					 DWORD dwFrequency, WORD wBend);
void    FAR PASCAL iwSoundMode(int nVoice, LPIW_SOUND lpSound, BYTE bType);
void    FAR PASCAL iwSoundStop(int nVoice);
int     FAR PASCAL iwSoundPlaying(int nVoice);
void    FAR PASCAL iwSoundVolume(int nVoice, int nVolume, DWORD dwPeriod);
void    FAR PASCAL iwSoundFrequency(int nVoice, DWORD dwFrequency);
void    FAR PASCAL iwSoundPan(int nVoice, WORD wPan);
            
/*
 * The return codes for iwReloadPatchMap:
 */                                          
#define RPM_OK		     0
#define RPM_MIDIBUSY         1
#define RPM_ERROR            2

#ifndef IN_MIDIOUT_C
int	FAR PASCAL iwReloadPatchMap(void);
#endif

