#ifndef __LIST_H
#define __LIST_H

#if defined(__BORLANDC__)
#undef RFAR
#define RFAR far
#elif defined(_MSC_VER) && (_MSC_VER <= 600)
#define RFAR far
#elif defined(_MSC_VER) && (_MSC_VER > 600)
#define RFAR __far
#else
#undef RFAR
#define RFAR
#endif

#define PREPEND 1
#define APPEND  2

struct node {
    struct node RFAR *next;
    struct node RFAR *prev;
    void RFAR *data;
};

struct list {
    struct node RFAR *head;
    struct node RFAR *tail;
};

void InitList(struct list RFAR *list);
struct list RFAR *CreateList(void);
struct node RFAR *CreateNode(void RFAR *data);
void DestroyNode(struct node RFAR *node);
void AddNode(struct list RFAR *list, struct node RFAR *node, struct node RFAR *where, int pa);
void DeleteNode(struct list RFAR *list, struct node RFAR *node);
#endif
