#!/bin/sh

export OPATH="$PATH"; export OPATH

#
#                          ****************************
#                          *** FUNCTION DEFINITIONS ***
#                          ****************************
#
#
# ***********************
# *** BUILD FUNCTIONS ***
# ***********************
#

#
# build viwd
#
function make_viwd
{
	echo "\n***********************"
	echo "*** building viwd..."
	echo "***********************\n"
	cd $IWPROJ\\windows
	if
		test "$REFRESH" = "Y"
	then
		pj refresh viwd\\* viwd\\minc\\*
	fi
	cd viwd
	
	rm -f *.obj *.map
	$MAKE -f make.ksh $TARGET
	if
		test $? -ne 0
	then
		echo "\n** viwd build failed; exiting\n"
		reset
		unset_all
		exit 1
	fi
}

#
# build win '95 viwd
#
function make_viwd_95
{
	echo "\n****************************"
	echo "*** building win '95 viwd..."
	echo "****************************\n"
	cd $IWPROJ\\windows
	if
		test "$REFRESH" = "Y"
	then
		pj refresh viwd\\* viwd\\minc\\*
	fi
	
	cd viwd
	rm -f *.obj *.map
	$MAKE -f make.w95 $TARGET
	if
		test $? -ne 0
	then
		echo "\n** viwd '95 build failed; exiting\n"
		reset
		unset_all
		exit 1
	fi
}

#
# ***********************
# *** SETUP FUNCTIONS ***
# ***********************
#

#
# reset PATH environment variable
#
function reset
{
	export PATH="$OPATH"; export PATH
}

#
# unset everything
#
function unset_all
{
	unset MAKESTARTUP
	unset TOOLROOTDIR
	unset LIBPATH
	unset HELPFILES
	unset INIT
	unset ASMEX
	unset INCLUDE
	unset INCLUDEPATH
	unset WATCOM
	unset COMPILER
	unset MAKE
	unset DEBUG
	unset BCPATH
	unset MCPATH
	unset WCPATH
	unset MC8INCLUDE
	unset OSVERSION
	unset MAKEINIT
	unset VIWD
	unset WINEXE
	unset TARGETDIR
}


#
# variables that are unique to each compiler or applicable 
# to all compilers
#
function set_general
{
	export BCPATH="$BCDIR\\bin"; export BCPATH
	export MCPATH="$DDKDIR;$DDKDIR\\tools;$MC8DIR\\bin;$BCDIR\\bin;$MLDIR\\bin;$MLDIR\\binb"; export MCPATH
	export WCPATH="$WCDIR\\bin;$WCDIR\\binb"; export WCPATH
	export MC8INCLUDE="$MC8DIR\\include;$MLDIR\\include"; export MC8INCLUDE
	export OSVERSION="6"; export OSVERSION
	export MAKEINIT="$HOME\\etc\\watcomc.mk"; export MAKEINIT
	export VIWD="$IWPROJ\\windows\\viwd"; export VIWD
	export WINEXE="$IWPROJ\\dist\\windows"; export WINEXE
}


#
# set up variables for building the windows drivers
#
function set_viwd
{
	export MAKESTARTUP="$HOME\\etc\\msc.mk"; export MAKESTARTUP
	export TOOLROOTDIR="$MC8DIR"; export TOOLROOTDIR
	export INCLUDE="$KERNEL;$KERNEL\\os\\windows;$IWPROJ\\windows\\viwd\\minc"; export INCLUDE
	export HELPFILES="$MLDIR\\help\\*.hlp"; export HELPFILES
	export ASMEX="$MLDIR\\samples\\"; export ASMEX
	export INCLUDEPATH="$BCDIR4\\include;$MLDIR\\include;$INCLUDE"; export INCLUDEPATH
	export LIBPATH="$BCDIR4\\lib;$VIWD\\kernel"; export LIBPATH
	export COMPILER="$BCDIR4"; export COMPILER
	export MAKE="$MC8DIR\\bin\\nmake" export MAKE
	export LINKER="$MLDIR\\bin"; export LINKER
	export PATH="$PATH;$MCPATH;$COMPILER;$SICEDIR;$LINKER"
	if
		test "$DBG" = "Y"
	then
		export DEBUG="YES"; export DEBUG
	fi
}

function set_viwd_95
{
	export PATH="$MVC2DIR\\bin;$MLDIR\\bin32;$PATH"; export PATH
	export INCLUDE="$DDK95DIR\\inc32;$DDK95DIR\\inc16;$MVC2DIR\\include;$MLDIR\\inc"; export INCLUDE
	export LIB="$DDK95DIR\\lib;$MVC2DIR\\lib"; export LIB
	export PROCESSOR_ARCHITECTURE="x86"; export PROCESSOR_ARCHITECTURE
	export PROCESSOR_IDENTIFIER="80486-D0"; export PROCESSOR_IDENTIFIER
	export PROCESSOR_LEVEL="4"; export PROCESSOR_LEVEL
	export PROCESSOR_REVISION="D0"; export PROCESSOR_REVISION
	export DDKROOT="$DDK95DIR"; export DDKROOT
	export MAKE="$MC8DIR\\bin\\nmake" export MAKE
	
	export MAKESTARTUP="$HOME\\etc\\msc.mk"; export MAKESTARTUP
	export HELPFILES="$MLDIR\\help\\*.hlp"; export HELPFILES
	export ASMEX="$MLDIR\\samples\\"; export ASMEX
	if
		test "$DBG" = "Y"
	then
		export DEBUG="YES"; export DEBUG
	fi
}

#
#                      *****************************
#                      *** START OF SHELL SCRIPT ***
#                      *****************************
#

#
# set up common environment variables
#
set_general
if
	test "$2" = "debug"
then
	export DBG="Y"
	export TARGET=""
	export REFRESH=""
elif
	test "$2" = "refresh"
then
	export REFRESH="Y"
	export TARGET=""
	export DEBUG=""
else
	export TARGET="$2"
	export DEBUG=""
	export REFRESH=""
fi

#
# ********************
# ***    VIWD      ***
# ********************
#

#
# set up and compile viwd libraries
#

reset
if
	test "$1" = "win"
then
	set_viwd
	make_viwd
	reset
elif
	test "$1" = "win95"
then
	set_viwd_95
	make_viwd_95
else
	echo "unknown target"
	reset
	unset_all
	exit 2
fi
reset
unset_all
