#!/bin/sh

export OPATH="$PATH"; export OPATH

#
#                          ****************************
#                          *** FUNCTION DEFINITIONS ***
#                          ****************************
#
#
# ***********************
# *** BUILD FUNCTIONS ***
# ***********************
#

#
# build the playmidi executable
#
function make_inst
{
	echo "\n**********************"
	echo "*** building install..."
	echo "**********************\n"
	cd $INSTALL
	if
		test "$REFRESH" = "Y"
	then
		pj refresh
	fi
		
	if
		test "$TARGET" = ""
	then
		$MAKE -f makefile
	else
		$MAKE -f makefile $TARGET
	fi

	if
		test $? -ne 0
	then
		echo "\n** install build failed; exiting\n"
		reset
		unset_all
		exit 1
	fi
}

#
# build osl kernel
#
function make_osl
{
	echo "\n***********************************"
	echo "*** making sure osl kernel exists..."
	echo "***********************************\n"

	cd $KERNEL
	$MAKE -fmakeos.ksh -DMODEL=l
	if
		test $? -ne 0
	then
		echo "\n** osl build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# ***********************
# *** SETUP FUNCTIONS ***
# ***********************
#

#
# reset PATH environment variable
#
function reset
{
	export PATH="$OPATH"; export PATH
}

#
# unset everything
#
function unset_all
{
	export PATH="$OPATH"; export PATH
	unset MAKEINIT
	unset TOOLROOTDIR
	unset LIBPATH
	unset INCLUDE
	unset INCLUDEPATH
	unset WATCOM
	unset COMPILER
	unset MAKE
	unset BCPATH
	unset OSVERSION
	unset INSTALL
	unset CONFIGINCDIR
	unset TARGETDIR
}

#
# variables that are unique to each compiler or applicable 
# to all compilers
#
function set_general
{
	export BCPATH="$BCDIR\\bin"; export BCPATH
	export OSVERSION="6"; export OSVERSION
	export INSTALL="$IWPROJ\\install"; export INSTALL
	if
		test "$DEBUG" = "Y"
	then
		export DEBUG="-v"; export DEBUG
	fi
}

#
# set up variables for the borland compiler
#
function set_borland
{
	export MAKESTARTUP="c:\\etc\\borlandc.mk"; export MAKESTARTUP
	export TOOLROOTDIR="$BCDIR"; export TOOLROOTDIR
	export COMPILER="$BCDIR"; export COMPILER
	export INCLUDEPATH="$BCDIR\\include"; export INCLUDEPATH
	export LIBPATH="$BCDIR\\lib"; export LIBPATH
	export PATH="$PATH;$BCPATH;$COMPILER"
	export MAKE="$BCDIR\\bin\\maker" export MAKE;
}

#
#                      *****************************
#                      *** START OF SHELL SCRIPT ***
#                      *****************************
#

#
# set up common environment variables
#
reset
export REFRESH=""
if
	test "$2" = "refresh"
then
	export REFRESH="Y"
	export TARGET=""
	export DEBUG=""; export DEBUG
elif
	test "$2" = "debug"
then
	export DEBUG="Y"
	export TARGET=""
	export REFRESH=""
else
	export REFRESH=""
	export DEBUG=""; export DEBUG
	export TARGET="$2"
fi

set_general
set_borland

make_inst
reset
unset_all
