#!/bin/sh

export OPATH="$PATH"; export OPATH

#
#                          ****************************
#                          *** FUNCTION DEFINITIONS ***
#                          ****************************
#
#
# ***********************
# *** BUILD FUNCTIONS ***
# ***********************
#

#
# build the rommaker executable
#
function make_binaries
{
	echo "\n**********************"
	echo "*** copying binaries..."
	echo "**********************\n"
	cd $BINARIES
	if
		test "$REFRESH" = "Y"
	then
		pj refresh
	fi
		
	if
		test "$TARGET" = ""
	then
		$MAKE -f make.ksh all
	else
		$MAKE -f make.ksh $TARGET
	fi

	if
		test $? -ne 0
	then
		echo "\n** binaries copy failed; exiting\n"
		reset
		unset_all
		exit 1
	fi
}

#
# ***********************
# *** SETUP FUNCTIONS ***
# ***********************
#

#
# reset PATH environment variable
#
function reset
{
	export PATH="$OPATH"; export PATH
}

#
# unset everything
#
function unset_all
{
	export PATH="$OPATH"; export PATH
	unset MAKE
	unset BCPATH
	unset BINARIES
	unset MAKESTARTUP
	unset TOOLROOTDIR
	unset COMPILER
	unset INCLUDEPATH
	unset LIBPATH
}

#
# variables that are unique to each compiler or applicable 
# to all compilers
#
function set_general
{
	export BINARIES="$IWPROJ\\binary"; export BINARIES
	export BCPATH="$BCDIR\\bin"; export BCPATH
}

#
# set up variables for the borland compiler
#
function set_borland
{
	export MAKESTARTUP="$HOME\\etc\\borlandc.mk"; export MAKESTARTUP
	export TOOLROOTDIR="$BCDIR"; export TOOLROOTDIR
	export COMPILER="$BCDIR"; export COMPILER
	export INCLUDEPATH="$BCDIR\\include"; export INCLUDEPATH
	export LIBPATH="$BCDIR\\lib"; export LIBPATH
	export PATH="$PATH;$BCPATH;$COMPILER"
	export MAKE="$BCDIR\\bin\\maker" export MAKE;
}

#
#                      *****************************
#                      *** START OF SHELL SCRIPT ***
#                      *****************************
#

#
# set up common environment variables
#
reset
export REFRESH=""
if
	test "$1" = "refresh"
then
	export REFRESH="Y"
	export TARGET=""
	export DEBUG=""; export DEBUG
elif
	test "$1" = "debug"
then
	export DEBUG="Y"
	export TARGET=""
	export REFRESH=""
else
	export REFRESH=""
	export DEBUG=""; export DEBUG
	export TARGET="$1"
fi

set_general
set_borland

make_binaries
reset

unset_all
