#!/bin/sh

export OPATH="$PATH"; export OPATH

#
#                          ****************************
#                          *** FUNCTION DEFINITIONS ***
#                          ****************************
#
#
# ***********************
# *** BUILD FUNCTIONS ***
# ***********************
#

#
# build the play executable
#
function make_play
{
	if
		test "$TARGET" = ""
	then
		export CONFIGINCDIR="$PLAY\\API"; export CONFIGINCDIR
		export TARGETDIR="$PLAY\\kernel"; export TARGETDIR
		make_osl
	fi
	
	echo "\n**********************"
	echo "*** building play..."
	echo "**********************\n"
	cd $PLAY
	if
		test "$REFRESH" = "Y"
	then
		pj refresh
	fi
		
	if
		test "$TARGET" = ""
	then
		$MAKE -f makefile
	else
		$MAKE -f make.ksh $TARGET
	fi

	if
		test $? -ne 0
	then
		echo "\n** play build failed; exiting\n"
		reset
		unset_all
		exit 1
	fi
}

#
# build the iwinit executable
#
function make_iwinit
{
	if
		test "$TARGET" = ""
	then
		export CONFIGINCDIR="$IWINIT"; export CONFIGINCDIR
		export TARGETDIR="$IWINIT\\kernel"; export TARGETDIR
		make_oss
	fi

	echo "\n**********************"
	echo "*** building iwinit..."
	echo "**********************\n"
	cd $IWINIT
		
	$MAKE -f make.ksh $TARGET
	if
		test $? -ne 0
	then
		echo "\n** iwinit build failed; exiting\n"
		reset
		unset_all
		exit 1
	fi
}

#
# build the playwav executable
#
function make_wav
{
	if
		test "$TARGET" = ""
	then
		export CONFIGINCDIR="$WAV"; export CONFIGINCDIR
		export TARGETDIR="$WAV\\kernel"; export TARGETDIR
		make_osl
	fi
	
	echo "\n***********************"
	echo "*** building playwav..."
	echo "***********************\n"
	cd $WAV
	if
		test "$REFRESH" = "Y"
	then
		pj refresh
	fi
		
	$MAKE -f make.ksh $TARGET
	if
		test $? -ne 0
	then
		echo "\n** playwav build failed; exiting\n"
		reset
		unset_all
		exit 1
	fi
}

#
# build the playmod executable
#
function make_mod
{
	if
		test "$TARGET" = ""
	then
		export CONFIGINCDIR="$MOD"; export CONFIGINCDIR
		export TARGETDIR="$MOD\\kernel"; export TARGETDIR
		make_osl
	fi
		
	echo "\n***********************"
	echo "*** building playmod..."
	echo "***********************\n"
	cd $MOD
	if
		test "$REFRESH" = "Y"
	then
		pj refresh
	fi
		
	$MAKE -f make.ksh $TARGET
	if
		test $? -ne 0
	then
		echo "\n** mikmod build failed; exiting\n"
		reset
		unset_all
		exit 1
	fi
}

#
# build all the applications
#
function make_apps
{
#	make_midi
	make_iwinit
	make_play
#	make_wav
#	make_mod
}

#
# build osl kernel
#
function make_osl
{
	echo "\n***********************************"
	echo "*** making sure osl kernel exists..."
	echo "***********************************\n"

	cd $KERNEL
	$MAKE -fmakeos.ksh -DMODEL=l all
	if
		test $? -ne 0
	then
		echo "\n** osl build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# build oss kernel
#
function make_oss
{
	echo "\n***********************************"
	echo "*** making sure osl kernel exists..."
	echo "***********************************\n"

	cd $KERNEL
	$MAKE -fmakeos.ksh -DMODEL=s all
	if
		test $? -ne 0
	then
		echo "\n** oss build failed; exiting \n"
		reset
		unset_all
		exit 1
	fi
}

#
# ***********************
# *** SETUP FUNCTIONS ***
# ***********************
#

#
# reset PATH environment variable
#
function reset
{
	export PATH="$OPATH"; export PATH
}

#
# unset everything
#
function unset_all
{
	export PATH="$OPATH"; export PATH
	unset MAKEINIT
	unset TOOLROOTDIR
	unset LIBPATH
	unset INCLUDE
	unset INCLUDEPATH
	unset WATCOM
	unset COMPILER
	unset MAKE
	unset BCPATH
	unset OSVERSION
	unset MAKEINIT
	unset PLAY
	unset MIDI
	unset IWINIT
	unset WAV
	unset MOD
	unset VIWD
	unset APPSEXE
	unset CONFIGINCDIR
	unset TARGETDIR
}

#
# variables that are unique to each compiler or applicable 
# to all compilers
#
function set_general
{
	export BCPATH="$BCDIR\\bin"; export BCPATH
	export OSVERSION="6"; export OSVERSION
	export MAKEINIT="$HOME\\etc\\watcomc.mk"; export MAKEINIT
	export PLAY="$IWPROJ\\apps\\play"; export PLAY
	export MIDI="$IWPROJ\\apps\\midi"; export MIDI
	export IWINIT="$IWPROJ\\apps\\iwinit"; export IWINIT
	export WAV="$IWPROJ\\apps\\wav"; export WAV
	export MOD="$IWPROJ\\apps\\mod"; export MOD
	export APPSEXE="$IWPROJ\\dist\\apps"; export APPSEXE
	if
		test "$DEBUG" = "Y"
	then
		export DEBUG="-v"; export DEBUG
	fi
}

#
# set up variables for the borland compiler
#
function set_borland
{
	export MAKESTARTUP="$HOME\\etc\\borlandc.mk"; export MAKESTARTUP
	export TOOLROOTDIR="$BCDIR"; export TOOLROOTDIR
	export COMPILER="$BCDIR"; export COMPILER
	export INCLUDEPATH="$BCDIR\\include"; export INCLUDEPATH
	export LIBPATH="$BCDIR\\lib"; export LIBPATH
	export PATH="$PATH;$BCPATH;$COMPILER"
	export MAKE="$BCDIR\\bin\\maker" export MAKE;
}

#
#                      *****************************
#                      *** START OF SHELL SCRIPT ***
#                      *****************************
#

#
# set up common environment variables
#
reset
export REFRESH=""
if
	test "$2" = "refresh"
then
	export REFRESH="Y"
	export TARGET=""
	export DEBUG=""; export DEBUG
elif
	test "$2" = "debug"
then
	export DEBUG="Y"
	export TARGET=""
	export REFRESH=""
else
	export REFRESH=""
	export DEBUG=""; export DEBUG
	export TARGET="$2"
fi

set_general
set_borland

#
# ********************
# *** APPLICATIONS ***
# ********************
#
# set up and compile the kernel and playmidi source code
#
if
	test "$1" = "midi"
then
	make_midi
	reset
#
# set up and compile the kernel and iwinit source code
#
elif
	test "$1" = "iwinit"
then
	make_iwinit
	reset
#
# set up and compile the kernel and playwav source code
#
elif
	test "$1" = "wav"
then
	make_wav
	reset
#
# set up and compile the kernel and playmod source code
#
elif
	test "$1" = "mod"
then
	make_mod
	reset
#
# set up and compile the kernel and play source code
#
elif
	test "$1" = "play"
then
	make_play
	reset
#
# set up and compile the kernel (osl version) and all apps
#
elif
	test "$1" = "apps"
then
	make_apps
	reset
#
# invalid target
#
else
	echo "$1: unknown target, exiting"
	reset
	unset_all
	exit
fi

reset
unset_all
