/************************************************************************
 *
 *     The version is VERNUM_HIGH.VERNUM_LOW
 *
 *     like    3.8
 * 
 ************************************************************************
 *
 * The Version numbers can only be one digit each -- will not correctly
 * print two or more digits
 *
 ************************************************************************/
#define VERSION_HIGH 1
#define VERSION_LOW1 2
#define VERSION_LOW2 0

/************************************************************************
        Version Summary:
 ************************************************************************

Version 0.1
    First Draft

Version 0.1 - Version 0.2
    First Draft with SB/ADLIB ports generating NMIs.  NMI handler at this point
    only handles minimal testing cases.
    More testing for ULTRASND environment variable and NMIs added.
    Only bug known is in NMI handler when a port other than the one (2x6)
    expected is written to.

Version 0.2 - Version 0.3
    **** Driver code ****
    Baseport insensitive - uses locals for port addresses
    Now hooks GF1 interrupt
    Tests state of card and spawns loader if card is messed up
    NMI routine handles all nmi cases and clears interrupt
    Also calls appropriate routine through table lookup
    Loads high by default
    Supports Command line parameters for driver and executable
        - MPU401 mode - puts driver in MPU401 comatable mode
          This entails retaining extra code for handling MPU401 calls
        - LOW - force driver to load in low memory
        - C7? - specify communication vector other than 7e
    Sizes DRAM, leaves data at end and inits pointer to data left for sound data
    **** Loader Code ****
    More robust NMI testing and enabling
    Gets MPU401 state from driver and sets up GF1 accordingly
    Can handle being spawned from driver with no extra parameters
    Better testing for unloading driver - ie. hooked vectors etc.

Version 0.3 - Version 0.4
    ***** Driver code *****
    Calls loader with /Q option to quiet execution
    Uses short jumps to get rid of all those annoying nops
    Added MPU-401 debugging capability - printing table of commands
    Added debugging program and debugging capability into driver
    Enhanced fm command parsing and decoding - created fm.asm fmc.c files
    int21 hook modified nmi vector on each call - like timer interrupt
    Created structures for fm part based on channels 0-8
    handle_IRQ now pushes extended registers
    Changed variable names to not reflect ultrasound or gf1
    Added xlat.c and synint.asm
    things_to_do parser tested and complete - routines stubbed
    Updated fm structures for more streamlined execution
    All FM writes stored and proper routines called
    Fixed a STUPID recursive bug in the ADLIB calling sequence (dum de dum dumm)
    ***** Loader code *****
    Will allow adlib detection without running ultrinit first
    Unloads the driver in case of an error
    Added option to quiet execution /Q
    The outp's and inp's work with Borland 2.0 now

Version 0.4 - Version 0.5
    ***** Driver code *****
    Startup code now sets pointers to 3 data sections 
    Goes resident with the correct size (dram.inc)
    Added much translation code in xlat.c and calc.asm
        Main loop for things_to_do
        Calcs FM vals to frequency
        Calcs FM vals to envelope points and to IW register values
        Calls stubbed synth functions in synth.c
    Stubbed synth interrupt handler in synint.asm
    Enabled combining of synth and NMI interrupt handlers
    ***** Loader code *****
    Loads DRAM with one of 3 patch libraries and inits shared data
    Prints out Usage list
    Loads library from loader's path in shared data
    ***** Library Builder code *****
    Now exists!!!
    Builds somewhat correct libraries for 256k, 512k and 1024k sets
    Builds dram.inc for driver
    
Version 0.5 - Version 0.6
    ***** Driver code *****
    Added most DAC support
    Added a real patch picker
    Added noise support
    Added percussions
    Made bank parser/builder (.BNK)
    ***** Loader code *****
    Finished loading shared data
    Finished library file picker
    ***** Library Builder code *****
    Fixed some bugs in patch data
    ***** SBOSDEB code *****
    All debug data is now kept in driver.
    Driver returns a pointer to pointers to data in driver for debug
    Added DAC comments to the debug output
    Added -a command to skip dumping Adlib data
    Added patch picker debugging stuff. Force select etc
    
Version 0.6 - Version 0.7
    ***** Driver code *****
        Bugs in startup code. missing ret. our stack on test-n-spawn.
        Better DAC detection. Still not complete.
        Fixed synth bugs.
                - Volume ramps.
                - high fc garbage on last patch in DRAM.
                - upgraded inst patch list
        Wrote picker in asm.
        Restructured things to do. Gather until key on, then calc.
        Added panning of instrument.
        Only program reggies if wave changed. (faster)
        Rewrite synth vector on every NMI.
        Shut synth down on DSP reset.
        Various DAC fixes.
        Fixed decay rate = 0 problem.
    ***** Loader code *****
        Various bugs/enhancements
    ***** Library Builder code *****
        Fixed 16 bit patches.
    ***** SBOSDEB code *****
        Added comments to DAC and FM register writes.
        Added picker history.
        Debug picker can work on all channels.

Version 0.7 - Version 0.8
    Cut Alpha version for Gravis
    Stubbed in rough algorithm for noise and effects voices.
    Gravis liked this one better than 0.7

Version 0.8 - Version 0.9
    Cut another Alpha for Gravis
    ***** Driver code *****
        Fixed saving/restoring user stack pointer (added cs:)
        Uncommented int21 handler. (ifdef NEVER) (gonna be a LONG year)
        Added new noise/effect algorithm
            Noise is now table based for its attenuation.
        Added 'blubber' checks. Now uses modulator sustain levels if the
            frequency is low enough. (carrier can't be heard ..[jill])
        Restructured xlat.c.  Now handles noise and effect voices properly.
            Effect is done by frequency shift on modulator...
        Added code to adlib timers to start timer #1 if it was set to FF.
            Some games (lhx,fps_baseball...) do a software delay after
            setting the timers. Since they just use a dead loop, a 486-66
            is way too fast and the app's don't detect the card.
            (if def'ed out for now ....)
        Major restructuring of the things to do loop.
            combined frequency/volume. re-did perc logic.
        Don't force instrument select on sustain or decay change (sbc.c)
    ***** Loader code *****
    ***** Library Builder code *****
        Added picking the slowest release out of the 6 point envs

Version 0.9 - Version 0.10
    ***** Driver code *****
        Fixed ADLIB timer stuff. Timer wasn't getting set until the next
            adlib timer tick. (80 or 320 us later) This caused the 
            previous value to be used when the app started the timer.
        Re-enabled the counting of the timers when an FF was put in.
            ( It was ifd'efd out of the previous version. lhx works.
        Fixed fps_baseball. It checks for a 0 on the status bit of
            2xC for presence of SB rather than AA in 2xA. I forced a reset
            to always return a 0 in this bit for the next read.
        Fixed stunts and bthorne. Had serious volume ramp problems.
            bthorne - Floor volume was too low. It took too long to ramp
                        up to audible volume. Moved floor up to about -50db
            stunts - Lots of missing notes/instruments. The volume ramps
                        would not work right on an already running note.
        Changed way version was printed to handle 2 minor digits.
    ***** Library Builder code *****
        Created sustain.h for dumpbank.
        Removed use of SDK. (Easier to to IW without it ..... )

Version 0.10 - Version 0.11
    Same as changes for version 0.10 - Version 0.20
    Alpha .10 delivered to Gravis, They put it on Internet .....

Version 0.10 - Version 0.20

    Delivered first BETA version to Gravis

    ***** Driver code *****
        - More Interwave code. Variable freqs don't work yet
        - Restructured various areas for speed.
                (adlib.asm - removed table so cmd proc is faster)
                (Start volume was streamlined)
                (Picker was streamlined)
        - made internal functions type 'pascal'
        - Added sustain and modulator sustain to picker parms
        - Code optimization. reduced about 700 bytes
        - Found DOS4GW bug - Flipped EBX and EDX
        - NMI handler uses less stack. Used statics for AX and DX
        - changed forking to int21_bypass
        - Fixed dsp bug. Blew AX register for small dma xfers (force_sbirq)
        - Fixed synth bug. (Decay rate = 0 and Sustain lev = 0)
        - Fixed lots of little bugs in startup code
            - No Ram (not MAX). fixed mixed up command line switches.
        - removed possible 256K DRAM version
        - static init fm_operator (0x3f). volume was inited to max ...
        - Added int_table to shared. loader will init sustain bit later ...
        - Reset synth side on 2x6 reset to dsp
        - restructured things_to_do loop again
    ***** Loader code *****
        - Fixed lots of little bugs in startup code
            - No Ram (not MAX). fixed mixed up command line switches.
        - Made NMU401 be a build switch so nothing ends up in executable
        - removed possible 256K DRAM version
        - Changed usage screen
        - Removed use of SDK code/libraries
    ***** Library Builder code *****
        - Added some patches to fill out DRAM
        - removed possible 256K DRAM version
        - Removed use of SDK code/libraries

Version 0.20 - Version 0.21
    ***** Driver code *****
        - Fixed volume ramp bug (lost percs - jill)
        - save and restore volume around setting acc. (clicks)
        - Added switch to force DOS4GW 'fix'

Version 0.21 - Version 0.22

    Delivered Beta 0.22 to Gravis for Interwave (Alan Alvarez)
    ***** Loader code *****
        - System Shock prob. Leaves NMI pending cause it trashes our mixer
            (System shock does not work !!!!!)
    Stubbed out fixed DAC value for ADLIB digial.

Version 0.22 - Version 0.23
    ***** Loader code *****
    Shut down DMA channels left running by windows drivers.
    Added option /k to preserve current setup for driver spawning.
    ***** Driver code *****
    Added (stubbed) int2f hook for VxD API support.
    Added port mask for ADLIB/SB IRQ enable port (index 45h)
    Cleaned up code and documentation in asm files
    Changed testnspawn() for Windows check
    Added support for the /k loader option for spawning.
    Fixed bug in ADLIB digital - stopped voice whenever freq was zero
        Now, stops voice only if voices (c & m) and freq is zero

Version 0.23 - Version 0.24
    ***** Loader code *****
    ***** Driver code *****
    Moved sustain bit information from sustain.h into library
    ***** Library Builder code *****
    Made compilation of driver and loader not dependent on library builder

Version 0.24 - Version 0.25
    ***** Loader code *****
    Interwave support
        Use iw.ini file for params (lib file)
    ***** Driver code *****
    Support un-documented cmd DA. Stop special looped DMA (Follow the Reader)
    Interwave support
        Remove dependancy from builder to executable
        Look in library file for DRAM params
    ***** Library Builder code *****
        BUild different libs IW and MAX

Version 0.25 - Version 0.30
    ***** Loader code *****
        Added DOCMAN stuff
    ***** Driver code *****    
        Fixed some percussion problems.
        Play nove from percussion bank.
        Support PNP stuff during init.
        Fixed bug in programming PNP DMA registers. (missing ret)
        Added DOCMAN stuff
        Fixed bug in dsp_encoded. temp_buff+1 problem created when 
            dependancy on builder/driver removed. XWING works again ...
    ***** Library Builder code *****
        Use INTERWAVE patches for Interwave version.
        Moved noise into basic bank
        Added separate version #'s for IW and MAX
    Pre_alpha version cut to AMD

Version 0.31 - Version 0.32
    Driver
        Build new rate table with proper range and moved floor back down.
        Moved attack-from start pos up to almost audible. Partially accounts
            for Adlib having linear volume response. We spent most of the 
            attack time in the inaudible range.

Version 0.31 - Version 0.32
    Driver Code
        Fixed problem w/app killing PIC. Synth IRQ (7) would be shut
            off and our envelopes wouldn't work. (Jill)
        Fixed lost notes in UW. Starting envelope at too low a start
            point and it would never make it to the audible range
        Repaired new rate tables. First entries are not supposed to be 3F.
        Fixed UW / STUNTS volume ramping. New start_volume algorithm
        Fixed off-key notes. carrier frequency not updated right.
        Fixed feedback/connections update instrument flag.
        Fixed/rearranged setting/programming frequency.
        Fixed bug in commented out code in update_volume_frequency();
            (skipped getting/setting and programming freq on some percs.....)
        Added code to take care of a frequency shift during a note playing.
            It will now reselect an instrument on next key on. (get wavenum
            right ...)
    Debugger Code
        Added some code to single out a certain adlib channel to be dumped.
            (-c #)
    Library builder
        Added a command line parameter to dump library contents (/L)
        Fixed off by one in length of sample.
        Fixed not sending down last byte of odd length sample

Version 0.32 - Version 0.33
    Driver Code
        MPU-401 support
        Moved voice data structs to the end of code instead of in drvrdata.c.
            This allows for 18 or 32 voices for IW MPU-401
    Library builder
        Uses 6 point envelope now ...

==========================================================================
Version 0.34 - Version 0.40

    REV B.0 IW SILICON !!!!!!!!

==========================================================================

Version 0.53
    Version cut for AMD. First BETA release 5/8/95

Version 0.53 - 0.54
    Fixed testnspawn bug on ROM systems. It would not respawn loader
    after exit from windows because Adlib-SB irq mask register was
    reset back to 0x22. Now we leave it at 0 so that testnspawn will
    call loader.

    Fixed bug with playback frequency after leaving windows. Didn't set
    playback frequency register properly (MCE bit)

Version 0.54 - 0.55
    Fixed CDROM SONY external pin bug - loader.c utillib.c

    Fixed buffer search for new dos4gw fix.  Now stops before the end of
    the buffer so no segment overruns can happen.

    Fixed cymbal exclusion code - The old code had a bug which would shut
    off a note (regardless percussion/melodic) if the note frequency was a 
    46 (percussion - hihat top) and any cymbal played.

    Fixed Jet Fighter II.  It destroys the NMI vector in DOS so it must be 
    played in Windows DOS BOX.  There was a bug in adlib.asm which init'd the
    adlib instruments wrong.

Version 0.55 - 0.56
    Added spawning support in a Windows DOS box

    Fixed Digital detection and playback - got rid of pops

    Optimized code in synth and mpu401 code.

    Fixed SYS driver support

Version 0.55 - 0.56
    Added scale factors to lib data
    MLS for driver
    
Version 0.57 - 0.90
    Bumped to .90 for Release Candidate #1 .....

Version 0.90 - 0.91
    Updated GAME API through int2f and int7e
    Fixed SB ADPCM
    0.91 Version complete 6/9/95 - RELEASE

Version 0.90 - 0.91
    - Fixed inca auto-detect I think ...

Version 0.92 - 0.93
    Kludged fix on CODEC irqs
    Has latest GAME API implementation
    Cut this version for symposiums - going to game developers
    Fixed bug in all_notes_off() in MPU401 code

Version 0.93 - 0.94
    Not Beta anymore
    Redesigned GAME API implementation and resource allocation in driver

Version 0.94 - 1.00
    Made Adlib Instrument picker choose piano #1 instead of #0
    Fixed noise volume bug in adlib section
    Added code to make sbos spawn in Windows when device is restored through
        the GAME API
    Added INT7x call to ignore the next immediate DOS Exec for spawning
    Updated implementation of 2xE reads to act like SB (fixes Blue Force)
    Optimized for size to make code fit under 20,480 bytes (20K)
    Release: 8/1 to AMD

    NOTE:
    Changed size of SBOSDATA structure. (8/8/95)  This means that any built
    version of SBOS prior to this date will be incompatable with this one.
    Got rid of MPU401 Mode Enabled banner message
    Changed error messages a little to be more consistent and not redundant
    Increased size of startup stack to 4k instead of 1k.
    Fixed MIDISIMPLE so it sets up DMA and synth ROM/RAM mode in foreground
    Wake call in GAME API will not close game devices anymore

    Read # of waves from ROM rather than hard code it for the maximum. Saves
        about 100 bytes of code.
    Fixed card detection for Mortal Kombat.
    ADPCM for MK works better, but not perfect.
    Removed some excess code from ADPCM. Saved about 50 bytes.


Version 1.00 - 1.01
    Changed DTR bit in codec reg 3xC. Fixed lots of pops .... Now we let
        DMA continue. Works well with autoinit DMA ....
    removed code to reset version # on a SB reset (not needed)
    Adjusted a few board detect checks ....
    Cut special version while at CSE

Version 1.01 - 1.02
    Changes for WIN-95 support. Changed DMA programming to be thru back
        door since PNP is not available .....
    Added copyright message.
    Added VxD support for win 95 configuration calls - removed PnP checks
        from loader.  Rearranged order of obtaining startup information.
    Changed 'SBOS' to 'IWSBOS' in .mls file
    Added version check for windows init message. (Fix Killing Moon)
        (Not a great fix but ....)

Version 1.02 - 1.03
    Changed keyboard handler to re-enable NMI's (port 70 bit 7) because
        some stupid BIOS' disable it when they read the keyboard.
        (Phoenix something ....)
    Changed loader and driver code to NOT automatically enable parity
        checking (port 61 bit 2). We need IOCHCK from ISA bus, and
        blindly enabling parity COULD cause problems. Let the BIOS
        handle it ....
    Cut a special version for CSE to give to Reveal ....

Version 1.03 - 1.04
    Added support for high speed playback. Pinball fantasy uses it.....

Version 1.04 - 1.05
    Fixed win DOS box problem. Don't look in iw.ini file for CSN and READ
        port.
    Added support for resetting back to DMA channel 0

Version 1.05 - 1.06
    Added some debug options to try and isolate NBA 95 problem. DEBUG only,
        no run time changes....
    Added some DEBUG stuff for trying to find compressed audio bugs
    Fixed a problem with compressed audio. Works better . (not perfect YET)
    Fixed another problem with AST's Phoenix BIOS. Trap ctrl-alt-del and
        disable NMI's so it doesn't hang when they scan hardware ...
    Added copyright in loader and driver. Don't print it in banner anymore.


    library builder.
        Bug. Unlinking image.dat before closing was causing lots of lost
            clusters.
        Fixed bug copying data. Copied 1 too many bytes & corrupted first
            byte of previous wave.
        8-16 bit conversion broken. Fixed.
        signed - unsigned conversion broken. Fixed.
                - caused sine wave #1 to be wrong ...

Version 1.06 - 1.07

    Removed leftover profane variable from synint.asm (unused)
    Reordered loader startup procedures so MLS gets initialized first
        This fixes the /? option (didn't print anything before)
        Added support for autoinit record. (looked like TFX used it....)
        Cleaned up some flag variable. Saved some code.
        Minor changes to DMA counter checks ...
        More debug stuff. Can now save data into DRAM and have debugger
          upload it after machine has reset to do a post-mortem.
        Made changeborder a function rather than a macro.
    Driver now returns version 2.0 instead of 2.1. NBA Live and NHL
       hockey would die with 2.1 (really should have been 2.0 anyway ...)
    First-access now turns speaker on. It was possible for adlib-only
      games to not enable output and therefore get no sound.
    Compressed audio works for Mortal Kombat. (first time only) More work
     needs to be done.
    Lots of DMA debugging stuff added to driver and debugger.
    Debugger can poke commands into DRAM so sbosdeb.exe can upload them
       after a game hangs up (post-mortem)
    Ifdef-ed some commands out of driver (mostly MIDI) to save some space.
       VERY little room left before exceeding 20K.
    Driver supports auto-init record.

Version 1.07 - 1.08
    Fixed Retribution. Blown stack by calling handler  in IRQ. Also had
     a dirty CD .....
    Made NMI code faster to minimize amount of lost data because of
       over head
    Fixed 2xE handshake problem. XWING wouldn't detect properly.
    Made both C code and ASM code leave TRD off if in autoinit mode.
       This helps with clicks

Version 1.08 - 1.09
    Main difference is adding code to allow fifo to flush after DMA TC
      IRQ. This fixes ALOT of audio pops. Now PEN is not turned off 
      when counter IRQ happens. It changes to polled I/O mode w/PEN IRQS
      turned off.

Version 1.08 - 1.09
     Fixed FX fighter. moved chage_from_pio to AFTER codec set up for DMA

Version 1.09 - 1.10
	Requesting DIRECTCODEC will put codec in mode 2 and shut off variable
	  frequency mode.
	After wake_codec() or wake_synth() we force a spawn of the loader to
	  refresh registers and such.  This was not working in a windows
	  DOS box.

Version 1.10 - 1.11
         Optimize code to get back under 20K
         Added call to IRQ handler when windows send me a port trap to
           'fix' 'lost' irqs. Not sure why we are losing them, but this
           gets past the problem.
         Changed DSP code to NOT gen irq if in autoinit DMA w/ 2 byte buffer.
           There were woo many IRQs, and windows DOS box would hang. Apps
           don't seem to need IRQ. (PGA486, mech warrior 2 etc)
         Moved some interrupt disable/enable stuff around to try and
           help DOS boxes. There is a companion change to WIN95 VxD to
           dramatically improve DOS box SBOS viability.
         Changed test for 'windows running' to be just the test to see if
          we can talk to the VxD. This is necessary to allow a win95 DOS
          box to prevent apps from detecting windows but still let SBOS
          know its there. Some games will detect windows and do BAD stuff,
          so being able to disable that detection is very valuable.
        Fixed really small bug in code to search for valid 2f id number.
          Now will return correct fail code if all IDs are taken up.  (should
          never happen)
        Removed ALL code ifdef'ed for either INTERWAVE or ULTRASND. Now
          this just supports IW. Its a lot less confusing and the code
          would no longer work on a MAX anyway......
        FIxed code to allow irq 10 and 4 to work
        Fixed code to allow DMA chan 0 to work.
        Fixed the IRQ and DMA variable to make sense.

Version 1.11 - 1.20
       Finished 'LINT'ing code. Got rid of unused vars. Fixed a potential
          bug in synth voice handling. Optimized a bit more.
       Made minor changes to synth/codec irq handler to  try and get rid
          of pops in Angel Devoid. Better, but not gone.
       Fixed ADC problem with Super Solver Spellbound detection. It looks
          like it broke when I went to PIO mode ....
       There are still problems with the DMA request being left enabled
          when one game ends and the next one begins. (Doom then Spellbound)

 ************************************************************************/
