/***************************************************************************
*       NAME:  UTIL.C $Revision: 1.3 $
**      COPYRIGHT:
**      "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************/
#include "sbosdefs.h"
#include "utillib.h"
#include "dac.h"

/****************************************************************************

FUNCTION DEFINITION:
assign_ports - Assigns port locations to local variables.

DESCRIPTION:
  Uses the values in lower_baseport and upper_baseport to determine other
  port locations on the soundcard.

EXPECTS:
  config->lower_base_port, config->upper_base_port must be valid

*/
void assign_ports(BOARD_CFG *config,PORT_STRUC *ports)
{
	ports->lower_baseport      = config->lower_base_port;
	ports->upper_baseport      = config->upper_base_port;
	ports->reg_mixer           = ports->lower_baseport + 0x00;
	ports->reg_sb2x6           = ports->lower_baseport + 0x06; /** WRITE **/
	ports->reg_irq_status      = ports->lower_baseport + 0x06; /** READ  **/
	ports->reg_adlib_status    = ports->lower_baseport + 0x08;
	ports->reg_update_sb2xA    = ports->lower_baseport + 0x08;
	ports->reg_adlib_data      = ports->lower_baseport + 0x09;
	ports->reg_sb2xC           = ports->lower_baseport + 0x0C;
	ports->reg_2xC_write       = ports->lower_baseport + 0x0D; /** WRITE **/
	ports->reg_sb2xE           = ports->lower_baseport + 0x0E;
	ports->reg_status_read     = ports->lower_baseport + 0x0F; /** READ **/
	ports->reg_2xFcontrol      = ports->lower_baseport + 0x0F; /** WRITE **/
	ports->reg_2xBindexed      = ports->lower_baseport + 0x0B;
	ports->reg_midi_control    = ports->upper_baseport + 0x00;
	ports->reg_midi_data       = ports->upper_baseport + 0x01;
	ports->reg_voice_sel       = ports->upper_baseport + 0x02;
	ports->reg_index           = ports->upper_baseport + 0x03;
	ports->reg_data_low        = ports->upper_baseport + 0x04;
	ports->reg_data_high       = ports->upper_baseport + 0x05;
	ports->reg_dram_io         = ports->upper_baseport + 0x07;
	ports->reg_388_read        = ports->lower_baseport + 0x0A; /** READ **/
	ports->reg_388_write       = 0x388;                 /** WRITE **/
	ports->reg_389             = 0x389;
	ports->codec_baseport      = config->codec_base_port;
	ports->reg_codec_addr      = ports->codec_baseport + CODEC_ADDR;	
	ports->reg_codec_data      = ports->codec_baseport + CODEC_DATA;	
	ports->reg_codec_status    = ports->codec_baseport + CODEC_STATUS;	
	ports->reg_codec_pio       = ports->codec_baseport + CODEC_PIO;	
}
