;*********************************************************************
;
; SYNTH.ASM 
;
;*********************************************************************
; THIS MODULE MUST ALL REMAIN RESIDENT
.386

_DATA     segment word public use16 'DATA'
_DATA     ends
_BSS      segment word public use16 'BSS'
_BSS      ends
_TEXT     segment byte public use16 'CODE'
_TEXT     ends

DGROUP    group    _DATA,_BSS,_TEXT

_DATA     segment word public use16 'DATA'

;---------------------------------------------------------------------
; LIST OF PUBLICS
;---------------------------------------------------------------------
public _syn_delay
public _convert_to_16bit

;---------------------------------------------------------------------
; LIST OF EXTERNS
;---------------------------------------------------------------------
;
; All needed ports
;
extrn _reg_mixer:word
extrn _reg_sb2x6:word
extrn _reg_irq_status:word
extrn _reg_dram_io:word
extrn _reg_adlib_status:word
extrn _reg_adlib_data:word
extrn _reg_sb2xC:word
extrn _reg_2xC_write:word
extrn _reg_sb2xE:word
extrn _reg_status_read:word
extrn _reg_2xFcontrol:word
extrn _reg_2xBindexed:word
extrn _reg_index:word
extrn _reg_data_high:word
extrn _reg_data_low:word
extrn _reg_388_read:word
extrn _reg_389:word
extrn _reg_voice_sel:word

_DATA ends

_TEXT           segment byte public use16 'CODE'
assume          cs:DGROUP, ds:DGROUP, ss:DGROUP

;---------------------------------------------------------------------
; _syn_delay()
;
; Provides a delay long enough for the synth update in the GF1 to make
; sure a value was written to a voice specific register.
;---------------------------------------------------------------------
_syn_delay proc near
    mov cx,15              ; read the register this many times for delay
delay_top:
    mov dx,_reg_mixer  ; read the voice select register
    in al,dx
    loop delay_top       ; keep jumping until cx is zero
    ret
_syn_delay endp

;---------------------------------------------------------------------
; _convert_to_16bit()
;
; This function will translate the address if the dma channel
; is a 16 bit channel. This translation is not necessary for
; an 8 bit dma channel.
;---------------------------------------------------------------------
_convert_to_16bit proc near
    push bp
    mov bp,sp
    mov    eax,dword ptr [bp+4]     ; EAX = address = [bp+4]
    mov ebx,eax                  ; EBX = hold_address
    shr    eax,1                    ; convert to 16 translated address.
    shld edx,eax,16              ; return value is DX:AX
    pop bp
    ret    
_convert_to_16bit endp

_TEXT ends
    end
