/************************************************************************
	shared.h

	Defines shared data structure
************************************************************************/

/** make sure that this is the same as in the asm file **/
#define LOADER_NAME_LEN 50

typedef struct
	{
	void (interrupt *old_int02)();
	void (interrupt *old_int08)();
	void (interrupt *old_int15)();
	void (interrupt *old_int21)();
	void (interrupt *old_int2f)();
	void (interrupt *old_int7x)();
	void (interrupt *old_intsynth)();
	void (interrupt *old_win21)();
	} OLD_VECTORS;

typedef struct
	{
	void (interrupt *new_int02)();
	void (interrupt *new_int08)();
	void (interrupt *new_int15)();
	void (interrupt *new_int21)();
	void (interrupt *new_int2f)();
	void (interrupt *new_int7x)();
	void (interrupt *new_intsynth)();
	void (interrupt *new_win21)();
	} NEW_VECTORS;

typedef struct  /** This one grows... **/
	{
	unsigned char dev_mode_synth;
	unsigned char dev_mode_codec;
	char loader_name[LOADER_NAME_LEN];
	unsigned char comm_vect;
	unsigned char synth_vect;
	unsigned int mpu401_port;
	unsigned char mpu401_irq;
	unsigned char mixer_mask;
	unsigned char regctl_mask;
	unsigned char adsbint_mask;
	unsigned char dram_size;
	unsigned char spec_eoi;
	unsigned char pic_mask;
	unsigned char multiplex_id;
	unsigned long dram_begin;
	unsigned long dram_stopped_voice;
	unsigned long dram_temp_buff;
	unsigned long dram_perc_map;
	unsigned long dram_wave_info;
	unsigned long dram_mpu_info;
	unsigned int save_lmcfi;
	unsigned int new_lmcfi;
	} SBOSDATA;

typedef struct 
	{
	unsigned int status;
	unsigned int size;
	unsigned char version_high;
	unsigned char version_low1;
	unsigned char version_low2;
	unsigned int user_dram_size;
	unsigned int synth_atten;
	unsigned int dac_atten;
	NEW_VECTORS near * new_vectors;
	OLD_VECTORS near * old_vectors;
	BOARD_CFG near * config;
	SBOSDATA near * sbosdata;
	unsigned char near *pick_table;
	WAVE_INFO near * wave_info;
	WAVE_DATA near * wave_data;

// ALL data after here MUST be initialized by loader .....

	unsigned int num_waves;
	unsigned int num_basic;
	unsigned int num_melodics;
	unsigned int num_percs;
	unsigned int num_effects;

	unsigned int codec_base;

	MAPS	instrument_maps;
	PATCH_INFO patch_info;
	long rom_addr[4];		// never used for MAX ....

	} SHARED;
