;************************************************************************
;    sbosdefs.inc
;
;************************************************************************
; Standard defines
TRUE  equ 1
FALSE equ 0

; Maximum length of the full path name for the loader 
; The path name is stored in the driver data space by the loader when it 
; runs.  There is only a fixed number of bytes for space for the name.  If 
; the name exceeds that, data can be destroyed, so the loader prints a
; message, unloads the driver, and exits.
LOADER_NAME_LEN  equ     50      ; max length of full path name for loader

; This is the location in dram where the int 21h code will look to see if
; dram has been changed.
SPAWNLOC         equ     2000h   ; DRAM address for comparison (00002000h)

; MS Windows API Identification Number
;API_ID equ 0295ah ; This is Gravis'
API_ID equ 033f0h

; Miscellaneous defines
XTRA_STACK equ 100
STARTUP_STACK_SIZE equ 4096

IFDEF DEBUG
GPR1W_CODE equ 0
GPR2W_CODE equ 1
GPR1R_CODE equ 2
GPR2R_CODE equ 3
R2xER_CODE  equ 4
R2x6W_CODE  equ 5
R388W_CODE  equ 6
R389W_CODE  equ 7
R2xCW_CODE  equ 8
DMA_DEBUG equ 9
DMA_MARKER equ 10
TIMER_MARKER equ 11
MARKER4_CODE equ 252
MARKER3_CODE equ 253
MARKER2_CODE equ 254
MARKER_CODE  equ 255
; DMA DEBUG codes ....
DMA_HALT_MARK			equ 57H
DMA_INIT_MARK			equ 58H
DMA_PROG_BLOCK_MARK		equ 59H
DMA_SET_BLOCK_MARK		equ 5aH
DMA_IRQ_MARK			equ 5bH
DMA_ADC_BLOCK_MARK		equ 5CH
DMA_ADPCM_MARK			equ 5DH
DMA_ADPCM_REF_MARK		equ 5EH
DMA_IRQ_ADPCM_MARK		equ 5FH
ENDIF

; Defines for interrupts **/
INT_NMI   equ 02h
INT_TIMER equ 08h
INT_KEY   equ 15h
INT_DOS   equ 21h
INT_2F    equ 2fh

; Defines for status bit in shared data space
; SHOULD mirror sbosdefs.h
STAT_DRIVER_INIT       equ 0001h
STAT_CHAIN_NMI         equ 0002h
STAT_COMBINED_IRQ      equ 0004h
STAT_ROM               equ 0008h
STAT_UNKNOWN_NMI       equ 0010h
STAT_IGNORE_SPAWN      equ 0020h
STAT_SKIP_DOS4GW_BUG   equ 0040h
STAT_FIRST_CONTROL     equ 0080h
STAT_FORCE_FLIPPER     equ 0100h
STAT_WINDOWS_RUNNING   equ 0200h
STAT_WINAPI_ACTIVE     equ 0400h
STAT_WIN21_FLAG        equ 0800h
STAT_ADLIB_ENABLED     equ 1000h
STAT_MPU401_ENABLED    equ 2000h
STAT_CODEC_ENABLED     equ 4000h
STAT_NO_NMIS           equ 8000h

DEV_HW                 equ 1
DEV_WINDOWS            equ 2
DEV_GAME               equ 3
DEV_ASLEEP             equ 4

; Defines for int2f API
INT2F_INSTALL          equ 00h
INT2F_NUM_DEVICES      equ 01h
INT2F_STATUS           equ 02h
INT2F_SUSPEND          equ 03h
INT2F_WAKE             equ 04h
INT2F_FREE             equ 05h
INT2F_GAME_INSTALL     equ 20h
INT2F_GAME_OPEN        equ 21h
INT2F_GAME_CLOSE       equ 22h
INT2F_MIXER            equ 80h

; Defines for int7x communications
; These values are preloaded into AX prior to calling int 7x
COM_MIDI_BYTE     equ 0001h
COM_MIDI_STRING   equ 0002h
COM_GET_SHARED    equ 0080h
COM_DRIVER_LOADED equ 0081h
IFDEF DEBUG
COM_DEBUG         equ 0082h
ENDIF
COM_WINAPI        equ 0083h
COM_DRIVER_UNLOAD equ 0084h
COM_IGNORE_SPAWN  equ 0085h

; Game API
GAME_CODEC_STOLEN equ 01h
GAME_SYNTH_STOLEN equ 02h

DMA_CONTROL_DEFAULT equ 092h

;/* Plug and Play Indirect Registers */
IW_PCCCI  EQU 02h
IW_PWAKEI EQU 03h
IW_PCSNI  EQU 06h
IW_PLDNI  EQU 07h
IW_PUACTI EQU 30h
IW_PURCI  EQU 31h
IW_P2X0HI EQU 60h
IW_P2X0LI EQU 61h
IW_P3X0HI EQU 62h
IW_P3X0LI EQU 63h
IW_PHCAI  EQU 64h
IW_PLCAI  EQU 65h
IW_PRAHI  EQU 60h
IW_PRALI  EQU 61h
IW_PATAHI EQU 60h
IW_PATALI EQU 61h
IW_P201HI EQU 60h
IW_P201LI EQU 61h
IW_P388HI EQU 60h
IW_P388LI EQU 61h
IW_P401HI EQU 60h
IW_P401LI EQU 61h
IW_PUI1SI EQU 70h
IW_PUI2SI EQU 72h
IW_PUD1SI EQU 74h
IW_PUD2SI EQU 75h
IW_PSBISI EQU 70h
IW_PMISI  EQU 70h
IW_PPWRI  EQU 0F2h

;/* Plug and Play Logical Devices */
IWL_PNP_AUDIO  EQU 0
IWL_PNP_EXT    EQU 1
IWL_PNP_GAME   EQU 2
IWL_PNP_ADLIB  EQU 3
IWL_PNP_MPU401 EQU 4

IFDEF NEVER
IW_PCCCI  equ 02h
IW_PWAKEI equ 03h
IW_PLDNI  equ 07h
IW_PUACTI equ 30h
IW_PURCI  equ 31h
ifdef NEVER
IW_P2X0HI equ 60h
IW_P2X0LI equ 61h
IW_P3X0HI equ 66h
IW_P3X0LI equ 67h
IW_PHCAI  equ 68h
IW_PLCAI  equ 69h
else			; BO Silicon
IW_P2X0HI equ 60h
IW_P2X0LI equ 61h
IW_P3X0HI equ 62h
IW_P3X0LI equ 63h
IW_PHCAI  equ 64h
IW_PLCAI  equ 65h
endif
IW_PUI1SI equ 70h
IW_PUI2SI equ 72h
IW_PUD1SI equ 74h
IW_PUD2SI equ 75h
IW_PPWRI  equ 0F2h

IW_PSBISI equ 70h
ENDIF

