/************************************************************************
    sbosdefs.h

************************************************************************/
#define CFG_FILE	"iwsblib.cfg"
#define OUT_FILE	"iwsb"

        /** Standard defines **/
#define TRUE 1
#define FALSE 0
#define UCHAR unsigned char

        /** Miscellaneous defines **/
void print_string(char *);
void print_crlf(void);

        /** Defines for interrupts **/
#define INT_NMI 0x02
#define INT_TIMER 0x08
#define INT_KEY 0x15
#define INT_DOS 0x21
#define INT_2F 0x2f

        /** Defines for status bit in shared data space **/
        /** SHOULD mirror sbosdefs.inc **/
#define STAT_DRIVER_INIT      0x0001
#define STAT_CHAIN_NMI        0x0002
#define STAT_COMBINED_IRQ     0x0004
#define STAT_ROM              0x0008
#define STAT_UNKNOWN_NMI      0x0010
#define STAT_IGNORE_SPAWN     0x0020
#define STAT_SKIP_DOS4GW_BUG  0x0040
#define STAT_FIRST_CONTROL    0x0080
#define STAT_FORCE_FLIPPER    0x0100
#define STAT_WINDOWS_RUNNING  0x0200
#define STAT_WINAPI_ACTIVE    0x0400
#define STAT_WIN21_FLAG       0x0800
#define STAT_ADLIB_ENABLED    0x1000
#define STAT_MPU401_ENABLED   0x2000
#define STAT_CODEC_ENABLED    0x4000
#define STAT_NO_NMIS          0x8000

#define DEV_HW                1
#define DEV_WINDOWS           2
#define DEV_GAME              3
#define DEV_ASLEEP            4

/** Defines for int2f API **/
#define INT2F_INSTALL         0x00
#define INT2F_NUM_DEVICES     0x01
#define INT2F_STATUS          0x02
#define INT2F_SUSPEND         0x03
#define INT2F_WAKE            0x04
#define INT2F_FREE            0x05
#define INT2F_GAME_INSTALL    0x20
#define INT2F_GAME_OPEN       0x21
#define INT2F_GAME_CLOSE      0x22
#define INT2F_MIXER           0x80

        /** Defines for int7x communications **/
        /** These values are preloaded into AX prior to calling int 7x **/
#define COM_MIDI_BYTE     0x0001
#define COM_MIDI_STRING   0x0002
#define COM_GET_SHARED    0x0080
#define COM_DRIVER_LOADED 0x0081
#ifdef DEBUG
#define COM_DEBUG         0x0082
#endif
#define COM_WINAPI        0x0083
#define COM_DRIVER_UNLOAD 0x0084
#define COM_IGNORE_SPAWN 0x0085

/** Game API **/
#define GAME_CODEC_STOLEN 0x0001
#define GAME_SYNTH_STOLEN 0x0002

#define DMA_CONTROL_DEFAULT 0x92

/***** From this point down, all defines are for C code only  *****/
/***** Everything above this point should mirror sbosdefs.inc *****/

/** This structure is used in loader code only .. **/
/** The driver has global defined port variables like this in its own space **/
/** This does not belong in shared.h because it is not mapped to any shared
    data **/
typedef struct 
    {

// Global port declarations for use anywhere in the driver
    unsigned int lower_baseport;
    unsigned int upper_baseport;
    unsigned int codec_baseport;
    unsigned int reg_mixer;
    unsigned int reg_sb2x6;
    unsigned int reg_irq_status;
    unsigned int reg_dram_io;
    unsigned int reg_adlib_status;
    unsigned int reg_update_sb2xA;
    unsigned int reg_adlib_data;
    unsigned int reg_sb2xC;
    unsigned int reg_2xC_write;
    unsigned int reg_sb2xE;
    unsigned int reg_status_read; /** READ **/
    unsigned int reg_2xFcontrol; /** WRITE **/
    unsigned int reg_2xBindexed;
    unsigned int reg_voice_sel;
    unsigned int reg_midi_control;
    unsigned int reg_midi_data;
    unsigned int reg_index;
    unsigned int reg_data_high;
    unsigned int reg_data_low;
    unsigned int reg_388_read;
    unsigned int reg_388_write;
    unsigned int reg_389;

    unsigned int reg_codec_addr;
    unsigned int reg_codec_data;
    unsigned int reg_codec_status;
    unsigned int reg_codec_pio;
} PORT_STRUC;

/** Macros and stuff **/
#define    LS_WORD( x )        ((unsigned int)(x))
#define    MS_WORD( x )        ((unsigned int)(((long) x) >> 16))
#define HI_B( x )        (unsigned char)((unsigned int)(x) >> 8)
#define LOW_B( x )        ((unsigned char)(x) )

typedef struct {
    unsigned int lower_base_port;
    unsigned int upper_base_port;
    unsigned int codec_base_port;
    unsigned char orig_dma1;
    unsigned char orig_dma2;
    unsigned char orig_dma_mask;
    unsigned char orig_irq1;
    unsigned char orig_irq2;
    unsigned char orig_irq_mask;
    unsigned char orig_ieirqi_mask;
    unsigned char sb_dma;
    unsigned char sb_irq;
    unsigned char sbos_dma_mask;
    unsigned char game_irq_mask;
    unsigned char game_ieirqi_mask;
    unsigned int pnp_read;
    unsigned int pnp_csn;
    unsigned int pnp_index;
    unsigned int pnp_write;
} BOARD_CFG;

