DMA_CONTROL         EQU 41H
SET_DMA_ADDRESS     EQU 42H
SET_DRAM_LOW        EQU 43H
SET_DRAM_HIGH       EQU 44H

TIMER_CONTROL       EQU 45H
TIMER1              EQU 46H
TIMER2              EQU 47H

SET_SAMPLE_RATE     EQU 48H
SAMPLE_CONTROL      EQU 49H

SET_JOYSTICK        EQU 4BH
MASTER_RESET        EQU 4CH

IW_LDSAHI               EQU 050H
IW_LMSBAI               EQU 051H
IW_LMCFI                EQU 052H
IW_LMCI                 EQU 053H
IW_LMRFAI               EQU 054H
IW_LMPFAI               EQU 055H
IW_LMFSI                EQU 056H
IW_LDICI                EQU 057H
IW_LDIBI                EQU 058H
IW_ICMPTI               EQU 059H
IW_IDECI                EQU 05aH
IW_IVERI                EQU 05bH
IW_IEMUAI               EQU 05cH
IW_IEMUBI               EQU 05dH
IW_GMRFAI               EQU 05eH
IW_ITCI                 EQU 05fH
IW_IEIRQI               EQU 060h

;/* Voice register mapping. */
SET_CONTROL         EQU 00H
SET_FREQUENCY       EQU 01H
SET_START_HIGH      EQU 02H
SET_START_LOW       EQU 03H
SET_END_HIGH        EQU 04H
SET_END_LOW         EQU 05H
SET_VOLUME_RATE     EQU 06H
SET_VOLUME_START    EQU 07H
SET_VOLUME_END      EQU 08H
SET_VOLUME          EQU 09H
SET_ACC_HIGH        EQU 0aH
SET_ACC_LOW         EQU 0bH
SET_BALANCE         EQU 0cH
SET_VOLUME_CONTROL  EQU 0dH
SET_VOICES          EQU 0eH

GET_CONTROL         EQU 80H
GET_FREQUENCY       EQU 81H
GET_START_HIGH      EQU 82H
GET_START_LOW       EQU 83H
GET_END_HIGH        EQU 84H
GET_END_LOW         EQU 85H
GET_VOLUME_RATE     EQU 86H
GET_VOLUME_START    EQU 87H
GET_VOLUME_END      EQU 88H
GET_VOLUME          EQU 89H
GET_ACC_HIGH        EQU 8aH
GET_ACC_LOW         EQU 8bH
GET_BALANCE         EQU 8cH
GET_VOLUME_CONTROL  EQU 8dH
GET_VOICES          EQU 8eH
GET_IRQV            EQU 8fH

;/********************************************************************
; *
; * GF1 global registers    ($41-$4C)
; *
; *******************************************************************/

;/* DMA control register */
DMA_ENABLE          EQU 01H
DMA_READ            EQU 02H        ;/* 1=read,0=write */
DMA_WIDTH_16        EQU 04H        ;/* 1=16 bit,0=8 bit (dma chan width)*/
DMA_RATE            EQU 18H        ;/* 00=fast, 11=slow */
DMA_IRQ_ENABLE      EQU 20H        ;/* 1=enable */
DMA_IRQ_PENDING     EQU 40H        ;/* read */
DMA_DATA_16         EQU 40H        ;/* write (data width) */
DMA_TWOS_COMP       EQU 80H        ;/* 1=do twos comp */

;/* These are the xfer rate bits ... */
DMA_R0        EQU 00H        ;/* Fastest DMA xfer (~650khz) */
DMA_R1        EQU 08H        ;/* fastest / 2 */
DMA_R2        EQU 10H        ;/* fastest / 4 */
DMA_R3        EQU 18H        ;/* Slowest DMA xfer (fastest / 8) */

;/* ($0,$80) Voice control register */
VOICE_STOPPED       EQU 01H        ;/* voice has stopped */
STOP_VOICE          EQU 02H        ;/* stop voice */
VC_DATA_TYPE        EQU 04H        ;/* 0=8 bit,1=16 bit */
VC_LOOP_ENABLE      EQU 08H        ;/* 1=enable */
VC_BI_LOOP          EQU 10H        ;/* 1=bi directional looping */
VC_WAVE_IRQ         EQU 20H        ;/* 1=enable voice's wave irq */
VC_DIRECT           EQU 40H        ;/* 0=increasing,1=decreasing */
VC_IRQ_PENDING      EQU 80H        ;/* 1=wavetable irq pending */

;/* ($D,$8D) Volume control register */
VOLUME_STOPPED      EQU 01H        ;/* volume has stopped */
STOP_VOLUME         EQU 02H        ;/* stop volume */
VC_ROLLOVER         EQU 04H        ;/* Roll PAST end & gen IRQ */
VL_LOOP_ENABLE      EQU 08H        ;/* 1=enable */
VL_BI_LOOP          EQU 10H        ;/* 1=bi directional looping */
VL_WAVE_IRQ         EQU 20H        ;/* 1=enable voice's wave irq */
VL_DIRECT           EQU 40H        ;/* 0=increasing,1=decreasing */
VL_IRQ_PENDING      EQU 80H        ;/* 1=wavetable irq pending */

