/************************************************************************
	fm.h - defines for fm emulation
************************************************************************/
#define UPD_VOLUME      0x01U
#define UPD_PERCUSSION  0x02U
#define UPD_FREQUENCY   0x04U
#define UPD_SUSTAIN     0x08U
#define UPD_INST_WAVE   0x10U
#define UPD_INSTRUMENT  0x20U
#define UPD_KEYON       0x40U

#define CUR_BANK	-1
#define CUR_INST	-1
#define CUR_BAL		-1

#define PERC_HIHAT      0x01
#define PERC_TOPCYM     0x02
#define PERC_TOMTOM     0x04
#define PERC_SNARE      0x08
#define PERC_BASS       0x10
#define PERC_ENABLE     0x20
#define PERC_ENABLE_ON  0x20
#define PERC_ENABLE_OFF 0x40

	/** 
	 **   Perc      FM-operator    FM-channel    IW-voice(fm_voice)
	 **   HIHAT         14          C8 - mod        14
	 **   TOPCYM        18          C9 - car        17
	 **   TOMTOM        15          C9 - mod        16
	 **   SNARE         17          C8 - car        15
	 **   BASS         13,16          C7           12,13
	 **
	 **/

#define VOICE_HIHAT     14 /** modulator **/
#define VOICE_TOPCYM    17 /** carrier   **/
#define VOICE_TOMTOM    16 /** modulator **/
#define VOICE_SNARE     15 /** carrier   **/
#define VOICE_BASS      13 /** carrier   **/
#define VOICE_PERC_LOW  12 /** Low percussion voice for compares **/

/** default balances for instrument **/
#define BAL_HIHAT       4
#define BAL_TOPCYM      5
#define BAL_TOMTOM      6
#define BAL_MIDDLE      7
#define BAL_SNARE       8
#define BAL_BASS        9

#define BANK_NOISE      TYPE_BASIC
#define INST_NOISE      4 /** noise    **/
//#define INST_HIHAT      46 /** hihatop  **/
#define INST_HIHAT      42 /** hihatcl  **/
#define INST_TOPCYM     51 /** cymride1 **/
#define INST_TOMTOM     47 /** tommid1  **/
#define INST_SNARE      38 /** snare1   **/
#define INST_BASS       35 /** kick1    **/

#define FREQ_NOISE      (2000L*1024L)

#define IS_MOD(x) (!(x & 0x01)) // TRUE if low bit is 0 - ie, modulator 
#define IS_CAR(x)   (x & 0x01)  // TRUE if low bit is 1 - ie, carrier 
#define MAKE_CAR(x) ((x & 0xFE)+1)
#define MAKE_MOD(x)  (x & 0xFE)
#define MAKE_PAN(x) (11-(x&0x07))

typedef struct
	{
	unsigned char param;   /** 20  AM - VIB - EG - KSR - MULT **/
	unsigned char level;   /** 40  Total Level                **/
	unsigned char ksl;     /** 40  KSL                        **/
	unsigned char attack;  /** 60  Attack                     **/
	unsigned char decay ;  /** 60  Decay                      **/
	unsigned char sustain; /** 80  Sustain                    **/
	unsigned char release; /** 80  Release                    **/
	unsigned char wave;    /** E0  Wave Select                **/
	} FM_OPERATOR;

typedef struct 
	{
	unsigned char freql; /** A0  F-Number (Low)             **/
	unsigned char keyon; /** B0  Keyon                      **/
	unsigned char freqh; /** B0  Block - FNumber(H)         **/
	unsigned char con;   /** C0  Feedback - Connection      **/
	} FM_CHANNEL;

#if ((sizeof(FM_CHANNEL))-4) /** if size of struct is not 4 **/
#error                   /** create an error **/
#endif

#if ((sizeof(FM_OPERATOR))-8) /** if size of struct is not 8 **/
#error                   /** create an error **/
#endif

