/***************************************************************************
*       NAME:  ERROR.C $Revision: 1.9 $
**      COPYRIGHT:
**      "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************/
#include "sbosdefs.h"
#include "error.h"
#include "stuff.h"

extern char mls_language[]; /** Error Message **/
extern char mls_default[];  /** Error Message **/
extern char mls_iwini[];    /** Error Message **/
extern char mls_file[];     /** Error Message **/
extern char sbos_mls[];     /**   'sbos.mls'  **/
extern char languages[];    /**  'Languages'  **/
extern char defaultstr[];   /**   'default'   **/
extern char ini_path[];     /**  Path to ini  **/
extern char error_string[]; /** Error Buffer  **/

/****************************************************************************

FUNCTION DEFINITION:
print_error -

DESCRIPTION:

EXPECTS:

MODIFIES:

SEE ALSO:

RETURNS:

*/
int print_error(int errornum)
{
	char *str;
	int ret = 0;

	if (errornum == ERROR_NO_LANGUAGE) 
		str = mls_language;
	else if (errornum == ERROR_NO_DEF_LANGUAGE) 
		str = mls_default;
	else if (errornum == ERROR_BAD_IWINI)
		str = mls_iwini;
	else if (errornum == ERROR_BAD_MESSAGE_FILE)
		str = mls_file;
	else
		{
		str = error_string;
		error_string[0] = 0;
		ret = iw_mls_getstring(sbos_mls, errornum, error_string, ERROR_STR_LEN);
		}

	if(ret == 0) /** OK **/
		{
		print_string(str);
		print_crlf();
		return(0);
		}

	if(errornum != ret) /** BAD STATUS - print out error message **/
		print_error(ret);
	return (-1);
}

/****************************************************************************

FUNCTION DEFINITION:
print_message -

DESCRIPTION:

EXPECTS:

MODIFIES:

SEE ALSO:

RETURNS:

*/
int print_message(int errornum)
{
	int ret;

	ret = iw_mls_getstring(sbos_mls, errornum, error_string, ERROR_STR_LEN);
	if(ret == 0)
		print_string(error_string);

	return ret;
}

/****************************************************************************

FUNCTION DEFINITION:
sbos_mls_init -

DESCRIPTION:

RETURNS:

*/
int sbos_mls_init(void)
{
    char nullchar = 0;
    char *ptrtonull = &nullchar;
	char buf[128];
	char *cp;

	iwu_get_profile_string(languages,defaultstr,ptrtonull,buf,128,ini_path);
	if(*buf == *ptrtonull)
		{
		print_error(ERROR_NO_LANGUAGE);
		return(-1);
		}

	iwu_get_profile_string(languages,buf,ptrtonull,buf,128,ini_path);
	if(*buf == *ptrtonull)
		{
		print_error(ERROR_NO_DEF_LANGUAGE);
		return(-1);
		}

	/**
	 ** go to the next null or ',' in the language string
	 **/
	for (cp=buf; *cp && *cp != ','; cp++) ;
	if (*cp == ',')
		cp++;
	else 
		{
		print_error(ERROR_NO_DEF_LANGUAGE);
		return(-1);
		}
	while (iwu_isspace(*cp)) cp++;
	iw_mls_init(cp);
	return(0);
}
