;*********************************************************************
;
; DEBUG Module --  
;
; The only entry points include:
;    add_to_debug_table() - add value to debugging table
;    start_debug_timer - start up a 1/10 sec timer for markers
;    stop_debug_timer - stop debug timer
;
;*********************************************************************
.386

INCLUDE sbosdefs.inc
INCLUDE dac.inc
INCLUDE dsp.inc

_DATA     segment word public use16 'DATA'
_DATA     ends
_BSS      segment word public use16 'BSS'
_BSS      ends
_TEXT     segment byte public use16 'CODE'
_TEXT     ends
DGROUP    group    _DATA,_BSS,_TEXT

IFDEF DEBUG    ; The whole thing is debug material

;Define poke_dram to have debug code poke values into IW DRAM at 32000
; Then sbosdeb.exe can upload the info to do a post-mortem on a game that
; dies and hangs .....
POKE_DRAM EQU 1

DEBUG_DATA_SIZE equ  10000

extrn _reg_codec_addr:word
extrn start_timer:near
extrn _poke_dram:near
extrn dsp_status:byte

;---------------------------------------------------------------------
; LIST OF PUBLICS
;---------------------------------------------------------------------
public _nmi_count
public _nmi_table
public _nmi_table_cnt
public _add_to_debug_table
public _enable_debug
public debug_timer
public changeborder

_DATA     segment word public use16 'DATA'
;
; This is a BIG data space for debugging FM-synth and mpu-401 commands
; The commands are put here in code for parsing later
; debug_ptr is an offset pointer into debug_data
;

DRAM_LEN_LOC equ 32000
dram_loc dw 32002

_nmi_table db DEBUG_DATA_SIZE dup ('D') ; 'D' for Data
_nmi_table_cnt dw 0
;
; Number of times the NMI routine was executed
;
_nmi_count dw 0
_enable_debug dw 1     ; Master enable of debug storing
operation_color db 0

_DATA     ends

_TEXT           segment byte public use16 'CODE'
assume          cs:DGROUP, ds:DGROUP, ss:DGROUP

;---------------------------------------------------------------------
; add_to_debug_table()
;
; Adds the data in al to the debug table in ram with the code dl unless full
; See sbosdefs.inc for the description of the codes
; AL - data
; DL - code
;---------------------------------------------------------------------
_add_to_debug_table proc near
    push bx
    push si
    ;
IFDEF POKE_DRAM
    cmp cs:_nmi_table_cnt,0
    jne not_first_debug
    push dx
    push cx
    mov cx,0fffh
    mov dx,DRAM_LEN_LOC
deb_loop:
    push dx
    push 0
    push 0
    push dx
    call _poke_dram
    add sp,6
    pop dx
    inc dx
    loop deb_loop
    pop cx
    pop dx
not_first_debug:
    push dx
    push ax
    push dx            ; first poke code
    push 0
    mov dx,cs:dram_loc    ; get loc to poke it
    push dx
    call _poke_dram
    add sp,6
    mov dx,cs:dram_loc    ; get loc to poke it
    inc dx
    pop ax        ; get data back
    push ax
    push ax        ; now push data ...
    push 0
    push dx
    call _poke_dram
    add sp,6
    cmp dx,0fffh
    ja near ptr stop_poking
    inc cs:dram_loc
    inc cs:dram_loc
stop_poking:
    pop ax
    pop  dx
ENDIF
    
    cmp cs:_enable_debug,0
    je short table_full           ; if not - leave
    ;
    mov bx,cs:_nmi_table_cnt      ; get number of values in table
    cmp bx,DEBUG_DATA_SIZE-1      ; compare with size of table
    jae short table_full          ; full??
    ;
    mov si,offset cs:_nmi_table   ; get offset of data table
    mov byte ptr cs:[si+bx],dl    ; store command
;    cmp dl,R2xER_CODE             ; compare command to 2xER_CODE
;    je short dont_save_data       ; if = don't write data
    mov byte ptr cs:[si+bx+1],al  ; else, write data
    add cs:_nmi_table_cnt,1       ; account for data
dont_save_data:
    add cs:_nmi_table_cnt,1       ; account for data
IFDEF POKE_DRAM
    push dx
    push ax
; Now update the #'s of bytes saved in the buffer
    mov dx,cs:_nmi_table_cnt
    push dx
    push 0
    mov dx,DRAM_LEN_LOC
    push dx
    call _poke_dram
    add sp,6
    mov dx,cs:_nmi_table_cnt
    xchg dl,dh
    push dx
    push 0
    mov dx,DRAM_LEN_LOC+1
    push dx
    call _poke_dram
    add sp,6
    pop ax
    pop dx
ENDIF
table_full:
    pop si
    pop bx
    ret
_add_to_debug_table endp

debug_timer proc near
    or dsp_status,DEBUG_TIMER_BIT
    mov bx,5000
    call near ptr start_timer
    ret
debug_timer endp

changeborder proc near
    push dx
    push ax
    mov dx,3daH
    in al,dx
    mov dx,3c0h
    mov al,31h
    out dx,al
    ;
    mov al,cs:operation_color
    inc al
    cmp al,32
    jl @@asdf
    mov al,0
@@asdf:
    mov cs:operation_color,al
    out dx,al
    pop ax
    pop dx
    ret
changeborder endp

_TEXT ends
ENDIF
    end
