/***************************************************************************
*	NAME:  OS.H $Revision: 1.3 $
**	COPYRIGHT:
**	"Copyright (c) 1994, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: os.h $
* Revision 1.3  1995/04/10 11:28:02  mleibow
* Fixed os_setvect
* Revision 1.2  1995/03/22 13:14:54  mleibow
* Revision 1.1  1995/02/23 11:06:52  unknown
* Initial revision
* Revision 1.2  1994/09/13 09:38:40  unknown
* Added os_file_gets
* Revision 1.1  1994/09/12 15:17:44  unknown
***************************************************************************
* This module has macros for operating system dependant functions 
***************************************************************************/

#include <conio.h>

/* Seek from the current file position */
#define DOS_SEEK_START     0
#define DOS_SEEK_END       2
#define DOS_SEEK_CURRENT   1

/* DMA mode bits */
#define DMAMODE_VERIFY_TRANSFER	0x00	/* verify DMA transfer mode */
#define DMAMODE_WRITE		0x04	/* write to external device */
#define DMAMODE_READ		0x08	/* read from external device */
#define DMAMODE_AUTOINIT	0x10	/* autoinitialization mode */
#define DMAMODE_AUTOINC		0x20	/* autoincrement mode */
#define DMAMODE_DEMAND_MODE	0x00
#define DMAMODE_SINGLE_MODE	0x40
#define DMAMODE_BLOCK_MODE	0x80
#define DMAMODE_CASCADE_MODE	0xC0

/* DMA macros */
#define NUM_CHANNELS 3
#define DMA_GET_PAGE(addr) ((unsigned short)((addr & 0xffff0000L) >> 16))
#define DMA_GET_ADDR(addr) ((unsigned short)(addr & 0x0000ffffL))
#define DMA_PAGE_SIZE	0x10000L

#if defined(__WATCOMC__)
#undef FAR
#define FAR
#define OS_DISABLE_INTERRUPTS() _disable()
#define OS_ENABLE_INTERRUPTS()  _enable()
#define OS_OUTPORTW 		outpw
#define OS_OUTPORTB		outp
#define OS_INPORTW		inpw
#define OS_INPORTB		inp
#pragma aux OS_LOAD_ES_WITH_DS = "push ds", "pop es"
#pragma aux OS_PUSH_DISABLE =	\
	"pushf",		\
	"cli"
#pragma aux OS_PUSH_FLAGS =	\
	"pushf"
#pragma aux OS_POP_FLAGS =	\
	"popf"
#pragma aux OS_PUSH_DS =	\
	"push ds"
#pragma aux OS_POP_DS =		\
	"pop ds"

typedef void (__far *OS_PINTERRUPT)(void);
typedef void OS_INTERRUPT(void);

void os_init_channel(int channel, int dma_channel);
void os_pgm_dma(int chan,
	unsigned long count,
	unsigned short mode,
	unsigned short page,
	unsigned short addr);
void os_stop_dma(int channel);
unsigned long os_dma_count(int channel);
unsigned long os_file_read(int handle, void *io_buffer, unsigned short size);
unsigned short os_file_close(int handle);
unsigned short os_file_seek(int handle, unsigned long offset, int method);
int os_file_open(char *name);
char RFAR *os_file_gets( int handle, char RFAR *io_buffer, unsigned short size);
OS_PINTERRUPT os_getvect(int int_number);
void os_setvect(int int_number, OS_PINTERRUPT isr);
void os_set_irq(int irq, OS_PINTERRUPT handler);
void os_unset_irq(int irq);
void os_eoi(unsigned short irq);
char RFAR *os_getenv(char RFAR *name);
void os_ins(USHORT port, void RFAR *data, USHORT length);
void os_outs(void RFAR *data, USHORT length);
void os_outset(USHORT port, UCHAR data, USHORT length);
#endif
