# InterWave Kernel Makefile for Borland C++ 4.0
# $Revision: 1.4 $

PROCESSOR = -DPROC386
BCC3_1 = -DTHREE_1
EXTRA =
# DIR = t$(MODEL)
LIBNAME = iw_os$(MODEL).lib
!if '$(MODEL)'=='t'
EXTRA = $(EXTRA) -D__t__
!endif
!if '$(MODEL)'=='t' || '$(MODEL)'=='s' || '$(MODEL)'=='c'
CODESIZE = -DNEARCODE=1
!else
CODESIZE = -DNEARCODE=0
!endif
!if '$(MODEL)'=='t' || '$(MODEL)'=='s' || '$(MODEL)'=='m'
DATASIZE = -DNEARDATA=1
!else
DATASIZE = -DNEARDATA=0
!endif
!if $(PROCESSOR)==-DPROC386
EXTRA = $(EXTRA) $(PROCESSOR)
CPROC = -3
ASMPROC = -j.386p 
!else
CPROC = -2
ASMPROC = -j.286p
!endif
OSINCDIR = os\dos\borland
# CONFIGINCDIR = configs\borland
CFLAGS = $(DEBUG) -I$(CONFIGINCDIR);$(INCLUDEPATH);$(OSINCDIR) $(DATASIZE) $(CODESIZE) $(BCC3_1) $(CPROC) -Ox -Os -j7 -m$(MODEL)! $(PROCESSOR)
ASMFLAGS = -q -t -ml -DTASM $(ASMPROC) $(CODESIZE) $(DATASIZE) -D__$(MODEL)__ $(PROCESSOR)

.autodepend
.path.obj = $(TARGETDIR)

.c.obj:
	bcc -c +bcc.cfg { $*.c}
#	bcc -c +bcc.cfg -S $*.c
#	tasm -q -t -l -ml $(CODESIZE) $(DATASIZE) -D__$(MODEL)__ $(TARGETDIR)\$*.asm
#	del $*.asm

!if "$(DEBUG)"=="-v"
.asm.obj :
        tasm -l -zi $(ASMFLAGS) $< , $(TARGETDIR)\\
#        tasm -DNOSEM -l -zi $(ASMFLAGS) $< , nosem$(TARGETDIR)\\
!else
.asm.obj :
        tasm $(ASMFLAGS) $< , $(TARGETDIR)\\
#        tasm -DNOSEM $(ASMFLAGS) $< , nosem$(TARGETDIR)\\
!endif

OBJS=	iwinit2.obj\
	iwisr1.obj\
	iwisr.obj\
	iwsem.obj\
	iwinit.obj\
	iwload.obj\
	iwsynth.obj\
	iwpnp.obj\
	iwdetct.obj\
	globals.obj\
	iwmem.obj\
	iwdram.obj\
	iwutils.obj\
	iwvoice.obj\
	iwdma.obj\
	iwaddr.obj\
	iwatten.obj\
	iwllist.obj\
	iwnote.obj\
	iwnote1.obj\
	iwlfo.obj\
	iwscale.obj\
	timer.obj\
	iwerror.obj\
	iwmidi.obj\
	iwuart.obj\
	iwmixer.obj\
	iwsound.obj\
	iwdig.obj\
        play.obj \
        record.obj \
        codec.obj \
        play16.obj \
        irq16.obj \
        vars16.obj \
        util16.obj \
        mixer.obj \
	mixctl.obj \
	mixbld.obj \
	iwmls.obj \
	profile.obj \
	profile1.obj \
	os.obj

LANGUAGES = english\kernel.mls

all: bcc.cfg $(TARGETDIR)\iw_os$(MODEL).lib $(LANGUAGES)

english\kernel.mls: english\kernel.txt
	$(TOOLS)\mlscomp\mlscomp english\kernel.txt

bcc.cfg: makeosb4
  copy &&|
$(CFLAGS)
-n$(TARGETDIR)
| bcc.cfg

os.obj: $(OSINCDIR)\os.c
	bcc -c +bcc.cfg $(OSINCDIR)\os.c

$(TARGETDIR)\$(LIBNAME): $(OBJS) makeosb4
	cd $(TARGETDIR)
        makersp "+!s &\n" &&|
        $(OBJS)
|       > lib.rsp
        if exist $(TARGETDIR)\$(LIBNAME) del $(TARGETDIR)\$(LIBNAME)
        tlib $(TARGETDIR)\$(LIBNAME) /C @lib.rsp,nul
        if exist $(TARGETDIR)\*.bak del $(LIBDIR)\*.bak
        del *.rsp
	cd $(KERNEL)
#        makersp "+detune$(TARGETDIR)\\\%s &\n" &&|
#        $(OBJS)
#|       > lib.rsp
#        if exist detune$(TARGETDIR)\$(LIBNAME) del detune$(TARGETDIR)\$(LIBNAME)
#        tlib detune$(TARGETDIR)\$(LIBNAME) /C @lib.rsp,nul
#        if exist detune$(TARGETDIR)\*.bak del detune$(TARGETDIR)\$(LIBDIR)\*.bak
#        del *.rsp
#        makersp "+nosem$(TARGETDIR)\\\%s &\n" &&|
#        $(OBJS)
#|       > lib.rsp
#        if exist nosem$(TARGETDIR)\$(LIBNAME) del nosem$(TARGETDIR)\$(LIBNAME)
#        tlib nosem$(TARGETDIR)\$(LIBNAME) /C @lib.rsp,nul
#        if exist nosem$(TARGETDIR)\*.bak del nosem$(TARGETDIR)\$(LIBDIR)\*.bak

clean:
	if exist $(TARGETDIR)\*.obj del $(TARGETDIR)\*.obj
	if exist $(TARGETDIR)\*.lib del $(TARGETDIR)\*.lib
	if exist $(TARGETDIR)\*.bak del $(TARGETDIR)\*.bak

