# InterWave Kernel Makefile for Watcom C++
# $Revision: 1.4 $

ASMPROC = -j.386p 
EXTRA =
MODEL = f
# DIR = lucid
LIBNAME = $(TARGETDIR)\iw_os$(MODEL).lib
ASMFLAGS = -DPROC386 -DTASM -q -t -ml -D__f__ -DNEARDATA=1 $(ASMPROC)
OSINCDIR = os\dos32\lucid
# CONFIGINCDIR = configs\lucid
!ifeq DEBUG -d2
COPT = -oi
!else
COPT = -oneatx
!endif
WOPTS = -DDPMS -zq -ei -3r -I$(CONFIGINCDIR);$(INCLUDE);$(OSINCDIR) $(DEBUG) -m$(MODEL) $(COPT) -of+ -s -zp1 -I..\lucid
CFLAGS = @WOPTS

.obj: $(TARGETDIR)

.c.obj:
	wcc386 -fo$(TARGETDIR)\ $< $(CFLAGS) 

!ifeq DEBUG -d2
.asm.obj :
        tasm -l -zi $(ASMFLAGS) $< , $(TARGETDIR)\
!else
.asm.obj :
        tasm $(ASMFLAGS) $< , $(TARGETDIR)\
!endif

OBJS=	iwinit2.obj &
	lucidisr.obj &
	iwsem.obj &
	iwinit.obj &
	iwpnp.obj &
	iwsynth.obj &
	iwload.obj &
	iwisr.obj &
	iwdetct.obj &
	globals.obj &
	iwmem.obj &
	iwdram.obj &
	iwutils.obj &
	iwvoice.obj &
	iwdma.obj &
	iwaddr.obj &
	iwatten.obj &
	iwllist.obj &
	iwnote.obj &
	iwnote1.obj &
	iwnote2.obj &
	iwlfo.obj &
	iwscale.obj &
	timer.obj &
	iwerror.obj &
	iwmidi.obj &
	iwuart.obj &
	iwsound.obj &
	iwdig.obj &
        play.obj &
        record.obj &
        codec.obj &
        mixer.obj &
        play16.obj &
        irq16.obj &
        vars16.obj &
        util16.obj &
	mixctl.obj &
	mixbld.obj &
	iwmls.obj &
	profile.obj &
	profile1.obj &
	os.obj

LANGUAGES = english\kernel.mls

all : environ $(TARGETDIR)\iw_os$(MODEL).lib $(LANGUAGES) .SYMBOLIC
	%null

english\kernel.mls: english\kernel.txt
	$(TOOLS)\mlscomp\mlscomp english\kernel.txt

	
environ: .SYMBOLIC
	set WOPTS=$(WOPTS)

os.obj: $(OSINCDIR)\os.c
	wcc386 -fo$(TARGETDIR)\ $(OSINCDIR)\os.c -I..\lucid $(CFLAGS) 

$(LIBNAME): $(OBJS)
        %create temp.lnk
        for %i in ($(objs)) do %append temp.lnk -+$(TARGETDIR)\%i
	wlib $^@ /n /b @temp.lnk
	del temp.lnk

clean: .SYMBOLIC
	if exist $(TARGETDIR)\*.obj del $(TARGETDIR)\*.obj
	if exist $(TARGETDIR)\*.lib del $(TARGETDIR)\*.lib
	if exist $(TARGETDIR)\*.bak del $(TARGETDIR)\*.bak
