/***************************************************************************
*	NAME:  IWMLS.C $Revision: 1.6 $
**	COPYRIGHT:
**	"Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwmls.c $
* Revision 1.6  1995/09/13 13:32:39  mleibow
* added os_file_seek call for multiple invocations of ...get_mls_string() func
* Revision 1.5  1995/07/27 17:52:02  mleibow
* Revision 1.4  1995/07/27 17:22:06  mleibow
* Added iw_mls_open and iw_mls_close calls to prevent openning and closing
* mls files every time a string is needed.
* Revision 1.3  1995/06/08 11:30:48  mleibow
* Forgot to close file after iw_mls_get_string
* Revision 1.2  1995/05/25 16:26:36  mleibow
* Revision 1.1  1995/05/25 15:44:21  mleibow
* Initial revision
***************************************************************************/

#include <dos.h>
#include "iw.h"
#include "os.h"

static char mls_path[128];

iw_mls_init(char RFAR *path)
{
    iwu_strcpy(mls_path, path);
    return(IW_OK);
}

long iw_mls_strlen(char RFAR *langfile, unsigned short id)
{
    char fname[128];
    int fp;
    unsigned long nmessages;
    struct iw_message_info mi;
    
    iwu_strcpy(fname, mls_path);
    iwu_strcat(fname, "\\");
    iwu_strcat(fname, langfile);
    fp = os_file_open(fname);
    if (fp < 0) {
    	return(IW_DOS_ERROR);
    }
    if (os_file_read(fp, &nmessages, sizeof(unsigned long)) != sizeof(unsigned long)) {
    	os_file_close(fp);
    	return(IW_CANT_READ_FILE);
    }
    while (nmessages) {
    	if (os_file_read(fp, &mi, sizeof(struct iw_message_info)) != sizeof(struct iw_message_info)) {
	    os_file_close(fp);
	    return(IW_CANT_READ_FILE);
	}
	if (mi.message_id == id) break;
	nmessages--;
    }
    os_file_close(fp);
    if (nmessages == 0) return(IW_MESSAGE_NOT_FOUND);
    return(mi.size);
}

static int lfp; /* language file handle */

int iw_mls_open(char RFAR *langfile)
{
    char fname[128];

    iwu_strcpy(fname, mls_path);
    iwu_strcat(fname, "\\");
    iwu_strcat(fname, langfile);
    lfp = os_file_open(fname);
    if (lfp < 0) return(IW_DOS_ERROR);
    return(IW_OK);
}

void iw_mls_close(void)
{
    os_file_close(lfp);
}

int iw_mls_getstring(char RFAR *langfile, unsigned short index, char RFAR *buf, unsigned short buflen)
{
    int ret;
    unsigned long nmessages;
    struct iw_message_info mi;
    
    if (langfile) {
	ret = iw_mls_open(langfile);
	if (ret != IW_OK) {
	    iwu_strncpy(buf, "Can't open message file", buflen);
	    return(ret);
	}
    } else {
	os_file_seek(lfp, 0, 0);
    }
    if (os_file_read(lfp, &nmessages, sizeof(unsigned long)) != sizeof(unsigned long)) {
	bad_read:
	if (langfile) iw_mls_close();
    	iwu_strncpy(buf, "Can't read message file", buflen);
    	return(IW_CANT_READ_FILE);
    }
    while (nmessages) {
    	if (os_file_read(lfp, &mi, sizeof(struct iw_message_info)) != sizeof(struct iw_message_info)) {
	    goto bad_read;
	}
	if (mi.message_id == index) break;
	nmessages--;
    }
    if (nmessages == 0) {
	bad_message:
    	iwu_strncpy(buf, "Can't find message in message file", buflen);
	if (langfile) iw_mls_close();
	return(IW_MESSAGE_NOT_FOUND);
    }
    if (os_file_seek(lfp, mi.message_offset, 0) != 0) {
        goto bad_message;
    }
    if (buflen > (mi.size+1)) buflen = mi.size + 1;
    if (os_file_read(lfp, buf, buflen-1) != buflen - 1) {
	goto bad_read;
    }
    buf[buflen-1] = 0;
    if (langfile) iw_mls_close();
    return(IW_OK);
}
