/***************************************************************************
*	NAME:  IWDETCT.C $Revision: 1.1 $
**	COPYRIGHT:
**	"Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: iwdetct.c $
* Revision 1.1  1995/02/23 11:07:03  unknown
* Initial revision
***************************************************************************/

#include <dos.h>
#include "iw.h"
#include "iwl.h"

/***************************************************************************

FUNCTION DEFINITION:
iw_detect_card - see if there is a card at the specified port

RETURNS: 1 if card exists; 0 otherwise
*/
int	iw_detect_card(
  unsigned short port) /* port to search for card */
{
	unsigned short source = port + 8;
	unsigned short dest = port + 10;

	OS_OUTPORTB(source, 0xaa);
	if (OS_INPORTB(dest) == 0xaa) {
	    OS_OUTPORTB(source, 0x55);
	    if (OS_INPORTB(dest) == 0x55) {
		return(1);
	    }
	}
	return(0);
}
