#DEBUG=-v
!if "$(DEBUG)"=="-v"
ASMDEBUG = -zi -dDEBUG
KDEBUG = DEBUG=$(DEBUG)
!endif

MODEL=s
CFLAGS=-c -I$(INCLUDEPATH) -I$(KERNEL);$(KERNEL)\\os\\dos\\borland
LFLAGS=-s -L$(LIBPATH)
AFLAGS=-q -t

.asm.obj:
	tasm $(ASMDEBUG) $(AFLAGS) $<

.c.obj:
	bcc $(DEBUG) $(CFLAGS) $<
	
OBJ= startup.obj \
     debug.obj \
     init.obj \
     delay.obj \
     n_lxmul.obj \
     h_ldiv.obj \
     h_llsh.obj \
     h_lursh.obj

LANGUAGES = english\\iwinit.mls

all: iwinit.exe $(LANGUAGES)

iwinit.exe: link.rsp $(OBJ) kernel\\iw_os$(MODEL).lib
	tlink $(DEBUG) $(LFLAGS) @link.rsp
	del link.rsp
	
kernel\\iw_os$(MODEL).lib:
	cd $(KERNEL)
	del bcc.cfg
	maker -f makeos.ksh $(KDEBUG) -DTARGETDIR=$(IWPROJ)\apps\iwinit\kernel -DCONFIGINCDIR=$(IWPROJ)\apps\iwinit MODEL=$(MODEL)
	cd $(IWPROJ)\apps\iwinit
	
english\\iwinit.mls: english\\iwinit.txt
	cd english
	$(IWPROJ)\tools\mlscomp\mlscomp iwinit.txt
	cd ..
	
dist: iwinit.exe $(LANGUAGES)
	cp iwinit.exe $(IWPROJ)\dist\apps\iwinit.exe
	cp english\*.mls $(IWPROJ)\dist\language\english
	cp $(KERNEL)\english\*.mls $(IWPROJ)\dist\language\english
	
link.rsp:
	copy &&|
$(OBJ)
iwinit
iwinit
kernel\\iw_os$(MODEL)
| link.rsp

clean:
	if exist *.obj del *.obj
	if exist *.lib del *.lib
	if exist *.bak del *.bak

cleankernel:
	if exist kernel\\*.obj del kernel\\*.obj
	if exist kernel\\*.lib del kernel\\*.lib
	if exist kernel\\*.bak del kernel\\*.bak

cleanall:
	if exist *.obj rm -f *.obj
	if exist *.lib rm -f *.lib
	if exist *.bak rm -f *.bak
	if exist kernel\\*.obj rm -f kernel\\*.obj
	if exist kernel\\*.lib rm -f kernel\\*.lib
	if exist kernel\\*.bak rm -f kernel\\*.bak
