/* 
 * xfce-colorbutton - color-selector button for gtk 2.2, GtkColorButton
 *                    wrapper for gtk 2.4
 *
 * Copyright (c) 2004 Brian Tarricone <bjt23@cornell.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Portions based on GtkColorButton, Copyright (C) 1998, 1999 Red Hat, Inc.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libxfcegui4/libxfcegui4.h>



GtkWidget*
xfce_color_button_new (void)
{
  return gtk_color_button_new ();
}



void
xfce_color_button_set_color (GtkColorButton *color_button,
                             const GdkColor *color)
{
  gtk_color_button_set_color (color_button, color);
}



GtkWidget*
xfce_color_button_new_with_color (const GdkColor *color)
{
  return gtk_color_button_new_with_color (color);
}



void
xfce_color_button_get_color (GtkColorButton *color_button,
                             GdkColor       *color)
{
  gtk_color_button_get_color (color_button, color);
}



void
xfce_color_button_set_alpha (GtkColorButton *color_button,
                             guint16         alpha)
{
  gtk_color_button_set_alpha (color_button, alpha);
}



guint16
xfce_color_button_get_alpha (GtkColorButton *color_button)
{
  return gtk_color_button_get_alpha (color_button);
}



void
xfce_color_button_set_use_alpha (GtkColorButton *color_button,
                                 gboolean        use_alpha)
{
  gtk_color_button_set_use_alpha (color_button, use_alpha);
}



gboolean
xfce_color_button_get_use_alpha (GtkColorButton *color_button)
{
  return gtk_color_button_get_use_alpha (color_button);
}



void
xfce_color_button_set_title (GtkColorButton *color_button,
                             const gchar    *title)
{
  gtk_color_button_set_title (color_button, title);
}



G_CONST_RETURN gchar *
xfce_color_button_get_title (GtkColorButton *color_button)
{
  return gtk_color_button_get_title (color_button);
}
