/*  xfce4
 *  Copyright (C) 2002 Olivier Fourdan (fourdan@xfce.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gdk/gdk.h>
#include <gtk/gtkframe.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkalignment.h>

#include "xfce_framebox.h"

/* Forward declarations */

/* Local data */
G_DEFINE_TYPE (XfceFramebox, xfce_framebox, GTK_TYPE_FRAME)

static void
xfce_framebox_class_init (XfceFrameboxClass * class)
{

}

static void
xfce_framebox_init (XfceFramebox * box)
{
}

/**
 * xfce_framebox_new:
 * @text    : header text.
 * @indent  : if TRUE, the children will be indented.
 *
 * Creates a new #XfceFramebox container widget.
 *
 * Return value: the newly allocated #XfceFramebox container widget.
 **/
GtkWidget*
xfce_framebox_new (const gchar *text, gboolean indent)
{
    XfceFramebox *framebox;
    
    framebox = g_object_new (xfce_framebox_get_type (), NULL);

    gtk_frame_set_shadow_type (GTK_FRAME (framebox), GTK_SHADOW_NONE);

    if (text)
    {
        GtkWidget *label;
        gchar *tmp;

        tmp = g_strdup_printf ("<b>%s</b>", text);
        label = gtk_label_new (tmp);
        gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
        gtk_frame_set_label_widget (GTK_FRAME (framebox), label);
        gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
        gtk_widget_show (label);
        g_free (tmp);
    }

    framebox->hbox = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (framebox->hbox);
    gtk_container_set_border_width (GTK_CONTAINER (framebox->hbox), 5);
    gtk_container_add (GTK_CONTAINER (framebox), framebox->hbox);
   
    if (indent)
    {
        framebox->indent_filler = gtk_alignment_new (0.5, 0.5, 1, 1);
        gtk_widget_show (framebox->indent_filler);
        gtk_box_pack_start (GTK_BOX (framebox->hbox), framebox->indent_filler, 
                            FALSE, FALSE, 0);
        gtk_widget_set_size_request (framebox->indent_filler, 16, -1);
    }
    
    return GTK_WIDGET (framebox);
}


/**
 * xfce_framebox_add:
 * @framebox  : an #XfceFramebox object.
 * @widget    : child widget to add to the @framebox container.
 *
 * Adds a child @widget to the @framebox container widget.
 **/
void
xfce_framebox_add (XfceFramebox *framebox, GtkWidget *widget)
{
    g_return_if_fail(framebox != NULL);
    g_return_if_fail(widget != NULL);
    g_return_if_fail(XFCE_IS_FRAMEBOX(framebox));
    
    gtk_box_pack_start (GTK_BOX (framebox->hbox), widget, TRUE, TRUE, 0);
}

