/*      $Id: misc.h 26999 2008-05-31 14:35:42Z olivier $

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2, or (at your option)
        any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., Inc., 51 Franklin Street, Fifth Floor, Boston,
        MA 02110-1301, USA.


        oroborus - (c) 2001 Ken Lynch
        xfwm4    - (c) 2002-2008 Olivier Fourdan

 */

#ifndef INC_MISC_H
#define INC_MISC_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <X11/X.h>
#include <X11/Xlib.h>
#include <glib.h>
#include "screen.h"

/*
   Just for completion, being a bit pedantic, X seems to be missing
   those so far, so create them for now.
 */

#ifndef Button6
#define Button6 6
#endif

#ifndef Button7
#define Button7 7
#endif

unsigned int             getMouseXY                             (ScreenInfo *,
                                                                 Window,
                                                                 int *,
                                                                 int *);
Window                   getMouseWindow                         (ScreenInfo *,
                                                                 Window);
GC                       createGC                               (ScreenInfo *,
                                                                 char *,
                                                                 int,
                                                                 XFontStruct *,
                                                                 int,
                                                                 gboolean);
void                     sendClientMessage                      (ScreenInfo *,
                                                                 Window,
                                                                 int,
                                                                 Time);
void                     sendRootMessage                        (ScreenInfo *,
                                                                 int,
                                                                 long,
                                                                 Time);
gboolean                 checkWindowOnRoot                      (ScreenInfo *,
                                                                 Window);
void                     placeSidewalks                         (ScreenInfo *,
                                                                 gboolean);
gint                     find_monitor_at_point                  (GdkScreen *,
                                                                 gint,
                                                                 gint);

#endif /* INC_MISC_H */
