#ifndef __XFCE_SHORTCUTS_PLUGIN_H__
#define __XFCE_SHORTCUTS_PLUGIN_H__

#include <gtk/gtk.h>

#include <libxfce4mcs/mcs-manager.h>
#include <libxfce4mcs/mcs-manager.h>
#include <xfce-mcs-manager/manager-plugin.h>

#define RCDIR       "mcs_settings"
#define OLD_RCDIR   "settings"

#define CHANNEL1    "settings"
#define RCFILE1     "gtk.xml"

#define CHANNEL2    "keyboard"
#define RCFILE2     "keyboard.xml"

#define CHANNEL3    "shortcuts"
#define RCFILE3     "shortcuts.xml"


typedef struct _KeyboardMcsDialog KeyboardMcsDialog;
struct _KeyboardMcsDialog
{
    McsPlugin *mcs_plugin;

    gboolean theme_modified;

    GtkWidget *checkbutton_blink;
    GtkWidget *checkbutton_repeat;
    GtkWidget *checkbutton_sticky;
    GtkWidget *checkbutton_sticky_ltl;
    GtkWidget *checkbutton_sticky_tk;
    GtkWidget *checkbutton_bounce;
    GtkWidget *scale_debounce_delay;
    GtkWidget *checkbutton_slow;
    GtkWidget *scale_slow_keys_delay;
    GtkWidget *checkbutton_mouse;
    GtkWidget *scale_mouse_keys_delay;
    GtkWidget *scale_mouse_keys_interval;
    GtkWidget *scale_mouse_keys_ttm;
    GtkWidget *scale_mouse_keys_max_speed;

    GtkWidget *scale_repeat_rate;
    GtkWidget *scale_repeat_delay;
    GtkWidget *scale_blink_time;
    GtkWidget *dialog_keyboard;
    GtkWidget *theme_swindow;
    GtkWidget *treeview_maps;

    GtkWidget *scrolledwindow_themes;
    GtkWidget *treeview_themes;
    GtkWidget *button_add_theme;
    GtkWidget *button_del_theme;
    GtkWidget *menu_popup_themes;
    GtkWidget *menuitem_popup_rename_theme;
    GtkWidget *menuitem_popup_add_theme;
    GtkWidget *menuitem_popup_del_theme;

    GtkWidget *scrolledwindow_shortcuts;
    GtkWidget *treeview_shortcuts;
    GtkWidget *button_add_shortcut;
    GtkWidget *button_del_shortcut;
    GtkWidget *menu_popup_shortcuts;
    GtkWidget *menuitem_popup_edit_shortcut;
    GtkWidget *menuitem_popup_add_shortcut;
    GtkWidget *menuitem_popup_del_shortcut;

    GtkWidget *button_close;
    GtkWidget *button_help;
};

GtkWidget* shortcuts_plugin_create_dialog (KeyboardMcsDialog *);
void shortcuts_plugin_setup_dialog (KeyboardMcsDialog *);
void shortcuts_plugin_init(McsPlugin *);
void shortcuts_plugin_load_theme (KeyboardMcsDialog *);
void shortcuts_plugin_save_theme (KeyboardMcsDialog *);
gboolean shortcuts_plugin_save_settings (McsPlugin *);

#endif /* __XFCE_SHORTCUTS_PLUGIN_H__ */
