/* copywrite 2001-2004 edscott wilson garcia under GNU/GPL 
 * 
 *  pasteboard routines for xffm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <X11/Xlib.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"
#include "modules.h"

#include "pasteboard.h"

#include "bookmarks.h"
#include "cpy.h"
#include "rcp.h"
#include "dnd.h"
#include "entry.h"
#include "icons.h"
#include "misc.h"
#include "password_dialog.h"
#include "monitor.h"
#include "run.h"
#include "uri.h"
#include "widgets.h"


#define CUT_BUFFER 0

extern gboolean tar_extraction;
extern char *src_host;

static GList *paste_list = NULL;
G_MODULE_EXPORT
char *pastepath;
G_MODULE_EXPORT
GtkTreeRowReference *pasteref;

G_MODULE_EXPORT
int valid_pasteboard(void)
{
    int ret = 0, len = -1;
    char *b;
    b = XFetchBuffer(GDK_DISPLAY(), &len, 0);
    /*printf("dbg:bytes=%d,buffer0=%s\n",len,b); */

    if((!b) || (!strlen(b)))
	ret = 0;
    else if(strncmp(b, "#xfvalid_buffer:copy", strlen("#xfvalid_buffer:copy")) == 0)
	ret = 1;
    else if(strncmp(b, "#xfvalid_buffer:cut", strlen("#xfvalid_buffer:cut")) == 0)
	ret = 2;

#ifdef DEBUG
    /*printf("DBG:paste buffer:\n%s\n",(b)?b:"NULL"); */
#endif
    XFree(b);
    return ret;
}

/* returns 0 if not in pasteboard, 1 if in copy pasteboard or 2 if
 * in cut pasteboard */
G_MODULE_EXPORT
int in_pasteboard(tree_entry_t *en)
{
    int len = -1;
    char *b, *search,*path;
    static char *files=NULL;
    gboolean cut;

    if(!en || !en->path) return FALSE;
    if (IS_ROOT_TYPE(en->type)&&!IS_LOCAL_TYPE(en->type)) return FALSE;
    if (__XF_MASK&en->subtype) return FALSE;
    
    b = XFetchBuffer(GDK_DISPLAY(), &len, 0);
    if((!b) || (!strlen(b))) goto not_here;

    if (IS_NETDIR(en->subtype)||IS_NETFILE(en->subtype)){
	char *server,*remote_file;
	if (files) {
		g_free(files);
		files=NULL;
	}
	server=g_strdup(en->path+2);
	strtok(server,"/");
	remote_file=server+strlen(server)+1;
	files=(char *)malloc(strlen(server)+
			strlen(remote_file)+
			strlen(en->tag)+
			strlen("smb://@://\n")+1);
	if (IS_NETDIR(en->subtype))
		sprintf (files, "%s://%s@%s:%s/",
		  IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
		  (en->tag)?en->tag:"GUEST%%",
		  server,remote_file);
	else
		sprintf (files, "%s://%s@%s:%s",
		  IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
		  (en->tag)?en->tag:"GUEST%%",
		  server,remote_file);
	
	g_free(server);
	server=NULL;
	path=files;
    }
    else path=en->path;
    
    search = strtok(b, "\n");
    if (!search) return 0;
    if (strncmp(search, "#xfvalid_buffer", strlen("#xfvalid_buffer")) != 0)
	    return 0;
    if (strncmp(search, "#xfvalid_buffer:cut", strlen("#xfvalid_buffer:cut")) != 0) cut = TRUE; else cut = FALSE;
    
    search = strtok(NULL,"\n");
    while(search)
    {
	if(strcmp(search, path) == 0) {
	    XFree(b);
	    return ((cut)?2:1);
	}
	search = strtok(NULL, "\n");
    }
  not_here:
    XFree(b);
    return 0;
}

static void check_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_entry_t *en;
       gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (!en) return;   

    if(!en){
#ifdef DEBUG
	printf("DBG: on check_select for pasteboard, entry is null!\n");
#endif
	return;
    }
    if(IS_DUMMY_TYPE(en->type))
	return;
    if(!IS_PATH(en->type)&&!IS_NETTHING(en->subtype))
	return;
    paste_list = g_list_append(paste_list, en);
    return;
}

static void tag_select(GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    set_icon(treemodel, iter);
    return;
}


static void copy_cut(GtkTreeView * treeview, gboolean cut)
{
    int len;
    char *buffer,*files;
    GList *tmp;

    if(!paste_list || !g_list_length(paste_list)){
	return;
    }
    len = 1 + strlen("#xfvalid_buffer:copy:%%:\n");
    len += strlen(our_host_name(treeview));
    for(tmp = paste_list; tmp; tmp = tmp->next)
    {
	int addlen;
	tree_entry_t *en=(tree_entry_t *)tmp->data;
	if (IS_NETWORK_TYPE(en->type)){
		addlen=strlen("smb://@://\n");
		addlen += ((en->tag)?strlen(en->tag):strlen("GUEST%%"));
	} else addlen=0;
	len += (1 + strlen(en->path)+addlen);
    }
    buffer = (char *)malloc(len * sizeof(char) + 1);
    if(!buffer)
    {
#ifdef DEBUG
	printf("xffm: unable to allocate paste buffer\n");
	assert_not_reached();
#endif
	return;
    }
    sprintf(buffer, "#xfvalid_buffer:%s:%s:\n", (cut) ? "cut" : "copy", our_host_name(treeview));
    files=buffer+ strlen(buffer);
    for(tmp = paste_list; tmp; tmp = tmp->next)
    {
	tree_entry_t *en=(tree_entry_t *)tmp->data;
	if (IS_NETWORK_TYPE(en->type)){
		char *server,*remote_file;
		server=g_strdup(en->path+2);
		strtok(server,"/");
		if (IS_XF_NETWS(en->subtype)) {
			sprintf (files, "%s://%s@%s:",
			  IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
			  (en->tag)?en->tag:"GUEST%%",
			  server);
		} else {
		  	remote_file=server+strlen(server)+1;
		  	sprintf (files, "%s://%s@%s:%s%s",
			  IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
			  (en->tag)?en->tag:"GUEST%%",
			  server,remote_file,
			  (IS_NETDIR(en->subtype))?"/\n":"\n");
		}
		g_free(server);
		server=NULL;
	        files = files + strlen(files);
		
	} else {
	  strcat(buffer, en->path);
	  strcat(buffer, "\n");
	}
    }
    /*printf("dbg:len=%d,strlen=%d,data=%s\n",len,strlen(buffer),buffer); */
    XStoreBuffer(GDK_DISPLAY(), buffer, len, CUT_BUFFER);
    g_free(buffer);
    buffer=NULL;


    g_list_free(paste_list);
    paste_list = NULL;
    {
	GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
	gtk_tree_selection_selected_foreach(selection, tag_select, (gpointer) treeview);
	if (cut) print_status("xfce/info",_("Pasteboard cut"),NULL);
	else print_status("xfce/info",_("Pasteboard copy"),NULL);
	/*gtk_tree_selection_unselect_all(selection);*/
        process_pending_gtk();

    }

    turn_on();
    local_monitor(TRUE);
}

/* this is equivalent to copying by dnd */

static void cb_paste(GtkTreeView * treeview, gboolean symlink)
{
    uri *u;
    gboolean cut;
    GList *list, *flist, *tmp;
    tree_entry_t *t_en = NULL;
    char *tmpfile, *b=NULL, *word;
    int i, len = -1;
    GtkTreeIter *iter;
    GtkTreeIter parent,child;
    gboolean will_expand=FALSE;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);

    if(!pastepath){
	return;
    }
    b = XFetchBuffer(GDK_DISPLAY(), &len, 0);
    /*printf("dbg:bytes=%d,buffer0=%s\n",len,b); */

    if((!b) || (!strlen(b))) {
no_pasteboard:
	if(b) XFree(b);
	return;
    }

    if((word = strtok(b, ":")) == NULL)  goto no_pasteboard;	
    if(!strstr(word, "#xfvalid_buffer")) goto no_pasteboard;	
    if((word = strtok(NULL, ":")) == NULL) goto no_pasteboard;	
    if(strstr(word, "cut")) cut = TRUE; else cut = FALSE;
    if((word = strtok(NULL, ":")) == NULL) goto no_pasteboard;	
    if(!word) {
	goto no_pasteboard;
    }
    src_host = g_strdup(word);

    word = word + strlen(word) + 1;
    if(word[0] == '\n') {
	word++;
	if(word[0] == 0) goto no_pasteboard;	
    } else {
	if((word = strtok(NULL, "\n")) == NULL) goto no_pasteboard;
	word = word + strlen(word) + 1;
    }

    /* create list to send to CreateTmpList */
    i = uri_parse_list(word, &list);
    flist = list;	/* keep initial pointer to later free the list */
    u = list->data;
    if(!i) goto no_pasteboard;	
    XFree(b);			/* no longer needed here */



#ifdef DEBUG
    printf("DBG:pastepath=%s\n",pastepath);
#endif
    if (!get_selected_entry(&child)){
	    return;
    }
    gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &t_en, -1);
    if (!t_en) return;
    
    if(IS_FILE(t_en->type)){
	if (!gtk_tree_model_iter_parent (treemodel,&parent,&child)){
	    g_warning("this should not happen");
	    return;
	}
	gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &t_en, -1);
	if (!t_en) return;
	iter=&parent;
    }
    else {
	iter=&child;
    }
    
    if (!pasteref){/*FIXME: is this used or not ? */
 	GtkTreePath *treepath=gtk_tree_model_get_path(treemodel,iter);
	g_warning("pasteref == NULL");
    	pasteref=gtk_tree_row_reference_new(treemodel,treepath);
    	gtk_tree_path_free(treepath);
    }	
    if (IS_EXPANDED(t_en->type)) will_expand=TRUE;
    if(strcmp(pastepath, "ROOT_BOOKMARKS") != 0)
    {
	if (strncmp(pastepath,"//",2)==0){
#ifdef DEBUG
	  printf("DBG:pastepath=%s,en->path=%s\n",pastepath,t_en?
			  t_en->path:"null");
#endif
	  
	} else {
    	  if(u->type == URI_SMB)
    	  {				/* src_host may be remote or local  
				   but target only local  or bookmark */
            if (IS_DIR(t_en->type)){	    
#ifdef USE_SMB_BRANCH
	      XF_SMBGetFile(treeview, t_en->path, list);
#endif
            }
	    goto paste_done;
	  }
	} 
    }

    if(!set_load_wait())
    {
	print_diagnostics("xfce/warning",strerror(EBUSY),"\n",NULL);
	return;
    }



    if(IS_NETDIR(t_en->subtype) || 
	 IS_XF_NETSHARE(t_en->subtype)|| 
	 IS_NETFILE(t_en->subtype) 
      )
    {
      gchar *target;
       
      if (IS_XF_NETSHARE(t_en->subtype)){
        target=g_strdup("/"); 	    
      } else {
	char *p;
	p=strstr(t_en->path+2,"/")+1;
	target=g_strdup(strstr(p,"/"));
        if (IS_NETFILE(t_en->subtype)) *strrchr(target,'/')=0;
      } 
#ifdef DEBUG
      printf("DBG:paste target=%s\n",target);
#endif
      
      tmpfile=CreateSMBTmpList(list,target,
		      IS_SAMBA_SERVER(t_en->subtype));
      g_free(target);
      target=NULL;
      if (!tmpfile) goto paste_done;
#ifdef USE_SMB_BRANCH
      XF_SMBDropFile (treeview,t_en,iter,tmpfile);
#endif
      goto paste_done;
    }

    /* single command line for rsync not possible, only for scp! */
    if(strcmp(src_host, our_host_name(treeview)) != 0)
    {
	int l = 0;
	char **srcs;
	for(tmp = list; tmp != NULL; tmp = tmp->next)
	{
	    l++;
	}
	srcs = (char **)malloc(l * sizeof(char *));
	if(!srcs){
	    printf("xffm: %s at malloc\n",strerror(errno));
	    assert_not_reached();
	}
	srcs[l] = NULL;
	for(l = 0, tmp = list; tmp != NULL; tmp = tmp->next)
	{
	    u = tmp->data;
	    srcs[l] = u->url;
	    srcs[l + 1] = NULL;
#if 0
	    /* with rsync, one by one */
	    if(tree_details->preferences & RSYNC_X_SCP)
	    {
		rsync(srcs + l, t_en->path);
	    }
#endif
	    l++;
	}
	/*if(!(tree_details->preferences & RSYNC_X_SCP))*/
	    rsync(srcs, t_en->path);
	goto paste_done;
    }
    if(strcmp(pastepath, "ROOT_BOOKMARKS") == 0)
    {
	for(tmp = list; tmp; tmp = tmp->next)
	{
	    u = tmp->data;
	    add2bookmarks(treeview, u->url);
	}
	goto paste_done;
    }    
    else {
	tmpfile = CreateTmpList(list, t_en);
	/*fprintf(stderr,"dbg:tmpfile=%s\n",tmpfile); */
	if(tmpfile) {
	    int mode;
	    if (cut) mode=TR_MOVE; else mode=TR_COPY;
	    if (symlink) mode=TR_LINK;
	    /*IndirectTransfer((cut) ? TR_MOVE : TR_COPY, tmpfile);*/
	    IndirectTransfer(mode, tmpfile);
	    unlink(tmpfile);
	    g_free(tmpfile);
	}
    }

  paste_done:

    list = uri_free_list(flist);
    update_dir(treeview, pasteref);

    if(cut)
	XStoreBuffer(GDK_DISPLAY(), "", 1, CUT_BUFFER);
    turn_on_pasteboard();
    unset_load_wait();
    if (will_expand && (IS_NETDIR(t_en->subtype) || 
			IS_XF_NETSHARE(t_en->subtype)||  
			IS_NETFILE(t_en->subtype)) )

    {
	GtkTreePath *treepath=gtk_tree_row_reference_get_path(pasteref);
    	gtk_tree_view_expand_row(treeview, treepath, FALSE);  
    	gtk_tree_path_free(treepath);
    }
    return;
}

G_MODULE_EXPORT
void cb_paste_show(GtkTreeView * treeview)
{
    char *b, *word;
    int len = -1;
    char *mess[] = {
	N_("Pasteboard cut"),
	N_("Pasteboard copy")
    };

    b = XFetchBuffer(GDK_DISPLAY(), &len, 0);
    /*printf("dbg:bytes=%d,buffer0=%s\n",len,b); */

    if(b && strlen(b))
    {
	print_diagnostics("xfce/info",_("List Pasteboard"),":\n", NULL);
	word = b;
	if(valid_pasteboard())
	{
	    strtok(b, ":");
	    if((word = strtok(NULL, ":")) != NULL)
	    {
		if(strcmp(word, "cut") == 0)
		    print_diagnostics("nonverbose", _(mess[0]), " :\n", NULL);
		else
		    print_diagnostics("nonverbose", _(mess[1]), " :\n", NULL);
	    }
	    if((word = strtok(NULL, ":")) != NULL)
	    {
		print_diagnostics("nonverbose", " ", _("from host"), " ", word, " :\n", NULL);
	    }
	    word += (strlen(word) + 1);
	    if (strstr(word,"smb://")) ascii_readable(word);
	    /* my guess is that SMB:// need not ascii readable, since
	     * its a Samba server */
	}
	print_diagnostics("nonverbose", word, "\n", NULL);
    }
    else
    {
	print_diagnostics("xfce/error", _("The pasteboard is currently empty."), "\n", NULL);
    }

    XFree(b);
    return;
}



static GtkTreeView *get_the_pasteboard_list(GtkWidget *w){
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeSelection *selection = tree_details->treestuff[tree_id].selection;
     /* get selection */
    if(paste_list) {
	g_list_free(paste_list);
	paste_list = NULL;
    }
    gtk_tree_selection_selected_foreach(selection, check_select, (gpointer) treeview);
    if (paste_list) return treeview;
    return NULL;
}

/*   callbacks   */

G_MODULE_EXPORT
void tb_cut(GtkWidget * w)
{
    GtkTreeView *treeview=NULL;
    treeview=get_the_pasteboard_list(w);
    if (!treeview) return;
    copy_cut(treeview, TRUE);
    turn_on_pasteboard();
    return;

}

G_MODULE_EXPORT
void on_cut_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tb_cut((GtkWidget *)menuitem);
    return;
}


G_MODULE_EXPORT
void tb_copy(GtkWidget * w)
{
    GtkTreeView *treeview=NULL;
    treeview=get_the_pasteboard_list(w);
    if (!treeview) return;
    copy_cut(treeview, FALSE);
    turn_on_pasteboard();
    return;

}


G_MODULE_EXPORT
void on_copy_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tb_copy((GtkWidget *)menuitem);
    return;
}

G_MODULE_EXPORT
void tb_paste(GtkWidget * w)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    cb_paste(treeview, FALSE);
    turn_on_pasteboard();
    return;

}

G_MODULE_EXPORT
void on_paste_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tb_paste((GtkWidget *)  menuitem);
    return;
}

G_MODULE_EXPORT
void tb_pastelink(GtkWidget * w)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    cb_paste(treeview, TRUE);
    turn_on_pasteboard();
    return;

}

G_MODULE_EXPORT
void on_pastelink_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tb_paste((GtkWidget *)  TRUE);
    return;
}


G_MODULE_EXPORT
void on_list_pasteboard_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    cb_paste_show(treeview);

}


G_MODULE_EXPORT
void on_clear_pasteboard_activate(GtkMenuItem * menuitem, gpointer user_data)
{

    XStoreBuffer(GDK_DISPLAY(), "", 1, CUT_BUFFER);	/* store a null string */
    turn_on_pasteboard();
}




