/*
 * Copyright (c) 2004 Jean-Franois Wauthy (pollux@xfce.org)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef __XFPRINT_PRINTING_SYSTEM_H__
#define __XFPRINT_PRINTING_SYSTEM_H__

#include <gtk/gtk.h>
#include <libxfcegui4/libxfcegui4.h>

/********/
/* Enum */
/********/
enum {
  JOBS_ICON_COLUMN,
  JOBS_NAME_COLUMN,
  JOBS_ID_COLUMN,
  JOBS_USER_COLUMN,
  JOBS_STATE_COLUMN,
  JOBS_SIZE_COLUMN,
  JOBS_PRIORITY_COLUMN,
  JOBS_CREATION_TIME_COLUMN,
  JOBS_PROCESSING_TIME_COLUMN,
  JOBS_N_COLUMNS
};

enum {
  PRINTER_TYPE_PRINTER,
  PRINTER_TYPE_CLASS
};

/*********/
/* Types */
/*********/
typedef struct _PrintingSystemInfo  PrintingSystemInfo;
typedef struct _Printer             Printer;
typedef struct _Job                 Job;
typedef struct _ManagerDlg          ManagerDlg;
typedef struct _QueueDlg            QueueDlg;
typedef struct _PrintDlg            PrintDlg;

/**************/
/* Structures */
/**************/
struct _ManagerDlg {
  XfceIconTheme *icontheme;

  GtkWidget *window;
  GtkAccelGroup *accel_group;
  GtkWidget *treeview;
  
  GtkWidget *menu_printer;
  GtkWidget *menuitem_properties;
  GtkWidget *menuitem_setdefault;
};

struct _QueueDlg{
  gchar *printer_name;
  XfceIconTheme *icontheme;

  GtkWidget *window;
  GtkAccelGroup *accel_group;
  GtkWidget *menuitem_job;
  GtkWidget *menuitem_removejob;
  GtkWidget *menuitem_refresh;
  GtkWidget *menuitem_close;

  GtkWidget *treeview;

  guint timeout_id;
};

struct _PrintDlg {
  GtkWidget *dialog;
  XfceIconTheme *icontheme;

  gpointer customization;
  const gchar *original_name;

  GtkWidget *notebook;
  GtkWidget *sheets;
  GtkWidget *vpages;
  GtkWidget *pprint;
  GtkWidget *input;
  GtkWidget *head;
  
  GtkWidget *copies;

  GtkWidget *button_save;
};

struct _PrintingSystemInfo {
  gchar *name;
  gchar *description;
  gchar *version;
  gchar *author;
  gchar *homepage;
};

struct _Printer {
  gchar *name;
  gchar *alias;
  gint  type;
};

struct _Job {
  gchar *name;
  guint id;
  gchar *user;
  gchar *state;
  gchar *size;
  gchar *priority;
  gchar *creation_time;
  gchar *processing_time;
};

/*************/
/* Functions */
/*************/
extern void printing_system_info_free (PrintingSystemInfo *psinfo);
extern void job_free (Job *job, gpointer user_data);
extern Printer* printer_lookup_byname (GList *list, const gchar *name);
extern Printer* printer_lookup_byalias (GList *list, const gchar *alias);
extern void printer_free (Printer *printer, gpointer user_data);

/* Printing-system fcts */
extern gboolean load_printing_system (const gchar *path);

extern GList* (*printing_system_get_printers_list) (void);
extern void (*printing_system_main_window_customize) (ManagerDlg *dlg);
extern gboolean (*printing_system_set_default_printer) (const gchar *printer);
extern Printer* (*printing_system_get_default_printer) (GList *printers);

extern void (*printing_system_queue_dialog_customize) (QueueDlg *dialog);
extern gboolean (*printing_system_remove_job) (const gchar *printer, gint id);
extern GList* (*printing_system_get_jobs_list) (const gchar *printer);
extern void (*printing_system_info_init) (PrintingSystemInfo *psinfo);

extern void (*printing_system_properties_dialog_run) (GtkWidget *widget, const gchar *printer);

extern void (*printing_system_about_dialog_run) (GtkWidget *widget, gpointer data);

extern void (*printing_system_print_dialog_customize) (PrintDlg *dialog);

extern gboolean (*printing_system_print_file) (PrintDlg *dialog, const gchar *file);

#endif
