/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * Copyright (c) 2003 Benedikt Meurer <benedikt.meurer@unix-ag.uni-siegen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif
#ifdef HAVE_SYS_UCRED_H
#include <sys/ucred.h>
#endif
#ifdef HAVE_SYS_MOUNT_H
#include <sys/mount.h>
#endif

#include <stdio.h>
#include <errno.h>
#ifdef HAVE_FSTAB_H
#include <fstab.h>
#endif
#include <limits.h>
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_MNTENT_H
#include <mntent.h>
#endif
#ifdef HAVE_PATHS_H
#include <paths.h>
#endif
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>

#ifdef HAVE_SYS_FS_TYPES_H
#include <sys/fs_types.h>
#endif

#ifdef HAVE_SYS_MNTTAB_H
#include <sys/mnttab.h>
#endif

#ifdef HAVE_SYS_VFS_H
#include <sys/vfs.h>
#endif

#ifdef HAVE_SYS_VFSTAB_H
#include <sys/vfstab.h>
#endif

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "basic_row.h"

#include "xfstab.h"

#include "entry.h"
#include "misc.h"
#include "password_dialog.h" 
#include "refresh.h"
#include "goto.h"
#include "tubo.h"
#include "icons.h"

static gboolean is_smb;

static int childFD;
static xfdir_t fstat_xfdir;
static pid_t Gpid;
static GtkTreeView *fstab_treeview;

static gint watch_stop(gpointer data)
{

    if(!tree_details->tubo_object) return FALSE;
    if(tree_details->stop)
    {
	gchar *m=g_strdup_printf("%d", Gpid);
	print_diagnostics("xfce/warning", strerror(ECANCELLED)," pid=", m, "\n",NULL);
	g_free(m);
	/*cancelled = TRUE;*/
	TuboCancel(tree_details->tubo_object, NULL);
	/*usleep(250); if(Gpid) kill(Gpid, SIGHUP);*/
	tree_details->stop = FALSE;
	tree_details->tubo_object = NULL;
	hide_stop();
	Gpid = 0;
	cursor_reset();
	return FALSE;
    }
    set_progress(-1, -1);
    return TRUE;
}



static int operate_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    D(printf("stderr:%s",line);)
    if (strncmp(line,"Password:",strlen("Password:"))==0){
	const char *p;
    	print_diagnostics("xfce/warning",_("Sudo password requested"),"\n", NULL);
	p=get_password(tree_details->window,_("Sudo password requested"));
	if (p && strlen(p)) write(childFD,p,strlen(p));
	write(childFD,"\n",strlen("\n"));

	return TRUE;
    }
    if (line[0] != '\n') print_diagnostics("xfce/error", line, NULL);
    return TRUE;
}
static int operate_stdout(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    D(printf("stdout:%s",line);)
    print_diagnostics(NULL, line, NULL);
    return TRUE;
}


static void fork_finished_function(pid_t pid)
{
    char m[32];
    tree_entry_t *en;
    int status;
    GtkTreeIter iter;
    sprintf(m, "%d\n", pid);

    tree_details->tubo_object = NULL;
    hide_stop();
    cursor_reset();
    /* another wait just in case the one in tubo misses 
     * (shouldn't happen, but it does)*/
    
    waitpid(pid, &status, WNOHANG);
    en= get_selected_entry(&iter);
    status=is_mounted((const gchar *)en->path);
    if (status < 0) TOGGLE_MOUNTED(en->type);
    else {
	    if (status) SET_MOUNTED(en->type);
	    else UNSET_MOUNTED(en->type);
    }
    if (IS_MOUNTED(en->type))
	on_refresh((GtkButton *)(tree_details->window),NULL);
    else {
    	GtkTreePath *treepath;
    	GtkTreeModel *treemodel = gtk_tree_view_get_model(fstab_treeview);
    	treepath = gtk_tree_model_get_path(treemodel, &iter);
    	gtk_tree_view_collapse_row(fstab_treeview, treepath);
    	prune_row(treemodel, &iter, NULL,en);
	insert_dummy_row(treemodel, &iter, NULL,en,NULL,NULL);
    	gtk_tree_path_free(treepath);
	update_icon(treemodel,&iter);
    }
    
#ifdef DEBUG  
    printf("DBG:fstab over by fork_finished_function\n");
#endif
}

/* NOTE: linux will fail if HAVE_STATFS is before HAVE_GETMNTENT section */
G_MODULE_EXPORT
int is_mounted (const gchar *mnt_point){
	
#if defined(HAVE_GETMNTENT) && defined(HAVE_STRUCT_MNTENT_MNT_DIR)
	struct mntent *m;
	const gchar *mnttab;
	FILE *mtab_fd;
	FILE *tab_file;

	
#if defined(MNT_MNTTAB)
	mnttab = MNT_MNTTAB;
#else
	/*
	 * try /proc/mounts first
	 */
	if ((mtab_fd = fopen("/proc/mounts", "r")) != NULL) {
		(void)fclose(mtab_fd);
		mnttab = "/proc/mounts";
	}
	else
		mnttab = "/etc/mtab";
#endif
	tab_file=setmntent(mnttab, "r");

	if (!tab_file) {
	      perror("setmntent:");
	      return -1;
	}
	while ((m=getmntent(tab_file))!=NULL){
		/*printf("DBG2:%s=%s\n",m->mnt_dir,mnt_point);*/
	   if (strcmp(m->mnt_dir,mnt_point)==0){
	        endmntent(tab_file);
		return 1;
	   }	   
	}
	endmntent(tab_file);
	return 0; 
#elif defined(HAVE_STATFS) && defined(HAVE_STRUCT_STATFS_F_MNTONNAME)
      struct statfs statfsbuf;	
      if (statfs(mnt_point, &statfsbuf) == 0) {
	if (strcmp(mnt_point, statfsbuf.f_mntonname) == 0) return 1;
	else return 0;
      }
      return -1; 
#elif defined(HAVE_GETMNTENT) && defined(HAVE_STRUCT_MNTTAB_MNT_MOUNTP)
	/*
	 * The Solaris way...
	 */
	struct mnttab mbuf;
	FILE *fp;
	int r=-1;

	if ((fp = fopen("/etc/mnttab", "r")) != NULL) {
		for (;;) {
			if (getmntent(fp, &mbuf) != 0){
				r=0;
				break;
			}

			if (strcmp(mbuf.mnt_mountp,mnt_point) == 0) {
				r=1;
				break;
			}
		}
		(void)fclose(fp);
	}
	return r;
#else
    return -1;
#warning "missing code here. " 
#endif
}


G_MODULE_EXPORT
int
fstab_mount (GtkTreeView *treeview, const gchar *mnt_point, gboolean umnt,tree_entry_t *en)
{
    gchar *argument[12];
    gchar **ap;
    int i;
    gchar *g=NULL;
    static gchar *sudo_prompt=NULL;
    gboolean use_sudo=FALSE;
    gchar *umount="umount",*mount="mount";
    const char *smb_user;
    gchar *smb_options=NULL;
    static gchar *smb_browse=NULL;
    /*GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);*/

    g_free(smb_browse);
    smb_browse=NULL;
    /* this will set the is_smb variable: */
    if (!is_in_fstab(mnt_point)) {
	if (!is_smb) {
	    print_diagnostics("xfce/error",strerror(ENODEV),":\n","no smbfs support detected in kernel\n",NULL);
	    return 0;
	}
	if (en && IS_XF_NETSHARE(en->subtype))
	{	    
	    smb_browse=randomTmpName(NULL);
	    unlink(smb_browse);
	    print_diagnostics(NULL,"$mkdir ",smb_browse,"\n",NULL);
	    mkdir(smb_browse, S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
	}
    }
    
    if (getenv("XFFM_USE_SUDO") && strlen(getenv("XFFM_USE_SUDO"))) use_sudo=TRUE;
    /*if (smb_browse) use_sudo=FALSE;*/

    if (!getuid()) use_sudo=FALSE;
    ap = argument;

    if (use_sudo) {
       if ((g = g_find_program_in_path("sudo")) != NULL){
	    *ap++ = "sudo";
	    *ap++ = "-S";
	    g_free(g);
       } else {
	   print_diagnostics("xfce/error",strerror(ENOENT),": sudo",NULL);
       }
    }
		 
    
    if (smb_browse) i=0;
    else i=is_mounted(mnt_point);
    
    if (i >= 0){
      if (i) *ap++ = umount;
      else *ap++ =mount;
    } else {
      if (umnt)	*ap++ = umount;
      else	*ap++ = mount;
    }
    if (is_smb && i==0) {
	if (smb_browse) {
	    *ap++="-t";
	    *ap++="smbfs";
	}
	smb_user=get_smbuserpass(tree_details->window,en);
	if (!smb_user || !strlen(smb_user)){
	  smb_options=g_strdup_printf("guest");
	} else {
	  smb_options=g_strdup_printf("username=%s",smb_user);
	}
     	*ap++ = "-o";
	*ap++ = smb_options;
    }

#if 0
#if !defined(HAVE_GETVFSENT) && !defined(STAT_STATVFS) 
    /* XXX - This test is BAD */
    /* -v is different on Solaris */
    *ap++ = "-v";
#endif
#endif
    *ap++ = (gchar *)mnt_point;
    if (smb_browse){
	*ap++ = smb_browse;
    }
    *ap++ = NULL;

    print_diagnostics(NULL,"$",argument[0],NULL);
    for (i=1;argument[i];i++){
	if (strstr(argument[i],"username=")) print_diagnostics(NULL," username=*****",NULL);
	else 
	    print_diagnostics(NULL," ",argument[i],NULL);
    }
    print_diagnostics(NULL,"\n",NULL);
    fstab_treeview = treeview;
    
    chdir(GETWD);
    show_stop();
	
    /*printf("DBG: envars=%s\n",env_vars[i]);
    printf("DBG: value=%s\n",value);*/
    
    /* put in a \n to the password prompt to flush the pipe: fluusshh */
    if (sudo_prompt) g_free(sudo_prompt);
    sudo_prompt = g_strconcat("SUDO_PROMPT=","Password:","\n",NULL);
    putenv(sudo_prompt);
    tree_details->tubo_object = 
		Tubo(fork_function, 
				(void *)argument, 
				fork_finished_function, 
				&childFD, 
				operate_stdout, 
				operate_stderr,0,TRUE);
    	
    g_timeout_add(260,(GtkFunction) watch_stop, (gpointer) treeview);
    	
    Gpid = TuboPID(tree_details->tubo_object);
    g_free(smb_options);
    if (smb_browse) {
	go_to(tree_details->treestuff+get_tree_id(treeview),smb_browse);
    }
    return(1);
}


/* NOTE: Cygwin does have FS mounts, but they work differently from
   all other environments. For the moment, we will not support any
   mounting functionality, although in the future we might add
   cygwin specific support
*/
#if defined (__CYGWIN__)

G_MODULE_EXPORT
int
open_fstab (GtkTreeView *treeview, GtkTreeIter *iter, GtkTreePath *treepath, 
	   gpointer user_data)
{
	fstat_xfdir.gl=NULL;
	return(1);
}

G_MODULE_EXPORT
gboolean
is_in_fstab (const gchar *path)
{
	is_smb=FALSE;
    return FALSE;
}

/* NOTE: FreeBSD will fail if is HAVE_GETVFSENT before HAVE_STATFS */
#elif defined(HAVE_GETMNTENT) && defined(HAVE_STRUCT_MNTENT_MNT_DIR)

/*
 * HP-UX, Linux, SunOS 4.x
 */

#if !defined(MNTTYPE_PROCFS)
#define MNTTYPE_PROCFS	"proc"
#endif

#if !defined(MNTTYPE_SMBFS)
#define MNTTYPE_SMBFS	"smbfs"
#endif

#if !defined(MNTTYPE_DEV)
#define MNTTYPE_DEV	"devpts"
#endif

#if !defined(MNTTYPE_SHM)
#define MNTTYPE_SHM	"tmpfs"
#endif

#if !defined(MNTTYPE_CDFS)
#define	MNTTYPE_CDFS	"hfs"		/* HP-UX */
#endif

#if !defined(MNTTYPE_SWAP)
#define MNTTYPE_SWAP	"swap"
#endif

#if !defined(MNTTYPE_SWAPFS)
#define	MNTTYPE_SWAPFS	"swapfs"	/* HP-UX */
#endif

#if !defined(MNTTYPE_NFS)
#define MNTTYPE_NFS	"nfs"
#endif

#if !defined(MNT_CHECKLIST)
#if defined(_PATH_FSTAB)
#define MNT_CHECKLIST	_PATH_FSTAB
#else
#define MNT_CHECKLIST	"/etc/fstab"
#endif
#endif

int
open_fstab (GtkTreeView *treeview, GtkTreeIter *iter, GtkTreePath *treepath, 
		gpointer user_data)
{
	/*struct mntent *mnt_mounted;*/
        struct mntent *mnt_struct;
   	tree_entry_t *en;
	const gchar *mnttab;
	/*struct stat st;*/
	FILE *fstab_fd;
	FILE *mtab_fd;
	int i;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);

#if defined(MNT_MNTTAB)
	mnttab = MNT_MNTTAB;
#else
	/*
	 * try /proc/mounts first
	 */
	if ((mtab_fd = fopen("/proc/mounts", "r")) != NULL) {
		(void)fclose(mtab_fd);
		mnttab = "/proc/mounts";
	}
	else
		mnttab = "/etc/mtab";
#endif
	
	if ((fstab_fd = setmntent(MNT_CHECKLIST,"r")) == NULL) {
		fprintf(stderr, "Unable to open %s\n", MNT_CHECKLIST);
		return(0);
	}

	fstat_xfdir.pathc = 0;
	
	for (mnt_struct = getmntent(fstab_fd); mnt_struct != NULL;
			mnt_struct = getmntent(fstab_fd)) {
		if (strcmp(MNTTYPE_SWAP, mnt_struct->mnt_type) == 0)
			continue;

#if defined(MNTTYPE_IGNORE)
		if (strcmp(MNTTYPE_IGNORE, mnt_struct->mnt_type) == 0)
			continue;
#endif

		if (!g_file_test(mnt_struct->mnt_dir, G_FILE_TEST_IS_DIR))
			continue;

		fstat_xfdir.pathc++;
        }

        (void)endmntent(fstab_fd);
	
	gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);

	fstat_xfdir.gl = (dir_t *)malloc(fstat_xfdir.pathc * sizeof(dir_t));

        if ((fstab_fd = setmntent(MNT_CHECKLIST,"r")) == NULL) {
		fprintf(stderr, "Unable to open %s\n", MNT_CHECKLIST);
		g_free(fstat_xfdir.gl);
		fstat_xfdir.gl=NULL;
		return(0);
	}

	for (i = 0, mnt_struct = getmntent(fstab_fd); mnt_struct != NULL;
			mnt_struct = getmntent(fstab_fd)) {
		if (strcmp(MNTTYPE_SWAP, mnt_struct->mnt_type) == 0)
			continue;

#if defined(MNTTYPE_IGNORE)
		if (strcmp(MNTTYPE_IGNORE, mnt_struct->mnt_type) == 0)
			continue;
#endif

		if (!g_file_test(mnt_struct->mnt_dir, G_FILE_TEST_IS_DIR))
			continue;

    		fstat_xfdir.gl[i].en = stat_entry(mnt_struct->mnt_dir, en->type);
   	 	fstat_xfdir.gl[i].pathv = g_strdup(mnt_struct->mnt_dir);

		SET_XF_FSTAB(fstat_xfdir.gl[i].en->type);

		if (strcmp(MNTTYPE_NFS, mnt_struct->mnt_type) == 0)
			SET_NFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_SMBFS, mnt_struct->mnt_type) == 0)
			SET_SMB_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_PROCFS, mnt_struct->mnt_type) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_DEV, mnt_struct->mnt_type) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_SHM, mnt_struct->mnt_type) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_SWAPFS, mnt_struct->mnt_type) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_CDFS, mnt_struct->mnt_type) == 0)
			SET_CDFS_TYPE(fstat_xfdir.gl[i].en->subtype);

		i++;

	}

        (void)endmntent(fstab_fd);

	add_contents_row(treemodel, iter, &fstat_xfdir);
	erase_dummy_row(treemodel, iter, NULL);
	

	xfdirfree(&fstat_xfdir);

        return(1);
}

gboolean
is_in_fstab (const gchar *path)
{
        struct mntent *mnt_struct;
	FILE *fstab_fd;
	gboolean result=FALSE;

	is_smb=FALSE;
	if ((fstab_fd = setmntent(MNT_CHECKLIST,"r")) == NULL) {
		fprintf(stderr, "Unable to open %s\n", MNT_CHECKLIST);
		return(0);
	}

	
	for (mnt_struct = getmntent(fstab_fd); mnt_struct != NULL;
			mnt_struct = getmntent(fstab_fd)) {
		if (strcmp(MNTTYPE_SWAP, mnt_struct->mnt_type) == 0)
			continue;
		if (strcmp(MNTTYPE_SMBFS, mnt_struct->mnt_type) == 0)
			is_smb=TRUE;
#if defined(MNTTYPE_IGNORE)
		if (strcmp(MNTTYPE_IGNORE, mnt_struct->mnt_type) == 0)
			continue;
#endif

		if (!g_file_test(mnt_struct->mnt_dir, G_FILE_TEST_IS_DIR))
			continue;
		if (strcmp(path,mnt_struct->mnt_dir)==0) {
		    result=TRUE;
		    break;
		}
        }

        (void)endmntent(fstab_fd);

        return(result);
}

/* needs STAT_STATVFS to avert FreeBSD from falling in here,
 * but that does not work with fbsd 5.0, so use HAVE_SYS_STATFS_H
 * instead... */
#elif defined(HAVE_GETVFSENT) && defined (HAVE_SYS_STATFS_H)

/*
 * Solaris
 */

#define MNTTYPE_CACHEFS	"cachefs"
#define MNTTYPE_HSFS	"hsfs"
#define MNTTYPE_NFS	"nfs"
#define MNTTYPE_SWAP	"swap"

int
open_fstab (GtkTreeView *treeview, GtkTreeIter *iter, GtkTreePath *treepath, 
		gpointer user_data)
{
	struct vfstab vbuf;
	struct mnttab mbuf;
   	tree_entry_t *en;
	FILE *vfstab_fp;
	FILE *mnttab_fp;
	struct stat st;
	int i;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);

	if ((vfstab_fp = fopen("/etc/vfstab", "r")) == NULL)
		return(0);

	for (i = 0;; ) {
		if (getvfsent(vfstab_fp, &vbuf) != 0)
			break;
		
		if(strcmp(MNTTYPE_SWAP, vbuf.vfs_fstype) == 0)
			continue;

		if (!g_file_test(vbuf.vfs_mountp, G_FILE_TEST_IS_DIR))
			continue;

		i++;
	}

	if ((mnttab_fp = fopen("/etc/mnttab", "r")) == NULL) {
		(void)fclose(vfstab_fp);
		return(0);
	}

	(void)rewind(vfstab_fp);

	if ((fstat_xfdir.gl = (dir_t *)malloc(i * sizeof(dir_t))) == NULL) {
		(void)fclose(mnttab_fp);
		(void)fclose(vfstab_fp);
		return(0);
	}

	fstat_xfdir.pathc = i;

	gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);

	for (i = 0;;) {
		if (getvfsent(vfstab_fp, &vbuf) != 0)
			break;
		
		if(strcmp(MNTTYPE_SWAP, vbuf.vfs_fstype) == 0)
			continue;

		if (!g_file_test(vbuf.vfs_mountp, G_FILE_TEST_IS_DIR))
			continue;

    		fstat_xfdir.gl[i].en = stat_entry(vbuf.vfs_mountp, en->type);
   	 	fstat_xfdir.gl[i].pathv = g_strdup(vbuf.vfs_mountp);

		SET_XF_FSTAB(fstat_xfdir.gl[i].en->type);
	
		if (strcmp(MNTTYPE_NFS, vbuf.vfs_fstype) == 0)
			SET_NFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_HSFS, vbuf.vfs_fstype) == 0)
			SET_CDFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_CACHEFS, vbuf.vfs_fstype) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);

		i++;
		/*
		 * Check if filesystem is already mounted
		 *  
		 */
		(void)rewind(mnttab_fp);
		for (;;) {
			if (getmntent(mnttab_fp, &mbuf) != 0)
				break;

			if (strcmp(mbuf.mnt_mountp, vbuf.vfs_mountp) == 0) 
		    		TOGGLE_MOUNTED(fstat_xfdir.gl[i].en->type);
		}
	}

        (void)fclose(mnttab_fp);
        (void)fclose(vfstab_fp);
	
	add_contents_row(treemodel, iter, &fstat_xfdir);
	erase_dummy_row(treemodel, iter, NULL);

	xfdirfree(&fstat_xfdir);

        return(1);
}

gboolean
is_in_fstab (const gchar *path)
{
	gboolean result=FALSE;
	struct vfstab vbuf;
	FILE *vfstab_fp;
	is_smb=FALSE;

	if ((vfstab_fp = fopen("/etc/vfstab", "r")) == NULL)
		return(0);

	while (1) {
		if (getvfsent(vfstab_fp, &vbuf) != 0)
			break;
		
		if(strcmp(MNTTYPE_SWAP, vbuf.vfs_fstype) == 0)
			continue;

		if (!g_file_test(vbuf.vfs_mountp, G_FILE_TEST_IS_DIR))
			continue;
		if (strcmp(path,vbuf.vfs_mountp)==0) {
		    result=TRUE;
		    break;
		}

	}
	(void)fclose(vfstab_fp);
        return(result);
}

#elif defined(HAVE_GETFSENT)

/*
 * AIX, BSD, OSF1, ULTRIX
 */

#if defined(MOUNT_CD9660)
#define MNTTYPE_CDFS	MOUNT_CD9660
#else
#define MNTTYPE_CDFS	"cdrfs"		/* AIX */
#endif

#if defined(MOUNT_CFS)
#define MNTTYPE_CODAFS	MOUNT_CFS
#elif defined(MOUNT_CODA)
#define MNTTYPE_CODAFS	MOUNT_CODA
#else
#define MNTTYPE_CODAFS	"coda"
#endif

#if defined(MOUNT_KERNFS)
#define MNTTYPE_KERNFS	MOUNT_KERNFS
#else
#define MNTTYPE_KERNFS	"kernfs"
#endif

#if defined(MOUNT_MFS)
#define MNTTYPE_MFS	MOUNT_MFS
#else
#define MNTTYPE_MFS	"mfs"
#endif

#if defined(MOUNT_NFS)
#define MNTTYPE_NFS	MOUNT_NFS
#else
#define MNTTYPE_NFS	"nfs"
#endif

#if defined(MOUNT_PROCFS)
#define MNTTYPE_PROCFS	MOUNT_PROCFS
#else
#define MNTTYPE_PROCFS "procfs"
#endif

#if defined(MOUNT_SMBFS)
#define MNTTYPE_SMBFS	MOUNT_SMBFS
#else
#define MNTTYPE_SMBFS	"smbfs"
#endif

#define MNTTYPE_SWAP	"swap"

int
open_fstab (GtkTreeView *treeview, GtkTreeIter *iter, GtkTreePath *treepath, 
	   gpointer user_data)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
#if 0
#if defined(HAVE_STATFS) && defined(HAVE_STRUCT_STATFS_F_MNTONNAME)
	struct statfs statfsbuf;
#endif
#endif
	struct fstab *fs;
   	tree_entry_t *en;
	int i;

	gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);

	if (!setfsent())
		return(0);

	for (i = 0, fs = getfsent(); fs != NULL;
			fs = getfsent()) {
		if (strcmp(MNTTYPE_SWAP, fs->fs_vfstype) == 0)
			continue;

		if (!g_file_test(fs->fs_file, G_FILE_TEST_IS_DIR))
			continue;

		i++;
	}

	if (!setfsent())
		return(0);
	
	if ((fstat_xfdir.gl = (dir_t *)malloc(i * sizeof(dir_t))) == NULL) {
		endfsent();
		return(0);
	}

	fstat_xfdir.pathc = i;

	for (i = 0, fs = getfsent(); fs != NULL; 
			fs = getfsent()) {
		if (strcmp(MNTTYPE_SWAP, fs->fs_vfstype) == 0)
			continue;

		if (!g_file_test(fs->fs_file, G_FILE_TEST_IS_DIR))
			continue;

    		fstat_xfdir.gl[i].en = stat_entry(fs->fs_file, en->type);
   	 	fstat_xfdir.gl[i].pathv = g_strdup(fs->fs_file);

		SET_XF_FSTAB(fstat_xfdir.gl[i].en->type);

		if (strcmp(MNTTYPE_CDFS, fs->fs_vfstype) == 0)
			SET_CDFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_CODAFS, fs->fs_vfstype) == 0)
			SET_NFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_KERNFS, fs->fs_vfstype) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_MFS, fs->fs_vfstype) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_NFS, fs->fs_vfstype) == 0)
			SET_NFS_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_PROCFS, fs->fs_vfstype) == 0)
			SET_PROC_TYPE(fstat_xfdir.gl[i].en->subtype);
		else if (strcmp(MNTTYPE_SMBFS, fs->fs_vfstype) == 0)
			SET_SMB_TYPE(fstat_xfdir.gl[i].en->subtype);
#if 0
		/* no longer needed to set lag in this case */
#if defined(HAVE_STATFS) && defined(HAVE_STRUCT_STATFS_F_MNTONNAME)
		/*
		 * Check if file system is already mounted
		 */
		if (statfs(fs->fs_file, &statfsbuf) == 0) {
			if (strcmp(fs->fs_file, statfsbuf.f_mntonname) == 0) {
				printf("%s: already mounted\n", fs->fs_file);
		    		TOGGLE_MOUNTED(fstat_xfdir.gl[i].en->type);
			}
		}
#endif
#endif

		i++;
	}

	endfsent();
	
	add_contents_row(treemodel, iter, &fstat_xfdir);
	erase_dummy_row(treemodel, iter, NULL);

	xfdirfree(&fstat_xfdir);
		
        return(1);
}

gboolean
is_in_fstab (const gchar *path)
{
	gboolean result=FALSE;
	struct fstab *fs;

	is_smb=FALSE;
	if (!setfsent()) return(0);

	for ( fs = getfsent(); fs != NULL; fs = getfsent()) {
		if (strcmp(MNTTYPE_SWAP, fs->fs_vfstype) == 0)
			continue;
		if (strcmp(MNTTYPE_SMBFS, fs->fs_vfstype) == 0)
			is_smb=TRUE;
		if (!g_file_test(fs->fs_file, G_FILE_TEST_IS_DIR))
			continue;
		
		if (strcmp(path,fs->fs_file)==0) {
		    result=TRUE;
		    break;
		}
	}
	endfsent();		
        return(result);
}


#else

int
open_fstab (GtkTreeView *treeview, GtkTreeIter *iter, GtkTreePath *treepath, 
	   gpointer user_data)
{
	fstat_xfdir.gl=NULL;
	return(1);
}

gboolean
is_in_fstab (const gchar *path)
{
	is_smb=FALSE;
    return FALSE;
}

#endif

G_MODULE_EXPORT
void
on_mount   (GtkMenuItem     *menuitem, gpointer         user_data){
    GtkTreeIter iter;
    tree_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;

    en = get_selected_entry(&iter);
    /*if(!en || (!IS_FSTAB_TYPE(en->type) && !IS_ROOT_TYPE(en->type)))*/
    if(!en || !en->path)
	    return;
    fstab_mount(treeview,(const gchar *)en->path,(int)((long)user_data),en);
}

