/*
 * Copyright (C) 2003-2004 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define __COMBO_C__
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gtk/gtksignal.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
/* include non installed headers */
#include <xfce4-modules/headers/constants.h>
#include <xfce4-modules/headers/combo.h>

#include <libxfce4util/libxfce4util.h>

#ifndef HAVE_LIBDBH
#warning "dbh not installed: combo module not compiled!"
G_MODULE_EXPORT
const gchar *g_module_check_init(GModule *module){
    g_error("Cannot work with combo module: libxfcegui4 constructed without libdbh.");
    return NULL;
}
#else
/* get rid of warnings generated on FreeBSD.5.2.1 
 * (these macros are not used in this code) */
#ifdef PACKAGE_BUGREPORT 
#undef PACKAGE_BUGREPORT 
#endif 
#ifdef PACKAGE_NAME 
#undef PACKAGE_NAME 
#endif 
#ifdef PACKAGE_STRING 
#undef PACKAGE_STRING 
#endif 
#ifdef PACKAGE_TARNAME 
#undef PACKAGE_TARNAME 
#endif 
#ifdef PACKAGE_VERSION 
#undef PACKAGE_VERSION 
#endif 

#include <dbh.h>

gboolean xfc_is_in_history(char *path2dbh_file,char *path2find);
gboolean xfc_set_combo(xfc_combo_info_t *combo_info, char *token);
void xfc_set_blank(xfc_combo_info_t *combo_info);
void xfc_set_entry(xfc_combo_info_t *combo_info,char *entry_string);
void xfc_save_to_history(char *path2dbh_file,char *path2save);
void xfc_remove_from_history(char *path2dbh_file,char *path2remove);
void xfc_read_history(xfc_combo_info_t *combo_info, gchar *path2dbh_file);
void xfc_clear_history(xfc_combo_info_t *combo_info);
xfc_combo_info_t *xfc_init_combo(GtkCombo *combo);
xfc_combo_info_t *xfc_destroy_combo(xfc_combo_info_t *combo_info);

/************** private ***************/

#define MAX_COMBO_ELEMENTS 13

#define HISTORY_ITEMS MAX_COMBO_ELEMENTS


#define CURSOR_KEYSTROKE(x) (								\
				x == GDK_Right || x == GDK_Left	||			\
				x == GDK_KP_Right || x == GDK_KP_Left			\
		)
		
#define BASIC_KEYSTROKE(x) (	x == GDK_KP_Divide || x == GDK_KP_Multiply ||		\
				x == GDK_KP_Subtract || x == GDK_KP_Add	||		\
				x == GDK_BackSpace || x == GDK_Delete ||		\
				x == GDK_KP_Delete || x == GDK_KP_Space ||		\
				(x >= GDK_KP_0 && x <= GDK_KP_9) ||			\
     				(x >= GDK_space && x <= GDK_asciitilde)			\
		)

#define ENTRY_KEYSTROKE(x) (								\
				x == GDK_Escape || x == GDK_KP_Enter ||			\
				x == GDK_Return || x == GDK_Tab ||			\
				CURSOR_KEYSTROKE(x) ||					\
				BASIC_KEYSTROKE(x)					\
		)

static GList **the_list;
static time_t last_hit;
static gboolean asian=FALSE;


static xfc_combo_functions *xfc_fun=NULL;

static void clean_history_list(GList **list);
static gint translate_key(gint x);
static gint on_key_press(GtkWidget * entry, GdkEventKey * event, gpointer data);
static gint on_key_press_history(GtkWidget * entry, GdkEventKey * event, gpointer data);
static gint on_combo_history_key_press(GtkWidget * window, GdkEventKey * event, gpointer data);
static int history_compare (gconstpointer a,gconstpointer b);
static void history_mklist(DBHashTable * d);
static void get_history_list(GList **in_list,char *dbh_file,char *top);

G_MODULE_EXPORT
const gchar *g_module_check_init(GModule *module){
    xfc_fun = g_new0 (xfc_combo_functions,1);
    if (!xfc_fun) return ("Cannot create function structure");
    xfc_fun->extra_key_completion = NULL;
    xfc_fun->extra_key_data = NULL; 
    xfc_fun->xfc_is_in_history = xfc_is_in_history;
    xfc_fun->xfc_set_combo = xfc_set_combo;
    xfc_fun->xfc_set_blank = xfc_set_blank;
    xfc_fun->xfc_set_entry = xfc_set_entry;
    xfc_fun->xfc_save_to_history = xfc_save_to_history;
    xfc_fun->xfc_remove_from_history = xfc_remove_from_history;
    xfc_fun->xfc_read_history = xfc_read_history;
    xfc_fun->xfc_clear_history = xfc_clear_history;
    xfc_fun->xfc_init_combo = xfc_init_combo;
    xfc_fun->xfc_destroy_combo = xfc_destroy_combo;
    xfc_fun->xfc_init_combo = xfc_init_combo;
    xfc_fun->xfc_destroy_combo = xfc_destroy_combo;
    return NULL;
}

void g_module_unload(GModule *module){
    if (xfc_fun) g_free(xfc_fun);
    xfc_fun=NULL;
}
static void clean_history_list(GList **list){
	GList *tmp;
	if (!*list) return ;
	for (tmp=*list;tmp;tmp=tmp->next){
		/*printf("freeing %s\n",(char *)tmp->data);*/
		g_free(tmp->data);
		tmp->data=NULL;
	}
	g_list_free(*list);
	*list=NULL;
	return;
}

static gint translate_key(gint x){
	switch (x) {
		case GDK_KP_Divide: return GDK_slash;
		case GDK_KP_Subtract: return GDK_minus;
		case GDK_KP_Multiply: return GDK_asterisk;
		case GDK_KP_Add: return GDK_plus;
		case GDK_KP_Space: return GDK_space;
		case GDK_KP_0: return GDK_0;
		case GDK_KP_1: return GDK_1;
		case GDK_KP_2: return GDK_2;
		case GDK_KP_3: return GDK_3;
		case GDK_KP_4: return GDK_4;
		case GDK_KP_5: return GDK_5;
		case GDK_KP_6: return GDK_6;
		case GDK_KP_7: return GDK_7;
		case GDK_KP_8: return GDK_8;
		case GDK_KP_9: return GDK_9;
	}
	return x;
}

static gint on_key_press(GtkWidget * entry, GdkEventKey * event, gpointer data)
{
 xfc_combo_info_t *combo_info=(xfc_combo_info_t *)data;
 /*printf("DBG(2):got key= 0x%x\n",event->keyval);*/
 if (event->keyval == GDK_Escape && combo_info->cancel_func) {
	(*(combo_info->cancel_func))((GtkEntry *)entry,combo_info->cancel_user_data);
	return TRUE;
 }
 return FALSE;
}
static gint on_key_press_history(GtkWidget * entry, GdkEventKey * event, gpointer data)
{
    gboolean find_match=FALSE;
    int i;
    gchar *text[2]={NULL,NULL};
    gchar c[]={0,0};
    gchar *fulltext=NULL;
    xfc_combo_info_t *combo_info = (xfc_combo_info_t *)data;
    GList *tmp=combo_info->list;
    GtkEditable *editable=(GtkEditable *)entry;
    static gint shift_pos=-1;
    static gint cursor_pos=-1;
    gint pos1,pos2,pos;
    gboolean preselection;
   /* asian input methods: turns off autocompletion */
    if (event->keyval == GDK_space &&(event->state&(GDK_CONTROL_MASK|GDK_SHIFT_MASK))){
	asian=TRUE;
	return FALSE;
    }
    else if (event->keyval == GDK_space &&(event->state&GDK_MOD1_MASK)){
	/* turn autocompletion back on */
	asian=FALSE;	
	return TRUE;
    }

    if (asian && !(event->keyval == GDK_Return) && !(event->keyval == GDK_KP_Enter)) return FALSE;
    
    

    if (event->keyval == GDK_Shift_L || event->keyval == GDK_Shift_R ){
     cursor_pos = shift_pos = pos; 
    }

    preselection=
	    gtk_editable_get_selection_bounds (editable,&pos1,&pos2);

    pos=gtk_editable_get_position(editable);
     
    if (!preselection) pos1 =  pos2 = -1;

    DBG("DBG(2):pos= %d, shift_pos=%d cursor_pos=%d",pos,shift_pos,cursor_pos);
    DBG("DBG(2):got key= 0x%x",event->keyval);
    /*DBG("DBG(2):dbhfile= %s\n",combo_info->active_dbh_file);*/

    
 if (event->keyval == GDK_KP_Down && (event->state&GDK_MOD1_MASK)){
	 goto returnFALSE;
 }
 if (event->keyval == GDK_KP_Up && (event->state&GDK_MOD1_MASK)){
	 goto returnFALSE;
 }
 if (event->keyval == GDK_Down && (event->state&GDK_MOD1_MASK)){
	 goto returnFALSE;
 }
 if (event->keyval == GDK_Up && (event->state&GDK_MOD1_MASK)){
	 goto returnFALSE;
 }
 
 
 g_signal_handlers_block_by_func (GTK_OBJECT (entry), on_key_press_history, data);
 if (event->keyval == GDK_Return || event->keyval == GDK_KP_Enter) {
	 /*printf("DBG: got return;\n");*/
	 if (combo_info->activate_func) {
		/*( *(combo_info->activate_func))((GtkEntry *)entry,(gpointer)combo_info);*/
		( *(combo_info->activate_func))((GtkEntry *)entry,combo_info->activate_user_data);
	 }
	 goto end;
 }
    
 if (event->keyval == GDK_BackSpace && (event->state&GDK_CONTROL_MASK)){
        gchar *p;
        fulltext=gtk_editable_get_chars (editable,0,-1);
	p = strrchr(fulltext,' ');
	if (!p) p = strrchr(fulltext,G_DIR_SEPARATOR);
	if (!p) {
	    gtk_editable_delete_text (editable,0,-1);
	    /*xfc_set_blank(combo_info);*/
	}
	else {
	    gtk_editable_delete_text (editable,strlen(fulltext)-strlen(p),-1);
	}
	g_free(fulltext);
	fulltext=NULL;
	 goto end;
 }

 if (event->keyval == GDK_Tab) {
    gint start,end;
    {	
    	if (gtk_editable_get_selection_bounds(editable,&start,&end)){
	  gchar *p;
	  p=gtk_editable_get_chars (editable,start,end);
	  if (*p ==G_DIR_SEPARATOR || *p ==' ') start++;
	  g_free(p);p=NULL;	  
	/*printf("selection at %d %d\n",start,end);*/
	  for (;start<=end;start++){
		p=gtk_editable_get_chars (editable,start,end);
		/*printf("start=%d got char %s\n",start,p);*/
		if (*p ==G_DIR_SEPARATOR || *p ==' ') {
			start++;
			gtk_editable_delete_text (editable,start,end);
			preselection=FALSE;
			g_free(p);p=NULL;
			break;
		}
		g_free(p);p=NULL;
	  }
   	  gtk_editable_select_region (editable, 0,0);
    	  gtk_editable_set_position(editable,-1);
      	  fulltext=gtk_editable_get_chars (editable,0,-1);
	  
	     cursor_pos = -1;
	  
	} 
	else {
 	  gchar *p,*q;
	  gboolean blank=TRUE;
	  p=gtk_editable_get_chars (editable,0,-1);
	  if (p){
		  for (q=p; *q; q++){
			  if (*q != ' ') blank=FALSE;
		  }
		  if (blank) g_signal_emit_by_name((gpointer)GTK_COMBO(combo_info->combo)->entry, "activate", NULL);
	  }
	  g_free(p);p=NULL;
          goto end;
	}
    }
 }
 else if (CURSOR_KEYSTROKE(event->keyval)) {
	 if (event->keyval == GDK_Right){
	     /*printf ("DBG: right\n");*/
	     if (event->state&GDK_SHIFT_MASK){
	       cursor_pos++;
	       if (cursor_pos < shift_pos) gtk_editable_select_region (editable, cursor_pos,shift_pos);
	       else gtk_editable_select_region (editable,shift_pos,cursor_pos);
	     } else {
		gtk_editable_set_position (editable,pos+1);
		cursor_pos = pos+1;
	     }
	 }else{
	     /*printf ("DBG: left\n");*/
	     /* cranky gtk design, position must be at end of selection... */
	     if (cursor_pos) cursor_pos--; 
	     if (event->state&GDK_SHIFT_MASK){
	           if (cursor_pos < shift_pos) 
		       gtk_editable_select_region (editable, cursor_pos,shift_pos);
	           else 
		       gtk_editable_select_region (editable,shift_pos,cursor_pos);
	     } else if (pos-1 >= 0){
		 gtk_editable_set_position (editable,pos-1);
		cursor_pos = pos-1;
	     }
	 }
	goto end;	 
 }


 /* construct search string... (limited to 128 bytes)*/

 /* control-delete will remove the selected item from the
  * history dbh file (to remove stale history items) */

 if (BASIC_KEYSTROKE(event->keyval)){
	/* get entry text */

   	if (event->keyval == GDK_BackSpace ){
    	    if (preselection) {
	        /* why was this -1? gtk_editable_delete_text (editable,pos1,-1);*/
	        gtk_editable_delete_text (editable,pos1,pos2);
		/*printf("DBG:pos1=%d,pos2=%d\n",pos1,pos2);*/
		goto end;
	    }
	    if (pos==0) {
		    goto end;
	    }
      	    text[0]=gtk_editable_get_chars (editable,0,pos-1);
	    text[1]=gtk_editable_get_chars (editable,pos,-1);
	    fulltext=g_strconcat(text[0],text[1],NULL);
   	    g_free(text[0]);
    	    g_free(text[1]);
	    text[0]=text[1]=NULL;
	    gtk_editable_delete_text (editable,0,-1);
	    pos1=0;
	    if (fulltext && strlen(fulltext)){
	       gtk_editable_insert_text (editable,(const gchar *)fulltext,
			     strlen(fulltext),&pos1);
	       gtk_editable_set_position (editable,pos-1);
	     cursor_pos = pos-1;
	       /*printf("DBG: inserting %s\n",fulltext);*/
	    } else {
	 	xfc_set_blank(combo_info);
	    }
	    g_free(fulltext); 
	    fulltext=NULL;
	    goto end;
	} 
	else if (event->keyval == GDK_Delete ||
     	    event->keyval == GDK_KP_Delete){
	  if (combo_info->active_dbh_file && event->state&GDK_CONTROL_MASK){ /* remove stale entries */
    	    fulltext=gtk_editable_get_chars (editable,0,-1);
	    xfc_remove_from_history(combo_info->active_dbh_file,fulltext);
	    /* XXX: parent program must need to know when to 
	     *        print the message. */
	    /*printf("DBG: Variable %s Cancelled\n", fulltext);*/
/*	    print_diagnostics(treeview,"xfce/info_icon",
			    _("Variable")," \"",fulltext,"\" ",
			    _("Cancelled"),"\n",NULL);*/
	    g_free(fulltext);
	    fulltext=NULL;
	    if (combo_info->cancel_func)
	       (*(combo_info->cancel_func))((GtkEntry *)entry,combo_info->cancel_user_data);
	    /*cancel_input(treeview);*/
	    goto end;
	  } else {
		  /*printf("DBG: pos=%d, pos1=%d\n",pos,pos1);*/
	    g_free(fulltext);
	    fulltext=NULL;
    	    if (preselection) {
	        /* gtk_editable_delete_text (editable,pos1,-1);*/
	        gtk_editable_delete_text (editable,pos1,pos2);
		goto end;
	    }
      	    text[0]=gtk_editable_get_chars (editable,0,pos);
	    text[1]=gtk_editable_get_chars (editable,pos+1,-1);
	    fulltext=g_strconcat(text[0],text[1],NULL);
   	    g_free(text[0]);
    	    g_free(text[1]);
	    text[0]=text[1]=NULL;
	    
	    gtk_editable_delete_text (editable,0,-1);
	    if (fulltext && strlen(fulltext)){
	      pos1=0;
	      gtk_editable_insert_text (editable,(const gchar *)fulltext,
			     strlen(fulltext),&pos1);
	      gtk_editable_set_position (editable,pos);
	     cursor_pos = pos;
	      /*printf("DBG: inserting %s\n",fulltext);*/
	    } else {
	 	xfc_set_blank(combo_info);
	    }
	    g_free(fulltext); 
	    fulltext=NULL;
	    goto end;
	  }
	} else {
	  *c=translate_key(event->keyval);
    	  if (preselection) {
	        gtk_editable_delete_text (editable,pos1,-1);
      	        text[0]=gtk_editable_get_chars (editable,0,-1);
	  	fulltext=g_strconcat(text[0],c,NULL);
		text[1]=NULL;
	  	pos=0;
	        gtk_editable_delete_text (editable,0,-1);
	  	gtk_editable_insert_text (editable,(const gchar *)fulltext,
			     strlen(fulltext),&pos);
	  	gtk_editable_set_position (editable,pos);
	     cursor_pos = pos;
	  } else {
		  /*printf("DBG: pos=%d\n",pos);*/
      	        text[0]=gtk_editable_get_chars (editable,0,pos);
    	        text[1]=gtk_editable_get_chars (editable,pos,-1);
	  	fulltext=g_strconcat(text[0],c,text[1],NULL);
		  /*printf("DBG: pos=%d fulltext=%s\n",pos,fulltext);*/
	  	pos1=0;
	        gtk_editable_delete_text (editable,0,-1);
	  	gtk_editable_insert_text (editable,(const gchar *)fulltext,
			     strlen(fulltext),&pos1);
	  	gtk_editable_set_position (editable,pos+1);
	     cursor_pos = pos;
	  }
	  
	}		
    	g_free(text[0]);
    	g_free(text[1]);
	text[0]=text[1]=NULL;
 }
 else if (event->keyval != GDK_Tab) {
         g_signal_handlers_unblock_by_func (GTK_OBJECT (entry), on_key_press_history, data);
	 goto returnFALSE;
 }

 for (i=0; i< strlen(fulltext); i++) if (fulltext[i] != ' ') find_match = TRUE;
 if (find_match && combo_info->combo) {
 	/*printf("DBG: setting limited list and emitting signal...fulltext=%s\n",(fulltext)?fulltext:"null");*/
	if (xfc_set_combo(combo_info,fulltext)){
       	    g_signal_emit_by_name((gpointer)(entry), "activate", NULL);
	}
 }
 
 if (fulltext){
    /* look for in ordered GList*/
    /*printf("DBG:fulltext is %s\n",fulltext);*/
    for (;tmp;tmp=tmp->next){
	gchar *p=(gchar *)tmp->data;
	if (!p) continue;
        /*printf("DBG:compare with-> %s\n",p);*/
	if (strncmp(fulltext,p,strlen(fulltext))==0){
	    gchar *to_write=p+strlen(fulltext);
	    /*printf("DBG: gotcha %s->%s, to write=%s\n",fulltext,p,to_write);*/
            /* if found, complete with untyped part selected.*/
	    gtk_editable_delete_text (editable,0,-1);
	    pos1=0;
	    gtk_editable_insert_text (editable,(const gchar *)fulltext,
			     strlen(fulltext),&pos1);
	    pos2=pos1;
	    gtk_editable_insert_text (editable,(const gchar *)to_write,
			     strlen(to_write),&pos2);
    	    gtk_editable_select_region (GTK_EDITABLE (entry), pos1, -1);
    	    g_free(fulltext);
	    fulltext=NULL;
	    goto end;
	}
    }
    g_free(fulltext);
    fulltext=NULL;
 }
 end:			    
 g_signal_handlers_unblock_by_func (GTK_OBJECT (entry), on_key_press_history, data);
 if (xfc_fun->extra_key_completion) (*(xfc_fun->extra_key_completion))(xfc_fun->extra_key_data);
 return (TRUE);
returnFALSE:
 if (xfc_fun->extra_key_completion) (*(xfc_fun->extra_key_completion))(xfc_fun->extra_key_data);
 return (FALSE);
}

static gint on_combo_history_key_press(GtkWidget * window, GdkEventKey * event, gpointer data)
{
	/* gtk bug: the default handler always gets called first, so you cannot do anything with
	 * return key. bummer. up to gtk2.4 at least. */
 xfc_combo_info_t *combo_info = (xfc_combo_info_t *)data; 
 if (event->keyval == GDK_KP_Down || event->keyval == GDK_KP_Up || event->keyval == GDK_Down || event->keyval == GDK_Up){
     if (xfc_fun->extra_key_completion) (*(xfc_fun->extra_key_completion))(xfc_fun->extra_key_data);
     return FALSE;
 }
     /*printf("DBG(32):got key= 0x%x\n",event->keyval);*/
 if (event->keyval == GDK_Shift_L 
	 || event->keyval == GDK_Shift_R
	 || event->keyval == GDK_Control_L
	 || event->keyval == GDK_Control_R){
     gtk_widget_hide (window);
     if (GTK_WIDGET_HAS_GRAB (window))
     {
	  gtk_grab_remove (window);
	  gdk_pointer_ungrab (event->time);
     }
 }

 if (ENTRY_KEYSTROKE(event->keyval)) {
     
     /*
      * function not found:
      * g_signal_emit_stop_by_name (GTK_OBJECT (window), "key_press_event");
      *
      */
     gtk_widget_hide (window);
     if (GTK_WIDGET_HAS_GRAB (window))
     {
	  gtk_grab_remove (window);
	  gdk_pointer_ungrab (event->time);
     }
     
#if 10
     on_key_press_history((GtkWidget *)(GTK_COMBO(combo_info->combo)->entry), event, data);
#else
     /* alternatively it may be done by signal, : */
     {
       gint i;
       /*TRACE("signal_emit combo = 0x%x\n",combo_info->combo);)*/
       gtk_signal_emit_by_name (GTK_OBJECT (combo_info->entry), "key_press_event",event,&i);
       /*TRACE("signal_emit done, combo = 0x%x\n",combo_info->combo);)*/
	/* the last parameter is used to return a value from the function.*/
     }
#endif
     return TRUE;

 }
 if (xfc_fun->extra_key_completion) (*(xfc_fun->extra_key_completion))(xfc_fun->extra_key_data);
 return FALSE;
}

static int history_compare (gconstpointer a,gconstpointer b){
	history_dbh_t *da=(history_dbh_t *)a;
	history_dbh_t *db=(history_dbh_t *)b;
	/*if (db->last_hit >= last_hit) last_hit = db->last_hit;
	if (da->last_hit >= last_hit) last_hit = da->last_hit;*/
	       	
	if (db->last_hit >= last_hit && da->last_hit < last_hit){
		return 1;
	}
	if (da->last_hit >= last_hit && db->last_hit < last_hit){
		return -1;
	}
	if (db->hits != da->hits) return (db->hits - da->hits);
	/*if (db->last_hit != da->last_hit) return db->last_hit - da->last_hit;*/
	return (strcmp(da->path,db->path));
}

static void history_lasthit(DBHashTable * d)
{
    history_dbh_t *history_mem = (history_dbh_t *)DBH_DATA(d);
    if (!history_mem) g_assert_not_reached();
    if (history_mem->last_hit >= last_hit) {
		last_hit=history_mem->last_hit;
    }
}

static void history_mklist(DBHashTable * d)
{
    history_dbh_t *history_mem = (history_dbh_t *)malloc(sizeof(history_dbh_t));
    if (!history_mem) g_assert_not_reached();
    memcpy(history_mem,DBH_DATA(d),sizeof(history_dbh_t));
    if (!the_list) g_assert_not_reached(); 
    if (history_mem->path && strlen(history_mem->path)){
       *the_list = g_list_insert_sorted(*the_list,history_mem,history_compare);
       /*printf("DBG: inserted %s\n",(char *)history_mem->path);*/
    }

}
/* if top==NULL, the top entry is left blank,
 * if top=="", the top entry is the one with the greatest access time for last hit
 * if top=="anything", the entry is set to "anything"
 *
 * (only "" is used now)
 * */

static void get_history_list(GList **in_list,char *dbh_file,char *top){
   DBHashTable *d;
   GList *tmp;
/*   char *first=NULL;*/
   the_list=in_list;

	/*printf("DBG:at get_history_list with %s \n",dbh_file);*/
	   
   clean_history_list(the_list);	
   last_hit=0;
   if ((d=DBH_open(dbh_file))!=NULL){
	DBH_foreach_sweep(d,history_lasthit);	
	DBH_foreach_sweep(d,history_mklist);	
	DBH_close(d);
   }
   /* leave only strings in the history list: */
   for (tmp=*the_list;tmp;tmp=tmp->next){
 	history_dbh_t *history_mem=(history_dbh_t *)tmp->data;
	gchar *p=g_strdup(history_mem->path);
	DBG("%s, hits=%d",history_mem->path,history_mem->hits);
	tmp->data=p;
	g_free(history_mem);
	history_mem=NULL;
   }
   
   
   /*if (!top) *the_list=g_list_prepend(*the_list,g_strdup(""));
   if (top && strlen(top)) *the_list=g_list_prepend(*the_list,g_strdup(top));*/
	
   if (*the_list==NULL) {
	   *the_list=g_list_prepend(*the_list,g_strdup(""));
   }
   return ;
}

static void on_select_child(GList *list, GtkWidget *child){
     if (xfc_fun->extra_key_completion) (*(xfc_fun->extra_key_completion))(xfc_fun->extra_key_data);
     return;     
}

/*
static const char *xfc_tod(void){
	time_t t=time(NULL);
	return ctime(&t);
}*/

/*************** public *****************/

G_MODULE_EXPORT gboolean 
xfc_is_in_history(char *dbh_file,char *path2save)
{
    	GString *gs;
	DBHashTable *d;
	history_dbh_t *history_dbh;
	gboolean found=FALSE;
	
	if (strlen(path2save) > 255) return FALSE;
	if ((d=DBH_open(dbh_file))==NULL) return FALSE;
	gs = g_string_new(path2save);
    	sprintf((char *)DBH_KEY(d), "%10u", g_string_hash(gs));
   	g_string_free(gs, TRUE);

	history_dbh = (history_dbh_t *)DBH_DATA(d);
	if (DBH_load(d)) found=TRUE;
    	DBH_close(d);
	return found;
}


G_MODULE_EXPORT
gboolean xfc_set_combo(xfc_combo_info_t *combo_info, char *token){
    int count;
    GList *tmp,**limited_list;
    gboolean match=FALSE;
    
    /*if (!combo_info->list || !combo_info->active_dbh_file) {*/
    if (!combo_info->list) return match;
    
    combo_info->old_list = combo_info->limited_list;
    combo_info->limited_list = NULL;
    limited_list = &(combo_info->limited_list);
    DBG("token=%s",((token) ? token: "null"));

    for (tmp=combo_info->list,count=0;tmp;tmp=tmp->next){
	gchar *p=(gchar *)tmp->data;
	if (!p) continue;
        /* if (token) DBG("token=%s <-->%s",token,p);*/
	if (!token || strncmp(token,p,strlen(token))==0){
		if (token) match=TRUE;
		*limited_list=g_list_append(*limited_list,g_strdup(p));
		if (++count >= MAX_COMBO_ELEMENTS) break;
	}
    }

    if (*limited_list) {
	    gtk_combo_set_popdown_strings(combo_info->combo,*limited_list);
    	    clean_history_list(&(combo_info->old_list));
    }
    else {
	    combo_info->limited_list = combo_info->old_list;
    }
   return match;
}

G_MODULE_EXPORT
void xfc_set_blank(xfc_combo_info_t *combo_info){
    char *p;
    GList **limited_list;
    xfc_set_combo(combo_info, NULL);
    limited_list = &(combo_info->limited_list);
    if (!(*limited_list)) return;
    
    p=(char *)((*limited_list)->data);
    if (strcmp(p,"")) {
	    *limited_list=g_list_prepend(*limited_list,g_strdup(""));
	    gtk_combo_set_popdown_strings(GTK_COMBO(combo_info->combo),*limited_list);
    }
}

G_MODULE_EXPORT
void xfc_set_entry(xfc_combo_info_t *combo_info,char *top){
    char *p;
    GList **limited_list;
    xfc_set_combo(combo_info, NULL);
    limited_list = &(combo_info->limited_list);
    if (!(*limited_list)) return;
    if (!top) return;
    
    p=(char *)((*limited_list)->data);
    if (strcmp(p,top)) {
	    *limited_list=g_list_prepend(*limited_list,g_strdup(top));
	    gtk_combo_set_popdown_strings(GTK_COMBO(combo_info->combo),*limited_list);
    }
}

G_MODULE_EXPORT
void xfc_save_to_history(char *dbh_file,char *path2save){
    	GString *gs;
	DBHashTable *d;
	history_dbh_t *history_dbh;
	int size;
	gchar *p,*g,*h;
	
	if (strlen(path2save) > 255) return;

	/* directory test */
	
	g=p=g_strdup(dbh_file);
	h=g_path_get_basename(dbh_file);
	p=strtok(p,G_DIR_SEPARATOR_S);
	chdir (G_DIR_SEPARATOR_S);
	if (p) do {
	    mkdir(p, 0770);
	    chdir(p);
	    p=strtok(NULL,G_DIR_SEPARATOR_S);
	} while (p != NULL && strcmp(h,p)!=0);
	chdir (g_get_home_dir());
        g_free(g);
        g_free(h);

	if ((d=DBH_open(dbh_file))==NULL){
		if ((d=DBH_create(dbh_file, 11))==NULL) {
			unlink(dbh_file);
			if ((d=DBH_create(dbh_file, 11))==NULL)	return;
		}
	}
	gs = g_string_new(path2save);
    	sprintf((char *)DBH_KEY(d), "%10u", g_string_hash(gs));
   	g_string_free(gs, TRUE);

	history_dbh = (history_dbh_t *)DBH_DATA(d);
	if (DBH_load(d)){
		history_dbh->hits++;
	} else {
		strncpy(history_dbh->path,path2save,255);
		history_dbh->hits=1;
	}
	history_dbh->last_hit=time(NULL);
	/*printf("updating %s to %d\n",history_dbh->path,history_dbh->last_hit);*/
	/* don't write more to disk than that which is necessary: */
	size= sizeof(history_dbh_t) + strlen(history_dbh->path) - 255;
	DBH_set_recordsize(d, size);
	DBH_update(d);
    	DBH_close(d);
}


G_MODULE_EXPORT
void xfc_remove_from_history(char *dbh_file,char *path2save){
    	GString *gs;
	DBHashTable *d;
	history_dbh_t *history_dbh;
	
	if (strlen(path2save) > 255) return;
	if ((d=DBH_open(dbh_file))==NULL){
		if ((d=DBH_create(dbh_file, 11))==NULL) {
			unlink(dbh_file);
			if ((d=DBH_create(dbh_file, 11))==NULL)	return;
		}
	}
	gs = g_string_new(path2save);
    	sprintf((char *)DBH_KEY(d), "%10u", g_string_hash(gs));
   	g_string_free(gs, TRUE);

	history_dbh = (history_dbh_t *)DBH_DATA(d);
	if (DBH_load(d)){
		DBH_erase(d);
	} else return;
    	DBH_close(d);
}

G_MODULE_EXPORT
xfc_combo_info_t *xfc_init_combo(GtkCombo *combo){

	
    xfc_combo_info_t *combo_info;
    
    /* XXX history for entries without combos not yet available through this module yet */ 
    if (!combo) return NULL;
    
    combo_info=(xfc_combo_info_t *)malloc(sizeof(xfc_combo_info_t));
    if (!combo_info) return NULL;
    
    g_signal_connect(G_OBJECT(combo->entry), "key_press_event", 
	    G_CALLBACK(on_key_press), (gpointer) combo_info);
    g_signal_connect(G_OBJECT(combo->entry), "key_press_event", 
	    G_CALLBACK(on_key_press_history), (gpointer) combo_info);	
    g_signal_connect(G_OBJECT(combo->popwin), "key_press_event", 
	    G_CALLBACK(on_combo_history_key_press), (gpointer) combo_info);
    g_signal_connect(G_OBJECT(combo->list), "select_child",
	     G_CALLBACK(on_select_child), NULL);

#if 0
    /* nope, cant be done on button press or release...*/
    g_signal_connect(G_OBJECT(combo->popwin), "button_press_event", 
	    G_CALLBACK(button_release), (gpointer) combo_info);
#endif

    combo_info->combo = combo;
    combo_info->entry = (GtkEntry *)combo->entry;
    combo_info->active_dbh_file = NULL;
    combo_info->list = NULL;
    combo_info->cancel_user_data = NULL;
    combo_info->activate_user_data = NULL;
    combo_info->cancel_func = NULL;
    combo_info->activate_func = NULL;
    
    combo_info->limited_list = NULL;
    
    return combo_info; 
    /*g_signal_connect(G_OBJECT(GTK_COMBO (combo_info->combo)->list), "select_child",
	     G_CALLBACK(on_select_child), NULL);*/
}


G_MODULE_EXPORT
xfc_combo_info_t *xfc_destroy_combo(xfc_combo_info_t *combo_info){
	if (!combo_info) return NULL;
	g_free(combo_info->active_dbh_file);
	g_free(combo_info);
	return NULL;
}


G_MODULE_EXPORT
void xfc_read_history(xfc_combo_info_t *combo_info, gchar *dbh_file)
{

/*	printf("DBG:at read_history_list with %s \n",dbh_file);*/
    g_return_if_fail (combo_info != NULL);
    g_return_if_fail (dbh_file != NULL);
    g_free(combo_info->active_dbh_file);
    combo_info->active_dbh_file = g_strdup(dbh_file);
    if (access(combo_info->active_dbh_file,F_OK)!=0){
   	clean_history_list(&(combo_info->list));	
	combo_info->list=NULL;
    }
    get_history_list(&(combo_info->list),combo_info->active_dbh_file,"");
    /* turn asian off to start with. If the combo object does not
     * do a read_history to start, then it has no business being a combo
     * object */
    asian=FALSE;
    return;
}


G_MODULE_EXPORT
void xfc_clear_history(xfc_combo_info_t *combo_info)
{

/*	printf("DBG:at read_history_list with %s \n",dbh_file);*/
    g_return_if_fail (combo_info != NULL);
    clean_history_list(&(combo_info->list));	
    combo_info->list=NULL;
    return;
}

G_MODULE_EXPORT
xfc_combo_functions *module_init(void){
    return xfc_fun;
}

#endif
