/*
 * Copyright (C) 2004 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "glade_support.h"

#include <libxml/parser.h>
#include <libxml/tree.h>
#include <errno.h>
 



#include "constants.h"
#include "types.h"

#include "toolbar.h"

#include "uri.h"
#include "settings.h"
#include "icons.h"
#include "misc.h"
#include "goto.h"
#include "terminal.h"
#include "run.h"
#include "callbacks.h"
#include "print.h"
#include "pasteboard.h"
#include "remove.h"
#include "new.h"
#include "new_win.h"
#include "options.h"
#include "menu_callbacks.h"
#include "menu.h"
#include "refresh.h"
#include "widgets.h"

/*FIXME: this include should not be necessary, reorder header files... */
#include "glade_main_callbacks.h"

/*FIXME: dnd to normal buttons not enabled, but everything is in place for it to work */

/* if the location of xfce4-panel icons changes, this line must change to
 * reflect that */
/*#define CURRENT_PANEL_ICONS PACKAGE_DATA_DIR,"xfce4","icons",panel_theme,"48x48","emblems"*/
#define CURRENT_PANEL_ICONS PACKAGE_DATA_DIR,"icons","hicolor","48x48","stock","generic"

/* if something is broken in icon detemination: */
#define DEFAULT_PANEL_ICON "xfce/unknown"
 
extern void sb_diff(GtkWidget *w); /* missing xfdiff.h file */
extern void sb_zoom_in(GtkWidget *w); /* missing zoom.h file */
extern void sb_zoom_out(GtkWidget *w); /* missing zoom.h file */
extern void tb_properties(GtkWidget *w); /* missing properties.h file */

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)
enum
{
    TARGET_URI_LIST,
    TARGET_PLAIN,
    TARGET_STRING,
    TARGET_ROOTWIN,
    TARGETS
};


static GtkTargetEntry target_table[] = {
    {"text/uri-list", 0, TARGET_URI_LIST},
    {"text/plain", 0, TARGET_PLAIN},
    {"STRING", 0, TARGET_STRING}
};
#define NUM_TARGETS (sizeof(target_table)/sizeof(GtkTargetEntry))


static guint open_timer=0;
static  GtkTooltips *tooltips=NULL;
static char *smart_button_cmd=NULL;
static char *smart_button_arg=NULL; /* used for dnd only */


static void run_term(GtkWidget *w){
    
    GError *error=NULL;
    gchar *command;
    int argc;
    gchar **argv;
    /*printf("run_term\n");*/
    if (!smart_button_cmd) return;
    
    if (smart_button_arg) 
	command = g_strconcat(what_term()," -e ",smart_button_cmd," ",smart_button_arg,NULL);
    else 
	command = g_strconcat(what_term()," -e ",smart_button_cmd,NULL);
    
    g_shell_parse_argv (command, &argc,&argv,&error);
    if (error){
	gchar *msg = g_strcompress (error->message);
	print_diagnostics("xfce/error",msg,":\n",command,"\n",NULL);
	g_error_free(error);
	g_free (msg);
	g_free(command);   
	return;
    }
    runv(argv);
    g_strfreev (argv);
    g_free(command);   
}
static void run_noterm(GtkWidget *w){
    GError *error=NULL;
    gchar *command;
    int argc;
    gchar **argv;
    /*printf("run_noterm: %s\n",smart_button_cmd);*/
    if (!smart_button_cmd) return;
    if (smart_button_arg) command = g_strconcat(smart_button_cmd," ",smart_button_arg,NULL);
    else command = g_strdup(smart_button_cmd);
    g_shell_parse_argv (command, &argc,&argv,&error);
    if (error){
	gchar *msg = g_strcompress (error->message);
	print_diagnostics("xfce/error",msg,":\n",command,"\n",NULL);
	g_error_free(error);
	g_free(command);
	g_free (msg);
	return;
    }
    runv(argv);
    g_free(command);
    g_strfreev (argv);
}


static gboolean false_click=FALSE;
static gint open_menu(gpointer user_data){
   smart_t *smart = (smart_t *)user_data;
   open_timer=0;
   false_click=TRUE;
   gtk_button_released ((GtkButton *)smart->button);
   gtk_menu_popup(GTK_MENU(smart->menu), NULL, NULL, NULL, NULL, 1, gtk_get_current_event_time());
   return FALSE;
}

static void open_menu1 (GtkButton * button, gpointer  user_data)
{
   /*printf("DBG: pressed\n");*/
   false_click=FALSE;
   open_timer=g_timeout_add_full(0, 150, (GtkFunction) open_menu, user_data, NULL);

}

static void close_menu1 (GtkButton * button, gpointer  user_data)
{
   smart_t *smart = (smart_t *)user_data;
   /*printf("DBG: clicked\n");*/
   if (open_timer)g_source_remove(open_timer);
   open_timer=0;
   smart_button_cmd = smart->cmd;
   if (smart->callback && !false_click) (*(smart->callback))(smart->widget);
   
}

static void change_button (GtkMenuItem * menuitem, gpointer  user_data)
{
    smart_button_t *smart_button=(smart_button_t *)user_data;
    smart_t *smart = (smart_t *)(smart_button->smartp);
    GtkWidget *box;
    
    if (smart->type == SMART_COLUMN_BUTTON) { 
	box = gtk_bin_get_child(GTK_BIN(smart->button));
	
    }
    else if (smart->type == SMART_TOOLBAR_BUTTON) { 
	box =(GtkWidget *)(smart->button);
    } else assert_not_reached();
    gtk_container_remove(GTK_CONTAINER (box),smart->image);
    gtk_container_add (GTK_CONTAINER (box), smart_button->altimage);
    
    smart->image=smart_button->altimage;
    smart->callback = smart_button->callback;
    if (smart->cmd){
	g_free(smart->cmd);
	smart->cmd=NULL;
    }
    if (smart_button->cmd) smart->cmd = g_strdup(smart_button->cmd);
    smart_button_cmd = smart->cmd; /* used by panel buttons */
    {
      gchar *g;
      if (smart_button->tooltip) g=g_strdup(_(smart_button->tooltip));
      else 
      g=g_strdup(_("Press and hold for popup"));
      gtk_tooltips_set_tip (tooltips, smart->button, g, NULL);
      g_free(g);
    }
#ifdef DEBUG
    printf("DBG:hashing value %s=%d\n ",smart->name,smart_button->id);
#endif
    if (smart_button->id) {
	g_hash_table_insert(tree_details->smart_hash,
	    (gpointer)(smart->name),
	    (gpointer)((long)smart_button->id));
    } else {
	g_hash_table_remove(tree_details->smart_hash,(gpointer)(smart->name));
    }
    write_xffm_config();
}

static void set_menu (GtkMenuItem * menuitem, gpointer  user_data){
    smart_button_t *smart_button=(smart_button_t *)user_data;
    smart_t *smart = (smart_t *)(smart_button->smartp);
    /*printf("smart button is %s\n",smart_button->tooltip);*/
    if (!menuitem) change_button(menuitem,user_data);
    else if (smart_button->callback){
	smart_button_cmd = smart_button->cmd;
       	(*(smart_button->callback))(smart->widget);
    }
    gtk_menu_popdown (GTK_MENU(smart->menu));	
}
static void exec_menu (GtkMenuItem * menuitem, gpointer  user_data){
    smart_button_t *smart_button=(smart_button_t *)user_data;
    smart_t *smart = (smart_t *)(smart_button->smartp);
    /*printf("activate menu\n");*/
    change_button(menuitem,user_data);
    if (smart->callback) (*(smart->callback))(smart->widget);
}

static void button_action (GtkButton * button, gpointer  user_data)
{
    /*printf("button_action\n");*/
    gchar *cmd=g_object_get_data(G_OBJECT(button),"cmd");
    if (cmd && strlen(cmd)) {
	smart_button_cmd=cmd;
    } else  smart_button_cmd=NULL;
    smart_button_arg=NULL; /* used for dnd only */
    if (user_data){
	void ((*func))(GtkWidget *);
        func = user_data;
	(*func)((GtkWidget *)button);
    }
    else {
	printf("DBG: button callback is NULL\n");
    }
}



static gboolean  menu_release_callback (GtkWidget *event_box,  GdkEventButton *event, gpointer user_data) {
    /*g_print ("release at coordinates %f,%f\n", event->x, event->y);*/
    /* ctrl-click1: exec and do not change top drawer */
    /* click1: exec and change top drawer */
    if (event->state & GDK_CONTROL_MASK && event->button == 1) {
	/*set_menu ((gpointer)((long) 1), user_data);
	return TRUE;*/
	set_menu (NULL, user_data);
	return FALSE;
    }
    if( event->button == 1) return FALSE;
    /* click2 or click3: change top drawer */
    set_menu (NULL, user_data);
    return TRUE;
}

G_MODULE_EXPORT
gboolean  normal_button_press_event (GtkWidget *event_box,  GdkEventButton *event, gpointer user_data) {
    GtkWidget *sidebar=gtk_bin_get_child(GTK_BIN(WIDGET("eventbox_sidebar")));
   if( event->button != 3) return FALSE;
   if (sidebar) {
       if (GTK_WIDGET_VISIBLE(sidebar)){
	   g_free(tree_details->sidebar);
	   tree_details->sidebar=g_strdup("");
	   gtk_widget_hide(sidebar);
	   write_xffm_config();
       }
       else do_main_popup("main_menu2_menu",event->time);
   } else do_main_popup("main_menu2_menu",event->time);

   return TRUE;
}


static  void normal_buttons(GtkWidget *toolbar,smart_button_init_t *button_info){
  int i;
  GdkPixbuf *pixbuf;
  GtkWidget *button,*image;
  
  if (!tooltips) tooltips = gtk_tooltips_new ();
  for (i=0; button_info[i].image; i++){
    if (strcmp(button_info[i].image,"-")==0){
	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
	continue;
    }
    if (strncmp(button_info[i].image,"gtk-",strlen("gtk-"))==0){
	pixbuf=load_stock_icon(button_info[i].image,GTK_ICON_SIZE_LARGE_TOOLBAR);
	/*pixbuf=gtk_widget_render_icon(tree_details->window, button_info[i].image,GTK_ICON_SIZE_LARGE_TOOLBAR, NULL);*/
    } else {
	pixbuf = icon_tell(GTK_ICON_SIZE_SMALL_TOOLBAR,button_info[i].image);
    }
    if (pixbuf) {
      image = gtk_image_new_from_pixbuf (pixbuf);
      g_object_unref(pixbuf);
    } else {
    	g_warning("Cannot find icon %s in icon factory",button_info[i].image);
	image = NULL;
    }
    button = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "",
                                _(button_info[i].tooltip), NULL,
                                image, NULL, NULL);

    gtk_widget_show (button);
    if (button_info[i].cmd && strlen(button_info[i].cmd)) 
	g_object_set_data(G_OBJECT(button),"cmd",button_info[i].cmd);
    g_signal_connect ((gpointer) button, "clicked", G_CALLBACK (button_action), (gpointer)button_info[i].callback);
    g_signal_connect ((gpointer) button, "button_press_event", G_CALLBACK (normal_button_press_event), toolbar);

    if (button_info[i].name) GLADE_HOOKUP_OBJECT(tree_details->window,button,button_info[i].name);
  }
}


G_MODULE_EXPORT
void tb_drag_data(GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, void *client)
{
    int nitems, action;
    uri *u;
    GList *tmp, *list = NULL;
    smart_t *smart;

    /*printf("DBG: tb drag data\n"); */
    if(!widget || data->length < 0 || data->format != 8)
    {
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }

    action = (context->action <= GDK_ACTION_DEFAULT) ?  GDK_ACTION_COPY  : context->action;

 
    if(!(info == TARGET_STRING) && !(info == TARGET_URI_LIST))
    {
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }

    nitems = uri_parse_list((const char *)data->data, &list);
    /*printf ("dbg:nitems=%d\n",nitems); */
    if(!nitems){
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;

    }
    u = list->data;
    
    if(u->type == URI_SMB)
    {	/* src_host may be remote or local, but target only local
	  or bookmark */		
 	g_message("xffm: drop from network not enabled");
	print_diagnostics("xfce/error",strerror(EINVAL),"\n",NULL);
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }
    smart = (smart_t *) g_object_get_data((GObject *)widget,"smart");
    if (!smart || !smart->cmd){
 	if (!smart) g_warning("xffm: g_object_get_data((GObject *)widget,\"smart\") != NULL");
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }
	


    uri_remove_file_prefix_from_list(list);
       
    for(tmp = list; tmp != NULL; tmp = tmp->next) {  
	 gchar *g;
	 u = tmp->data;
	 smart_button_cmd=smart->cmd;
	 smart_button_arg=u->url;
	 if (g_file_test(u->url,G_FILE_TEST_IS_DIR)) g=g_strdup(u->url);
	 else g=g_path_get_dirname (u->url);
	 chdir(g);
	 g_free(g);
	 
	 if (strcmp(smart_button_cmd,"xterm")==0){
	     smart_button_cmd = (char *)what_term();
	     smart_button_arg=NULL;
	 }
	 if (smart->callback != run_term && smart->callback != run_noterm){
	     /*printf("changing callback to run_noterm\n");*/
	     run_noterm(smart->widget);
	 } else {
 	     if (smart->callback) (*(smart->callback))(smart->widget);  
	 }
	 chdir(GETWD);
	 smart_button_arg=NULL;
    }
    list = uri_free_list(list);
    gtk_drag_finish(context, TRUE, FALSE, time);
    return;
}


G_MODULE_EXPORT
gboolean tb_drag_motion(GtkWidget * widget, GdkDragContext * dc, gint x, gint y, guint t, gpointer data)
{
    GdkDragAction action = GDK_ACTION_COPY;
    /*printf("DBG:  tb_drag_motion \n"); */
    /* Insert code to get our default action here. */

    if(dc->actions == GDK_ACTION_MOVE) gdk_drag_status(dc, GDK_ACTION_MOVE, t);
    else if(dc->actions == GDK_ACTION_COPY) gdk_drag_status(dc, GDK_ACTION_COPY, t);
    else if(dc->actions == GDK_ACTION_LINK) gdk_drag_status(dc, GDK_ACTION_LINK, t);
    else if(dc->actions & action) gdk_drag_status(dc, action, t);
    else gdk_drag_status(dc, 0, t);
    return (TRUE);
}

static void create_sidebar(smart_t *smart, gboolean save){
  GtkWidget *sidebar,*eventbox_sidebar;
  smart_t *old_smart;
  eventbox_sidebar=WIDGET("eventbox_sidebar");
  sidebar = gtk_bin_get_child(GTK_BIN(eventbox_sidebar));

  if (!smart->button_info) {
      return;
  }

  old_smart = (smart_t *)g_object_get_data(G_OBJECT(eventbox_sidebar),"smart_id");
  if (sidebar && old_smart && smart==old_smart) {
     g_free(tree_details->sidebar);
     if (GTK_WIDGET_VISIBLE(sidebar)){
	 tree_details->sidebar=g_strdup("");
	 gtk_widget_hide(sidebar);
     }
     else {
	 tree_details->sidebar=g_strdup(smart->name);
	 gtk_widget_show(sidebar);
     }
     if (save) write_xffm_config();
     return;
  }
      
  
  if (sidebar)
    gtk_container_remove(GTK_CONTAINER (eventbox_sidebar),sidebar);
  
  sidebar = gtk_toolbar_new ();
  g_object_set_data(G_OBJECT(eventbox_sidebar),"smart_id",smart);
  
  gtk_toolbar_set_style (GTK_TOOLBAR (sidebar), GTK_TOOLBAR_ICONS);
  gtk_toolbar_set_orientation (GTK_TOOLBAR (sidebar), GTK_ORIENTATION_VERTICAL);
  normal_buttons(sidebar,smart->button_info);
  gtk_container_add (GTK_CONTAINER (eventbox_sidebar), sidebar);
  
  g_free(tree_details->sidebar);
  if (smart->name) tree_details->sidebar=g_strdup(smart->name);
  else tree_details->sidebar=g_strdup("");
  
  gtk_widget_show (sidebar);  
  if (save) {
     write_xffm_config();
     turn_on();
  }
}

static gboolean  button_press_callback (GtkWidget *event_box,  GdkEventButton *event, gpointer user_data) {
    /*g_print ("Event box clicked at coordinates %f,%f\n", event->x, event->y);*/
   if( event->button == 1) return FALSE;
   if (!((smart_t *)user_data)->button_info) {
       open_menu(user_data);
       return TRUE;
   }
   create_sidebar((smart_t *)user_data,TRUE);

    return TRUE;
}

G_MODULE_EXPORT
smart_t *
mk_smart_button(	smart_button_init_t *button_info,
			gchar *name,
			GtkWidget **button_p)
{
  int i,id;
  GdkPixbuf *pixbuf;
  smart_t *smart;  
  GtkWidget *button,*image;
  int lastused=0;
  gpointer lu;
  if (tree_details->smart_hash == NULL){
	tree_details->smart_hash = 
	    g_hash_table_new( g_str_hash, g_str_equal);
  }
  if ((lu = g_hash_table_lookup(tree_details->smart_hash, name)) != NULL){
      lastused = (int)((long)lu);
  }
#ifdef DEBUG
  else {
    printf("DBG:new hash value %s=0\n ",name);
  } 
#endif
  
  
  smart = (smart_t *)malloc(sizeof(smart_t));
  if (!smart) assert_not_reached();
  
  
  if (button_p) {
      smart->button_info = NULL;
      smart->type = SMART_COLUMN_BUTTON;
  }
  else {
      smart->button_info = (gpointer)button_info;
      smart->type = SMART_TOOLBAR_BUTTON;
  }
  
  smart->name = g_strdup(name);
  if (!tooltips) tooltips = gtk_tooltips_new ();
  if (button_p) smart->button = *button_p;
  else  smart->button = gtk_button_new ();
  smart->menu = gtk_menu_new ();
  smart->widget = (GtkWidget *)tree_details->window;
  gtk_widget_show (smart->button);
  gtk_widget_show (smart->menu);
  /*gtk_container_add (GTK_CONTAINER (toolbar), smart->button);*/
  g_signal_connect (G_OBJECT (smart->button), "pressed", G_CALLBACK (open_menu1), (gpointer) smart);
  g_signal_connect (G_OBJECT (smart->button), "clicked", G_CALLBACK (close_menu1), (gpointer) smart);
  g_signal_connect (G_OBJECT (smart->button), "button_press_event", G_CALLBACK (button_press_callback),(gpointer) smart);

  if (smart->name) GLADE_HOOKUP_OBJECT(tree_details->window,smart->button,smart->name);
  /*
  button=gtk_tearoff_menu_item_new ();
  gtk_container_add (GTK_CONTAINER (smart->menu), button);
  gtk_widget_show (button);
  */

  /*****************  popup buttons ***************************/
  for (i=0,id=0; button_info[i].image; i++,id++){
    if (strcmp(button_info[i].image,"-")==0){
	GtkWidget *separator = gtk_menu_item_new ();
	gtk_widget_show (separator);
	gtk_container_add (GTK_CONTAINER (smart->menu), separator);
	gtk_widget_set_sensitive (separator, FALSE);
	id--;
	continue;
    }
    smart->smart_button=(smart_button_t *)malloc(sizeof(smart_button_t));
    if (!smart->smart_button) assert_not_reached();
    smart->smart_button->id = i;
    smart->smart_button->tooltip=g_strdup(_(button_info[i].tooltip));
    if (button_info[i].cmd) smart->smart_button->cmd=g_strdup(button_info[i].cmd); /* used by dnd and panel */
    else smart->smart_button->cmd=NULL;
    smart->smart_button->smartp = (gpointer)smart;
   
   
    /*printf("loading image %s\n", button_info[i].image);*/
    if (strncmp(button_info[i].image,"gtk-",strlen("gtk-"))==0){
	pixbuf=load_stock_icon(button_info[i].image,GTK_ICON_SIZE_LARGE_TOOLBAR);
	/*pixbuf=gtk_widget_render_icon(tree_details->window, button_info[i].image,GTK_ICON_SIZE_LARGE_TOOLBAR, NULL);*/
    } else {
    	pixbuf = icon_tell(GTK_ICON_SIZE_SMALL_TOOLBAR,button_info[i].image);
    }
    if (!pixbuf) {
	g_warning("Cannot find icon %s in icon factory",button_info[i].image);
	pixbuf = icon_tell(GTK_ICON_SIZE_SMALL_TOOLBAR,DEFAULT_PANEL_ICON);
    }

    
#if 0
    /* this does not work because:
     * Gtk-CRITICAL **: file gtkmenushell.c: line 353 (gtk_menu_shell_insert): assertion `GTK_IS_MENU_ITEM (child)' failed
     * */
#include <libxfcegui4/xfce_menubutton.h>
    if (button_info[i].caption) 
	button = xfce_menubutton_new_with_pixbuf(button_info[i].caption,pixbuf);
    else 
	button =  xfce_menubutton_new_with_pixbuf ("",pixbuf);
#else
    if (button_info[i].caption) 
	button = (GtkWidget *)gtk_image_menu_item_new_with_mnemonic (button_info[i].caption);
    else 
	button = (GtkWidget *)gtk_image_menu_item_new_with_mnemonic ("");
    if (pixbuf) {
      image = gtk_image_new_from_pixbuf (pixbuf);
      g_object_unref(pixbuf);
      gtk_widget_show (image);
      gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (button), image);
    } else {
	g_warning("Cannot find icon %s in icon factory",DEFAULT_PANEL_ICON);
	image = NULL;
    }

#endif

    /* replaceable image for top button */
    
    if (strncmp(button_info[i].image,"gtk-",strlen("gtk-"))==0){
	pixbuf=load_stock_icon(button_info[i].image,GTK_ICON_SIZE_LARGE_TOOLBAR);
	/*pixbuf=gtk_widget_render_icon(tree_details->window, button_info[i].image,GTK_ICON_SIZE_LARGE_TOOLBAR, NULL);*/
    } else {
    	pixbuf = icon_tell(GTK_ICON_SIZE_SMALL_TOOLBAR,button_info[i].image);
    }
    if (!pixbuf) {
	g_warning("Cannot find icon %s in icon factory",button_info[i].image);
	pixbuf = icon_tell(GTK_ICON_SIZE_SMALL_TOOLBAR,DEFAULT_PANEL_ICON);
    }
    if (pixbuf) {
      GdkPixbuf *p;
      if (smart->type == SMART_COLUMN_BUTTON) p=gdk_pixbuf_scale_simple ((const GdkPixbuf *)pixbuf,16,16,GDK_INTERP_BILINEAR);
      else p=gdk_pixbuf_copy(pixbuf);


      g_object_unref(G_OBJECT(pixbuf));
     /* if (smart->type == SMART_COLUMN_BUTTON) insert_pixbuf_tag("downarrow.png",&p, GTK_ICON_SIZE_SMALL_TOOLBAR,3,"SE");
      else */
      insert_pixbuf_tag("downarrow.png",&p, GTK_ICON_SIZE_SMALL_TOOLBAR,3,"SE"); 
      smart->smart_button->altimage = gtk_image_new_from_pixbuf (p);
      g_object_unref(p);
      gtk_widget_show (smart->smart_button->altimage);
      g_object_ref ((gpointer)smart->smart_button->altimage);
    } else {
	smart->smart_button->altimage = NULL;
    }
    
    smart->smart_button->callback = button_info[i].callback;

    
    gtk_widget_show (button);
    gtk_container_add (GTK_CONTAINER (smart->menu), button);
    gtk_tooltips_set_tip (tooltips, button, _(button_info[i].tooltip), NULL);

    
    g_signal_connect (G_OBJECT (button), "button_release_event", G_CALLBACK (menu_release_callback),(gpointer) smart->smart_button);
    g_signal_connect (G_OBJECT (button), "activate", G_CALLBACK (exec_menu), (gpointer)smart->smart_button);
    if (button_info[i].name) {
	GLADE_HOOKUP_OBJECT(tree_details->window,button,g_strconcat(button_info[i].name,"_sb",NULL));
    }

  }
  
  if (tooltips) g_object_set_data (G_OBJECT (tree_details->window), "tooltips", tooltips);

  /* this should come from config... */
  if (lastused >= i || lastused < 0) lastused=0;
  if (strncmp(button_info[lastused].image,"gtk-",strlen("gtk-"))==0){
	pixbuf=load_stock_icon(button_info[lastused].image,GTK_ICON_SIZE_LARGE_TOOLBAR);
	/*pixbuf=gtk_widget_render_icon(tree_details->window, button_info[lastused].image,GTK_ICON_SIZE_LARGE_TOOLBAR, NULL);*/
  } else {
      	pixbuf = icon_tell(GTK_ICON_SIZE_SMALL_TOOLBAR,button_info[lastused].image);
  }
  {
    GdkPixbuf *p=NULL;
    if (pixbuf) {
	if (smart->type == SMART_COLUMN_BUTTON) p=gdk_pixbuf_scale_simple ((const GdkPixbuf *)pixbuf,16,16,GDK_INTERP_BILINEAR);
	else p=gdk_pixbuf_copy(pixbuf);

	g_object_unref(G_OBJECT(pixbuf));
    }
    /*if (smart->type == SMART_COLUMN_BUTTON) insert_pixbuf_tag("downarrow.png",&p, GTK_ICON_SIZE_SMALL_TOOLBAR,3,"SE"); 
    else */
    insert_pixbuf_tag("downarrow.png",&p, GTK_ICON_SIZE_SMALL_TOOLBAR,3,"SE");
    smart->image = gtk_image_new_from_pixbuf (p);
    if (p) g_object_unref(G_OBJECT(p));
  }
  gtk_widget_show (smart->image);
  
  if (smart->type == SMART_COLUMN_BUTTON) { /* this applies to column buttons...*/
    GtkWidget *box = gtk_bin_get_child(GTK_BIN(smart->button));
    gtk_box_pack_start (GTK_BOX (box), smart->image, FALSE, FALSE, 0);
  } else {
    gtk_button_set_relief((GtkButton *)smart->button,GTK_RELIEF_NONE);
    gtk_container_add (GTK_CONTAINER (smart->button),smart->image);
  }

  GTK_WIDGET_UNSET_FLAGS (smart->button, GTK_CAN_FOCUS);
  smart->callback = button_info[lastused].callback;
  if (button_info[lastused].cmd) smart->cmd = g_strdup(button_info[lastused].cmd); /* used by panel buttons */
  else smart->cmd = NULL;
  
  {
    gchar *g;
    if (button_info[lastused].tooltip) 
	g=g_strdup(_(button_info[lastused].tooltip));
    else
	g=g_strdup(_("Press and hold for popup"));
    gtk_tooltips_set_tip (tooltips, smart->button, g, NULL);
    g_free(g);
  }

  g_signal_connect(G_OBJECT(smart->button), "drag_data_received", G_CALLBACK(tb_drag_data), NULL);
  g_signal_connect(G_OBJECT(smart->button), "drag_motion", G_CALLBACK(tb_drag_motion), NULL);
  gtk_drag_dest_set(smart->button, GTK_DEST_DEFAULT_DROP | GTK_DEST_DEFAULT_HIGHLIGHT, target_table, NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY);

  if (smart) g_object_set_data(G_OBJECT(smart->button), "smart", (gpointer) smart);
  /*gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));*/
  return smart;
}

static  smart_t *smart_buttons(GtkWidget *toolbar,smart_button_init_t *button_info,gchar *name){
  smart_t *smart;  
  smart = mk_smart_button(button_info,name,NULL);
  gtk_container_add (GTK_CONTAINER (toolbar), smart->button);
  if (name && tree_details->sidebar && strcmp(name,tree_details->sidebar)==0){
      create_sidebar(smart,FALSE);
  }
  /*XXX: remove spacer? */
  /*gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));*/
  return smart;
}

G_MODULE_EXPORT
void sb_clear_pasteboard(GtkWidget *w){
   on_clear_pasteboard_activate(NULL,NULL); 
}
G_MODULE_EXPORT
void sb_refresh(GtkWidget *w){
    on_refresh((GtkButton *)w, (gpointer)((long)ROOT_FILES));
    
}
G_MODULE_EXPORT
void sb_toggle_win(GtkWidget *w){
    on_activate_branch((GtkMenuItem *)w, (gpointer)((long)ROOT_FILES));
    
}
#ifdef USE_SMB_BRANCH
G_MODULE_EXPORT
void sb_toggle_smb(GtkWidget *w){
    on_activate_branch((GtkMenuItem *)w, (gpointer)((long)ROOT_NETWORK));
}
#endif
G_MODULE_EXPORT
void sb_toggle_fstab(GtkWidget *w){
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
    on_activate_branch((GtkMenuItem *)w, (gpointer)((long)ROOT_FSTAB));
#endif
}
G_MODULE_EXPORT
void sb_toggle_book(GtkWidget *w){
    on_activate_branch((GtkMenuItem *)w, (gpointer)((long)ROOT_BOOKMARKS));
}
G_MODULE_EXPORT
void sb_toggle_trash(GtkWidget *w){
    on_activate_branch((GtkMenuItem *)w, (gpointer)((long)ROOT_TRASH));
}
G_MODULE_EXPORT
void sb_toggle_recent(GtkWidget *w){
    on_activate_branch((GtkMenuItem *)w, (gpointer)((long)ROOT_RECENT));
}
G_MODULE_EXPORT
void sb_toggle_frequent(GtkWidget *w){
    on_activate_branch((GtkMenuItem *)w, (gpointer)((long)ROOT_FREQUENT));
}
G_MODULE_EXPORT
void sb_about(GtkWidget *w){
    on_about_activate((GtkMenuItem *)w, NULL);
}

G_MODULE_EXPORT
void sb_show_size(GtkWidget *w){
    toggle_preference((GtkMenuItem *)w,(gpointer)((long)(SHOW_SIZE|INDIVIDUAL_TOGGLE)));
}
G_MODULE_EXPORT
void sb_show_date(GtkWidget *w){
    toggle_preference((GtkMenuItem *)w,(gpointer)((long)(SHOW_DATE|INDIVIDUAL_TOGGLE)));
}
G_MODULE_EXPORT
void sb_show_owner(GtkWidget *w){
    toggle_preference((GtkMenuItem *)w,(gpointer)((long)(SHOW_UID|INDIVIDUAL_TOGGLE)));
}
G_MODULE_EXPORT
void sb_show_group(GtkWidget *w){
    toggle_preference((GtkMenuItem *)w,(gpointer)((long)(SHOW_GID|INDIVIDUAL_TOGGLE)));
}
G_MODULE_EXPORT
void sb_show_mode(GtkWidget *w){
    toggle_preference((GtkMenuItem *)w,(gpointer)((long)(SHOW_MODE|INDIVIDUAL_TOGGLE)));
}

G_MODULE_EXPORT
void sb_duplicate(GtkWidget *w){
    on_duplicate_activate((GtkMenuItem *)w,NULL);
}
G_MODULE_EXPORT
void sb_symlink(GtkWidget *w){
    on_symlink_activate((GtkMenuItem *)w,NULL);
}
G_MODULE_EXPORT
void sb_touch(GtkWidget *w){
    on_touch_activate((GtkMenuItem *)w,NULL);
}
G_MODULE_EXPORT
void sb_rename(GtkWidget *w){
    on_rename_activate((GtkMenuItem *)w,NULL);
}
G_MODULE_EXPORT
void sb_scramble(GtkWidget *w){
    on_scramble_activate((GtkMenuItem *)w,NULL);
}
G_MODULE_EXPORT
void sb_unscramble(GtkWidget *w){
    on_unscramble_activate((GtkMenuItem *)w,NULL);
}

G_MODULE_EXPORT
void on_tb_new(GtkMenuItem *w, gpointer data){
    tb_new((GtkWidget *)w);
}

G_MODULE_EXPORT
void on_tb_newd(GtkMenuItem *w, gpointer data){
    tb_newd((GtkWidget *)w);
}

G_MODULE_EXPORT
void sb_xfce_setting_show(GtkWidget *w){
    gchar *argv[]={"xfce-setting-show",NULL};
    runv(argv);
    return;
 
}

G_MODULE_EXPORT
void on_xfce_setting_show(GtkMenuItem *w,gpointer data){
    gchar *argv[]={"xfce-setting-show",NULL};
    runv(argv);
    return;
 
}

G_MODULE_EXPORT
void sb_themes_menu(GtkWidget *w){
    /*do_main_popup("themes1_menu",0);*/
    return;
}
G_MODULE_EXPORT
void sb_preferences_menu(GtkWidget *w){
    do_main_popup("preferences3_menu",0);
    return;
}
G_MODULE_EXPORT
void sb_printer_configuration(GtkWidget *w){
    on_printer_configuration_activate((GtkMenuItem *)w,NULL);
    return;
}
G_MODULE_EXPORT
void sb_list_pasteboard(GtkWidget *w){
    on_list_pasteboard_activate((GtkMenuItem *)w,NULL);
    return;
}

G_MODULE_EXPORT
void sb_xfmime_edit(GtkWidget *w){
    gchar *argv[]={"xfmime-edit",NULL};
    runv(argv);
    return;
 
}

G_MODULE_EXPORT
void
on_edit_themes                         (GtkMenuItem     *menuitem,
                                        gpointer         user_data){
    sb_xfmime_edit((GtkWidget *)menuitem);
}
#include "toolbar.i"

G_MODULE_EXPORT
void toolbar_buttons(void){
    static gboolean mapped=FALSE;
    GtkWidget *toolbar=WIDGET("toolbar_xftree");
    if (mapped) return;
    g_message("xffm: loading toolbar buttons");
    smart_buttons(toolbar,exec_button_info,"exec_button");
    smart_buttons(toolbar,exec2_button_info,"exec2_button");
    smart_buttons(toolbar,go_button_info,"go_button");
    /*
     * these are now the funky button:
     * smart_buttons(toolbar,branch_button_info,"view_button");
     * smart_buttons(toolbar,column_button_info,"column_button");
     * */
    smart_buttons(toolbar,view_button_info,"view_button");
    /* separators added in normal button info */
    /*gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));*/
    normal_buttons(toolbar,normal_button_info1);
    smart_buttons(toolbar,paste_button_info,"paste_button");
    normal_buttons(toolbar,normal_button_info1b);
    smart_buttons(toolbar,new_button_info,"new_button");
    smart_buttons(toolbar,single_selection_button_info,"single_selection_button");
    /* separator is added in normal button info */
    normal_buttons(toolbar,normal_button_info2);

    
    mapped=TRUE;
}
/* end smartbuttons.c */

#ifdef USE_TOOLBAR_PANEL 

/* panel */
typedef struct panel_items_t {
    char *cmd;
    gboolean interm;
    int icon_id;
    char *icon;
    char *tooltip;
    char *caption;
}panel_items_t;

static   xmlDocPtr doc = NULL;
static GList *group_list=NULL;
static int parse_control(xmlNodePtr node,gboolean item,gboolean mail){
    xmlNodePtr subnode;
    GList *tmp;
    panel_items_t *panel_items;
    panel_items = (panel_items_t *)malloc(sizeof(panel_items_t));
    if (!panel_items) assert_not_reached();
    panel_items->caption=panel_items->icon=panel_items->tooltip=panel_items->cmd=NULL;
    panel_items->icon_id=0;panel_items->interm=0;

    /* FIXME: should monitor mailbox and change icon accordingly */
    if (mail) panel_items->icon_id=13;

    for (subnode=node->children;subnode;subnode = subnode->next){
	/* Caption Command Tooltip Icon*/
	/*printf("DBG: ssubnode->name=%s\n", subnode->name);*/
        if (xmlStrEqual((const xmlChar *)"Command", subnode->name)){
              char *e=(char *)xmlGetProp(subnode, (const xmlChar *)"term");
	      char *cmd=xmlNodeListGetString(doc, subnode->children, 1);
	      if (atoi(e) != 0) panel_items->interm=TRUE;
	      panel_items->cmd=g_strdup(cmd);
		/*printf("DBG: interm=%s cmd=%s\n",e,cmd);	      */
	      g_free(e);
	}		   
	else if (xmlStrEqual((const xmlChar *)"Icon", subnode->name)){
              xmlChar *value = xmlGetProp(subnode, (const xmlChar *)"id");
	      char *e=xmlNodeListGetString(doc, subnode->children, 1);
	      if (e) panel_items->icon = g_strdup(e);
	      panel_items->icon_id = atoi(value);
 	      /*printf("DBG: icon id=%s\n",value);	      
	      printf("DBG: icon file=%s\n",e);	*/      
	      g_free(value);
	}
        else if (xmlStrEqual((const xmlChar *)"Tooltip", subnode->name)){
  	       char *e=xmlNodeListGetString(doc, subnode->children, 1);
		/*printf("DBG: tooltip=%s\n",e);	  */
		panel_items->tooltip=g_strdup(e);
	}
        else if (xmlStrEqual((const xmlChar *)"Caption", subnode->name)){
  	       char *e=xmlNodeListGetString(doc, subnode->children, 1);
		/*printf("DBG: caption=%s\n",e);	  */
		panel_items->caption=g_strdup(e);
	}
        else if (xmlStrEqual((const xmlChar *)"Mailcheck", subnode->name)){
		parse_control(subnode,TRUE,TRUE);	
	}
    }
    if (!panel_items->cmd) return 1;
    /* FIXME if (!g_find_program_in_path) return 1; */
    
    tmp=g_list_last(group_list);
    if (item)tmp->data = g_list_append(tmp->data,panel_items);
    else tmp->data = g_list_prepend(tmp->data,panel_items);
    return 1;
}
 
static int parse_popup(xmlNodePtr node){
    xmlNodePtr subnode;
    /*printf("DBG parsing popup...\n");*/
    for (subnode=node->children;subnode;subnode = subnode->next){
      if (xmlStrEqual((const xmlChar *)"Item", subnode->name)){
        /*printf("DBG parsing item...\n");*/
	parse_control(subnode,TRUE,FALSE);	
      }	  
    }
    return 1;
}

static int parse_group(xmlNodePtr node){
    xmlNodePtr subnode;
    group_list = g_list_append(group_list,NULL);
	/*printf("DBG: new grouplist\n");*/
    for (subnode=node->children;subnode;subnode = subnode->next){
      if (xmlStrEqual((const xmlChar *)"Popup", subnode->name)){
	  parse_popup(subnode);
      }
      else if (xmlStrEqual((const xmlChar *)"Control", subnode->name)){
	parse_control(subnode,FALSE,FALSE);
      }	    
    }
    return 1;
}

static void parse_groups(xmlNodePtr node){
    xmlNodePtr subnode;
    for (subnode=node->children;subnode;subnode = subnode->next){
	/*printf("DBG: subnode->name=%s\n", subnode->name);*/
      if (xmlStrEqual((const xmlChar *)"Group", subnode->name)){
	parse_group(subnode);
      }	
    }
}
#endif

G_MODULE_EXPORT
int parse_panel_config(void){
#ifdef USE_TOOLBAR_PANEL 
    char *panel_theme=NULL;
    GtkWidget *toolbar=WIDGET("toolbar_edit");
    int j=0;
    gchar *rcfile;
    GList *tmp,*subtmp;
    static gboolean already_parsed=FALSE;
    xmlNodePtr root, node;
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CONFIG,"/",TRUE);

    if (already_parsed) return 1;
    
    xmlKeepBlanksDefault(0);
    rcfile = g_build_filename(PANEL_CONFIG_FILE,NULL);
    if (!g_file_test(rcfile,G_FILE_TEST_EXISTS)){
	g_warning("%s not found. Trying 4.0.x configuration directory...",rcfile);
	g_free(rcfile);
	rcfile = g_build_filename(g_get_home_dir(),".xfce4","xfce4rc",NULL);
    }
    g_free(xdg_dir);
    doc = xmlParseFile(rcfile);
    g_free(rcfile);
    g_message("xffm: loading panel buttons");
   
    if (!doc) {
	    return 0;
    }
    root = xmlDocGetRootElement(doc);
    if(!root || !xmlStrEqual(root->name, (const xmlChar *)"Xfce")) {
	xmlFreeDoc(doc);
	return 0;
    }
    already_parsed=TRUE;
    for(node = root->children; node; node = node->next){
	/*printf("DBG: node->name=%s\n", node->name);*/
	if (xmlStrEqual((const xmlChar *)"Panel", node->name)){
              panel_theme=(char *)xmlGetProp(node, (const xmlChar *)"icontheme");
	      /*printf("DBG: panel theme=%s\n",panel_theme);*/
	}
	if (xmlStrEqual((const xmlChar *)"Groups", node->name)){
	  /*printf("DBG: hit=%s\n", node->name);*/
	  parse_groups(node);
	}
	
    }
    xmlFreeDoc(doc);
    for (tmp=group_list;tmp;tmp=tmp->next){
	int l,i;
	smart_button_init_t *panel_button;
	if (!tmp->data) continue;
	l=g_list_length((GList *) tmp->data);
	/*printf("GROUP (%d)\n");*/
	panel_button = (smart_button_init_t *)malloc((l+1)*sizeof(smart_button_init_t));
	if (!panel_button) assert_not_reached();
	for (i=0,subtmp = (GList *) tmp->data;subtmp; subtmp=subtmp->next,i++){
	   panel_items_t *panel_items=(panel_items_t *)subtmp->data;
	   /*printf("cmd=%s,interm=%d,icon_id=%d,icon=%s,tooltip=%s\n",
		   panel_items->cmd,
		   panel_items->interm,
		   panel_items->icon_id,
		   (panel_items->icon)?panel_items->icon:"null",
		   panel_items->tooltip);*/
	   switch (panel_items->icon_id){
	    case -1: if (panel_items->icon) {
			panel_button[i].image = g_strdup(panel_items->icon);
			break;
		     }
		     else  panel_button[i].image = "xfce/p-unknown";
	    default: panel_button[i].image = "xfce/p-unknown";
		     break;
	    case 0: panel_button[i].image = "xfce/p-unknown";break;
	    case 1: panel_button[i].image = "xfce/p-edit";break;
	    case 2: panel_button[i].image = "xfce/p-file1";break;
	    case 3: panel_button[i].image = "xfce/p-file2";break;
	    case 4: panel_button[i].image = "xfce/p-games";break;
	    case 5: panel_button[i].image = "xfce/p-man";break;
	    case 6: panel_button[i].image = "xfce/p-multimedia";break;
	    case 7: panel_button[i].image = "xfce/p-network";break;
	    case 8: panel_button[i].image = "xfce/p-paint";break;
	    case 9: panel_button[i].image = "xfce/p-print";break;
	    case 10: panel_button[i].image = "xfce/p-schedule";break;
	    case 11: panel_button[i].image = "xfce/p-sound";break;
	    case 12: panel_button[i].image = "xfce/p-terminal";break;
	    case 13: panel_button[i].image = "xfce/p-newmail";break;
	   }

	   /* this value (panel_button[i].image) is not freed to allow for 
	    * changing the icons if the panel theme changes 
	    * (not yet implemented) */
#if 0
	   if (!g_file_test(panel_button[i].image,G_FILE_TEST_EXISTS) && panel_theme) {
	           panel_button[i].image = g_build_filename(CURRENT_PANEL_ICONS,panel_button[i].image,NULL);
	       if (!g_file_test(panel_button[i].image,G_FILE_TEST_EXISTS)) {
		 g_warning("panel icon is %s",panel_button[i].image);
	         g_warning("panel icon not present!");
	         g_free(panel_button[i].image);
	         panel_button[i].image = DEFAULT_PANEL_ICON;
	       }
	   }
	   else if (!panel_theme) {
	       panel_button[i].image = DEFAULT_PANEL_ICON;
	   }
#endif

	   /* strdup this for later use at dynamic sidebar */
	   if (panel_items->tooltip)
		panel_button[i].tooltip=g_strdup(panel_items->tooltip);
	   else panel_button[i].tooltip=NULL;

	   if (!panel_items->cmd) {
	       g_warning("panel_items->cmd == NULL");
	       panel_button[i].cmd=panel_button[i].name=NULL;
	   } else {
	       panel_button[i].name=g_strdup(panel_items->cmd);
	       panel_button[i].cmd=g_strdup(panel_items->cmd);
	   }
	   
	   if (!panel_items->caption && !panel_button[i].tooltip) 
	       panel_button[i].caption=panel_button[i].tooltip;
	   else if (!panel_items->caption && !panel_button[i].tooltip)
	       panel_button[i].caption=panel_button[i].name;
	   else if (panel_items->caption) 
	       panel_button[i].caption=g_strdup(panel_items->caption);
	   else panel_button[i].caption="";

	   
	   if (panel_items->interm) panel_button[i].callback = run_term;
	   else panel_button[i].callback = run_noterm;
	}
	{
	  gchar *g=g_strdup_printf("panel_button%d",j++);
	  panel_button[i].image=NULL; /* to mark end of initialization array */
	  /*printf("DBG: loading icon theme for panel=%s\n",panel_theme);*/

	  /*printf("DBG: doing a smartbutton now...\n");*/	  
	  smart_buttons(toolbar,panel_button,g);
	  /*printf("DBG: smartbutton done!\n");*/
	  /* this can be freed */ 
	  g_free(g);
	}
	/* this should not be freed, since it will be used to create sidebars
	 * on demand later on... */
	/*free(panel_button);*/
    }
	

    
    /* free glists from panel config parsing... */
    
   for (tmp=group_list;tmp;tmp=tmp->next){
	if (!tmp->data) continue;
	for (subtmp = (GList *) tmp->data;subtmp; subtmp=subtmp->next){
	   panel_items_t *panel_items=(panel_items_t *)subtmp->data;
	   if (panel_items) {
	       if (panel_items->cmd) free(panel_items->cmd);
	       if (panel_items->icon) free(panel_items->icon);
	       if (panel_items->tooltip) free(panel_items->tooltip);
	       if (panel_items->caption) free(panel_items->caption);
	       free(panel_items);
	   }
	}
	g_list_free((GList *) tmp->data);
   }
   g_list_free(group_list);
    
   if (panel_theme) free(panel_theme); 
#endif
   return 1; 
}
  
/*********************************************************************/
 
static 
void 
put_in_menu(		const gchar *menutext,
			const gchar *icon_id,
			GtkWidget *parent_menu,
			void *callback,
			const gchar *name,
			guint key)
{
    gchar *menuname;
    GtkWidget *image=NULL;
    GtkWidget *menuitem = gtk_image_menu_item_new_with_mnemonic (_(menutext));
    gtk_widget_show (menuitem);

    gtk_container_add (GTK_CONTAINER (parent_menu), menuitem);
    /*XXX: probably should register all xffm stock icons as
     *       stock icons to use only gtk_image_new_from_stock,
     *       but apparently not much is gained, except the
     *       overhead from doing do
     *       */

    if (icon_id) {
	if (strncmp(icon_id,"gtk-",strlen("gtk-"))==0){
	  GdkPixbuf *p =load_stock_icon(icon_id, GTK_ICON_SIZE_MENU);
	  if (p) {
	    image = gtk_image_new_from_pixbuf (p);
	    g_object_unref(p);
	  }
	  /*image = gtk_image_new_from_stock (icon_id, GTK_ICON_SIZE_MENU);*/
	} else {
    	  GdkPixbuf *p = icon_tell(GTK_ICON_SIZE_MENU,icon_id);
	  if (p) {
	    image = gtk_image_new_from_pixbuf (p);
	    g_object_unref(p);
	  }
	}
	if (image) {
	  gtk_widget_show (image);
	  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menuitem), image);
	}
    }
    if (callback) {
	g_signal_connect ((gpointer) menuitem, "activate",G_CALLBACK (callback), NULL);
	if (key) {
	    GSList *l;
	    l = gtk_accel_groups_from_object((GObject *) tree_details->window);
#ifdef DEBUG
	    printf("DBG: adding CTL+%c\n",key);
#endif
	    if(l && l->data){
		gtk_widget_add_accelerator (menuitem, "activate", 
			    (GtkAccelGroup *) (l->data),
                              key, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
	    }
	}
    }
    if (name) {
      menuname=g_strconcat(name,"_menuitem",NULL);
      GLADE_HOOKUP_OBJECT (tree_details->window, menuitem, menuname);
    }
}

static 
void
mk_smart_menu(		GtkWidget *parent_menu,
			smart_button_init_t *button_info)
{
  int i;
  for (i=0; button_info[i].tooltip; i++){
    if (strcmp(button_info[i].tooltip,"-")==0){
	GtkWidget *separator = gtk_menu_item_new ();
	gtk_widget_show (separator);
	gtk_container_add (GTK_CONTAINER (parent_menu), separator);
	gtk_widget_set_sensitive (separator, FALSE);
        if (button_info[i].name)
	    GLADE_HOOKUP_OBJECT (tree_details->window, separator, button_info[i].name);
	continue;
    } 
    else if (button_info[i].menu_callback) {
	put_in_menu(	(const gchar *)button_info[i].tooltip,
			(const gchar *)button_info[i].image,
			parent_menu,
			button_info[i].menu_callback,
			(const gchar *)button_info[i].name,
			button_info[i].key);
			
	

    }
    /*
    else {
	g_warning("skipping menu add %s\n",button_info[i].tooltip);
    }*/
    
  }
}

static 
void 
mk_toggle_menu(		GtkWidget *parent_menu,
			toggle_button_init_t *button_info)
{
  int i;
  GtkWidget *w;
  for (i=0; button_info[i].tag; i++){
    w = gtk_check_menu_item_new_with_mnemonic (_(button_info[i].tag));
    gtk_widget_show (w);
    gtk_container_add (GTK_CONTAINER (parent_menu), w);
    GLADE_HOOKUP_OBJECT (tree_details->window, w, button_info[i].name);
    g_signal_connect(w,"toggled", G_CALLBACK(button_info[i].callback),button_info[i].data);
    
  }
}

G_MODULE_EXPORT
void smart_menus(void){
    static gboolean mapped=FALSE;
    if (mapped) return;
    g_message("xffm: loading menus");
    mk_smart_menu(WIDGET("tools1_menu"),exec_button_info);
    mk_smart_menu(WIDGET("open1_menu"),exec2_button_info);
    mk_smart_menu(WIDGET("go1_menu"),go_button_info);
    mk_smart_menu(WIDGET("options1_menu"),view_button_info);
    mk_smart_menu(WIDGET("file1_menu"),new_button_info);
    mk_smart_menu(WIDGET("file1_menu"),single_selection_button_info);
    mk_toggle_menu(WIDGET("branches1_menu"),toggle_branches_info);
    mk_toggle_menu(WIDGET("columns1_menu"),toggle_columns_info);
    mk_smart_menu(WIDGET("item22_menu"),popup_button_info);
    mapped=TRUE;
}

