
/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "modules.h"
#include "options.h"

#include "settings.h"
#include "misc.h"
#include "widgets.h"
#include "icons.h"
#include "refresh.h"
#include "dnd.h"

#include "preferences.i"

static gboolean disable_column_action=FALSE;
G_MODULE_EXPORT
gboolean disable_branch_action=FALSE;
static gboolean disable_sort_action=FALSE;

extern gboolean light_background;
typedef struct change_size_t {
	GtkTreeView *treeview;
	int size;
}change_size_t;

#if 0
static gboolean set_icon_size(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    tree_entry_t *en;
    /*change_size_t *cs=(change_size_t *)data;*/
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
#if 0
    if (en) switch(cs->size){
	    case 0: SET_SIZE_S(en->type); break;
	    case 1: SET_SIZE_M(en->type); break;
	    case 2: SET_SIZE_L(en->type); break;
	    case 3: SET_SIZE_XL(en->type); break;
    }
#endif
    set_icon(treemodel, iter);
    return FALSE;
}
#endif

G_MODULE_EXPORT
void apply_view(GtkTreeView * treeview)
{
    treestuff_t *treestuff=get_treestuff(treeview);
    gtk_tree_view_column_set_visible(treestuff->column[SIZE_COLUMN], 
		    treestuff->preferences & SHOW_SIZE);
    gtk_tree_view_column_set_visible(treestuff->column[DATE_COLUMN], 
		    treestuff->preferences & SHOW_DATE);
    gtk_tree_view_column_set_visible(treestuff->column[OWNER_COLUMN], 
		    treestuff->preferences & SHOW_UID);
    gtk_tree_view_column_set_visible(treestuff->column[GROUP_COLUMN], 
		    treestuff->preferences & SHOW_GID);
    gtk_tree_view_column_set_visible(treestuff->column[MODE_COLUMN], 
		    treestuff->preferences & SHOW_MODE);

    disable_column_action=FALSE;

}



G_MODULE_EXPORT
void apply_preferences(GtkTreeView * treeview, int preferences)
{
    tree_details->preferences = preferences;
}

G_MODULE_EXPORT
void quick_hide(GtkButton * button, gpointer user_data)
{
    unsigned l = (unsigned)((long)user_data);

    tree_details->preferences ^= l;
    hide_bars();
}

static gboolean set_dot(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    tree_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en) SET_SHOWS_HIDDEN(en->type);
    return FALSE;
}
static gboolean unset_dot(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    tree_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en) UNSET_SHOWS_HIDDEN(en->type);
    return FALSE;
}

static gboolean switch_easy_edit(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data){
	gboolean c=FALSE;
	tree_entry_t *en;
    
	gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
	if (!en) return FALSE;

	if (!(tree_details->preferences & DISABLE_EASY_EDIT)){
	    c=IS_PATH(en->type);
	    if (en && en->path && strchr(en->path,G_DIR_SEPARATOR) && 
		strcmp( strrchr(en->path,G_DIR_SEPARATOR)+1,"..Wastebasket")==0)
		c=FALSE;

	}
       	gtk_tree_store_set((GtkTreeStore *) treemodel, iter,EDITABLE_COLUMN,c, -1);
	/*printf("DBG:%s set to %d\n",en->path,c);*/
	return FALSE;
}

G_MODULE_EXPORT
void set_column_menu(gint tree_id){
    int flag=tree_details->treestuff[tree_id].preferences;
    disable_column_action=TRUE;

    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET("size5")), flag & SHOW_SIZE);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET("date5")), flag & SHOW_DATE);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET("uid5")), flag & SHOW_UID);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET("gid5")), flag & SHOW_GID);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET("mode5")), flag & SHOW_MODE);
    disable_column_action=FALSE;
    
    disable_branch_action=TRUE;
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET("home6")), flag & ACTIVATE_LOCAL );
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET("network6")), flag & ACTIVATE_SMB);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET("fstab6")), flag & ACTIVATE_FSTAB);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET("book6")), flag & ACTIVATE_BOOK);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET("frequent6")), flag & ACTIVATE_FREQUENT);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET("recent6")), flag & ACTIVATE_RECENT);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET("trash6")), flag & ACTIVATE_TRASH);
    disable_branch_action=FALSE;

    disable_sort_action=TRUE;
    {
      const gchar *c;
      switch (tree_details->treestuff[tree_id].sort_column){
	  case NAME_COLUMN: c="name6"; break;
	  case DATE_COLUMN: c="date6"; break;
	  case SIZE_COLUMN: c="size6"; break;
	  case OWNER_COLUMN: c="owner6"; break;
	  case GROUP_COLUMN: c="group6"; break;
	  case MODE_COLUMN: c="mode6"; break;
	  default: c="unsorted6"; break;
      }
      gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(WIDGET(c)), TRUE);
      if (tree_details->treestuff[tree_id].ascending % 3 == 1){
 	  showit(tree_details->window,"descending1");
	  hideit(tree_details->window,"ascending1");
     }
      else {
	  showit(tree_details->window,"ascending1");
	  hideit(tree_details->window,"descending1");
      }
	  
    }   
    disable_sort_action=FALSE;
    
    
}


G_MODULE_EXPORT
void toggle_preference(GtkMenuItem * menuitem, gpointer user_data)
{
    int i;
    gboolean warned=FALSE;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;
    unsigned flag = (unsigned)((long)user_data);
   
    if (flag & (SHOW_SIZE|SHOW_DATE|SHOW_UID|SHOW_GID|SHOW_MODE))
	tree_id = get_relative_tree_id();
    
    
    if (disable_column_action){
#ifdef DEBUG
	printf("DBG: disable_column_action=TRUE\n");
#endif
       	return;
    }
#ifdef DEBUG
	printf("DBG: toggle_preference...\n");
#endif
    if (flag & INDIVIDUAL_TOGGLE) {
	flag ^= INDIVIDUAL_TOGGLE;

	/* this is incompatible for individual toggle since
	 * icon size is a global thing. */
     if (flag &(ICON_VIEW|DEFAULT_VIEW|SMALL_VIEW|DETAILED_VIEW)){
#if 0
#ifdef DEBUG
	printf("DBG: toggle_preference... flag & INDIVIDUAL_TOGGLES)\n");
	printf("DBG: option not enabled.\n");
#endif
        cs.treeview=treeview;
        tree_details->treestuff[tree_id].preferences &= 
	   (BIT_MASK^(ICON_VIEW|DEFAULT_VIEW|SMALL_VIEW|DETAILED_VIEW));
	tree_details->treestuff[tree_id].preferences &= 
	   (BIT_MASK^(SHOW_SIZE|SHOW_DATE|SHOW_UID|SHOW_GID|SHOW_MODE)); 
        switch(flag){
	 case DETAILED_VIEW:
	    tree_details->treestuff[tree_id].preferences |= SHOW_UID; 
	    tree_details->treestuff[tree_id].preferences |= SHOW_GID; 
	    tree_details->treestuff[tree_id].preferences |= SHOW_MODE; 
	 case SMALL_VIEW:
	    tree_details->treestuff[tree_id].preferences |= SHOW_SIZE; 
	 case DEFAULT_VIEW:
	    tree_details->treestuff[tree_id].preferences |= SHOW_DATE; 
	 case ICON_VIEW:
	    break;
	}
	switch(flag){
	 case DETAILED_VIEW:
	    tree_details->icon_size=cs.size=0;
	    break;
	 case SMALL_VIEW:
	    tree_details->icon_size=cs.size=1;
	    break;
	 case DEFAULT_VIEW:
	    tree_details->icon_size=cs.size=2;
	    break;
	 case ICON_VIEW:
	    tree_details->icon_size=cs.size=3;
	    break;
	}
	gtk_tree_model_foreach(treemodel,set_icon_size, &cs);
#endif
      
     }
     else {
	tree_details->treestuff[tree_id].preferences ^= flag;
	if (flag & SHOW_COLUMNS){
	  apply_view(tree_details->treestuff[tree_id].treeview);
	}
	if (flag & ACTIVATE_ALL){
	    /* the hide/show stuff is at toolbar.c in sb_toggle 
	     * functions, which calls this function. This is backwards*/
	}
     }
     write_local_xffm_config (); 
     return;
    
    }

    /* preferences for all treeviews: */
    tree_details->preferences ^= flag;
    for (i=0;i<TREECOUNT;i++) {
      treemodel = tree_details->treestuff[i].treemodel;
      treeview = tree_details->treestuff[i].treeview;
      /*if (flag & FILETYPE_SUBS){
	gtk_tree_model_foreach(treemodel, 
			tree_details->preferences & FILETYPE_SUBS ?
		        set_subsort:unset_subsort, treeview);
      }*/
      if (flag & SHOW_DOT){
	gtk_tree_model_foreach(treemodel, 
			tree_details->preferences & SHOW_DOT ?
		        set_dot:unset_dot, treeview);
      }    
      if(flag & (IMAGE_PREVIEW | HIDE_WASTE_B |  SHOW_DOT ))
      {
	on_unselect_activate(menuitem, NULL);
	on_refresh((GtkButton *) menuitem, user_data);
      }
      if (!warned && flag & (TEXT_HEADERS|ENABLE_RESIZE_FONTS)){
	warned=TRUE;
	print_diagnostics("xfce/warning",_("Restart application for changes to take effect"),"\n",NULL);
      } 
      if (flag & DISABLE_EASY_EDIT)	
	gtk_tree_model_foreach(treemodel, switch_easy_edit, treeview);
    }

    /* XXX  why this? Couldn't light_background be static at basic_colours.c? */
    if (flag & DISABLE_TEXT_COLOR) light_background = !light_background;
    
    write_local_xffm_config (); 

}

G_MODULE_EXPORT
void
tb_toggleview                          (GtkButton       *button,
                                        gpointer         user_data)
{
    g_warning("tb_toggleview function is not enabled (options.c)");
#if 0
    gboolean sub=(gboolean)((long)user_data);	
    /*gint tree_id = get_active_tree_id();*/
    /*treestuff_t *treestuff = (tree_details->treestuff)+tree_id;*/

  if (sub) tree_details->icon_size--;
  else tree_details->icon_size++;
  if (tree_details->icon_size>3) tree_details->icon_size=0;
  if (tree_details->icon_size<0) tree_details->icon_size=3;
  switch (tree_details->icon_size) {
	  case 0: toggle_preference((GtkMenuItem *)button,
				 (gpointer)((long)(DETAILED_VIEW|INDIVIDUAL_TOGGLE)));
		  break;
	  case 1: toggle_preference((GtkMenuItem *)button,
				 (gpointer)((long)(SMALL_VIEW|INDIVIDUAL_TOGGLE)));
		  break;
	  case 2: toggle_preference((GtkMenuItem *)button,
				 (gpointer)((long)(DEFAULT_VIEW|INDIVIDUAL_TOGGLE)));
		  break;
	  case 3: toggle_preference((GtkMenuItem *)button,
				 (gpointer)((long)(ICON_VIEW|INDIVIDUAL_TOGGLE)));
		  break;
  }
  write_local_xffm_config();
#endif
}

G_MODULE_EXPORT
void sb_toggleview (GtkWidget *w){
  tb_toggleview ((GtkButton *)w,NULL);
}



G_MODULE_EXPORT
void on_save_preferences_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    write_xffm_config();
}

G_MODULE_EXPORT
gboolean set_icon_theme(gchar *theme,gboolean restart){
    int theme_status=MIME_ICON_load_theme();
    if (!theme_status){
	print_diagnostics("xfce/error",_("Themes"),": ",theme,"\n",NULL);
	print_diagnostics("xfce/info",_("Edit themes"),"-->",
		"xfmime-edit","\n",NULL);
	return FALSE;
    }
    if (theme_status == -1){
	return TRUE;
    }
    g_free(tree_details->theme);
    tree_details->theme=g_strdup(theme);
    print_diagnostics("xfce/info",_("Themes"),":",theme,"\n",NULL);
    if (restart) print_diagnostics("xfce/warning",_("Restart application for changes to take effect"),"\n",NULL);
    return TRUE;
}

G_MODULE_EXPORT
void toggle_theme(GtkMenuItem * menuitem, gpointer user_data)
{
    int i;
/*    if (!set_icon_theme((gchar *)user_data,TRUE)) return;*/
    if (!tree_details) return;
    MIME_ICON_load_theme();
    for (i=0;i<TREECOUNT;i++) {
      recreate_icons(tree_details->treestuff[i].treeview);
    }
    /*print_diagnostics("xfce/info", tree_details->theme,"\n",NULL);
    print_diagnostics("xfce/warning",_("Restart application for changes to take effect"),"\n",NULL);*/
    write_local_xffm_config();
}
