/*
 * Archivo main.c inicial generado por Glade. Edítelo como
 * lo necesite, Glade nunca sobreescribirá este archivo.
 */


#define __XFFM_MAIN_C__
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <glob.h>
#include <limits.h>
#include <memory.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <libxfcegui4/libxfcegui4.h>



#include <gtk/gtk.h>
#include <gmodule.h>

#include "glade_support.h"

#include "constants.h"

#include "xmcs-manager.h"

#include "dnd.h"
#include "callbacks.h"
#include "goto.h"
#include "settings.h"
#include "menu.h"
#include "misc.h"
#include "modules.h"
#include "toolbar.h"
#include "treeview.h"
#include "widgets.h"

#if 10
#ifndef DEBUG
#if 0
#warning "This version is unstable and will only compile with --enable-debug=yes. Previous version 4.1.1 is very stable and available at http://www.xfce.org/~edscott/tarballs."
#endif
#else
#warning "DEBUG is enabled. Performance will be poor due to repeated output to stdout"
#endif
#endif


G_MODULE_EXPORT
SessionClient *session_client;

G_MODULE_EXPORT
tree_details_t *tree_details=NULL;
G_MODULE_EXPORT
gchar *bookfile=NULL;
G_MODULE_EXPORT
gchar *xffm_iconpath=NULL;
static gboolean enable_pane_resize=FALSE;


static void finishit(int sig)
{
    static gboolean green=TRUE;
    if (!green) return;
    green=FALSE;
    if(sig == SIGUSR1)
    {
	green=TRUE;
	/*g_timeout_add_full(0, 260, (GtkFunction) open_warning, NULL, NULL); */
	return;
    }
    else
    {
	fprintf(stderr, "xffm: signal %d received. Cleaning up before exiting\n", sig);
	cleanup_tmpfiles();
	
	if (sig == SIGSEGV) {   /* drop a core file here */
	    assert_not_reached();
	}
	exit(1);
    }
}

G_MODULE_EXPORT
gboolean    on_name_size (GtkWidget *widget, GtkAllocation *allocation, gpointer user_data){
    int which = (int)((long)user_data);
    if (!enable_pane_resize) return FALSE;
    /*printf("DBG %d is changing...%d\n",which,widget->allocation.width);*/
    tree_details->treestuff[which].name_size=widget->allocation.width;
    return TRUE;
}

G_MODULE_EXPORT
gboolean    on_size (GtkWidget *widget, GtkAllocation *allocation, gpointer user_data){
    static int pane_pos;
    
    GtkWidget *hpaned;

    if (!enable_pane_resize) {
#ifdef DEBUG
	printf("pane resize not enabled\n");
#endif
	return FALSE;
    }
    hpaned = WIDGET("hpaned1");
#ifdef DEBUG
    printf("DBG:pane width=%d\n",hpaned->allocation.width);
#endif
    pane_pos=gtk_paned_get_position((GtkPaned *)hpaned);
    if (tree_details->geometryX == tree_details->window->allocation.width &&
	tree_details->geometryY == tree_details->window->allocation.height &&
	tree_details->hpane != gtk_paned_get_position((GtkPaned *)hpaned)
	){
        tree_details->hpane = gtk_paned_get_position((GtkPaned *)hpaned);
	tree_details->hpane_ratio = (double)tree_details->hpane / (double)hpaned->allocation.width;
	set_widget_initial_state();
	turn_on();
#ifdef DEBUG
	printf("pane size is changing... new ratio=%lf (%d/%d)\n",
		tree_details->hpane_ratio,tree_details->hpane,hpaned->allocation.width);
#endif
    } else if (tree_details->geometryX != tree_details->window->allocation.width ||
	    tree_details->geometryY != tree_details->window->allocation.height ||
	    (tree_details->hpane_ratio >= 0 && tree_details->hpane != tree_details->hpane_ratio * hpaned->allocation.width))
    {
	if (tree_details->geometryX != tree_details->window->allocation.width ||
	    tree_details->hpane != tree_details->hpane_ratio * hpaned->allocation.width)
	{
	    int pane_pos = tree_details->hpane_ratio * hpaned->allocation.width;
#ifdef DEBUG
	    /* keep pane ratio constant*/
	    printf("geometryX is changing... ratio=%lf, setting pane pos to %d\n",
		tree_details->hpane_ratio,pane_pos);
#endif
	    gtk_paned_set_position(GTK_PANED(hpaned), pane_pos);
	    tree_details->hpane = gtk_paned_get_position((GtkPaned *)hpaned);
	} else {
	    tree_details->geometryY = tree_details->window->allocation.height;
#ifdef DEBUG
	    printf("geometryY change... not interesting.\n");
#endif
	    return TRUE;
	}
	tree_details->geometryX = tree_details->window->allocation.width;
	tree_details->geometryY = tree_details->window->allocation.height;	    
    } else {
#ifdef DEBUG
	printf("size allocation event for main window...\n");
#endif
	return TRUE;
    }
    write_xffm_config(); 
    return TRUE;
}

G_MODULE_EXPORT
void
on_pane1_clicked                       (GtkButton       *button,
                                        gpointer         user_data){
    GtkWidget *hpaned=WIDGET("hpaned1");
    tree_details->hpane=hpaned->allocation.width;
    gtk_paned_set_position(GTK_PANED(hpaned), tree_details->hpane);
    tree_details->hpane_ratio=1.0;
}

G_MODULE_EXPORT
void
on_pane0_clicked                       (GtkButton       *button,
                                        gpointer         user_data){
    GtkWidget *hpaned=WIDGET("hpaned1");
    tree_details->hpane=0;
    gtk_paned_set_position(GTK_PANED(hpaned), tree_details->hpane);
    tree_details->hpane_ratio=0.0;
}
G_MODULE_EXPORT
void
on_pane10_clicked                       (GtkButton       *button,
                                        gpointer         user_data){
    GtkWidget *hpaned=WIDGET("hpaned1");
    tree_details->hpane=hpaned->allocation.width/2;
    gtk_paned_set_position(GTK_PANED(hpaned), tree_details->hpane);
    tree_details->hpane_ratio=0.50;
}

static gboolean setup_dir(gchar *path){
	struct stat st;
	if(stat(path, &st) < 0)
	{
	    if(mkdir(path, 0770) < 0)
	    {
		printf("xffm: cannot write to %s\n", path);
		assert_not_reached();
	    }
	    g_warning ("%s created\n", path);
	    return TRUE;
	}
	return FALSE;
}

static void verify_directories(void){
    gchar *path;
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CONFIG,"/",FALSE);
    gchar *oldpath=g_build_filename(g_get_home_dir(),".xfce4","xffm",NULL);

    path=g_build_filename(xdg_dir,"xfce4",NULL);
    setup_dir(path);
    g_free(path);
    
    path=g_build_filename(xdg_dir,"xfce4","xffm",NULL);
    setup_dir(path);
    g_free(path);

    g_free(xdg_dir);
    xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
    
    path=g_build_filename(xdg_dir,"xfce4",NULL);
    setup_dir(path);
    g_free(path);
    
    path=g_build_filename(xdg_dir,"xfce4","xffm",NULL);
    setup_dir(path);
    g_free(path);
    
    path=g_build_filename(xdg_dir,"xfce4","xffm","books",NULL);
    if (!g_file_test(path,G_FILE_TEST_EXISTS)){
	  DIR *directory;
	  struct dirent *d;
	  gchar *argv[]={"cp","*.bm.dbh",path,NULL};
          setup_dir(path);
	  chdir(oldpath);
	  directory = opendir(oldpath);
	  if(directory){
	    while((d = readdir(directory)) != NULL){
		if(strstr(d->d_name,".bm.dbh") || strstr(d->d_name,"bookmarks.dbh")){
		    GError *error=NULL;
		    argv[1]=d->d_name;
		    if (!g_spawn_async(NULL,argv,NULL,G_SPAWN_SEARCH_PATH,NULL,NULL,NULL,&error)){
			gchar *msg = g_strcompress (error->message);
			g_warning(msg);
			g_error_free (error);
			g_free (msg);
		    }
		}
	    }
	    closedir(directory);
	  }
    }
    g_free(path);
    
    path=g_build_filename(xdg_dir,"xfce4","xffm","histories",NULL);
    setup_dir(path);
    g_free(path);
    
    path=g_build_filename(xdg_dir,"xfce4","xfce4-modules",NULL);
    setup_dir(path);
    g_free(path);
    g_free(oldpath);
    g_free(xdg_dir);

     return ;
}



int main(int argc, char *argv[])
{
    GtkTreeView *treeview;
    int i;
    
    verify_directories();
    if (!g_module_supported()){
	    g_error("g_module_supported() != TRUE\n");
	    exit(1);
    }

#ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
#endif
    textdomain(GETTEXT_PACKAGE);
#endif

    /*disable_diagnostics();*/

    gtk_set_locale();
    gtk_init(&argc, &argv);
    session_client = client_session_new (argc,argv, NULL,SESSION_RESTART_IF_RUNNING,1);
    if(!session_init(session_client))
    {
	g_message("Cannot connect to session manager");
    }

    init_xffm_env();
 

    {
#ifdef HAVE_SIGACTION
	struct sigaction act;
	act.sa_handler = finishit;
	sigemptyset(&act.sa_mask);
#ifdef SA_RESTART
	act.sa_flags = SA_RESTART;
#else
	act.sa_flags = 0;
#endif
	sigaction(SIGHUP,&act,NULL);
	sigaction(SIGINT,&act,NULL);
	sigaction(SIGQUIT,&act,NULL);
	sigaction(SIGABRT,&act,NULL);
	sigaction(SIGBUS,&act,NULL);
	sigaction(SIGSEGV,&act,NULL);
	sigaction(SIGTERM,&act,NULL);
	sigaction(SIGFPE,&act,NULL);
	sigaction(SIGUSR1,&act,NULL);
	sigaction(SIGUSR2,&act,NULL);
#else
	signal(SIGHUP, finishit);
	signal(SIGINT, finishit);
	signal(SIGQUIT, finishit);
	signal(SIGABRT, finishit);
	signal(SIGBUS, finishit);
	signal(SIGSEGV, finishit);
	signal(SIGTERM, finishit);
	signal(SIGFPE, finishit);
	signal(SIGUSR1, finishit);
	signal(SIGUSR2, finishit);
#endif
    }
 
 

    
 
    if (!tree_details) tree_details = (tree_details_t *) malloc(sizeof(tree_details_t));
    tree_details->window = NULL;
    tree_details->timer = 0;
    tree_details->remove = NULL;
    tree_details->loading = 0;
    tree_details->input = OTHER_INPUT;
    tree_details->tubo_object = NULL;
    tree_details->stop = FALSE;
    tree_details->argv[0] = g_path_get_basename(argv[0]);
    if (strncmp(tree_details->argv[0],"lt-",strlen("lt-"))==0) 
	  tree_details->argv[0] += strlen("lt-");
    if (argc >=2) tree_details->argv[1] = g_strdup(argv[1]);
    else tree_details->argv[1] = NULL;
    tree_details->preferences = DEFAULT_PREFERENCES;
    tree_details->theme = NULL;
    /*g_build_filename(PACKAGE_DATA_DIR,"xfce4","icons","Plain",NULL);*/
    for (i=0; i<TREECOUNT; i++){
	tree_details->treestuff[i].name_size=100;
    }
    get_xffm_config();
    D(printf("theme by config is %s\n",tree_details->theme);)

    
    connect_mcs();
    D(printf("theme by mcs is %s\n",tree_details->theme);)
    
    /*printf("DBG: mcs connected\n");   */
    
    if (!MIME_ICON_load_theme()){
	g_message("cannot load theme\n");
    }

    /* this is done by mime_icons module, but since that is not loaded yet...*/
    /*xffm_iconpath=g_build_path(PACKAGE_DATA_DIR,"icons","hicolor","48x48","stock","generic",NULL);
    add_pixmap_directory(xffm_iconpath);
    g_free (xffm_iconpath);*/
 

    {
	int i;
	for(i = 0; i < argc; i++)
	    if(strcmp(argv[i], "--version") == 0)
	    {
		printf("%s version %s\nCopywrite Edscott Wilson Garcia, GPL\n", PACKAGE, VERSION);
		exit(1);
	    }

    }
/* how were we called? */
    if (strstr(tree_details->argv[0],"xfbook") && argc >= 2) {
      gchar *g=g_path_get_basename(argv[1]);
      if (g && strlen(g)){
        bookfile=g;
#ifdef DEBUG
        printf("DBG:using %s\n",bookfile);
#endif
      } else {
	g_free(g);
	g=NULL;
      }
    }
    if (getenv("TERMCMD")  && strlen( getenv("TERMCMD"))){
	gchar *p,*g=g_strdup(getenv("TERMCMD"));
	if (strstr(g," ")) g=strtok(g," ");
	p=g_find_program_in_path(g);
	if (!p) xffm_setenv("TERMCMD",NULL,FALSE);
	g_free(g);
	g_free(p);
    }

    /* escape to associated mimetype program, 
     * or xfrun if no mimetype association present 
     * (only xffm and xftree4)*/
    if ((strstr(tree_details->argv[0],"xftree") || strstr(tree_details->argv[0],"xffm")) && argc >= 2){
	 if (!g_file_test((const gchar *)argv[1],G_FILE_TEST_IS_DIR) && g_file_test((const gchar *)argv[1],G_FILE_TEST_EXISTS)) {
	     /* do the run thing */
	     const gchar *prg = MIME_command (argv[1]);
	     if (prg) {
		 GError *error=NULL;
		 int argcp;
		 char **argvp;
		 gchar *g;
		 if (strstr(prg,"%s")){
		   g = g_strdup_printf(prg,argv[1]);
		 } else {
		   g = g_strconcat(prg," ",argv[1],NULL);
		 }
#ifdef DEBUG
		 printf("DBG:%s\n",g);
#endif
		 if (g_shell_parse_argv(g,&argcp,&argvp,&error)){
		   execvp(argvp[0],argvp);
		   g_strfreev(argvp);	   
		 } else {
		     g_warning(error->message);
		     g_error_free(error);
		 }
		 g_warning("Could not execute \"%s\" %s",prg,argv[1]);
		 g_free(g);
		 exit(1);
	     } else {
		 char *argvp[3];
		 argvp[0]="xfrun4";
		 argvp[1]=argv[1];
		 argvp[2]=NULL;
		 execvp(argvp[0],argvp);
		 g_warning("Could not execute xfrun4 %s",argv[1]);
		 exit(1);
	     }
	 }
    }

    /*printf("DBG:init_xffm\n");*/
    init_xffm(argc, argv);
    g_signal_connect ((gpointer) tree_details->treestuff[0].treeview, "size-allocate", G_CALLBACK (on_size), NULL);
    g_signal_connect ((gpointer) tree_details->treestuff[1].treeview, "size-allocate", G_CALLBACK (on_size), NULL);
    for (i=0;i<TREECOUNT;i++) {
      treestuff_t *treestuff=tree_details->treestuff+i;
      g_signal_connect ((gpointer) (treestuff->column[NAME_COLUMN]->button), "size-allocate", G_CALLBACK (on_name_size), (gpointer)((long)i));
    }

    if (tree_details->preferences & SHOW_TB1) toolbar_buttons();

#ifdef USE_TOOLBAR_PANEL    
    if (tree_details->preferences & SHOW_TB2) parse_panel_config();
#endif

    smart_menus();
    
    treeview = get_bigger_treeview();

#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
    if (strstr(tree_details->argv[0],"xffstab") && argc >= 2) {
	int fstab_mount(GtkTreeView *treeview, char *mnt_point, gboolean umnt, tree_entry_t *en);
	int is_mounted(const gchar *mnt_point);
	int tree_id=get_tree_id(treeview);
	tree_details->argv[1]=argv[1];
	
	if (!is_mounted((const gchar *)tree_details->argv[1])){   
	   go_to(tree_details->treestuff+tree_id,tree_details->argv[1]);
	   fstab_mount(treeview, tree_details->argv[1],FALSE,NULL);
	}else{
	   go_to(tree_details->treestuff+tree_id,tree_details->argv[1]);
	}
    }
#endif
    if (strstr(tree_details->argv[0],"xfglob")) {
	xffind_functions *xffind_fun = load_find_module();
	if (argc >= 2) (*(xffind_fun->do_find_path))((GtkWidget *) treeview,argv[1]);
	else (*(xffind_fun->do_find))((GtkWidget *) treeview);
	/* XXX: function returns before find is done, so
	* we should not unload here, but later. 
	* Can a gmodule unload itself when done? */
	/*unload_find_module();*/
    }
    else {
        gtk_widget_show((GtkWidget *)(tree_details->window));
    }
    

    /*enable_diagnostics();*/
    hide_text(tree_details->window);
    /* final column settings until here to get around a gtk bug (2.2.4)
     * with the autosize column not rendering... */
    for (i=0;i<TREECOUNT;i++){
      treestuff_t *treestuff = (tree_details->treestuff)+i;	
      treestuff->ascending = 0;
      treestuff->sort_column = GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID;
       
      gtk_tree_view_column_set_sizing(treestuff->column[NAME_COLUMN], GTK_TREE_VIEW_COLUMN_FIXED);
      gtk_tree_view_column_set_resizable(treestuff->column[NAME_COLUMN], TRUE);
      /*printf("DBG:setting width to %d\n",treestuff->name_size);*/
      gtk_tree_view_column_set_fixed_width(treestuff->column[NAME_COLUMN],treestuff->name_size);

      gtk_tree_view_column_set_sizing(treestuff->column[PIXBUF_COLUMN], GTK_TREE_VIEW_COLUMN_AUTOSIZE);
      gtk_tree_view_column_set_resizable(treestuff->column[PIXBUF_COLUMN], FALSE);
    }

    hide_bars();
    enable_pane_resize=TRUE;

    chdir(GETWD);
    xffm_setenv("PWD",(gchar *)GETWD,FALSE);
     set_widget_initial_state();
    /*turn_on_goto(treeview);*/
    turn_on_pasteboard();
    add_preferences_items();
#ifndef USE_TOOLBAR_PANEL
    hideit(tree_details->window,"show_tb2");
    hideit(tree_details->window,"box_tb2");
#endif
#ifndef USE_FILTER_BAR
    hideit(tree_details->window,"show_f");
    hideit(tree_details->window,"filter_box");
#endif
#ifndef USE_MENU_BAR
    hideit(tree_details->window,"eventbox6");
    hideit(tree_details->window,"eventbox5");
    hideit(tree_details->window,"menubar2");
#endif
  


    /* expand... */
   if ((strstr(tree_details->argv[0],"xfsamba") ||
	 strstr(tree_details->argv[0],"xfbook") ||    
	 strstr(tree_details->argv[0],"xftrash") ||    
	 strstr(tree_details->argv[0],"xffrequent") ||    
	 strstr(tree_details->argv[0],"xfrecent") ||    
	 strstr(tree_details->argv[0],"xftree") ||    
	 strstr(tree_details->argv[0],"xfglob") ||    
	 strstr(tree_details->argv[0],"xffstab") )||
	(strstr(tree_details->argv[0],"xffm") && argc >= 2)) 
   {
	GtkTreeIter iter;
	tree_entry_t *en=NULL;
	
   
	{
	  if (strstr(tree_details->argv[0],"xffm") || strstr(tree_details->argv[0],"xftree")) 
	      get_local_root(treeview, &iter, &en);
	  if (strstr(tree_details->argv[0],"xffrequent")) 
	      get_frequent_root(treeview, &iter, &en);
	  if (strstr(tree_details->argv[0],"xfrecent")) 
	      get_recent_root(treeview, &iter, &en);
#ifdef USE_SMB_BRANCH
	  if (strstr(tree_details->argv[0],"xfsamba")) 
	      get_network_root(treeview, &iter, &en);
#endif
	  if (strstr(tree_details->argv[0],"xfglob")) 
	      get_find_root(treeview, &iter, &en);
	  if (strstr(tree_details->argv[0],"xfbook")) 
	      get_bookmark_root(treeview, &iter, &en);
	  if (strstr(tree_details->argv[0],"xftrash")) 
	      get_trash_root(treeview, &iter, &en);
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
	  if (strstr(tree_details->argv[0],"xffstab"))
	      get_fstab_root(treeview, &iter, &en);
#endif
	  if (en){
  	   GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
           GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
           GtkTreePath *treepath = gtk_tree_model_get_path(treemodel, &iter);
    	   gtk_tree_view_expand_row(treeview, treepath, FALSE);  
     	   gdk_flush();
	   gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
    	   clear_dnd_selection_list();
	   gtk_tree_selection_select_path (selection,treepath);
           get_dnd_selection(treemodel, treepath, &iter, (gpointer) treeview);	   
	   gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
 	   gtk_tree_path_free(treepath); 
	  }
	}
   }

   for (i=0;i<TREECOUNT;i++){
     GtkTreeSortable *sortable=GTK_TREE_SORTABLE(tree_details->treestuff[i].treemodel);
     tree_details->treestuff[i].sort_column =GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID;
     gtk_tree_sortable_set_sort_column_id (sortable,tree_details->treestuff[i].sort_column,GTK_SORT_ASCENDING);
   }
   /*
   {
       GtkWidget *label = gtk_bin_get_child(GTK_BIN(WIDGET("main_menu3")));
       gchar *g=g_strdup_printf("%s (%s)",_("Main menu"),VERSION);
       gtk_label_set_text((GtkLabel *)label,my_utf_string(g));
       g_free(g);
   }*/

    {
	GtkWidget *hpaned=WIDGET("hpaned1");
	
#ifdef DEBUG
	printf("pane size to %d\n",tree_details->hpane);
#endif
        gtk_paned_set_position(GTK_PANED(hpaned), tree_details->hpane);
        tree_details->hpane_ratio = (double)tree_details->hpane / (double)hpaned->allocation.width;
    }
   turn_on();
   enable_write_config();
    
   write_local_xffm_config();

   gtk_main();
   mcs_stop_watch(); 

    return 0;
}
