/* basic_row_i */
/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Static functions for basic_local.c */


static gint all_files=0;
static gint 
all_files_count(void)
{
    return all_files;
}

#ifndef HAVE_WORKING_READDIR
#error "HAVE_WORKING_READDIR != 1"
#endif
static
void 
set_type_local(		int branch_type,
			tree_entry_t *en)
{
    int type=0;
    INHERIT_TYPE(type,branch_type);
    if (!en ||!en->path) goto end;
    if (!en->st) {
	goto end;
    }
#if 0
    if (strstr(en->path,"..Wastebasket")){
	gchar *g=get_path_basename(en->path);
	if (strcmp(g,"..Wastebasket")==0)set wastebasket type 
    }
#endif
    if (g_file_test(en->path,G_FILE_TEST_IS_EXECUTABLE)) SET_EXE(type);
    if (g_file_test(en->path,G_FILE_TEST_IS_SYMLINK))	SET_XF_LNK(type);
    if(access(en->path, R_OK) < 0)	SET_NOACCESS(type);
    if (access(en->path,W_OK)!=0) {
	if (g_file_test(en->path,G_FILE_TEST_IS_DIR) ){
	 SET_NOWRITE(type);
	} else { 
	    /* if you can write to the directory you can
	     * write to the file. Let us check... */
	    gchar *g=g_path_get_dirname(en->path);
	    if (access(g,W_OK)!=0) {
		SET_NOWRITE(type);
	    }
	    g_free(g);
	}
    }
	    
    if(S_ISDIR(en->st->st_mode)) {
	SET_DIR(type);
	if (!IS_XF_LNK(type)) SET_XF_DIR(type);
    }
    else if(S_ISSOCK(en->st->st_mode)) SET_XF_SOCK(type);
    else if(S_ISBLK(en->st->st_mode)) SET_XF_BLK(type);
    else if(S_ISCHR(en->st->st_mode)) SET_XF_CHR(type);
    else if(S_ISFIFO(en->st->st_mode)) SET_XF_FIFO(type);
    else SET_XF_REG(type);
    

end:
    en->type = type;
    return;
}

static gint 
read_files_local(		const gchar *path, 
				gint type, 
#ifdef USE_FILTER_BAR
				const regex_t * preg, 
#endif
				xfdir_t * xfdir)
{
    DIR *directory;
    gint count = 0;
    gint smallcount = 0;
    struct dirent *d;
    struct stat st;

    all_files = 0;

    directory = opendir(path);
    if(!directory) return -1;
    while((d = readdir(directory)) != NULL)
    {
	gchar *fullpath=NULL;
	gboolean broken=FALSE;
	if(strcmp(d->d_name, ".")==0 || strcmp(d->d_name, "..")==0)  continue;
	all_files++;
	if(!SHOWS_HIDDEN(type) && strcmp(d->d_name,"..Wastebasket") != 0 && d->d_name[0] == '.') continue;
	if(tree_details->preferences & HIDE_WASTE_B && strcmp(d->d_name, "..Wastebasket") == 0)
	    continue;
	
#ifdef USE_FILTER_BAR
	if (preg) { /* filtering will be done */
	    fullpath = g_build_filename(path, d->d_name,NULL);
	    if (stat(fullpath, &st)<0) {
		if (lstat(fullpath, &st)<0) {
		    g_free(fullpath);
		    continue;
	       }	   
	       broken=TRUE;
	    }
	    if (!S_ISDIR(st.st_mode) && regexec(preg, d->d_name, 0, NULL, 0)){
	        g_free(fullpath);
	        continue;   
	    }
	}
#endif
	if(xfdir != NULL)
	{
	    if (!fullpath) {
	       fullpath = g_build_filename(path, d->d_name,NULL);
	       if (stat(fullpath, &st)<0){
		    if (lstat(fullpath, &st)<0) {
			g_free(fullpath);
			continue;
		    }	   
		    broken=TRUE;
	       }
	    }
	    xfdir->gl[count].pathv = g_strdup(d->d_name);
	    xfdir->gl[count].en = mk_entry(type);
	    xfdir->gl[count].en->path = fullpath;
	    xfdir->gl[count].en->st = (struct stat *)malloc(sizeof(struct stat));
	    memcpy(xfdir->gl[count].en->st, &st, sizeof(struct stat));
	    /* set the local file type specifics: */
	    if (broken) SET_BROKEN_LNK(xfdir->gl[count].en->type);
	    else set_type_local(type,xfdir->gl[count].en);
	} else {
	    g_free(fullpath);
	}
	count++;
	if (++smallcount & 0x100) {
	  smallcount=0;
	  /* this happens too fast to even be seen */
	  /* set_progress(-1,-1); */
	  /* but we need to give gtk some time slots so
	   * the application does not seem to hang 
	   * during long reads : */
	  process_pending_gtk();
	}
    }
    closedir(directory);
    return (count);
}

static
gboolean 
add_folder_local(	GtkTreeView * treeview, 
			GtkTreeIter * iter,
			tree_entry_t *en)
{
    xfdir_t xfdir;
#ifdef USE_FILTER_BAR
    const regex_t *preg=NULL;
#endif
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    off_t tama = 0;
    gint j;
    time_t inicio = time(NULL);

    xfdir.gl=NULL;
    
    if(!en){
	g_warning("en != NULL");
	return FALSE;
    }
    
#ifdef USE_FILTER_BAR
    g_free(en->filter);
    en->filter = g_strdup(get_filter(tree_details->window));

    preg = compile_regex_filter(en->filter,SHOWS_HIDDEN(en->type));
#endif

    /* count step */
#ifdef USE_FILTER_BAR
    xfdir.pathc = read_files_local(en->path, en->type, preg, NULL);
#else
    xfdir.pathc = read_files_local(en->path, en->type,  NULL);
#endif
    if(xfdir.pathc < 0) {
      folder_add_error:
	if (xfdir.gl) g_free(xfdir.gl);
	reset_dummy_row(treemodel, iter,NULL,en,"xfce/error_icon",_("Load failed"));
	print_diagnostics("xfce/error_icon", en->path, " :\n", strerror(errno), "\n", NULL);
	return FALSE;
    }

    /* done in addnodecontents too...
    gtk_widget_freeze_child_notify((GtkWidget *) treeview);
    */
    
    if(xfdir.pathc)
    {
	print_status(NULL,_("Reading..."),NULL);
	process_pending_gtk();
	/* XXX should be no dummy...
	if (!(IS_ROOT_TYPE(en->type) && IS_LOCAL_TYPE(en->type))) {
	    erase_dummy_row(treemodel, iter, NULL);
	}*/
	xfdir.gl = (dir_t *) malloc(xfdir.pathc * sizeof(dir_t));
	if(!xfdir.gl)
	{
	    goto folder_add_error;
	} else {
	    memset(xfdir.gl,0,xfdir.pathc * sizeof(dir_t));
	}

#ifdef USE_FILTER_BAR
	if(read_files_local(en->path, en->type, preg, &xfdir) < 0)
	{
	    goto folder_add_error;
	}
#else
	if(read_files_local(en->path, en->type,  &xfdir) < 0)
	{
	    goto folder_add_error;
	}
#endif

	/* calculate checksums for the directory (for later use by monitor) 
	 * */
	for(j = 0; j < xfdir.pathc; j++) if (xfdir.gl[j].en && xfdir.gl[j].en->st)
	{
	    tama += xfdir.gl[j].en->st->st_size;
	    en->checksum += (xfdir.gl[j].en->st->st_mtime + xfdir.gl[j].en->st->st_ctime);
	}
	add_contents_row(treemodel, iter, &xfdir);
	xfdirfree(&xfdir);
	if (!IS_ROOT_TYPE(en->type)){
	    erase_dummy_row(treemodel,iter,NULL);
	}
    }

    SET_LOADED(en->type);

    /* XXX: is en->tag really necessary? */
    if(tree_details->stop)
    {
	SET_INCOMPLETE(en->type);
	tree_details->stop = FALSE;
 	if (en->tag) g_free(en->tag);	
	en->tag = g_strconcat(FILENAME(en)," : ", strerror(ECANCELLED), NULL);
	print_diagnostics("xfce/warning_icon",strerror(ECANCELLED),":\n", en->tag, "\n",NULL);
#ifdef DEBUG
	printf("DBG: stopped!\n");
#endif
    }
    else
    {
	UNSET_INCOMPLETE(en->type);
	hide_stop();
	set_entry_tag(treeview, en, tama);
	if (en->tag && strchr(en->tag,'%'))
		print_status_tmp(resolve_icon_small(en), FILENAME(en), NULL);
	else if (en->tag) print_status(resolve_folder_icon(en), en->tag, NULL);
	process_pending_gtk();
    }
    en->load_time = time(NULL) - inicio;

    return TRUE;

}

