/*#define DEBUG*/
/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define __MENU_C__

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <glob.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "modules.h"

#include "menu.h"
#include "menu_callbacks.h"

#include "dnd.h"
#include "entry.h"
#include "icons.h"
#include "input.h"
#include "options.h"
#include "misc.h"
#include "refresh.h"
#include "run.h"
#include "widgets.h"
#include "xfstab.h"
#include "bookmarks.h"
#include "preferences.i"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)


extern gchar *bookfile;
/* keep first five elements unaltered. (needed by quick_hide()) */
G_MODULE_EXPORT
preferences_t opt_col_titles[]={
	    {N_("Show sizes"),"SHOW_SIZE",SHOW_SIZE|INDIVIDUAL_TOGGLE,GDK_F1},
	    {N_("Show dates"),"SHOW_DATE",SHOW_DATE|INDIVIDUAL_TOGGLE,GDK_F2},
	    {N_("Show owner"),"SHOW_UID",SHOW_UID|INDIVIDUAL_TOGGLE,GDK_F3},
	    {N_("Show group"),"SHOW_GID",SHOW_GID|INDIVIDUAL_TOGGLE,GDK_F4},
	    {N_("Show permissions"),"SHOW_MODE",SHOW_MODE|INDIVIDUAL_TOGGLE,GDK_F5},
	    {NULL,NULL,0,0}
};

G_MODULE_EXPORT
preferences_t opt_view_titles[]={
	    {N_("Icon view"),"ICON_VIEW",ICON_VIEW,0},
	    {N_("Default view"),"DEFAULT_VIEW",DEFAULT_VIEW,0},
	    {N_("Small view"),"SMALL_VIEW",SMALL_VIEW,0},
	    {N_("Detailed view"),"DETAILED_VIEW",DETAILED_VIEW,0},
	    {NULL,NULL,0,0}
};

G_MODULE_EXPORT
preferences_t preferences_titles[]={
#ifdef USE_EXTENDPREFS
	    {N_("Autoscroll"),"AUTOSCROLL",AUTOSCROLL,GDK_A},
	    {N_("Text headers"),"TEXT_HEADERS",TEXT_HEADERS,GDK_B},
#endif
	    {N_("Copy on drag"),"DRAG_DO_COPY",DRAG_DO_COPY,GDK_C},
#ifdef USE_EXTENDPREFS
	    {N_("Show Hidden"),"SHOW_DOT",SHOW_DOT,GDK_D},
	    /*{N_("Filetype subsorting"),"FILETYPE_SUBS",FILETYPE_SUBS,GDK_F},*/
	    {N_("Image auto-previews"),"IMAGE_PREVIEW",IMAGE_PREVIEW,GDK_F},
#endif
	    {N_("Monitor enabled"),"ENABLE_MONITOR",ENABLE_MONITOR,GDK_G},
	    {N_("Default GTK mouse selection mode"),"ENABLE_GTK_CLICK",ENABLE_GTK_CLICK,GDK_H},
#ifdef USE_EXTENDPREFS
	    {N_("Resize fonts to match icons"),"ENABLE_RESIZE_FONTS",ENABLE_RESIZE_FONTS,GDK_I},
	    {N_("Disable auto trash collection"),"ENABLE_AUTO_T",ENABLE_AUTO_T,GDK_J},
	    {N_("Disable text colors"),"DISABLE_TEXT_COLOR",DISABLE_TEXT_COLOR,GDK_K},
	    {N_("Disable cell editing"),"DISABLE_EASY_EDIT",DISABLE_EASY_EDIT,GDK_L},
	    {N_("Invisible Wastebaskets"),"HIDE_WASTE_B",HIDE_WASTE_B,GDK_N},
	    {N_("rcp before scp"),"RSH_X_SSH",RSH_X_SSH,GDK_R},
#endif
	    {N_("Verbose diagnostics"),"VERBOSE",VERBOSE,GDK_V},
	    {NULL,NULL,0,0}
    };

G_MODULE_EXPORT
preferences_t opt_branches_titles[]={
	    {N_("Local"),"ACTIVATE_LOCAL",ROOT_FILES,GDK_F1},
	    {N_("Book"),"ACTIVATE_BOOK",ROOT_BOOKMARKS,GDK_F2},
#ifdef USE_SMB_BRANCH
	    {N_("SMB Network"),"ACTIVATE_SMB",ROOT_NETWORK,GDK_F3},
#endif
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
	    {N_("Fstab"),"ACTIVATE_FSTAB",ROOT_FSTAB,GDK_F4},
#endif
	    {N_("Recent"),"ACTIVATE_RECENT",ROOT_RECENT,GDK_F5},
	    {N_("Frequent"),"ACTIVATE_FREQUENT",ROOT_FREQUENT,GDK_F6},
	    {N_("Trash"),"ACTIVATE_TRASH",ROOT_TRASH,GDK_F7},
	    {NULL,NULL,0,0}
    };


/* autotype entries will appear in file-menu and popup depending on
 * extension of selected item (if any). Notes:
 * -leave a blank at end of command if using arguments (to be safe) 
 * -keep entries with same extension together (so they all will appear)
 * -using NULL for input_query_text means that no input will be required
 * -using TRUE in the queued field will place it into the single queued, 
 *        where processes are run one at a time, sequentially.
 * 
 *  {char *extension,char *command,
 *  char *menu_label,char *input_query_text, gboolean queued} 
 * */
#if 1
/* here the extension is appendend to "$command $filename$extension $filename". if NULL, 
 * then  "$command $filename" is used */
G_MODULE_EXPORT
autotype_t autotype_dir []= {/* all directory commands which query for directory 
	must have output specified on command line...*/
	/* archive file extractions (queued) */
	/*{".tar","tar -cf ",N_("Create tarball %s"),N_("Output dir"),1},*/
	{".tar.gz","tar -czf ",N_("Create gzip tarball %s"),N_("Output dir"),1},
	{".tar.bz2","tar -cjf ",N_("Create bzip2 tarball %s"),N_("Output dir"),1},
	{".iso","mkisofs -dDlLNRTUP Created_by_XFce4_desktop -o ",N_("Create isofs %s"),N_("Output dir"),1},
	{NULL,NULL}
};
#endif

G_MODULE_EXPORT
autotype_t autotype []= {
	/* archive file extractions (queued) */
	{".tar.gz","tar -xzf ",N_("Extract files from %s"),N_("Extract into"),1},
	{".tar.gz","tar -tzf ",N_("Package contents %s"),NULL,1}, /* XXX remove when tarball expansion enabled */
	{".gz","gunzip","gunzip",NULL,1},
	{".tar","tar -tf ",N_("Package contents %s"),NULL,1},/* XXX remove when tarball expansion enabled */
	{".tar","tar -xf ",N_("Extract files from %s"),N_("Extract into"),1},
	{".tar.bz2","tar --use-compress-program bunzip2 -xf",N_("Extract files from %s"),N_("Extract into"),1},
	{".bz2","bunzip2",N_("uncompress %s"),NULL,1},
	{".Z","uncompress",N_("uncompress %s"),NULL,1},
	{".ZIP","unzip",N_("uncompress s"),NULL,1},
	{".zip","unzip",N_("uncompress %s"),NULL,1},
	
	{".tgz","tar -xzf ",N_("Extract files from %s"),N_("Extract into"),1},
	{".tgz","tar -tzf ",N_("Package contents %s"),NULL,1}, /* XXX remove when tarball expansion enabled */
						   
	{".iso","burncd -f /dev/acd0 -s max data %s fixate","burncd",NULL,1},
	{".iso","sudo burncd -f /dev/acd0 -s max data %s fixate","sudo burncd",NULL,1},
	{".iso","cdrecord -v dev=ATAPI:0,0,0 ","cdrecord %s",NULL,1},
	{".iso","sudo cdrecord -v dev=ATAPI:0,0,0 ","sudo cdrecord %s",NULL,1},
#if 0
	deprecated
	{".iso","cdrecord -v speed=24 dev=0,0 ","cdrecord %s",NULL,1},
	{".iso","sudo cdrecord -v speed=24 dev=0,0 ","sudo cdrecord %s",NULL,1},
#endif
	
	/* FreeBSD package management (queued) */
#ifndef __linux__
	{".tgz","pkg_info -d ",N_("Package information %s"),NULL,1},
	{".tbz","pkg_info -d ",N_("Package information %s"),NULL,1},
	
	{".tgz","pkg_info -r ",N_("Package requirements %s"),NULL,1},
	{".tgz","pkg_info -L ","pkg_info -L %s",NULL,1},
	{".tgz","pkg_update ","pkg_update %s",NULL,1},
	{".tgz","sudo pkg_update ","sudo pkg_update %s",NULL,1},
	{".tgz","pkg_add ","pkg_add %s",NULL,1},
	{".tgz","sudo pkg_add ","sudo pkg_add %s",NULL,1},
	{".tgz","pkg_add -f ","pkg_add -f %s",NULL,1},
	{".tgz","sudo pkg_add -f ","sudo pkg_add -f %s",NULL,1},

	{".tbz","pkg_info -r ",N_("Package requirements %s"),NULL,1},
	{".tbz","pkg_info -L ","pkg_info -L %s",NULL,1},
	{".tbz","pkg_update ","pkg_update %s",NULL,1},
	{".tbz","sudo pkg_update ","sudo pkg_update %s",NULL,1},
	{".tbz","pkg_add ","pkg_add %s",NULL,1},
	{".tbz","sudo pkg_add ","sudo pkg_add %s",NULL,1},
	{".tbz","pkg_add -f ","pkg_add -f %s",NULL,1},
	{".tbz","sudo pkg_add -f ","sudo pkg_add -f %s",NULL,1},


	
#endif
#ifdef __linux__
	/* RedHat package management (queued) */
	{".rpm","rpm -q -i -p ",N_("Package information %s"),NULL,1},
	{".rpm","rpm -qR -p ",N_("Package requirements %s"),NULL,1},
	{".rpm","rpm -ql -p ",N_("Package contents %s"),NULL,1},
	{".rpm","rpm -U --percent ","rpm -U %s",NULL,1},
	{".rpm","sudo rpm -U --percent ","sudo rpm -U %s",NULL,1},
	{".rpm","rpm -U --percent --nodeps ","rpm -U --nodeps %s",NULL,1},
	{".rpm","sudo rpm -U --percent --nodeps ","sudo rpm -U --nodeps %s",NULL,1},
	{".rpm","rpm -U --percent --force ","rpm -U --force %s",NULL,1},
	{".rpm","sudo rpm -U --percent --force ","sudo rpm -U --force %s",NULL,1},
	{".rpm","rpm -i --percent ","rpm -i %s",NULL,1},
	{".rpm","sudo rpm -i --percent ","sudo rpm -i  %s ",NULL,1},
	{".rpm","rpm -i --percent --nodeps ","rpm -i --nodeps %s",NULL,1},
	{".rpm","sudo rpm -i --percent --nodeps ","sudo rpm -i --nodeps %s",NULL,1},
	{".rpm","rpm -i --percent --force ","rpm -i --percent --force %s",NULL,1},
	{".rpm","sudo rpm -i --percent --force ","sudo rpm -i --percent --force %s",NULL,1},
	
	/* Debian package management (queued) */
	{".deb","dpkg -i ","dpkg -i %s",NULL,1},
	{".deb","sudo dpkg -i ","sudo dpkg -i %s",NULL,1},
#endif
	/* assorted packages (not queued) */
	/*{"","","",NULL},*/
	{NULL,NULL}
};

/* Use as many different names for as many different
 * autotype menu entries for one file extension type. */
G_MODULE_EXPORT
char *auto_C_name []={
   "ejecutar1",
   "ejecutar2",
   "ejecutar3",
   "ejecutar4",
   "ejecutar5",
   "ejecutar6",
   "ejecutar7",
   "ejecutar8",
   "ejecutar9",
   "ejecutar10",
   NULL
};

static gchar *always_show[]={
    "refresh3",
    "select_all2_menuitem",
    "edit_separator",
    "salir1_menuitem",
    NULL
};

static gchar *multiple_selection[]={
    "cut1_menuitem",
    "copy1_menuitem",
    "remove1_menuitem",
    "popup_disk_usage_menuitem",
    "popup_separator1",
    NULL
};

static gchar *trash_menu_stuff[]={
    "collect_trash1_menuitem",
    NULL
};

static gchar *file_menu_stuff[]={
    "sb_duplicate_menuitem",
    "sb_symlink_menuitem",
    "sb_touch_menuitem",
    "sb_rename_menuitem",
    "sb_print_menuitem",
    "sb_scramble_menuitem",
    "sb_unscramble_menuitem",
    NULL
};

  
static gchar *book_menu_stuff[]={
    "open_book2_menuitem",
    "default_book2_menuitem",
    "new4_menuitem",
    "save_book2_menuitem",
    "purge_bookmarks1_menuitem",
    NULL
};
  
static gchar *popup_menu_stuff[]={
    "refresh3",
    "select_all2_menuitem",
    NULL
};

static gchar *path_selection[]={
    "cut1_menuitem",
    "copy1_menuitem",
    "paste1_menuitem", /* FIXME: this should be insensitive if invalid pasteboard, should also test since no longer a directory must be target, but plain path. */
    "remove1_menuitem",
    "popup_separator1",
    "file1",
    "popup_disk_usage_menuitem",
    NULL
};

static gchar *anything_selected_list[]={
    "sort1",
    "go1",
    "descending1",
    "ascending1",
    "unsorted6",
    "name6",
    "size6",
    "date6",
    "owner6",
    "group6",
    "mode6",
    
    "sb_go_home_menuitem",
    "sb_goto_jump_menuitem",
    "sb_go_backward_menuitem",
    "sb_go_forward_menuitem",
    "sb_go_up_menuitem",
    NULL
};




static gboolean invalid_input;
static gboolean local_stuff;
static gboolean remote_stuff;
static gchar *remote_pass=NULL;
static gchar *remote_location=NULL;
static GList *unselect_list=NULL;
static gboolean is_recent_selection,is_frequent_selection;



G_MODULE_EXPORT
void set_sense (int which,gboolean state)
{
    gchar **p;
    if (which==0) p=trash_menu_stuff;
    else if (which==1) p=file_menu_stuff;
    else if (which==2) p=book_menu_stuff;
    else if (which==3) p=popup_menu_stuff;
    else if (which==4) p=auto_C_name;
    else if (which==5) p=anything_selected_list;
    else {
	g_warning("p==NULL");
	return;
    }
    for (;*p;p++){
	GtkWidget *w=WIDGET(*p);
	gtk_widget_set_sensitive(w,state);
    }
}

static 
void 
create_menu_entry(		char *name,
				char *label,
				GtkWidget *parent,
				GtkWidget *main_window,
				void *callback,
				void *data,
				int offset){
  GtkWidget *w,*image;
  w = gtk_image_menu_item_new_with_label (label);
  if (offset <0) gtk_container_add (GTK_CONTAINER (parent), w);
  else {
	gtk_menu_shell_insert(GTK_MENU_SHELL(parent), w, offset);
  }
  
  /* get the application icon would look nice */
  {
      GdkPixbuf *p=load_stock_icon("gtk-execute",GTK_ICON_SIZE_MENU);
      if (p) {
	image = gtk_image_new_from_pixbuf (p);
	g_object_unref(p);
      } else image=NULL;
  }
  /*image = gtk_image_new_from_stock ("gtk-execute", GTK_ICON_SIZE_MENU);*/
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (w), image);
  g_signal_connect ((gpointer) w, "activate", G_CALLBACK (callback), data);
  GLADE_HOOKUP_OBJECT (main_window, w, name);
}

static void add_autotype_C_widgets(void){
  int i;
  GtkWidget *open1_menu;
  static gboolean done=FALSE;

  if (done) return;
  done=TRUE;
  open1_menu = WIDGET("item22_menu");
  
  /*create_menu_entry("autotype_Prun",_("Execute"),open1_menu,
		tree_details->window,(void *)on_autotype_run,NULL);*/
#if HAVE_GETMNTENT || HAVE_GETMNTINFO
  {
   GtkWidget *w;
   w = lookup_widget(tree_details->window, "mountP");
   g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_mount),(gpointer)((long)0));
   w = lookup_widget(tree_details->window, "unmountP");
   g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_mount),(gpointer)((long)1));

  }
#endif
	  
  
 for (i=0;auto_C_name[i];i++){
    create_menu_entry(auto_C_name[i]," ",open1_menu,tree_details->window,on_autotype_C,NULL,i+4);
 }

}

G_MODULE_EXPORT
void
change_sort_column (GtkButton     *button, gpointer         user_data)
{
    int tree_id=get_relative_tree_id();
    int column_id;
    column_id=(int)((long)user_data);
    
    tree_details->treestuff[tree_id].ascending--;
    on_column_click(
	    tree_details->treestuff[tree_id].column[column_id],
	    tree_details->treestuff[tree_id].treeview);
}

G_MODULE_EXPORT
void on_ascending (GtkMenuItem * menuitem, gpointer user_data){
    int tree_id=get_relative_tree_id();
    int column_id=tree_details->treestuff[tree_id].sort_column;

    if (!tree_details->treestuff[tree_id].ascending) return;
    tree_details->treestuff[tree_id].ascending = 1;
    tree_details->treestuff[tree_id].ascending--;
    on_column_click(
	    tree_details->treestuff[tree_id].column[column_id],
	    tree_details->treestuff[tree_id].treeview);
}

G_MODULE_EXPORT
void on_descending (GtkMenuItem * menuitem, gpointer user_data){
    int tree_id=get_relative_tree_id();
    int column_id=tree_details->treestuff[tree_id].sort_column;
	
    if (!tree_details->treestuff[tree_id].ascending) return;
    tree_details->treestuff[tree_id].ascending = 2; 
    tree_details->treestuff[tree_id].ascending--;
    on_column_click(
	    tree_details->treestuff[tree_id].column[column_id],
	    tree_details->treestuff[tree_id].treeview);

}

    
static void add_sort_callbacks(void){
	g_signal_connect((gpointer)WIDGET("unsorted6"), "toggled", G_CALLBACK(change_sort_column), (gpointer) ((long)PIXBUF_COLUMN));
	g_signal_connect((gpointer)WIDGET("name6"), "toggled", G_CALLBACK(change_sort_column), (gpointer) ((long)NAME_COLUMN));
	g_signal_connect((gpointer)WIDGET("size6"), "toggled", G_CALLBACK(change_sort_column), (gpointer) ((long)SIZE_COLUMN));
	g_signal_connect((gpointer)WIDGET("date6"), "toggled", G_CALLBACK(change_sort_column), (gpointer) ((long)DATE_COLUMN));
	g_signal_connect((gpointer)WIDGET("owner6"), "toggled", G_CALLBACK(change_sort_column), (gpointer) ((long)OWNER_COLUMN));
	g_signal_connect((gpointer)WIDGET("group6"), "toggled", G_CALLBACK(change_sort_column), (gpointer) ((long)GROUP_COLUMN));
	g_signal_connect((gpointer)WIDGET("mode6"), "toggled", G_CALLBACK(change_sort_column), (gpointer) ((long)MODE_COLUMN));
}

G_MODULE_EXPORT
void add_preferences_items (void)
{
    GtkWidget *w, *menu;
    int i;
    GSList *l;
    static gboolean done=FALSE;

    if (done) return;
    done=TRUE;
    add_sort_callbacks();
    menu = WIDGET("preferences3_menu");
    l = gtk_accel_groups_from_object((GObject *) tree_details->window);
    if(!l || !l->data)	{
	g_error("no accel group for window!");
	assert_not_reached();
    }
    /* this button is still defined in glade: */
    
    gtk_widget_add_accelerator (lookup_widget(tree_details->window,"refresh3"), "activate", 
			    (GtkAccelGroup *) (l->data),
                              GDK_Z, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
	    D(printf("DBG: adding CTL+%c\n",GDK_Z);)
    
    for (i=0;preferences_titles[i].label;i++)
    {
	w = gtk_check_menu_item_new_with_label(_(preferences_titles[i].label));
	if(tree_details->preferences & preferences_titles[i].flag)
	{
	    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(w), TRUE);
	}

	if (preferences_titles[i].key){
		gtk_widget_add_accelerator(w, "activate", 
				(GtkAccelGroup *) (l->data), 
				preferences_titles[i].key, 
				GDK_SHIFT_MASK|GDK_CONTROL_MASK,
				GTK_ACCEL_VISIBLE);
	}
	g_signal_connect((gpointer) w, "activate", 
			G_CALLBACK(toggle_preference), 
			(gpointer) ((long)preferences_titles[i].flag));
  	GLADE_HOOKUP_OBJECT (tree_details->window, w, 
			preferences_titles[i].xml_option);
	/*gtk_menu_shell_insert(GTK_MENU_SHELL(menu), w, i);*/
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), w);
	gtk_widget_show(w);
    }

    
}

static gboolean anything_selected=FALSE;
static void check_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_entry_t *en;
   
    anything_selected=TRUE;
       gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (!en) return;   
/*    GtkTreeRowReference *reference;*/

    if(!en || IS_DUMMY_TYPE(en->type)){		    
         GtkTreeRowReference *reference=
		 gtk_tree_row_reference_new(model,path);
	 unselect_list = g_list_append(unselect_list, reference);    
	 return;
    }	
    if (IS_RECENT_TYPE(en->type)) is_recent_selection=TRUE;    
    if (IS_FREQUENT_TYPE(en->type)) is_frequent_selection=TRUE;    
    if (IS_PATH(en->type)) local_stuff=TRUE;
    if(IS_NETTHING(en->subtype)||IS_NETWORK_TYPE(en->type)){
	remote_stuff=TRUE;
	if (IS_NETDIR(en->subtype)||IS_NETFILE(en->subtype)||
			IS_XF_NETSHARE(en->subtype)){
	   gchar *server_pass=g_strdup(en->tag);
	   gchar *location=g_strdup(en->path);
	   if (local_stuff){
		   invalid_input=TRUE;
		   return;
	   }
	   if (!strchr(location+2,'/')) assert_not_reached();
	   strtok(strchr(location+2,'/')+1,"/");
	   /*printf("DBG:location=%s\n",location);*/
	   if (!location || !strlen(location)) assert_not_reached();
   	   if (!remote_location)remote_location=location;
	   else {
	     if (strcmp(remote_location,location)!=0)invalid_input=TRUE;
	     g_free(location);location=NULL;
	   }
   	   if (!remote_pass)remote_pass=server_pass;
	   else {
	     if (strcmp(remote_pass,server_pass)!=0)invalid_input=TRUE;
	     g_free(server_pass);server_pass=NULL;
	   }
	}
    }
    if (local_stuff&&remote_stuff){
	   invalid_input=TRUE;
	   return;
    }
    tree_details->selectionOK++;
    return;
}

static void show_group(GtkWidget *popup, gchar **p){
    int i;
    for (i=0; *(p+i); i++){
	  showit(popup,*(p+i));
    }
}

static
int 
set_auto_command(			int j,
					GtkWidget *popup,
					const gchar *name,
					const gchar *alt_label,
					const gchar *app, 
					const gchar *path,
					const gchar *querypath,
					const gboolean *queued,
					const gchar *output_arg,
					const gchar *output_ext)
{
    int jj;
     if (MIME_is_valid_command(app)){
	      GtkWidget *label;
	      gchar *old_text, *command ;
	      GtkWidget *a=WIDGET(name);
	      if (strncmp(app,"sudo ",strlen("sudo "))==0){
		    if (getuid()==0) return j; /* don't sudoize root */
		    if (!strlen(app+strlen("sudo ")) || !MIME_is_valid_command(app+strlen("sudo "))) return j;
	      }
	      
	      label = gtk_bin_get_child(GTK_BIN(a));
	      if (alt_label){
		 gtk_label_set_text((GtkLabel *)label,my_utf_string(alt_label));
	      } else {
		  gchar *new_label;
		  gchar *fname=g_path_get_basename(path);
		  if (queued && *queued && output_arg) new_label=g_strdup(app);
		  else new_label=g_strdup(MIME_mk_command_line(app,fname,FALSE,FALSE));
		  gtk_label_set_text((GtkLabel *)label,my_utf_string(new_label));
		  g_free(new_label);
		  g_free(fname);
	      }

	      

	      if (queued && *queued && output_arg) command=g_strdup(app);
	      else command=g_strdup(MIME_mk_command_line(app,path,FALSE,FALSE));
	      
	      /* check for duplicates */
	      for (jj=0;jj<j;jj++){
		gchar *set_command=g_object_get_data(G_OBJECT(WIDGET(auto_C_name[jj])), "command");
#ifdef DEBUG
		printf("j=%d: %s == %s\n",jj,set_command,command);
#endif
		if (strcmp(set_command,command)==0)
		{ /* skip it */
		  g_free(command);
		  return j;
		}	   
	      }
	      
	      if ((old_text=g_object_get_data(G_OBJECT(a),"command")) != NULL) g_free(old_text);
	      if ((old_text=g_object_get_data(G_OBJECT(a),"output_arg")) != NULL) g_free(old_text);
	      g_object_set_data(G_OBJECT(a),"command",(gpointer)command);
	      
	      g_object_set_data(G_OBJECT(a),"querypath",(gpointer)querypath);
	      g_object_set_data(G_OBJECT(a),"queued",(gpointer)queued);
	      g_object_set_data(G_OBJECT(a),"output_arg",((output_arg)?g_strdup(output_arg):NULL));
	      g_object_set_data(G_OBJECT(a),"output_ext",(gpointer)output_ext);
	      showit(popup, name);
	      j++;
     }
     return j;
}

static
gchar *
alt_menu_label(			const gchar *label, const gchar *path,const gchar *extension)
{/* chinese friendly translations: */
    gchar *alt_label=NULL;
    if (label) 
    { 
	gchar *fname=g_path_get_basename(path);
	gchar *ffname=g_strconcat(fname,extension,NULL);
	if (strstr(label,"%s")) {
	    alt_label=g_strdup_printf(label,ffname);
	} else {
	    alt_label=g_strdup_printf("%s %s",label,ffname);
	}
	g_free(fname);
	g_free(ffname);   
    }
    return alt_label;
}


static void autostuff(GtkWidget *popup,tree_entry_t *en){
    gchar **text_editors;
    int j=0;
    if (IS_EXE(en->type) && !IS_DIR(en->type)) {
      gchar *cmd;		
      GtkWidget *label,*a=WIDGET("autotype_Prun");
      label = gtk_bin_get_child(GTK_BIN(a));
      cmd=g_strconcat(_("Execute")," ",FILENAME(en),NULL);
      gtk_label_set_text((GtkLabel *)label,my_utf_string(cmd));
      g_free(cmd);
      showit(popup,"autotype_Prun");
    }
    if(IS_DIR(en->type))
    {/* all directory commands which query for directory 
	must have output specified on command line...*/	      
       int i;
       for (i=0;auto_C_name[j]&&autotype_dir[i].label;i++){
	   gchar *alt_label;	
	   if (!autotype_dir[i].command) continue;
	   alt_label=alt_menu_label(_(autotype_dir[i].label),en->path,autotype_dir[i].extension);	
	   j=set_auto_command(j,popup,auto_C_name[j],alt_label,autotype_dir[i].command,en->path,autotype_dir[i].querypath,&(autotype[i].queued),FILENAME(en),autotype_dir[i].extension);
	   g_free(alt_label);
       }
    }
    
    {/* autotypes */	      
       gchar *loc;
       int i;
       gboolean in_term;
       const gchar *p=get_from_open_history(en->path, &in_term);
	/* XXX: allow in term to be processed too (later...) */
       if (p && !in_term) {
	   j=set_auto_command(j,popup,auto_C_name[j],NULL,p,en->path,NULL,NULL,NULL,NULL);
       }

       for (i=0;auto_C_name[j]&&autotype[i].extension;i++){
	   if (!auto_C_name[j]) continue;
           loc=strstr(en->path,autotype[i].extension);
           if ((loc)&&(strcmp(loc,autotype[i].extension)==0)){
	       gchar *alt_label;	
	       if (autotype[i].command == NULL) continue;
	       alt_label=alt_menu_label(_(autotype[i].label),en->path,NULL);	
	       
	       j=set_auto_command(j,popup,auto_C_name[j],alt_label,autotype[i].command,en->path,autotype[i].querypath,&(autotype[i].queued),NULL,NULL);
	       g_free(alt_label);
	   }
       }
    }

	    
    /* duplicate mime types */
    {
      int i=0;
      const gchar **apps=MIME_apps(en->path);
      if (apps && apps[i]) for (;apps && apps[i]; i++){
	  if (!auto_C_name[j]) continue;
	  j=set_auto_command(j,popup,auto_C_name[j],NULL,apps[i],en->path,NULL,NULL,NULL,NULL);
      }	
      
    }
    if ((text_editors=text_type_OK(en->path))!=NULL){  
	  /* OK to apply an editor */
	int k;
	for (k=0;text_editors[k];k++){
	    j=set_auto_command(j,popup,auto_C_name[j],NULL,text_editors[k],en->path,NULL,NULL,NULL,NULL);
	}
    }

   	
    
    showit(popup, "open_with_1");		

    
    return;
}

G_MODULE_EXPORT
void set_menu_context (void){
    gint tree_id = get_relative_tree_id();
    GtkTreeView *treeview=tree_details->treestuff[tree_id].treeview;
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    
    anything_selected=FALSE;
    gtk_tree_selection_selected_foreach(selection, 
		    check_select, (gpointer) treeview);
    set_column_menu(tree_id);
    
    if (get_only_visible_treestuff() || anything_selected){
        set_sense(5,TRUE);/* anything_selected_list */
    } else {
        set_sense(5,FALSE);/* anything_selected_list */
    }
}


G_MODULE_EXPORT
void do_main_popup (const gchar *name,gint32 t){
    GtkWidget  *popup;
    if(tree_details->loading) return;
    add_preferences_items();
    add_autotype_C_widgets();
    set_menu_context();
    popup = WIDGET(name);
    gtk_widget_show_all(popup);
    gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, 0);
}

G_MODULE_EXPORT
gboolean  popup_button_press_event (GtkWidget *event_box,  GdkEventButton *event, gpointer user_data) {
    /*g_print ("Event box clicked at coordinates %f,%f\n", event->x, event->y);*/
   if( event->button != 3) return FALSE;
   do_main_popup("main_menu2_menu",event->time);
   return TRUE;
}

 
G_MODULE_EXPORT
gboolean  column_button_press_event (GtkWidget *event_box,  GdkEventButton *event, gpointer user_data) {
    /*g_print ("Event box clicked at coordinates %f,%f\n", event->x, event->y);*/
    gint tree_id=(gint)((long)user_data);
   if( event->button != 3) return FALSE;
   set_relative_tree_id(tree_id);
   set_column_menu(tree_id); /* does branch menu too...*/
   do_main_popup("columns1_menu",event->time);
   return TRUE;
}



G_MODULE_EXPORT
void do_select_popup (GtkTreeView * treeview, GtkTreePath *selectpath,gint32 t)
{
    GtkWidget *widget, *popup;
    GtkTreeIter iter;
    tree_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    int tree_id = get_tree_id(treeview);

    if(tree_details->loading) return;
    add_preferences_items();
    add_autotype_C_widgets();
    invalid_input=FALSE;
    local_stuff=FALSE;
    remote_stuff=FALSE;
    remote_pass=NULL;
    remote_location=NULL;    
    tree_details->selectionOK=0;
    is_frequent_selection=is_recent_selection=FALSE;

    set_sense(5,FALSE);/* anything_selected_list */
    
    anything_selected=FALSE;
    gtk_tree_selection_selected_foreach(selection, 
		    check_select, (gpointer) treeview);
    while (unselect_list){
	    GtkTreeRowReference *ref=(GtkTreeRowReference *)unselect_list->data;
	    GtkTreePath *tpath=gtk_tree_row_reference_get_path(ref);
	    gtk_tree_selection_unselect_path(selection,tpath);
    	    unselect_list = g_list_remove(unselect_list, ref);
	    gtk_tree_path_free(tpath);
	    gtk_tree_row_reference_free(ref);	    
    }
    
    popup = WIDGET("item22_menu");
    gtk_widget_hide_all(popup);

    set_sense(0,TRUE);/* trash */
    set_sense(1,TRUE);/* file */
    set_sense(2,TRUE);/* book */
    set_sense(3,TRUE);/* popup */
    set_sense(4,TRUE);/* auto_C */
    
    show_group(popup,always_show);
    if (get_only_visible_treestuff() || anything_selected){
        set_sense(5,TRUE);/* anything_selected_list */
    }
    
    set_relative_tree_id(tree_id);
    showit(popup, "sort1");
#if 0
    /* these have no good reason to appear in the popup context */
    showit(popup, "columns1");
    showit(popup, "branches1");
#endif
    

    if (invalid_input || tree_details->selectionOK==0){
	set_sense(3,FALSE);
 	gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, t);
	return;
    }

    /* something selected */
    
    if (tree_details->selectionOK > 1){
	show_group(popup,multiple_selection);
	if (is_frequent_selection) showit(popup, "undo_frequent");
	if (is_recent_selection) showit(popup, "undo_recent");
 	gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, t);
	return;
   }
    
	    /* single item selected */	    
    gtk_tree_selection_unselect_all(selection);
    clear_dnd_selection_list();
    gtk_tree_selection_select_path(selection, selectpath);
    gtk_tree_model_get_iter(treemodel, &iter, selectpath);
    gtk_tree_selection_select_iter(selection, &iter);
    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
   
    if(!en){
 	gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, t);
	return;
    }
    /*if (IS_ROOT_TYPE(en->type)) */
	showit(popup,"hide_branch_menuitem");
    if (IS_ROOT_TYPE(en->type)) {
	if (IS_BOOKMARK_TYPE(en->type)){
	    showit(popup, "clear_all_bookmarks_menuitem");
	    showit(popup, "open_book2_menuitem");
	    showit(popup, "default_book2_menuitem");
	    showit(popup, "remember1_menuitem");
	    showit(popup, "new4_menuitem");
	    showit(popup, "save_book2_menuitem");
	    showit(popup, "purge_bookmarks1_menuitem");
	}
	if (IS_RECENT_TYPE(en->type)){
	    showit(popup, "clear_recent_menuitem");
	    showit(popup, "set_recent_threshold2_menuitem");
	}
	if (IS_FREQUENT_TYPE(en->type)){
	    showit(popup, "clear_frequent_menuitem");
	    showit(popup, "set_frequency_threshold2_menuitem");
	}
	if(IS_FIND_TYPE(en->type)) showit(popup, "clear_all_results_menuitem"); 
	if(IS_TRASH_TYPE(en->type)) {
	    showit(popup, "delete_all_trash1_menuitem"); 
	    showit(popup, "uncollect_trash1_menuitem"); 
	}
    }

    enable_refresh_by_toggle(FALSE);
    print_status_tmp( resolve_icon_small(en),  FILENAME(en), NULL);

    /* turn on/off toolbar buttons... */
    turn_on();

    if (IS_NETTHING(en->subtype)){
        showit(popup, "copy1_menuitem");
        showit(popup, "remove1_menuitem");
        showit(popup, "show_hidden1");
        showit(popup, "paste1_menuitem"); 
	showit(popup, "popup_separator1");
	if (IS_XF_NETSHARE(en->subtype)){
	      showit(popup, "mountP");
	}
    }
    
    if(IS_FIND_TYPE(en->type) && !IS_ROOT_TYPE(en->type)) {
	showit(popup, "remove_from_results_menuitem");	    
    }	    
    if(IS_PATH(en->type)){
	int mounted;
	show_group(popup,path_selection);
	
	if (strrchr(en->path,'/') && IS_IMAGE(strrchr(en->path,'/')))
			showit(popup,"preview_this_image_menuitem");
	
	widget = WIDGET("show_hidden1");
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(widget), 
			SHOWS_HIDDEN(en->type));
	widget = WIDGET("preview_images1");
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(widget), 
			SHOWS_IMAGES(en->type));
	showit(popup, "show_hidden1");
	showit(popup, "preview_images1");
	    
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
	mounted=is_mounted((const gchar *)en->path);
	if ((IS_FSTAB_TYPE(en->type) && IS_XF_FSTAB(en->type)) ||
	    (IS_PATH(en->type) && is_in_fstab(en->path)))
	{
	  if (mounted>=0){
	      if (mounted) showit(popup, "unmountP");
	      else showit(popup, "mountP");
	  } else {
	      if (IS_MOUNTED(en->type)) showit(popup, "unmountP");
	      else showit(popup, "mountP");
	  }
	}
	if (mounted){
	    showit(popup, "unmountP");
	}
#endif
	if (IS_DIR(en->type) && !IS_TRASH_TYPE(en->type)){
	    showit(popup, "collect_trash1_menuitem"); 
	}
#if USE_XFALL || USE_SCRAMBLEDIR
	if (!IS_PATH(en->type))
#else
	if (IS_DIR(en->type)|| !IS_FILE(en->type))
#endif
	{
	  gtk_widget_set_sensitive(WIDGET("sb_scramble_menuitem"),FALSE);
	  gtk_widget_set_sensitive(WIDGET("sb_unscramble_menuitem"),FALSE);
	} 
	else 
#if USE_XFALL || USE_SCRAMBLEDIR
	   if (IS_DIR(en->type)) 
	     gtk_widget_set_sensitive(WIDGET("sb_unscramble_menuitem"),TRUE);
	   else
			
#endif
	{
	    gchar *p=strrchr(en->path,'.');
	    if (!p || strcmp(p,".cyt")!=0) {
		gtk_widget_set_sensitive(WIDGET("sb_scramble_menuitem"),TRUE);
		gtk_widget_set_sensitive(WIDGET("sb_unscramble_menuitem"),FALSE);
	    }
	    else {
		gtk_widget_set_sensitive(WIDGET("sb_unscramble_menuitem"),TRUE);
		gtk_widget_set_sensitive(WIDGET("sb_scramble_menuitem"),FALSE);
	    }
	}
	    
	/* mutually exclusive conditions: */
	if(IS_TRASH_TYPE(en->type)) showit(popup, "uncollect_from_trash_menuitem");
	
	else if (IS_BOOKMARK_TYPE(en->type)){
	   if (IS_ROOT_TYPE(en->type)){
		if(IS_ERASED_SPACE(en->type)) {
		    gtk_widget_set_sensitive(WIDGET("purge_bookmarks1_menuitem"), TRUE);
		} else {
		    gtk_widget_set_sensitive(WIDGET("purge_bookmarks1_menuitem"), FALSE);
		}		    
		showit(popup, "clear_all_bookmarks_menuitem");
	   }
	   else {
	       showit(popup, "remove_from_bookmarks_menuitem");
	       hideit(popup, "purge_bookmarks1_menuitem");
	   }
	}
	else if (IS_RECENT_TYPE(en->type)){
	    showit(popup, "undo_recent_menuitem");
	}
	else if (IS_FREQUENT_TYPE(en->type)){
	    showit(popup, "undo_frequent_menuitem");
	}

	autostuff(popup,en);
	/* gray out stuff that wont work anyways: */
	if(IS_BROKEN_LNK(en->type)) {
	    set_sense(1,FALSE);/* file */
	    set_sense(2,FALSE);/* book */
	    set_sense(4,FALSE);/* auto_C */
	}
	    
    }
    

    gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, t);
			/*event->time);*/
    enable_refresh_by_toggle(TRUE);
    return;
}
	
	

G_MODULE_EXPORT
void do_popup (GtkTreeView * treeview, GdkEventButton * event)
{
    GtkTreePath *selectpath;
    if (gtk_tree_view_get_path_at_pos(treeview, event->x, event->y, &selectpath, NULL, NULL, NULL)) do_select_popup(treeview, selectpath,event->time);
}

G_MODULE_EXPORT
void
hide_branch_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    tree_entry_t *en;
    GtkTreeIter iter;
    
    en = get_selected_entry(&iter);
    if (!en) return;
    else if (IS_LOCAL_TYPE(en->type)) on_activate_branch(menuitem,(gpointer)((long)ROOT_FILES));
    else if (IS_FIND_TYPE(en->type)) {
	on_activate_branch(menuitem,(gpointer)((long)ROOT_FIND)); 
	unload_find_module();
    }
#ifdef USE_SMB_BRANCH
    else if (IS_NETWORK_TYPE(en->type)) {
	on_activate_branch(menuitem,(gpointer)((long)ROOT_NETWORK));
	/* no use checking if branch visible since can be on
	 * the other treeview, so let's just unload if loaded.
	 * The module will get reloaded if needed... */
	    unload_smb_module();
    }
#endif
    else if (IS_BOOKMARK_TYPE(en->type)) on_activate_branch(menuitem,(gpointer)((long)ROOT_BOOKMARKS));
    else if (IS_TRASH_TYPE(en->type)) on_activate_branch(menuitem,(gpointer)((long)ROOT_TRASH));
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
    else if (IS_FSTAB_TYPE(en->type)) on_activate_branch(menuitem,(gpointer)((long)ROOT_FSTAB));
#endif
    else if (IS_RECENT_TYPE(en->type)) on_activate_branch(menuitem,(gpointer)((long)ROOT_RECENT));
    else if (IS_FREQUENT_TYPE(en->type)) on_activate_branch(menuitem,(gpointer)((long)ROOT_FREQUENT));
}

G_MODULE_EXPORT
void
on_tools_menu                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    gboolean trash=find_root(treeview,ROOT_TRASH);
    gboolean book=find_root(treeview,ROOT_BOOKMARKS);
    gboolean find=find_root(treeview,ROOT_FIND);
    if (trash){
	gtk_widget_set_sensitive(WIDGET("collect_trash1"), 
			TRUE);
	gtk_widget_set_sensitive(WIDGET("uncollect_all_trash1"), 
			TRUE);
	gtk_widget_set_sensitive(WIDGET("delete_all_trash2"), 
			TRUE);
    } else {
 	gtk_widget_set_sensitive(WIDGET("collect_trash1"), 
			FALSE);
	gtk_widget_set_sensitive(WIDGET("uncollect_all_trash1"), 
			FALSE);
			
	gtk_widget_set_sensitive(WIDGET("delete_all_trash2"), 
			FALSE);
    }
    if (book) {
	gtk_widget_set_sensitive(WIDGET("clear_book1"), 
			TRUE);
    } else {
		gtk_widget_set_sensitive(WIDGET("clear_book1"), 
			FALSE);
    }
    if (find) {
	gtk_widget_set_sensitive(WIDGET("clear_find_results1"), 
			TRUE);
    } else {
	gtk_widget_set_sensitive(WIDGET("clear_find_results1"), 
			FALSE);
    }
}

G_MODULE_EXPORT
void
on_defaultbook_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
	
    g_free(bookfile);bookfile=NULL;
    bookfile=NULL;
    reload_book(treeview);
}


G_MODULE_EXPORT
void
on_newbook_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_input(NEW_BOOK_INPUT);
}




G_MODULE_EXPORT
void
on_open_book_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_input(OPEN_BOOK_INPUT);

}
G_MODULE_EXPORT
void
on_set_menu_context                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    set_menu_context();
}


