/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-Francois Wauthy (pollux@xfce.org)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* !HAVE_CONFIG_H */

#include <sys/time.h>
#include <sys/types.h>
#include <string.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include <libxfce4mcs/mcs-client.h>
#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>
#include <printing-system.h>

#define CHANNEL         "xfprint"

extern void print_dialog_run (const gchar *ifile);

int main(int argc, char **argv)
{
  gchar *ifile = NULL;
  McsClient *client;
  Display *dpy;
  int screen;

#if 0
#ifdef ENABLE_NLS
  /* This is required for UTF-8 at least - Please don't remove it */
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
  textdomain (GETTEXT_PACKAGE);
#endif
#else
  /* This is required for UTF-8 at least - Please don't remove it */
  xfce_textdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, "UTF-8");
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  /* Load the printing system module */
  dpy = GDK_DISPLAY ();
  screen = XDefaultScreen (dpy);
	
  if(!mcs_client_check_manager (dpy, screen, "xfce-mcs-manager"))
    g_warning ("%s: mcs manager not running\n", PACKAGE);
  client = mcs_client_new (dpy, screen, NULL, NULL, NULL);
  if(client){
    McsSetting *setting;

    mcs_client_add_channel (client, CHANNEL);

    if( mcs_client_get_setting (client, "XfPrint/system", CHANNEL, &setting) == MCS_SUCCESS){
      if (!load_printing_system (setting->data.v_string))
	g_error ("Unable to load printing system module %s", setting->data.v_string);
      mcs_setting_free (setting);
    }else{
      gchar *default_system = NULL;

      g_warning ("No mcs-setting found for XfPrint/system in channel %s, using default printing-system", CHANNEL);

      default_system = g_build_filename (PLUGIN_DIR, "file_plugin.so", NULL);

      if (!load_printing_system (default_system)){
	g_error ("Unable to load default printing system module %s", default_system);
      }

      g_free (default_system);
    }

    mcs_client_destroy (client);
  }


  if (argc == 1) {
    struct timeval tv;
    fd_set fds;
    gchar *file;

    FD_ZERO (&fds);
    FD_SET (STDIN_FILENO, &fds);

    tv.tv_sec = 0;
    tv.tv_usec = 20 * 1000;

    /* If no input is available on stdin, ask the users to
     * choose a file to print.
     */
    if (select (1, &fds, NULL, NULL, &tv) < 1) {
      GtkWidget *selection;
      gint response;

      selection = xfce_file_chooser_new (_("Select file to print"),
					 NULL,
					 XFCE_FILE_CHOOSER_ACTION_OPEN,
					 GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					 GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL);
      response = gtk_dialog_run (GTK_DIALOG (selection));
			
      if (response != GTK_RESPONSE_OK)
	exit (EXIT_SUCCESS);

      file = xfce_file_chooser_get_filename (XFCE_FILE_CHOOSER (selection));

      if (!g_file_test (file, G_FILE_TEST_IS_REGULAR)) {
	xfce_err (_("The specified file does not exist"));
	g_free (file);
	exit (EXIT_FAILURE);
      }

      ifile = file;
      
      gtk_widget_destroy (selection);
    } else {
      /* Ok, data ready on stdin */
      ifile = g_strdup ("-");
    }
  } else if (!strcmp (argv[1], "--version") || !strcmp(argv[1], "-V")){
    PrintingSystemInfo *psinfo;

    psinfo = g_new0 (PrintingSystemInfo, 1);

    printing_system_info_init (psinfo);

    g_print ("\tThis is %s version %s for Xfce %s\n", PACKAGE, VERSION,
	     xfce_version_string());
    g_print ("\tbuilt with GTK+-%d.%d.%d, ", GTK_MAJOR_VERSION,
	     GTK_MINOR_VERSION, GTK_MICRO_VERSION);
    g_print ("linked with GTK+-%d.%d.%d.\n", gtk_major_version,
	     gtk_minor_version, gtk_micro_version);
    g_print ("\tCurrently it uses the %s printing system.\n", psinfo->name);
    
    printing_system_info_free (psinfo);
    exit(EXIT_SUCCESS);
  } else {
    ifile = g_strdup (argv[1]);
  }

  print_dialog_run (ifile);

  g_free (ifile);

  return (EXIT_SUCCESS);
}

  
