/*
 *
 * Edscott Wilson Garcia 2001-2004 for xfce project.
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/stat.h>

#include <errno.h>
#include <limits.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include <gtk/gtk.h>
#include <glib.h>
#include <gmodule.h>
#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/xfce-icontheme.h>

/* include non installed headers */
#include <xfce4-modules/headers/constants.h>
#include <xfce4-modules/headers/mime_icons.h>

#ifdef DEBUG
#undef DEBUG
#endif
/*#define DEBUG*/
/*#define DD(x) x*/
#define DD(x) 

/*extern GtkWidget *main_window;*/

#ifndef HAVE_LIBXML
#warning "mime_icons module will be disabled without libxml!"
G_MODULE_EXPORT
const gchar *g_module_check_init(GModule *module){
    g_error("Cannot work with mime-icons module: libxfcegui4 constructed without libxml.");
    return NULL;
}
#else

static GHashTable *theme_hash = NULL;
static GHashTable *icon_hash = NULL;
static GtkIconFactory *icon_factory = NULL;
/*static GList *pixmaps_directories = NULL;*/
static XfceIconTheme *icon_theme=NULL;
static gchar *icon_theme_name=NULL;

typedef struct theme_info_t {
	GHashTable *icon_hash;
	GtkIconFactory *icon_factory;
} theme_info_t;

G_MODULE_EXPORT
gchar*
mime_icon_find_pixmap_file                       (const gchar     *filename);

G_MODULE_EXPORT
GdkPixbuf *mime_icon_create_pixbuf (const gchar     *filename);
G_MODULE_EXPORT
GtkWidget *mime_icon_create_pixmap (GtkWidget *widget, const gchar   *filename);
G_MODULE_EXPORT
GtkIconSet *mime_icon_get_iconset(const gchar *id, GtkWidget *main_window);
G_MODULE_EXPORT
void mime_icon_add_iconset(const gchar *tag, GtkIconSet *icon_set);
G_MODULE_EXPORT
GHashTable * mime_icon_load_theme(void);

G_MODULE_EXPORT
char **mime_icon_find_themes(gboolean only_valid,gboolean full_paths);
G_MODULE_EXPORT
gchar *
mime_icon_get_local_xml_file(const gchar *theme_name);
G_MODULE_EXPORT
gchar *
mime_icon_get_global_xml_file(const gchar *theme_name);
G_MODULE_EXPORT
gchar *
mime_icon_get_theme_path(const gchar *theme);


static xfmime_icon_functions *xfmime_icon_fun=NULL;

G_MODULE_EXPORT
const gchar *g_module_check_init(GModule *module){
    xfmime_icon_fun = g_new0 (xfmime_icon_functions,1);
    D(printf("g_module_check_init...\n");)
    if (!xfmime_icon_fun) return ("unable to create function structure");
    xfmime_icon_fun->mime_icon_find_pixmap_file =mime_icon_find_pixmap_file ;
    xfmime_icon_fun->mime_icon_get_iconset = mime_icon_get_iconset;
    xfmime_icon_fun->mime_icon_add_iconset = mime_icon_add_iconset;
    xfmime_icon_fun->mime_icon_load_theme = mime_icon_load_theme;
    xfmime_icon_fun->mime_icon_create_pixmap = mime_icon_create_pixmap;
    xfmime_icon_fun->mime_icon_create_pixbuf = mime_icon_create_pixbuf;
    xfmime_icon_fun->mime_icon_find_themes = mime_icon_find_themes;
    xfmime_icon_fun->mime_icon_get_local_xml_file = mime_icon_get_local_xml_file;
    xfmime_icon_fun->mime_icon_get_global_xml_file = mime_icon_get_global_xml_file;
    xfmime_icon_fun->mime_icon_get_theme_path = mime_icon_get_theme_path;
    return NULL;
}

G_MODULE_EXPORT
gchar *
mime_icon_get_local_xml_file(const gchar *theme_name){
    gchar *xdg_dir= xfce_resource_save_location (XFCE_RESOURCE_THEMES,"/",TRUE);
    gchar *n=g_build_filename(xdg_dir,theme_name,NULL); 
    gchar *mimefile=g_strconcat(n,".mime.xml",NULL);
    g_free(n);
    g_free(xdg_dir);
    return mimefile;
}


/* this checks for the existence of the xxx.mime.xml file, which associates
 * filenames with mimetypes... (may be created with xfmime-edit) */

/* FIXME: create a fallback xml file for iconname/mimetype association
 * (gnome-ish, probably) and use this as well as any user specified
 * file created with xfmime-edit. This is now possible with the xfce-icontheme
 * feature of trying several filenames for rendering an icon...
 * 
 * After doing this, xfmime-edit will probably be broken and need fixing.
 * */

static gboolean is_valid_theme_dir(gchar *theme_dir){
    gchar *b=g_path_get_basename(theme_dir);
    gchar *g=g_strconcat(PACKAGE_DATA_DIR,G_DIR_SEPARATOR_S,
	    "xfce4",G_DIR_SEPARATOR_S,"mime",G_DIR_SEPARATOR_S,
	    b,".mime.xml",NULL);
	/*printf("is_valid_theme_dir --->%s? \n",theme_dir);
	printf("is_valid_theme --->%s? \n",g);*/
    if (!g_file_test(theme_dir,G_FILE_TEST_IS_DIR)) return FALSE;
    if (g_file_test(g,G_FILE_TEST_EXISTS)){
        g_free(g);
	/*printf("is_valid_theme_dir --->%s? yes\n",g);*/
	return TRUE;
    } else {
	g_free(g);
	g=mime_icon_get_local_xml_file(theme_dir);
        if (g_file_test(g,G_FILE_TEST_EXISTS)){
	/*printf("is_valid_theme_dir --->%s? yes\n",g);*/
	  g_free(g); 
	  return TRUE;	   
        }
        g_free(g); 
    }
    return FALSE;
}

gchar *mime_icon_get_theme_path(const gchar *theme){
    gchar **p;
    gchar **sdirs;
    gchar *g=NULL;
    
    xfce_resource_push_path(XFCE_RESOURCE_ICONS, PACKAGE_DATA_DIR "/icons");
    sdirs = xfce_resource_dirs(XFCE_RESOURCE_ICONS);
    xfce_resource_pop_path(XFCE_RESOURCE_ICONS);
    
    /* literal name */
    D(printf("mime_icon_get_theme_path...%s\n",theme);)
    for (p=sdirs;*p;p++){
	g=g_build_filename(G_DIR_SEPARATOR_S,*p,theme,NULL);
    D(printf("mime_icon_get_theme_path...%s?\n",g);)
	if (g_file_test(g,G_FILE_TEST_IS_DIR)) {
	    goto done;
	}
	g_free(g); g=NULL;
    }
    
    /* literal name not found: is it a translated name? */
    
    D(printf("mime_icon_get_theme_path...2\n");)
    for (p=sdirs;*p;p++)
    {
        XfceRc *themefile;
        gchar *themeindex;
	const gchar *themename;
	GDir *dir;
	const gchar *file;
    D(printf("mime_icon_get_theme_path...2.0:%s\n",*p);)

	if (!g_file_test(*p,G_FILE_TEST_IS_DIR)) continue;
    
        dir = g_dir_open(*p, 0, NULL);
    D(printf("mime_icon_get_theme_path...2.1\n");)
        if(!dir) continue;

    D(printf("mime_icon_get_theme_path...%s\n",*p);)
        while((file = g_dir_read_name(dir)))
        {
            themeindex = g_build_path(G_DIR_SEPARATOR_S, *p, file, "index.theme", NULL);
            themefile = xfce_rc_simple_open(themeindex, TRUE);
            g_free(themeindex);
            if(!themefile) continue;

            xfce_rc_set_group(themefile, "Icon Theme");

            if(strcmp(xfce_rc_read_entry(themefile, "Hidden", "false"), "true") == 0)
            {
                xfce_rc_close(themefile);
                continue;
            }

            themename = xfce_rc_read_entry(themefile, "Name", file);
            xfce_rc_close(themefile);

	    if (themename && strcmp(themename,theme)==0){
		/* we got a hit */
		g = g_build_path(G_DIR_SEPARATOR_S, *p, file,  NULL);
		if (g_file_test(g,G_FILE_TEST_IS_DIR)) break;
		g_free(g); g=NULL;
	    }
        }
        g_dir_close(dir);
	if (g) break;
    }
done:
    g_strfreev(sdirs);  
    D(printf("mime_icon_get_global_xml_file...done\n");)
    return g;
}

static gchar **mime_icon_get_inherits(const gchar *theme){
    gchar *theme_path;
    gchar **inherits=NULL;

    theme_path=mime_icon_get_theme_path(theme);
    if (!theme) return NULL;
     
	DD(printf("DBG: inherit themepath=%s\n",theme_path);)
       
    /* inherited paths... */

    {
        XfceRc *themefile;
        gchar *themeindex;
          
	themeindex = g_build_path(G_DIR_SEPARATOR_S, theme_path, "index.theme", NULL);
        themefile = xfce_rc_simple_open(themeindex, TRUE);
        g_free(themeindex);
	if (themefile){
            xfce_rc_set_group(themefile, "Icon Theme");
	    inherits = xfce_rc_read_list_entry(themefile, "Inherits", ",");
	    xfce_rc_close(themefile);
        }
    }
    return inherits;
}


G_MODULE_EXPORT
char **
mime_icon_find_themes(gboolean only_valid,gboolean full_paths)
{
    char **dirs = NULL;
    GList *list = NULL, *li;
    gchar **p;
    gchar **sdirs;
    GDir *gdir;
    const char *file;
    int i, len;

    xfce_resource_push_path(XFCE_RESOURCE_ICONS, PACKAGE_DATA_DIR "/icons");
    sdirs= xfce_resource_dirs(XFCE_RESOURCE_ICONS);
    xfce_resource_pop_path(XFCE_RESOURCE_ICONS);

    for (p=sdirs;*p;p++){	
	gchar **q;

	/* we don't want to process "pixmaps" directories */
	if (strstr(*p,"pixmaps")) continue;
	    
	for(q=sdirs;q!=p;q++){
	    if (strcmp(*q,*p)==0) {
		goto skip_duplicate;
	    }
	}

     if ((gdir = g_dir_open(*p, 0, NULL)) != NULL) {
      while((file = g_dir_read_name(gdir))) {
		char *path = g_build_filename(*p, file, NULL);
		if (only_valid && !is_valid_theme_dir(path)){
		    g_free(path);
		    continue;
		} 
		if(!g_list_find_custom(list, file, (GCompareFunc) strcmp) && g_file_test(path, G_FILE_TEST_IS_DIR))
		{
		    if (!full_paths) list = g_list_append(list, g_strdup(file));
		    else list = g_list_append(list, g_strdup(path));
		}
		g_free(path);
      }
      g_dir_close(gdir);
    } 
skip_duplicate:;
   }
   if (!list) return NULL;
   
   len = g_list_length(list);
   dirs = g_new0(char *, len + 1);
   for(i = 0, li = list; li; li = li->next, i++) {
	/*printf("DBG:got %s\n",(char *)li->data);*/
	dirs[i] = (char *)li->data;
   }
   g_list_free(list);
   return dirs;
}  

static void clear_iconhash(gpointer key, gpointer value, gpointer user_data)
{
    if (key) g_free(key);
    if (value) g_free(value);
}



gchar*
mime_icon_find_pixmap_file                       (const gchar     *filename)
{    
  return (xfce_icon_theme_lookup (icon_theme, filename, 48));
}


static void start_element (GMarkupParseContext *context,
                          const gchar         *element_name,
                          const gchar        **attribute_names,
                          const gchar        **attribute_values,
                          gpointer             user_data,
                          GError             **error){
    int i;
    gchar *name=NULL,*icon=NULL;
      /*printf("start -> %s\n",element_name);*/
      /* here we should have the type and icon attributes set,
       * but they are not :-(
       * */
    if (strcmp(element_name,"mime-type")) return;
    if (attribute_names) {
	for (i=0;attribute_names[i];i++) 
	  if (attribute_names[0] && attribute_values[0]) 
	      name=g_strdup(attribute_values[0]);
	  if (attribute_names[1] && attribute_values[1]) 
	      icon=g_strdup(attribute_values[1]);
	  
          if (name && icon) {
		g_hash_table_insert(icon_hash, name, (gpointer) icon);
	      /*printf("hashing %s=%s\n",name,icon);*/
	  }
	  else if (name) {	      
#ifdef DEBUG
	      printf("no icon defined for %s\n",name);
#endif
	      g_free(name);
	  }

      }
      return;
  }


static void glib_parser(const gchar *mimefile){
  FILE *f;
  size_t l;
  gchar line[81];
  GMarkupParseContext *context; 
  GError *error=NULL; 
  GMarkupParser parser={
      start_element,
      NULL, 
      NULL, /*text_fun,*/
      NULL,
      NULL
  };
  gpointer user_data=NULL;
  context=g_markup_parse_context_new(&parser,0,user_data,NULL);
  f=fopen(mimefile,"r");
  if (!f){
      printf("sh*t, cannot open %s\n",mimefile);
      return;
  }
  while(!feof(f) && (l=fread(line,1,80,f))!=0) {
      line[l]=0;
      g_markup_parse_context_parse (context,line,l,&error);
  }
  fclose(f);
  
  g_markup_parse_context_free (context);
}

G_MODULE_EXPORT
gchar *
mime_icon_get_global_xml_file(const gchar *theme_name){
    gchar *themepath=NULL;
    gchar *mimefile=NULL;
    if (!theme_name) {
	g_warning("theme_name==NULL");
	return NULL;
    }
    D(printf("mime_icon_get_global_xml_file name...%s\n",theme_name);)
    themepath=mime_icon_get_theme_path(theme_name);
    if (themepath) {
	gchar *b=g_path_get_basename(themepath);
	mimefile=g_strconcat(PACKAGE_DATA_DIR,G_DIR_SEPARATOR_S,
	        "xfce4",G_DIR_SEPARATOR_S,"mime",G_DIR_SEPARATOR_S,
		 b,".mime.xml",NULL);
	g_free(b);
    }
     
    DD(printf("mime_icon_get_global_xml_file...3:%s\n",mimefile);)
   /* test for default mimefile (xfce distributed)  */
   if (!mimefile || !g_file_test(mimefile,G_FILE_TEST_EXISTS)) {
        gchar **inherits;
        gchar **p;
	
	DD(printf("DBG: global file %s not found\n",mimefile);)
        g_free(mimefile); mimefile=NULL;
	inherits = mime_icon_get_inherits(theme_name);
	/* test for inherited default mimefiles (xfce distributed) */
	for (p=inherits; p && *p; p++){
	    mimefile=g_strconcat(PACKAGE_DATA_DIR,G_DIR_SEPARATOR_S,
	        "xfce4",G_DIR_SEPARATOR_S,"mime",G_DIR_SEPARATOR_S,
		 *p,".mime.xml",NULL);
	    DD(printf("DBG: inherits file %s \n",mimefile);)
	    if (g_file_test(mimefile,G_FILE_TEST_EXISTS)) break;
	    g_free(mimefile); mimefile=NULL;
	}
	g_strfreev(inherits);  
	
   }
   if (!mimefile || access(mimefile,F_OK)!=0) {
        g_free(mimefile); mimefile=NULL;
	g_warning("No mime file found for theme %s\n",theme_name);
	return mime_icon_get_global_xml_file("hicolor");
   }	
    
   return mimefile;
}

static gboolean create_icon_hash(void){
    gchar *mimefile = NULL;

    theme_info_t *theme_info;  

    D(printf("create_icon_hash...\n");)

    /*g_free(icon_theme_name);*/

    
    icon_theme = xfce_icon_theme_get_for_screen(NULL);
    
    /* this should be the same theme as above */
#if GTK_CHECK_VERSION (2,4,0)
    g_object_get (gtk_settings_get_default(), "gtk-icon-theme-name", &icon_theme_name, NULL);
#else /* gtk < 2.4 */
    {
      GtkSettings *gsettings = gtk_settings_get_default ();
      g_object_get (G_OBJECT (gsettings), "gtk-icon-theme-name", &icon_theme_name, NULL);
    }
#endif
  

   /* test for user defined mimefile (via xfmime-edit)*/
   mimefile= mime_icon_get_local_xml_file(icon_theme_name);
    D(printf("create_icon_hash...%s\n",mimefile);)

   /* test for default mimefile (xfce distributed)  */
   if (!mimefile || !g_file_test(mimefile,G_FILE_TEST_EXISTS)) {
       g_free(mimefile);
	mimefile=mime_icon_get_global_xml_file(icon_theme_name);
   }
    D(printf("create_icon_hash...3\n");)
   
   if (!mimefile || !g_file_test(mimefile,G_FILE_TEST_EXISTS)) {
       g_warning("no mime theme found for %s",icon_theme_name);
       g_free(mimefile);
       return FALSE;
   }
   
    if (theme_hash==NULL) {
	    D(printf("DBG:creating new theme_hash...\n");)
	    theme_hash = g_hash_table_new(g_str_hash, g_str_equal);
    }
    D(printf("create_icon_hash...4\n");)

    theme_info = g_hash_table_lookup(theme_hash,icon_theme_name);
    if (!theme_info){
        D(printf("creating new icon hash and factory for %s\n",icon_theme_name);)
	theme_info = (theme_info_t *)malloc(sizeof(theme_info_t));
    	theme_info->icon_hash = icon_hash = g_hash_table_new(g_str_hash, g_str_equal);
    	theme_info->icon_factory = icon_factory = gtk_icon_factory_new();
	g_hash_table_insert(theme_hash, g_strdup(icon_theme_name), (gpointer) theme_info);	
    } 
    else {
	    icon_hash = theme_info->icon_hash;
	    icon_factory = theme_info->icon_factory;
	    g_free(mimefile);
	    return TRUE;
    }
    
    D(printf("create_icon_hash...5\n");)
    glib_parser(mimefile);
   
    g_free(mimefile);mimefile=NULL;
	    
    D(printf("DBG:theme_hash created!\n");)
    return TRUE;
}




/**********************************************************************************************/
G_MODULE_EXPORT
GdkPixbuf *mime_icon_create_pixbuf                          (const gchar     *filename)
{
  if (!filename || !filename[0]) return NULL;

  /*if (strstr(filename,"directory"))printf("dbg: lookup(%s)=%s\n",filename,xfce_icon_theme_lookup (icon_theme, filename, 48));*/
  return xfce_icon_theme_load(icon_theme, filename,48);
}

G_MODULE_EXPORT
GtkWidget *mime_icon_create_pixmap (GtkWidget *widget, const gchar     *filename)
{
  gchar *pathname = NULL;
  GtkWidget *pixmap;

  if (!filename || !filename[0]) return gtk_image_new ();
  /*if (strstr(filename,"directory"))printf("dbg: lookup(%s)=%s\n",filename,xfce_icon_theme_lookup (icon_theme, filename, 48));*/
  pathname = xfce_icon_theme_lookup (icon_theme, filename, 48);
  

  if (!pathname)
    {
#ifdef DEBUG
      g_warning ("Couldn't find pixmap file: %s", filename);
#endif
      return gtk_image_new ();
    }
  pixmap = gtk_image_new_from_file (pathname);
  g_free (pathname);
  if (!pixmap) {
      g_warning("FIXME: this should not happen (gtk<2.4 and no libsvg");
      return gtk_image_new ();
  }
  return pixmap;
}

G_MODULE_EXPORT
GtkIconSet *mime_icon_get_iconset(const gchar *id, GtkWidget *main_window){
    GtkIconSet *icon_set;
    gchar *iconfile;
    GdkPixbuf *pixbuf;
    gchar *gg=NULL;

#ifdef DEBUG
    printf("looking for %s in theme\n",id);
#endif
    if (!id || !strlen(id)) return NULL;

    if (!icon_hash) {
	if (!create_icon_hash()) {
	   g_error("!create_icon_hash()");
	   return NULL;
	}
    }
    icon_set = gtk_icon_factory_lookup(icon_factory, id);
    if (icon_set) return icon_set;

    /* is the id an actual path? (custom icons) */
    if (access(id,F_OK)==0) iconfile=(gchar *)id;
    else iconfile=g_hash_table_lookup(icon_hash,id);
    if (!iconfile || !strlen(iconfile)) {
	    if (strchr(id,'/')){
		    gchar *g=g_strdup(id);
		    *(strchr(g,'/'))=0;
		    gg=g_strconcat(g,"/default",NULL);
		    g_free(g);
    		    icon_set = gtk_icon_factory_lookup(icon_factory, gg);
		    if (icon_set){
			    g_free(gg);
			    return icon_set;
		    }
		    iconfile=g_hash_table_lookup(icon_hash,gg);
	    }
    }
    if (!iconfile || !strlen(iconfile)) return NULL;
#ifdef DEBUG
    printf("DBG:adding icon to iconfactory: %s->%s\n",id,iconfile);
#endif

    if(strncmp("gtk-", iconfile, strlen("gtk-")) == 0){
#ifdef DEBUG
    	printf("DBG:rendering icon %s...\n",iconfile);
#endif
 	pixbuf = gtk_widget_render_icon(main_window, iconfile, GTK_ICON_SIZE_DIALOG, NULL);
#ifdef DEBUG
    	printf("DBG: %s rendered.\n",iconfile);
#endif
    }
    else {
	/* full path specified? (as in custom icons) */    
	if (access(id,F_OK)==0) {
	   GError *error=NULL;
	   pixbuf = gdk_pixbuf_new_from_file (id, &error);
	   if (error) g_error_free(error);
	   if (!pixbuf) return NULL;
	}
	else {
	    pixbuf=mime_icon_create_pixbuf(iconfile);
	}
    }
	
    if (!pixbuf) return NULL;
    icon_set = gtk_icon_set_new_from_pixbuf(pixbuf);
    /*gtk_icon_set_ref (icon_set);*/


    if (!icon_set) return NULL;
    if (gg) {
	    gtk_icon_factory_add(icon_factory, gg, icon_set);
	    g_free(gg);
    } else gtk_icon_factory_add(icon_factory, id, icon_set);
    g_object_unref (G_OBJECT (pixbuf));
    return icon_set; 
}

G_MODULE_EXPORT
void mime_icon_add_iconset(const gchar *tag, GtkIconSet *icon_set){
	gtk_icon_factory_add(icon_factory, tag, icon_set);
}

void g_module_unload(GModule *module){
	/* hmm... this really does not free up the resident memory... */
	if (icon_hash){
	   g_hash_table_foreach(icon_hash, clear_iconhash, NULL);
           g_hash_table_destroy(icon_hash);
   	   icon_hash=NULL;
	}
	gtk_icon_factory_remove_default (icon_factory);
	if (xfmime_icon_fun) g_free(xfmime_icon_fun);
	xfmime_icon_fun=NULL;
}

G_MODULE_EXPORT
GHashTable * mime_icon_load_theme(void){
    gboolean r;
    D(printf("mime_icon_load_theme...\n");)
    r=create_icon_hash();
    if (r) return icon_hash;
    g_warning("cannot create icon_hash");
    return NULL;
}

G_MODULE_EXPORT
xfmime_icon_functions *module_init(void){
    return xfmime_icon_fun;
}

#endif
