/*
 * Copyright (C) 2003-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define SPLIT_VIEW
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#define __TREEVIEW_C__

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>
#include <grp.h>
#include <pwd.h>
#include <dirent.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_main_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "basic_row.h"
#include "basic_colours.h"

#include "modules.h"

#include "treeview.h"

#include "misc.h"
#include "menu.h"
#include "menu_callbacks.h"
#include "callbacks.h"
#include "dnd.h"
#include "entry.h"
#include "filter.h"
#include "icons.h"
#include "monitor.h"
#include "options.h"
#include "refresh.h"
#include "settings.h"
#include "treestore.h"
#include "widgets.h"
#include "libs/input.h"
#include "print.h"
#include "run.h"
#include "remove.h"
#include "keybindings.h"
#include "easy.h"
#include "xfstab.h"

/*XXX funky smartbutton for column (alpha):*/
#include "toolbar.h"


#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define LOCAL_OVERRIDE_MASK (SHOW_MM|SHOW_TB1|SHOW_TB2|SHOW_F|SHOW_TITLES|RSH_X_SSH|RSYNC_X_SCP)



extern gchar *bookfile;


/* keep order the same as defined for enum at libs/types.h: */
G_MODULE_EXPORT
root_t root[] = {
	{ROOT_BOOKMARKS, "/xfbook", N_("Book"), __BOOKMARK_TYPE},
	{ROOT_FILES, "/xftree4", N_("Local"), __LOCAL_TYPE},
#ifdef USE_SMB_BRANCH
	{ROOT_NETWORK, "/xfsamba4", N_("SMB Network"), __NETWORK_TYPE},
#endif
	{ROOT_FIND, "/xfglob4", N_("Find"), __FIND_TYPE},
	{ROOT_TRASH, "/xftrash4", N_("Trash"), __TRASH_TYPE},
	{ROOT_RECENT, "/xfrecent", N_("Recent"), __RECENT_TYPE},
	{ROOT_FREQUENT, "/xffrequent", N_("Frequent"), __FREQUENT_TYPE}
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
     	,{ROOT_FSTAB, "/xffstab", N_("Fstab"), __FSTAB_TYPE}
#endif
};

G_MODULE_EXPORT
void menu_detach(void)
{
    /*printf ("dbg:menu_detach()\n"); */
}




static gboolean null_motion(GtkWidget * widget, GdkDragContext * dc, gint x, gint y, guint t, gpointer data)
{
    /*print_status(NULL, NULL);*/
    return FALSE;
}

G_MODULE_EXPORT
void create_root_element(GtkTreeView * treeview, GtkTreeIter *iterator,
		int i,const gchar *home){
    tree_entry_t *en;
    /*gint tree_id = get_tree_id(treeview);*/
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    
	const gchar *name;
    	gchar *tag;
	if(i == ROOT_FILES)
	{
	    if (!home) home=g_get_home_dir();	
	    if((en = stat_entry((char *)home, 0)) == NULL) assert_not_reached();
	    SET_LOCAL_TYPE(en->type);


	}
	else
	{
	    if((en = mk_entry(0)) == NULL) assert_not_reached();
	    en->type |= (root[i].type);	/* hack */
	}
	SET_ROOT_TYPE(en->type);
	if (tree_details->preferences & IMAGE_PREVIEW) 
		SET_SHOWS_IMAGES(en->type);
	if (tree_details->preferences & SHOW_DOT) 
		SET_SHOWS_HIDDEN(en->type);
	if (en->tag) {
		g_free(en->tag);
		en->tag = NULL;
	}
	tag = g_strdup(my_utf_string(_(root[i].label)));
	
	gtk_tree_store_append((GtkTreeStore *) treemodel, iterator, NULL);
	if(i == ROOT_FILES)
	{
	    name = FILENAME(en);
#ifdef DEBUG
	    printf("DBG: root name is %s (%s)\n",name,en->path);
#endif
	    en->count = -1;
	    set_row_colours(treemodel, iterator, NULL,DIR_COLOR);
	}
	else if(i == ROOT_BOOKMARKS && bookfile)
	{
	    name = my_utf_string((const gchar *)bookfile);
	    /* this is bugged: en->path=g_strdup(bookfile);
	     * en->path for bookmarks operations should not be used in other modules
	     * to eliminate this bug */
	    en->path = g_strdup(_(root[i].path));	    
	}
	else 
	{
	    name = tag;
	    en->path = g_strdup(_(root[i].path));
	}
	/* icon size set by config-file */
/* FIXME: should be "basic" function:*/
	gtk_tree_store_set((GtkTreeStore *) treemodel, iterator, 
			ENTRY_COLUMN, en, 
			NAME_COLUMN, g_strdup(name), 
			MODE_COLUMN, g_strdup(""), 
			DATE_COLUMN, g_strdup(""), 
			GROUP_COLUMN, g_strdup(""), 
			OWNER_COLUMN, g_strdup(""), 
			SIZE_COLUMN, g_strdup(""), 
	-1);
	set_icon(treemodel, iterator);
	insert_dummy_row(treemodel, iterator,NULL,en,NULL,NULL);
	switch (i)
	{
	    case ROOT_FILES:
		update_row(treemodel, iterator, NULL, en);
		break;
	    case ROOT_FIND:
		reset_dummy_row(treemodel, iterator,NULL,en,"xfce/info",_("Nothing searched"));
		break;
	    default:
		break;
	}
	g_free(tag);tag=NULL;
}

static void add_roots(GtkTreeView * treeview, char *home)
{
    int i;
    GtkTreeIter iter;
    treestuff_t *treestuff=get_treestuff(treeview);
    
    for(i = 0; i < ROOT_TAGS; i++)
    {
	gboolean will_show;
	switch(i){
	  case ROOT_BOOKMARKS:
	        will_show=treestuff->preferences & ACTIVATE_BOOK;
		break;
	  case ROOT_FILES:
	        will_show=(treestuff->preferences & ACTIVATE_LOCAL) || home!=NULL;
		break;
#ifdef USE_SMB_BRANCH
	  case ROOT_NETWORK:
	        will_show=treestuff->preferences & ACTIVATE_SMB;
		break;
#endif
	  case ROOT_FIND:
		will_show=FALSE;
		break;
	  case ROOT_TRASH:
	        will_show=treestuff->preferences & ACTIVATE_TRASH;
		break;
	  case ROOT_RECENT:
	        will_show=treestuff->preferences & ACTIVATE_RECENT;
		break;
	  case ROOT_FREQUENT:
	        will_show=treestuff->preferences & ACTIVATE_FREQUENT;
		break;
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
	  case ROOT_FSTAB:
	        will_show=treestuff->preferences & ACTIVATE_FSTAB;
		break;
#endif
	  default:
		will_show=TRUE;
		break;
	}
	if (will_show) {
#ifdef DEBUG
	    printf("DBG:will_show 0x%x\n",i);
#endif	    
	    create_root_element(treeview,&iter,i,home);
	}
    }
    return;
}

/***********  treeview ******************/
typedef struct menu_checks_t
{
    unsigned flag;
    char *name;
}
menu_checks_t;



static void insert_arrows(GtkTreeViewColumn *column, gboolean showup, gboolean showdown){
    GtkWidget *w = column->button;
    GtkWidget *box = gtk_bin_get_child(GTK_BIN(w));
    GtkWidget *arrow;
    arrow=gtk_arrow_new (GTK_ARROW_DOWN,GTK_SHADOW_NONE);
    g_object_set_data(G_OBJECT(column), "down", (gpointer) arrow);
    gtk_box_pack_start (GTK_BOX (box), arrow, FALSE, FALSE, 0);
    if (showdown) gtk_widget_show(arrow);
    arrow=gtk_arrow_new (GTK_ARROW_UP,GTK_SHADOW_NONE);
    g_object_set_data(G_OBJECT(column), "up", (gpointer) arrow);
    gtk_box_pack_start (GTK_BOX (box), arrow, FALSE, FALSE, 0);
    if (showup) gtk_widget_show(arrow);
}

static void insert_column_icon(GtkTreeViewColumn *column, const gchar *name){
  GdkPixbuf *src=NULL;
  GtkWidget *w = column->button;
  GtkWidget *box = gtk_bin_get_child(GTK_BIN(w));
  if (!name || !strlen(name)) return;
  src=MIME_ICON_create_pixbuf(name);
  if (src){
    GdkPixbuf *tgt = gdk_pixbuf_scale_simple(src, 18,18, GDK_INTERP_BILINEAR);
    GtkWidget *image = gtk_image_new_from_pixbuf (tgt);
    g_object_unref(src);
    g_object_unref(tgt);
    if (image) {
      GList *t,*tmp;
      gtk_widget_show(image);
      t=gtk_container_get_children(GTK_CONTAINER(box));
      for (tmp=t;tmp;tmp=tmp->next) {
	  GtkWidget *v=(GtkWidget *)tmp->data;
	  gtk_box_set_child_packing (GTK_BOX (box), v,FALSE,FALSE,0,GTK_PACK_START);
      }
      g_list_free(t);
      gtk_box_pack_start (GTK_BOX (box), image, FALSE, FALSE, 0);
      /*  gtk_box_reorder_child (GTK_BOX (box),image,0);*/
    }
  }
}


/* this is a flag to turn off sorting until all row of a node have
 * been added, so that a single sort is performed. This speeds things up.
 * Currently the value is set an unset in callbacks.c
 * */
G_MODULE_EXPORT
gboolean no_sorting=FALSE;
G_MODULE_EXPORT
gint IterCompareFunc(GtkTreeModel *treemodel, GtkTreeIter *a,GtkTreeIter *b, gpointer user_data){
    int caso=(int)((long)user_data);
    tree_entry_t *en_a;
    tree_entry_t *en_b;
    gtk_tree_model_get(treemodel, a, ENTRY_COLUMN, &en_a, -1);
    gtk_tree_model_get(treemodel, b, ENTRY_COLUMN, &en_b, -1);
    
    /*gboolean subsort = (gboolean)((long)user_data);*/

    if (no_sorting) return 0;
    return (entry_compare(caso,en_a,en_b));
}


static GtkTreeView *create_treeview(char *path,gint tree_id)
{
    int i;
    GtkCellRenderer *cell;
    gchar *d_path=NULL;
    GtkTreeViewColumn *column;
    GtkTreeModel *treemodel;
    GtkTreeView *treeview;
    GtkTreeSortable *sortable;
    GtkTreeSelection *selection;
    treestuff_t *treestuff = (tree_details->treestuff)+tree_id;
    
    if(path && g_file_test(path,G_FILE_TEST_IS_DIR)) d_path=g_strdup(path);     

    /* create treemodel: */
    treemodel = treestuff->treemodel = GTK_TREE_MODEL(create_treestore());
    /* get treesortable */
    sortable = treestuff->sortable = GTK_TREE_SORTABLE((GtkTreeStore *)treestuff->treemodel);
    /* create treeview */
    treeview = treestuff->treeview = GTK_TREE_VIEW(gtk_tree_view_new_with_model(treestuff->treemodel));
    /* get selection */
    selection = treestuff->selection = GTK_TREE_SELECTION(gtk_tree_view_get_selection(treestuff->treeview));
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);

    /* twice?, yes. It will set colors for treemodel, should be done 
     * for each treemodel */
     
    g_timeout_add_full(0, 2000, (GtkFunction) set_treeview_colours, treeview, NULL);


    /* empty margin column. Do not remove */
    column = gtk_tree_view_column_new();
    cell = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, "text", EMPTY_COLUMN,  NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
    gtk_tree_view_column_set_clickable(column, TRUE);
    g_signal_connect ((gpointer) (column->button), "button_press_event", G_CALLBACK (column_button_press_event), (gpointer)((long)tree_id));
    g_signal_connect(G_OBJECT(column), "clicked", G_CALLBACK(titles_off), NULL);
    
    {
	  GtkWidget *arrow=gtk_arrow_new (GTK_ARROW_DOWN,GTK_SHADOW_NONE);
	  GtkWidget *w=column->button;
    	  GtkWidget *box = gtk_bin_get_child(GTK_BIN(w));
	  GtkTooltips *tooltips=(GtkTooltips *)WIDGET("tooltips");

	  gtk_box_pack_start (GTK_BOX (box), arrow, TRUE, TRUE, 0);
	  gtk_widget_show(arrow);
	  gtk_widget_set_size_request (w, 13, 0);
	  GTK_WIDGET_UNSET_FLAGS (w, GTK_CAN_FOCUS);
	  gtk_tooltips_set_tip (tooltips, w, _("Hide"), NULL);
    }
    
    /* XXX autosize columns must be set until after rendering window...
     * (gtk 2.2.4 bug) so they are set at main.c ...*/
    /* expander column.  */
    column = 
	tree_details->treestuff[tree_id].column[PIXBUF_COLUMN] = gtk_tree_view_column_new();
    cell = gtk_cell_renderer_pixbuf_new();

    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "pixbuf", PIXBUF_COLUMN, 
		    "pixbuf_expander_closed", PIXBUF_COLUMN, 
		    "pixbuf_expander_open", PIXBUF_COLUMN, 
		    NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
    gtk_tree_view_column_set_clickable(column, TRUE);
    g_signal_connect(column, "clicked", G_CALLBACK(on_treeview_column_click),(gpointer)((long)tree_id));
    /*g_signal_connect(column, "clicked", G_CALLBACK(on_column_click),(gpointer)(treeview));*/
    g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID)));
    

    gtk_tree_view_set_expander_column(treeview, column);
    /* XXX alpha code: must put in proper place */
    {
	smart_button_init_t button_info[]={
#if 0
      {"c-time",N_("Show dates"),sb_show_date,"sb_show_date",NULL,NULL},
      {"c-size",N_("Show sizes"),sb_show_size,"sb_show_size",NULL,NULL},
      {"c-uid",N_("Show owner"),sb_show_owner,"sb_show_owner",NULL,NULL},
      {"c-gid",N_("Show group"),sb_show_group,"sb_show_group",NULL,NULL},
      {"c-mode",N_("Show permissions"),sb_show_mode,"sb_show_mode",NULL,NULL},
      {"-",NULL,NULL,NULL,NULL,NULL},
      {"-",NULL,NULL,NULL,NULL,NULL},
      {"-",NULL,NULL,NULL,NULL,NULL},
#endif
      {"xfce/b-fstab",N_("Fstab"),sb_toggle_fstab,"sb_toggle_fstab",NULL,NULL},
      {"xfce/b-book",N_("Book"),sb_toggle_book,"sb_toggle_book",NULL,NULL},
#ifdef USE_SMB_BRANCH
      {"xfce/b-network",N_("SMB Network"),sb_toggle_smb,"sb_toggle_smb",NULL,NULL},
#endif
      {"xfce/b-recent",N_("Recent"),sb_toggle_recent,"sb_toggle_recent",NULL,NULL},
      {"xfce/b-frequent",N_("Frequent"),sb_toggle_frequent,"sb_toggle_frequent",NULL,NULL},
      {"xfce/b-trash",N_("Trash"),sb_toggle_trash,"sb_toggle_trash",NULL,NULL},
      {"xfce/go-home",N_("Local"),sb_toggle_win,"sb_toggle_win",NULL,NULL},
      {NULL,NULL,NULL,NULL,NULL,NULL}
	};
	gchar *funky_name=g_strdup_printf("funky-%d",tree_id);
	mk_smart_button(button_info,funky_name,&(column->button));
    }
    /* end alpha code */

    /* create the label column */
    column = 
	tree_details->treestuff[tree_id].column[NAME_COLUMN] = gtk_tree_view_column_new();
    gtk_tree_view_column_set_reorderable(column, FALSE);
    gtk_tree_view_column_set_spacing(column,2);


    cell = gtk_cell_renderer_text_new();
    /*g_object_set (G_OBJECT (cell), "editable",TRUE,NULL); */
    g_signal_connect (G_OBJECT (cell), "edited",
		      G_CALLBACK (easy_rename), (gpointer)treeview);
    
    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "style", STYLE_COLUMN, 
		    "font-desc", FONT_COLUMN, 
		    "text", NAME_COLUMN,
		    "editable", EDITABLE_COLUMN, 
		    "foreground-gdk", COLOUR_COLUMN,
		    /*"weight", WEIGHT_COLUMN,*/
		    NULL);

    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);

    if (tree_details->preferences & TEXT_HEADERS) gtk_tree_view_column_set_title(column, my_utf_string(_("Name")));
    else insert_column_icon(column,"xfce/c-name");
    gtk_tree_view_column_set_clickable(column, TRUE);
    g_signal_connect ((gpointer) (column->button), "button_press_event", G_CALLBACK (column_button_press_event), (gpointer)((long)tree_id));
    g_signal_connect(column, "clicked", G_CALLBACK(on_treeview_column_click),(gpointer)((long)tree_id));
    g_signal_connect(G_OBJECT (column), "clicked", G_CALLBACK(on_column_click), (gpointer)(treeview));
    g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(NAME_COLUMN)));
    insert_arrows(column,FALSE,FALSE);


    for(i = SIZE_COLUMN; i < TREE_COLUMNS; i++)
    {
	const gchar *iname=NULL;
	cell = gtk_cell_renderer_text_new();
	g_object_set(G_OBJECT(cell), "editable", FALSE, NULL);
	column = 
	    gtk_tree_view_column_new();
	gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_GROW_ONLY);
	gtk_tree_view_column_set_resizable(column, TRUE);
	/* seems like a gtk bug while reordering (sometimes):
	 * Gtk-CRITICAL **: file gtktreeview.c: line 8647 (gtk_tree_view_move_column_after): assertion `base_el != NULL' failed */
	/*gtk_tree_view_column_set_reorderable(column, TRUE);*/

	gtk_tree_view_column_pack_start(column, cell, FALSE);
        g_signal_connect(column, "clicked", G_CALLBACK(on_treeview_column_click),(gpointer)((long)tree_id));
	switch (i)
	{
	    case SIZE_COLUMN:
		/*texto = _("Size");*/
		iname = (tree_details->preferences & TEXT_HEADERS)?_("Size"):"xfce/c-size";
		g_signal_connect(column, "clicked", G_CALLBACK(on_column_click),(gpointer)treeview );
		g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(SIZE_COLUMN)));
		tree_details->treestuff[tree_id].column[SIZE_COLUMN] = column;
		break;
	    case DATE_COLUMN:
		iname = (tree_details->preferences & TEXT_HEADERS)?_("Date"):"xfce/c-time";
		/*texto = _("Date");*/
		g_signal_connect(column, "clicked", G_CALLBACK(on_column_click), (gpointer)treeview);
		g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(DATE_COLUMN)));
		tree_details->treestuff[tree_id].column[DATE_COLUMN] = column;
		break;
	    case OWNER_COLUMN:
		iname = (tree_details->preferences & TEXT_HEADERS)?_("Owner"):"xfce/c-uid";
		/*texto = _("Owner");*/
		g_signal_connect(column, "clicked", G_CALLBACK(on_column_click),(gpointer)treeview);
		g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(OWNER_COLUMN)));
		tree_details->treestuff[tree_id].column[OWNER_COLUMN] = column;
		g_object_set (G_OBJECT (cell), "editable",TRUE,NULL); 
		g_signal_connect (G_OBJECT (cell), "edited",
		      G_CALLBACK (easy_chown), (gpointer)treeview);	
		break;
	    case GROUP_COLUMN:
		iname = (tree_details->preferences & TEXT_HEADERS)?_("Group"):"xfce/c-gid";
		/*texto = _("Group");*/
		g_signal_connect(column, "clicked", G_CALLBACK(on_column_click),(gpointer)treeview);
		g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(GROUP_COLUMN)));
		tree_details->treestuff[tree_id].column[GROUP_COLUMN] = column;
		g_object_set (G_OBJECT (cell), "editable",TRUE,NULL); 
		g_signal_connect (G_OBJECT (cell), "edited",
		      G_CALLBACK (easy_chgrp), (gpointer)treeview);	
		break;
	    case MODE_COLUMN:
		iname = (tree_details->preferences & TEXT_HEADERS)?_("Mode"):"xfce/c-mode";
		/*texto = _("Mode");*/
		tree_details->treestuff[tree_id].column[MODE_COLUMN] = column;
		g_signal_connect(column, "clicked", G_CALLBACK(on_column_click),(gpointer)treeview);
		g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(MODE_COLUMN)));
		g_object_set (G_OBJECT (cell), "editable",TRUE,NULL); 
		g_signal_connect (G_OBJECT (cell), "edited",
		      G_CALLBACK (easy_remode), (gpointer)treeview);	
		break;
	    default:
		iname = NULL;
	}
	
	if (i!=SIZE_COLUMN && i!=DATE_COLUMN) {
	   gtk_tree_view_column_set_attributes(column, cell,  
			"font-desc", SFONT_COLUMN, 
		        "foreground-gdk", COLOUR_COLUMN,
			"text", i, 
			"editable", EDITABLE_COLUMN, 
			NULL);
	} else {
	   gtk_tree_view_column_set_attributes(column, cell,  
			"font-desc", SFONT_COLUMN, 
		        "foreground-gdk", COLOUR_COLUMN,
			"text", i, 
			NULL);	    
	}
	
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
	gtk_tree_view_column_set_clickable(column, i);
	g_signal_connect ((gpointer) (column->button), "button_press_event", G_CALLBACK (column_button_press_event), (gpointer)((long)tree_id));
	if (iname){
	  if (tree_details->preferences & TEXT_HEADERS) gtk_tree_view_column_set_title(column, my_utf_string(iname));
	  else insert_column_icon(column,iname);
	}
	insert_arrows(column,FALSE,FALSE);
	gtk_tree_sortable_set_sort_func(sortable,i,IterCompareFunc,(gpointer)((long)i),NULL);

    }
    gtk_tree_sortable_set_sort_func(sortable,NAME_COLUMN,IterCompareFunc,(gpointer)((long)NAME_COLUMN),NULL);
    gtk_tree_sortable_set_default_sort_func(sortable,IterCompareFunc,(gpointer)((long)GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID),NULL);
    /* we change this to GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID just before
     * entering gtk_main() to force a sort in main.c */
    gtk_tree_sortable_set_sort_column_id (sortable,NAME_COLUMN,GTK_SORT_ASCENDING);
    
    gtk_widget_show(GTK_WIDGET(treeview));
        
    /* XXX: this is only good for current names defined in glade */
    {
	gchar *g;
	g=g_strdup_printf("treeview_scroll%d",tree_id);
	gtk_container_add(GTK_CONTAINER(WIDGET(g)), GTK_WIDGET(treeview));
	g_free(g);
    }

    g_signal_connect_object(treeview, "row-expanded", G_CALLBACK(open_dir), treeview, 0);
    g_signal_connect_object(treeview, "row-collapsed", G_CALLBACK(close_dir), treeview, 0);


    /*g_signal_connect(treeview, "motion-notify-event", G_CALLBACK(on_mouse_move), treeview);*/
    g_signal_connect(treeview, "button-press-event", G_CALLBACK(treeclick), treeview);
/* g_signal_connect works better than g_signal_connect_object, sometimes */
    g_signal_connect_object(treeview, "button-release-event", 
		    G_CALLBACK(button_releaseF), treeview, G_CONNECT_AFTER);

#ifdef DEBUG
    printf("************dpath is %s\n",d_path);
#endif
    add_roots(treeview, d_path);
    g_signal_connect(treeview, "key-press-event", G_CALLBACK(treeview_key), NULL);    
    g_free(d_path);
    return treeview;
}

/* if it fails to set directory, it goes to root,
 * if no directory is given in argv, it goes to home */
G_MODULE_EXPORT
GtkTreeView *init_xffm(int argc, char *argv[])
{
    int i;
    gchar *startup=NULL;
    GtkTreeView *treeview;
#ifdef DEBUG
    printf("DBG:tree_details->argv[0]=%s\n",tree_details->argv[0]);
#endif
    if((strstr(tree_details->argv[0],"xffm") || strstr(tree_details->argv[0],"xftree"))&& argc >= 2)
    {				/* if it fails it goes to root. */
	if(argv[1][0] == '/')
	    startup = g_strdup(argv[1]);
	else
	{
	    gchar *wd = g_get_current_dir ();
	    startup = g_strconcat(wd, G_DIR_SEPARATOR_S,argv[1],NULL);
	    g_free(wd);
	    if (!g_file_test(startup,G_FILE_TEST_IS_DIR)){
		g_free(startup);
		startup=g_build_filename(g_get_home_dir(),argv[1],NULL);	
		if (!g_file_test(startup,G_FILE_TEST_IS_DIR)){
		    g_free(startup);
		    startup=NULL;
		}
	    }
	}
    }
#ifdef DEBUG
    printf("startup is %s\n",((startup)?startup:"NULL"));
#endif
    chdir(g_get_tmp_dir());

    parse_colours();
    /* set in settings... tree_details->theme =  NULL;*/
    


    if((tree_details->window = create_xffm()) == NULL)	assert_not_reached();
    /*XXX: this should be removed when the glade code generation 
     * is removed (if ever)*/
    g_signal_connect(G_OBJECT(tree_details->window), 
		    "destroy_event", G_CALLBACK(on_xffm_destroy_event), (gpointer) tree_details);
    g_signal_connect(G_OBJECT(tree_details->window), 
		    "delete_event", G_CALLBACK(on_xffm_delete_event), (gpointer) tree_details);
    hideit(tree_details->window, "item22");
    hide_text(tree_details->window);
    hideit(tree_details->window, "stop");
    hideit(tree_details->window, "input_box");
    /* XXX does this "activates-default" do anything??? */
    g_object_set(G_OBJECT (WIDGET("combo_entry2")), "activates-default", TRUE, NULL);
    g_object_set(G_OBJECT (WIDGET("input_entry")), "activates-default", TRUE, NULL);
    {
	int i;
	/* NOTICE: keep names[] order in sync with on_sort_activate() 
	 * at libs/refresh.c */
	char *names[] = { "show_hidden1","preview_images1", NULL};
	for(i = 0; names[i]; i++){
	    g_signal_connect(G_OBJECT(WIDGET(names[i])), "activate", 
			    GTK_SIGNAL_FUNC(on_sort_activate), (gpointer) ((long)i));
	}
    }

   
    /*if (!startup) startup=g_strdup(GETWD);*/

    for (i=0;i<TREECOUNT;i++) {
      treestuff_t *treestuff = (tree_details->treestuff)+i;	
      treestuff->gogo = (golist *) malloc(sizeof(golist));
      if (!treestuff->gogo) assert_not_reached();
      treestuff->gogo->next = treestuff->gogo->previous = NULL;
      if (startup && strlen(startup)) treestuff->gogo->path = g_strdup(startup);
      else treestuff->gogo->path = g_strdup(g_get_home_dir());

      treeview = treestuff->treeview = create_treeview(startup,i);
      /*printf("DBG: treeview is 0x%x\n",treeview);*/
      setup_drag_signal(treestuff->treeview);
      apply_view(treestuff->treeview);
    }
    g_free(startup);startup=NULL;

    /* FIXME: set_title(treeview, &d_path);*/
   {
	GtkWidget *menu;
	menu = WIDGET("item22_menu");
	gtk_menu_detach((GtkMenu *) menu);
	gtk_menu_attach_to_widget(GTK_MENU(menu), (GtkWidget *) treeview, 
			(GtkMenuDetachFunc) menu_detach);
    }
    
    

    gtk_combo_set_case_sensitive(GTK_COMBO(WIDGET("input_combo")), TRUE);
    gtk_combo_set_case_sensitive(GTK_COMBO(WIDGET("filter_combo")), TRUE);
    tree_details->loading = FALSE;

    {				/* status should not accept drops nor input */
	GtkWidget *w;

	w = WIDGET("status");
	g_signal_connect(G_OBJECT(w), "drag_motion", G_CALLBACK(null_motion), NULL);
	gtk_text_view_set_editable((GtkTextView *) w, FALSE);
    }

    {
	char *shows[]={
	    "show_tb1",
#ifdef USE_TOOLBAR_PANEL
	    "show_tb2",
#endif
#ifdef USE_FILTER_BAR
	    "show_f",
#endif
	    "show_titles",
	    NULL};
	char *hides[]={
	    "hide_tb1",
#ifdef USE_TOOLBAR_PANEL
	    "hide_tb2",
#endif
#ifdef USE_FILTER_BAR
	    "hide_f",
#endif
	    NULL};
	char **wnames[]={shows,hides};
	int i,j;
	for (j=0;j<2;j++) for (i=0;wnames[j][i];i++){
	  GtkWidget *arrow;
	  GtkWidget *w=WIDGET(wnames[j][i]);
    	  GtkWidget *l = gtk_bin_get_child(GTK_BIN(w));
	  if (j) arrow=gtk_arrow_new (GTK_ARROW_DOWN,GTK_SHADOW_NONE);
	  else arrow=gtk_arrow_new (GTK_ARROW_RIGHT,GTK_SHADOW_NONE);
	  /* remove empty labels */
	  if (l) gtk_container_remove((GtkContainer *)w, l);
	  gtk_container_add ((GtkContainer *)w,arrow);
	  gtk_widget_show(arrow);
	} 
    }

    g_signal_connect(G_OBJECT(WIDGET("show_tb1")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TB1));
    g_signal_connect(G_OBJECT(WIDGET("hide_tb1")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TB1));

#ifdef USE_TOOLBAR_PANEL
    g_signal_connect(G_OBJECT(WIDGET("show_tb2")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TB2));
    g_signal_connect(G_OBJECT(WIDGET("hide_tb2")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TB2));
#endif

#ifdef USE_FILTER_BAR
   g_signal_connect(G_OBJECT(WIDGET("show_f")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_F));
    g_signal_connect(G_OBJECT(WIDGET("hide_f")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_F));
#endif

    g_signal_connect(G_OBJECT(WIDGET("show_titles")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TITLES));

    {
  	GdkPixbuf *xffm_icon_pixbuf;
  	xffm_icon_pixbuf = MIME_ICON_create_pixbuf ("xffm_icon.xpm");
  	if (xffm_icon_pixbuf)
    	{
      		gtk_window_set_icon (GTK_WINDOW (tree_details->window), 
				xffm_icon_pixbuf);
      		g_object_unref (G_OBJECT(xffm_icon_pixbuf));
   	}
	else g_warning("cannot create application icon");
    }


    gtk_widget_grab_focus((GtkWidget *) (tree_details->treestuff[get_active_tree_id()].treeview));
    
    set_filter_combo();

    gtk_window_set_default_size(GTK_WINDOW(tree_details->window), tree_details->geometryX, tree_details->geometryY);

    /* gtk_window_set_default_size() *must* come before gtk_widget_realize() */
    gtk_widget_realize(tree_details->window);

   
   /* local_monitor will monitor all treeviews...*/ 
      local_monitor(FALSE);

    
   D(printf("---------------here8\n"); )
    recreate_icons(treeview);
   D(printf("---------------here9\n"); )
   return treeview;

}
