/*   
 *  smblookup.c: This is the basic gear that makes
 *  the xfsamba browser work. It lists the remote browser tables,
 *  thus it is good for quering the master browser for ws names
 *  and querying ws for remote share listing.
 *   *  
 *  Copyright (C) 2001-2003 Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#ifdef USE_SMB_BRANCH

#include <unistd.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/stat.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>



#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "basic_row.h"

#include "smblookup.h"

#include "entry.h"
#include "smb_open.h"
#include "smb_misc.h"
#include "misc.h"
#include "tubo.h"
#include "password_dialog.h"




extern char *challenges[];
extern unsigned net_root_type;
extern void *smb_object;
extern GtkTreeView *smb_treeview;

static xfdir_t smb_xfdir;
static GList *listSMB=NULL;
static GList *listSHARES=NULL;
static GList *listMASTERS=NULL;
static int   smb_count;
static GtkTreeIter *wg_iter;
static char *smb_server;
static char *smb_pass;
static gboolean samba_server;

typedef struct share_t{
	char *share;
	unsigned type;
}share_t;

void 
free_share_t(gpointer data,gpointer user_data){
	share_t *d_share=(share_t *)data;
	g_free(d_share->share);
	d_share->share=NULL;
	g_free(d_share);
	d_share=NULL;
}
	

static int cual_chingao,query_result=UNDEFINED;


static void
printout_listSMB(gpointer data,gpointer user_data){
  char *netbios=(char *)data;
		  
		  
  smb_xfdir.gl[smb_count].pathv=g_strdup(netbios);
  if (!samba_server) ascii_readable(smb_xfdir.gl[smb_count].pathv);
  
  smb_xfdir.gl[smb_count].en=mk_entry(net_root_type);
  if (samba_server) SET_SAMBA_SERVER(smb_xfdir.gl[smb_count].en->subtype);
  smb_xfdir.gl[smb_count].en->path=
	(char *)malloc(strlen(netbios)+3);
  sprintf(smb_xfdir.gl[smb_count].en->path,"//%s",netbios);
  smb_xfdir.gl[smb_count].en->st=(struct stat *)malloc(sizeof(struct stat));
  smb_xfdir.gl[smb_count].en->st->st_size=0;
  smb_xfdir.gl[smb_count].en->st->st_mtime=time(NULL);
  smb_xfdir.gl[smb_count].en->st->st_ctime=time(NULL);
  smb_xfdir.gl[smb_count].en->st->st_gid=(gid_t)-1;
  smb_xfdir.gl[smb_count].en->st->st_uid=(uid_t)-1;
  smb_xfdir.gl[smb_count].en->st->st_mode=S_IFBLK;
  if (smb_pass) smb_xfdir.gl[smb_count].en->tag=g_strdup(smb_pass);
  else {
	  if (getenv("SMB_USER") && strlen(getenv("SMB_USER"))
			  && strchr(getenv("SMB_USER"),'%'))
		  smb_xfdir.gl[smb_count].en->tag=g_strdup(getenv("SMB_USER"));
	  else 
		  smb_xfdir.gl[smb_count].en->tag=g_strdup("GUEST%%");
  }
  SET_XF_NETWS(smb_xfdir.gl[smb_count].en->subtype);
  smb_count++;
}

static void
printout_shares(gpointer data,gpointer user_data){
  share_t *d_share=(share_t *)data;
  smb_xfdir.gl[smb_count].pathv=g_strdup(d_share->share);
  if (!samba_server) ascii_readable(smb_xfdir.gl[smb_count].pathv);
  
  smb_xfdir.gl[smb_count].en=mk_entry(net_root_type);
  if (samba_server) SET_SAMBA_SERVER(smb_xfdir.gl[smb_count].en->subtype);
  smb_xfdir.gl[smb_count].en->path=
	(char *)malloc(strlen(d_share->share)+strlen(smb_server)+2);
  sprintf(smb_xfdir.gl[smb_count].en->path,"%s/%s",smb_server,d_share->share);
  smb_xfdir.gl[smb_count].en->st=(struct stat *)malloc(sizeof(struct stat));
  smb_xfdir.gl[smb_count].en->st->st_size=0;
  smb_xfdir.gl[smb_count].en->st->st_mtime=time(NULL);
  smb_xfdir.gl[smb_count].en->st->st_gid=(gid_t)-1;
  smb_xfdir.gl[smb_count].en->st->st_uid=(uid_t)-1;
  smb_xfdir.gl[smb_count].en->st->st_mode=S_IFLNK;
  if (smb_pass) smb_xfdir.gl[smb_count].en->tag=g_strdup(smb_pass);
  else {
	  if (getenv("SMB_USER") && strlen(getenv("SMB_USER"))
			  && strchr(getenv("SMB_USER"),'%'))
		  smb_xfdir.gl[smb_count].en->tag=g_strdup(getenv("SMB_USER"));
	  else 
		  smb_xfdir.gl[smb_count].en->tag=g_strdup("GUEST%%");
  }
  
  switch (d_share->type){
	  case __XF_NETSHARE:
		  SET_XF_NETSHARE(smb_xfdir.gl[smb_count].en->subtype);
		  break;
	  case __XF_NETPRINT:
		  SET_XF_NETPRINT(smb_xfdir.gl[smb_count].en->subtype);
		  break;
	  case __XF_NETIPC:
		  SET_XF_NETIPC(smb_xfdir.gl[smb_count].en->subtype);
		  break;
  }
  smb_count++;
}

static void
SMBlistForkOver (pid_t pid)
{
  GtkTreeModel *treemodel = gtk_tree_view_get_model(smb_treeview);

  switch (query_result) {
	  case UNDEFINED:
		  printf("DBG: undefined error at smblookup.c\n");
		  reset_dummy_row(treemodel, wg_iter,NULL,NULL,"xfce/error","undefined error");
		  break;
	  case CHALLENGED:
                  print_status ("xfce/warning",
				  _("Query password has been requested."),
				  NULL);
		  reset_dummy_row(treemodel, wg_iter,NULL,NULL,"xfce/warning",_("Query password has been requested."));
		  break;
	  case SUCCESS:
		  print_status ("xfce/info",
				  _("SMB query done"),
				  NULL);
  		  if (listSHARES){
  			print_status ("xfce/info",
				  _("Query done"),NULL);
        		smb_xfdir.pathc = g_list_length(listSHARES);
        		smb_xfdir.gl = (dir_t *) malloc(smb_xfdir.pathc * sizeof(dir_t));
			smb_count=0;
			g_list_foreach(listSHARES,printout_shares,NULL);
			add_contents_row(treemodel, wg_iter, &smb_xfdir);
			erase_dummy_row(treemodel, wg_iter,NULL);
			xfdirfree(&smb_xfdir);
			gtk_tree_iter_free(wg_iter);
		  } else {
			reset_dummy_row(treemodel, wg_iter,NULL,NULL,NULL,NULL);
		  }
		  break;
	  case FAILED:
		  print_status ("xfce/error",
				  _("SMB query failed"),
				  NULL);
		  reset_dummy_row(treemodel, wg_iter,NULL,NULL,"xfce/error",_("SMB query failed"));
	  default: break;
  }
  smb_object = NULL;
  return;
}

static void
SMBForkOver (pid_t pid)
{
  GtkTreeModel *treemodel = gtk_tree_view_get_model(smb_treeview);
	
  if (listSMB){
  	print_status ("xfce/info",
				  _("Query done"),NULL);
        smb_xfdir.pathc = g_list_length(listSMB);
        smb_xfdir.gl = (dir_t *) malloc(smb_xfdir.pathc * sizeof(dir_t));
	smb_count=0;
	g_list_foreach(listSMB,printout_listSMB,NULL);
	add_contents_row(treemodel, wg_iter, &smb_xfdir);
        erase_dummy_row(treemodel, wg_iter,NULL);
	xfdirfree(&smb_xfdir);
	gtk_tree_iter_free(wg_iter);
  } else { 
	  print_status ("xfce/info",
				  _("Query failed"),NULL);
	  reset_dummy_row(treemodel, wg_iter,NULL,NULL,NULL,NULL);
  }
  if (listMASTERS){
	  /* here should add any new workgroups found on remote subnets
	   * in some future version */
  }
  smb_object = NULL;
  return;
}

static int
SMBparseLookup (int n, void *data)
{
  static char *position[3];
  char *line,*text[3],*atext[3];
  int i;
  /* data is a static memory location */
  if (n)   return TRUE;	
  line = (char *) data;
  if (strstr (line, "Anonymous login successful"))  {
        print_diagnostics("nonverbose",line,NULL);
  	  return TRUE;
  }   

  if (!samba_server)
  {
     gchar *readable_line=g_strdup(line);
     ascii_readable (readable_line);
     print_diagnostics ("nonverbose",readable_line,NULL);
     g_free(readable_line);readable_line=NULL;
  } 
  else  print_diagnostics ("nonverbose",line,NULL);
  

  
  if (strstr (line, "Connection") && strstr (line, "failed"))  {
    cual_chingao = LOCATION_SHARES;
    query_result = FAILED;
    position[0] = position[1] = NULL;
    return TRUE;
  }
  /* pre samba 2.2 */
  if (strstr (line, "Access") && strstr (line, "denied"))  {
    cual_chingao = LOCATION_SHARES;
    query_result = CHALLENGED;
    position[0] = position[1] = NULL;
    return TRUE;
  }
  /* post samba 2.2 */
  for (i=0;challenges[i]!=NULL;i++){
      if (strstr (line, challenges[i]))  {
        cual_chingao = LOCATION_SHARES;
        query_result = CHALLENGED;
        position[0] = position[1] = NULL;
        return TRUE;
      }	
  }
  if (strstr(line,"Server=") && strstr(line,"Samba")) samba_server=TRUE;
  /* workgroup */
  if (strstr (line, "Domain=[") || strstr (line, "Workgroup=[")){
        return TRUE;
  }
  
  if (strlen (line) < 3)  return TRUE;
  if (strstr (line, "Sharename") && strstr (line, "Comment"))  {
    position[0] = position[1] = NULL;
    cual_chingao = LOCATION_SHARES;
    return TRUE;
  }
  if (strstr (line, "Server") && strstr (line, "Comment"))  {
    position[0] = position[1] = NULL;
    cual_chingao = LOCATION_SERVERS;
    return TRUE;
  }
  if (strstr (line, "Workgroup") && strstr (line, "Master"))  {
    position[0] = position[1] = NULL;
    cual_chingao = LOCATION_WORKGROUPS;
    return TRUE;
  }
  if (strstr (line, "--------")) {
    char *buf;
    position[0] = strstr (line, "---");
    buf = strtok (position[0], " ");
    if (buf) {
      buf = strtok (NULL, "\n");
      if (buf)
	position[1] = strstr (buf, "---");
    }
    return TRUE;
  }
  if (!position[0]) {
	  /*printf("returning on null line\n");*/
	  return TRUE;
  }
  if (!position[1]) text[1]=g_strdup("-");
  else {
    text[1]=g_strdup(position[1]);
    *position[1]=0;
  }
  text[0]=g_strdup(position[0]);
  for (i=0;i<2;i++) {
	  while (strlen(text[i]) && 
			  (text[i][strlen(text[i])-1]==' ' || 
			   text[i][strlen(text[i])-1]=='\t'||
			   text[i][strlen(text[i])-1]=='\n') )
	  	text[i][strlen(text[i])-1]=0;
  }
  /*text[2]=g_strdup(current_workgroup);*/
  text[2]=NULL;
#ifdef DEBUG
  printf("DBG:texts =%s, %s, %s\n",text[0],text[1],text[2]);
#endif
  switch (cual_chingao) {
    case LOCATION_SHARES:
     {
      share_t *d_share; 
      query_result = SUCCESS; /* something valid came thru */
      d_share=(share_t *)malloc(sizeof(share_t));
      d_share->type=0;
      d_share->share=g_strdup(text[0]);
      if (strncmp("Disk",text[1],strlen("Disk"))==0)
	      SET_XF_NETSHARE(d_share->type);
      else if (strncmp("Printer",text[1],strlen("Printer"))==0)
	      SET_XF_NETPRINT(d_share->type);
      else if (strncmp("IPC",text[1],strlen("IPC"))==0)
	      SET_XF_NETIPC(d_share->type);
      listSHARES = g_list_append (listSHARES,(gpointer)d_share);
     }
     break;
    case LOCATION_SERVERS:
     {
      gchar *real_name;
      GList *tmp;
      gboolean repeat=FALSE;
      atext[0]=text[0];          /* the server */
      /* workaround IS~ stuff */
      if (strncmp(atext[0],"IS~",strlen("IS~"))==0) 
	      real_name=g_strdup(atext[0]+strlen("IS~"));
      else real_name=g_strdup(atext[0]);
      atext[1]=text[2];          /* the work group */
      atext[2]=text[1];          /* the comment */
      for (tmp=listSMB; tmp; tmp=tmp->next){
	      char *c=(char *)tmp->data;
	      if (c && real_name && strcmp(c,real_name)==0){
		      repeat=TRUE;
		      break;
	      }
      }
      if (repeat) g_free(real_name);
      else listSMB = g_list_append (listSMB,(gpointer)(real_name));
      break;
     }
    case LOCATION_WORKGROUPS:
      /* have to turn around values here */
      atext[0]=text[1];          /* the server */
      atext[1]=text[0];          /* the work group */
      atext[2]="Master subnet browser"; /* the comment: there may be more than one MB
					   if there are servers on different subnets */
      listMASTERS = g_list_append (listMASTERS,(gpointer)(g_strdup(atext[0])));
      break;
    default:
      break;
  }
  for (i=0;i<3;i++) {
	  g_free(text[i]);
	  text[i]=NULL;
  }


  return TRUE;
}


int
SMBLookup (GtkTreeView *treeview,unsigned char *servidor,
		GtkTreeIter *iter,int caso,
		char *pass)
{
  char *argument[7];
  int i;
  GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
  
  wg_iter=gtk_tree_iter_copy(iter);
  
  if (!servidor || !strlen(servidor) || smb_object){
     return FALSE;
  }
  smb_treeview=treeview;
  smb_server=servidor; 
  smb_pass=pass;
  samba_server=FALSE;
  cual_chingao = 0;

  print_status (NULL,
		  _("Querying")," ",
		  servidor,NULL);

  /* bla bla section */
  print_diagnostics ("nonverbose","XFSAMBA> smbclient -N -L ",
		  servidor,"\n",NULL);
  
   if (listSMB){
	g_list_foreach(listSMB,free_data,NULL);
      	g_list_free(listSMB);
	listSMB=NULL;
  }
  if (strncmp(servidor,"//",strlen("//"))==0) listSMB = g_list_append (listSMB,(gpointer)(g_strdup(servidor+2)));
  
  if (listSHARES){
	g_list_foreach(listSHARES,free_share_t,NULL);
      	g_list_free(listSHARES);
	listSHARES=NULL;
  }
  if (listMASTERS){
	g_list_foreach(listMASTERS,free_data,NULL);
      	g_list_free(listMASTERS);
	listMASTERS=NULL;
  }

  i=0;
  argument[i++]=  "smbclient";
  argument[i++]=  "-N";
  if (caso && pass) {
    argument[i++]=  "-U";
    argument[i++]=  pass;
  }
  argument[i++]=  "-L";
  argument[i++]=  servidor;
  argument[i++]=  0;

  
  query_result=UNDEFINED;
  reset_dummy_row(treemodel,iter,NULL,NULL,"xfce/warning",_("Loading..."));
  smb_object = Tubo (fork_function, 
	(void *)argument, 
	(caso)?SMBlistForkOver:SMBForkOver, 
	NULL, 
	SMBparseLookup, 
	smb_stderr,0,FALSE);
  smb_wait(TRUE);
  return query_result;
}

#endif

