 /*  Copyright (C) 2001-2003 Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#ifdef USE_SMB_BRANCH

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "glade_support.h"

#include "constants.h"
#include "types.h"
#include "smb_module.h"

#include "smb_misc.h"
#include "smb_open.h"
#include "smb_download.h"

#include "misc.h"

static xfsmb_functions *xfsmb_fun=NULL;
extern void *smb_object;
extern GtkTreeView *smb_treeview;
char *challenges[]={
	  "Error opening local file",
	  "ERRDOS",
	  "ERRSRV",
	  "ERRbadpw", /* before samba 2.2.3 */
	  "NT_STATUS_WRONG_PASSWORD", 
	  "NT_STATUS_ACCESS_DENIED",
	  "NT_STATUS_ILL_FORMED_PASSWORD",
	  "NT_STATUS_PASSWORD_RESTRICTION",
	  "NT_STATUS_NO_SUCH_USER",
	  "NT_STATUS_LOGON_FAILURE",
	  "NT_STATUS_ACCOUNT_RESTRICTION",
	  "NT_STATUS_INVALID_LOGON_HOURS",
	  "NT_STATUS_INVALID_WORKSTATION",
	  "NT_STATUS_PASSWORD_EXPIRED",
	  "NT_STATUS_NETWORK_ACCESS_DENIED",
	  "NT_STATUS_ACCOUNT_DISABLED",
	  NULL
};
char *smb_errors[]={
	  "Error opening local file",
	  "ERRDOS",
	  "ERRSRV",
	  "NT_STATUS_ACCESS_DENIED",
	  "NT_STATUS_DIRECTORY_NOT_EMPTY",
	  "NT_STATUS_OBJECT_NAME_NOT_FOUND",
	  "NT_STATUS_NO_SUCH_FILE",
	  "NT_STATUS_OBJECT_NAME_INVALID",
	  NULL
};

/* this does not work well with parallel smbclient
 *      (not enough time alloted to process gtk events)
 *      */

void 
free_data(gpointer data,gpointer user_data){
	g_free((char *)(data));
	data=NULL;
}
int smb_wait(gboolean animate){
	
  while (smb_object){
     if (animate){
        GtkWidget *progress;
        progress = WIDGET("progressbar1");
	gtk_progress_bar_pulse((GtkProgressBar *) progress);
     } 
     while (gtk_events_pending()) gtk_main_iteration();
     usleep(5000);
  }
  return TRUE;
}

G_MODULE_EXPORT
xfsmb_functions *module_init(void){
    /*if (xfprop_fun) return xfprop_fun; (deallocate at main)*/
#ifdef ENABLE_NLS
    /* This is required for UTF-8 at least - Please don't remove it */
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);
#endif
    xfsmb_fun = g_new0 (xfsmb_functions,1);
    if (!xfsmb_fun) g_assert_not_reached();
    xfsmb_fun->open_smb = open_smb;
    xfsmb_fun->SMBGetFile = SMBGetFile;
    xfsmb_fun->SMBDropFile = SMBDropFile;
    xfsmb_fun->SMBrmFile = SMBrmFile;
    xfsmb_fun->SMBmkdir = SMBmkdir;
    
    return xfsmb_fun;
}
#endif

