/*   master.c: this file contains routines to query and
 *   resolve the master browser(s) on the local subnet. 
 *
 *   It requires the samba suite programs:
 *  smbclient and nmblookup (included in most linux distributions).
 *  
 *  Copyright (C) 2001-2003 Edscott Wilson Garcia under GNU GPL
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#ifdef USE_SMB_BRANCH
#include <unistd.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>



#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "basic_row.h"

#include "master_lookup.h"

#include "entry.h"
#include "misc.h"
#include "smb_open.h"
#include "smb_misc.h"
#include "tubo.h"
#include "widgets.h"
#include "password_dialog.h"

extern GtkTreeView *smb_treeview;
extern unsigned net_root_type;

static GList *mastersIP=NULL;
static void *resolve_object=NULL;
static gboolean lookup_done;
static xfdir_t smb_xfdir;


/***************  master resolve segment  *************************/
static int   master_count;
static int   master_status;
static char *master_name=NULL;
static char *master_netbios=NULL;
static char *master_group=NULL;
static char *master_IP;


#define RESOLVED 	0x01
#define RESOLVING	0x02
#define NOT_RESOLVED	0x04
#define FAILED		0x08



static void 
NMBmastersResolveOver (pid_t pid){
  smb_xfdir.gl[master_count].en=mk_entry(net_root_type);
  switch (master_status){
	case RESOLVED:
    	    print_status ("xfce/info", _("Resolved")," ",master_name, NULL);
 	     smb_xfdir.gl[master_count].pathv=g_strdup(master_group);
	     smb_xfdir.gl[master_count].en->path=
		     (char *)malloc(strlen(master_netbios)+3);
	     sprintf(smb_xfdir.gl[master_count].en->path,"//%s",master_netbios);
   		break;	
	case NOT_RESOLVED:
		
 	     smb_xfdir.gl[master_count].pathv=g_strdup(master_IP);
	     smb_xfdir.gl[master_count].en->path=
		     (char *)malloc(strlen(master_IP)+3);
	     sprintf(smb_xfdir.gl[master_count].en->path,"//%s",master_IP);
 
	     print_status ("xfce/info", _("Not resolved")," ",master_IP, NULL);
		break;
  }
  smb_xfdir.gl[master_count].en->st=(struct stat *)malloc(sizeof(struct stat));
  smb_xfdir.gl[master_count].en->st->st_size=0;
  smb_xfdir.gl[master_count].en->st->st_mtime=time(NULL);
  smb_xfdir.gl[master_count].en->st->st_ctime=time(NULL);
  smb_xfdir.gl[master_count].en->st->st_gid=(gid_t)-1;
  smb_xfdir.gl[master_count].en->st->st_uid=(uid_t)-1;
  smb_xfdir.gl[master_count].en->st->st_mode=S_IFDIR;
  SET_XF_NETWG(smb_xfdir.gl[master_count].en->subtype);
  resolve_object=NULL;
}

static int 
NMBparseMastersResolve (int n, void *data){
  char *line;
  if (n)  return TRUE;		/* this would mean binary data */
  line = (char *) data;
  print_diagnostics ("nonverbose",line,NULL);

  if (strstr (line, "<00>")) {
	 if (strstr (line, "<GROUP>")){ /* workgroup name */
 	     strtok (line, " ");
	     g_free(master_group);
	     master_group=g_strdup(line + 1);
    	     ascii_readable (master_group);
	 } else { /* server name */
 	     strtok (line, " ");
	     g_free(master_netbios);
	     master_netbios=NULL;
	     g_free(master_name);
	     master_name=NULL;
	     if (strncmp(line+1,"IS~",strlen("IS~"))==0) {
	       master_netbios=g_strdup(line + 1+strlen("IS~"));
	       master_name=g_strdup(line + 1+strlen("IS~"));
	     } else {
	       master_netbios=g_strdup(line + 1);
	       master_name=g_strdup(line + 1);
	     }
    	     ascii_readable (master_name);
  	     master_status=RESOLVED;	     
	}
  }
  return TRUE;
}


static gboolean 
NMBmastersResolve (char *IP){
  char *argument[5];
  if (!IP) return FALSE;
  master_status=NOT_RESOLVED;
  argument[0]=  "nmblookup";
  argument[1]=  "-A";
  argument[2]= master_IP = IP;
  argument[3]=  0;
  print_diagnostics("nonverbose", "XFSAMBA> ","nmblookup -A ", IP,"\n", NULL);
  print_status ("xfce/info", _("Resolving")," ", IP,NULL);
  
  resolve_object=Tubo (fork_function, 
	(void *)argument, 
	NMBmastersResolveOver, 
	NULL, 
	NMBparseMastersResolve, 
	smb_stderr,0,FALSE);
  
  
  return FALSE;
}


/***************  master lookup segment  *************************/

/* Look up the subnet master browsers, it fails for win95 master
 * browsers, but that's ok. */


static void
printout_masterIP(gpointer data,gpointer user_data){
      print_status ("xfce/info",_("Master browser found"),NULL);
      if (data) NMBmastersResolve ((char *)data);
      while (resolve_object) {
	      usleep(5000);
	      while (gtk_events_pending()) gtk_main_iteration();
      }
      master_count++;
}

static void
NMBmastersForkOver (pid_t pid)
{
  
  if (mastersIP){
       smb_xfdir.pathc = g_list_length(mastersIP);
       smb_xfdir.gl = (dir_t *) malloc(smb_xfdir.pathc * sizeof(dir_t));
	master_count=0;
       g_list_foreach(mastersIP,printout_masterIP,NULL);
       lookup_done=TRUE;
  } else {
    print_status ("xfce/error", _("No master browser found."),NULL);
    lookup_done=TRUE;
  }
  
  return;
}

static int
NMBmastersParseLookup (int n, void *data)
{
  char *line, *buffer;
  if (n)  return TRUE;		/* this would mean binary data */
  line = (char *) data;
  print_diagnostics ("nonverbose",line,NULL); /* verbose diagnostics */
  if (!strncmp (line, "querying", strlen ("querying")))
	  return TRUE;
  if (strstr (line, "name_query") 
		  && strstr (line, "failed") 
		  && strstr (line, "__MSBROWSE__")){
          return TRUE;
  }
  if (strstr (line, "__MSBROWSE__") && strstr (line, "<01>")) {
    GList *tmp;
    buffer = strtok (line, " ");
    if (!buffer) return TRUE;
    for (tmp=mastersIP;tmp;tmp=tmp->next){
	gchar *g=tmp->data;
	if (strcmp(g,buffer)==0) return TRUE;
    }
    
    mastersIP = g_list_append (mastersIP,(gpointer)(g_strdup(buffer)));
  }
  return TRUE;
}



	
gboolean
NMBmastersLookup (GtkTreeView *treeview)
{
  tree_entry_t *en;
  GtkTreeIter iter;
  char *argument[5];
  GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
  
  get_network_root(treeview, &iter, &en);
  net_root_type=en->type;

  argument[0]=  "nmblookup";
  argument[1]=  "-M";
  argument[2]=  "--";
  argument[3]=  "-";
  argument[4]=  0;
  smb_treeview=treeview;
  if (mastersIP){
	g_list_foreach(mastersIP,free_data,NULL);
      	g_list_free(mastersIP);
	mastersIP=NULL;
  }
  print_diagnostics("nonverbose", _("Looking for master browsers...\n"), NULL);  
  print_diagnostics ("nonverbose","XFSAMBA> ","nmblookup -M -- -\n",NULL);
  lookup_done=FALSE;
  
  reset_dummy_row(treemodel,&iter,NULL,NULL,"xfce/warning",_("Loading..."));
  
  Tubo (fork_function, 
	(void *)argument,
	NMBmastersForkOver, 
	NULL, 
	NMBmastersParseLookup, 
	smb_stderr,0,FALSE);
  

  while (!lookup_done){
	usleep(5000);
	while (gtk_events_pending()) gtk_main_iteration();
  }
  if (smb_xfdir.pathc)  {
      add_contents_row(treemodel, &iter, &smb_xfdir);
      erase_dummy_row(treemodel, &iter,NULL);
  } else 	  {
	reset_dummy_row(treemodel, &iter,NULL,NULL,NULL,NULL);
  }

  xfdirfree(&smb_xfdir);
  
  return FALSE;
}
#endif
