/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include <dirent.h>
#include <errno.h>
#include <glob.h>
#include <limits.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_remove_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"
#include "modules.h"

#include "remove.h"

#include "entry.h"
#include "cpy.h"
#include "icons.h"
#include "new.h"
#include "ls.h"
#include "misc.h"
#include "password_dialog.h"
#include "monitor.h"
#include "remove.h"
#include "trash.h"
#include "widgets.h"

enum
{
    WASTE,
    UNLINK,
    SCHRED
};

static GList *remove_list = NULL;
static GList *remote_remove_list = NULL;
static gboolean waste = TRUE;
static gboolean unlink_mode = FALSE;
static gboolean all;
static gboolean cancel_remove;
static gchar *remote_pass=NULL;
static gchar *remote_location=NULL;
static gboolean invalid_input = FALSE;
static int remove_selectionOK=0;
static gboolean on_destroy_event(GtkWidget * widget, 
		GdkEvent * event, gpointer user_data);
static void on_remove_no_activate(GtkButton * button, gpointer user_data);
static void on_remove_yes_activate(GtkButton * button, gpointer user_data);
static void on_waste_yes_activate(GtkButton * button, gpointer user_data);
static void on_remove_all_toggled(GtkToggleButton * togglebutton, gpointer user_data);

#define is_digit(x) ((x)>='0' && (x)<='9')
/*
static gboolean is_removable(char *file){
	char **p;
	char *substrings[]={"core","tmp","test",NULL};
	char *extensions[]={".core",".o",".lo",".la",".tmp",".log",".out",NULL};
	if (strchr(file,'-') && is_digit(*((strchr(file,'-')+1)))) return TRUE;
	if (strstr(file,"core") || strstr (file,"tmp")) return TRUE;
	for (p=substrings; *p; p++) if (strstr(file,*p)) return TRUE;
	if (strchr(file,'.')) for (p=extensions; *p; p++) {
		if (strstr(file,*p) && strcmp(strstr(file,*p),*p)==0)
			return TRUE;
	}	
	return FALSE;
}*/

static char  *CreateRmTmpList(GtkTreeView *treeview){
  GList *tmp;
  tree_entry_t *en;
  FILE *tmpfile;
  gchar *path,*directory=NULL,*file=NULL;
  gchar *fname;
       
  if ((fname=randomTmpName(NULL))==NULL) return NULL;
  if ((tmpfile=fopen(fname,"w"))==NULL) {
      g_free(fname);
      return NULL;
  }

  for (tmp=remote_remove_list;tmp;tmp=tmp->next){
    GtkTreeIter iter;
    get_entry_from_reference(treeview, 
		    (GtkTreeRowReference *) tmp->data, &iter, &en);  
    path=strstr(en->path+2,"/")+1; /* this gives us path with share.*/    
    path=g_strdup(strstr(path,"/"));/* this gives us the path.*/
    file=strrchr(path,'/');
    if (!file) assert_not_reached();
    file++;
    if (!strlen(file)) assert_not_reached();
    directory=g_strdup(path);
    if (!strchr(directory,'/')) assert_not_reached();
    *(strrchr(directory,'/'))=0;
    if (!strlen(directory)) {directory[0]='/';directory[1]=0;}
    /* smbclient is screwed with window server here. */
    fprintf(tmpfile,"cd \"%s\";\n",directory);
    if (IS_NETDIR(en->subtype)){
	fprintf(tmpfile,"rmdir \"%s\";\n",file);
        /*fprintf(tmpfile,"cd /;rmdir \"%s\\\";\n",t);	     */
     } else {
        if (!IS_SAMBA_SERVER(en->subtype)){
	  char *g;
	  for(g=file;*g;g++)if (*g=='/')*g='\\';
	}
	fprintf(tmpfile,"del \"%s\";\n",file);
     }
     g_free(path);path=NULL;
     g_free(directory);directory=NULL;
   }
   fclose (tmpfile);
   return fname;
}


static gboolean schredit(char *path)
{
    return TRUE;
}


G_MODULE_EXPORT
gboolean unlinkit(char *path)
{
    struct stat st;

    process_pending_gtk();
    if(tree_details->stop)
    {
	tree_details->stop = FALSE;
	cancel_remove = TRUE;
	hide_stop();
	return FALSE;
    }
    if(cancel_remove)
	return FALSE;
    if(lstat(path, &st) < 0)
    {
	print_diagnostics("xfce/error",
			    strerror(errno),":",path, "\n", NULL);
	return FALSE;
    }
    if(!S_ISDIR(st.st_mode))
    {
	if(unlink(path) < 0)
	{
	    print_diagnostics("xfce/error",
			    strerror(errno),":",path, "\n", NULL);
	    return FALSE;
	}
#if 0
	/* this sloooows things down */
	if(path && strlen(path) >= 2)
	    print_status("xfce/warning", _("Deleted"), " ", __VY_FN__(path), NULL);
#endif
	return TRUE;
    }
    else
    {
	gchar *fullpath;
	DIR *directory;
	struct dirent *dir;
	directory = opendir(path);
	if(!directory)
	{
	    return FALSE;
	}
	while((dir = readdir(directory)) != NULL && !cancel_remove)
	{
	    if(strcmp(dir->d_name, ".") == 0 || strcmp(dir->d_name, "..") == 0)
		continue;

	    fullpath=g_strconcat(path,"/",dir->d_name,NULL);

	    if(!unlinkit(fullpath))
	    {
		g_free(fullpath);fullpath=NULL;
		return FALSE;
	    }
	    g_free(fullpath);fullpath=NULL;
	}
	closedir(directory);
	if(cancel_remove)
	    return FALSE;
	if(rmdir(path) < 0)
	{
	    print_diagnostics("xfce/error",
			    strerror(errno),":",path, "\n", NULL);
	    return FALSE;
	}
    }
#if 0
    if(strstr(path, "/..Wastebasket/"))
    {
	char *p = g_strdup(path);
	*(strrchr(p, '/')) = 0;
	/*printf("DBG:unlinking %s\n",path); */
	rmdir(p);
	g_free(p);
    }
#endif
    return TRUE;
}


static void move2trash(char *path)
{

#ifdef DEBUG
	printf("DBG:move2trash %s\n",path); 
#endif
#if 0
	this is obsolete now
    lstat(path, &st);
    if(S_ISDIR(st.st_mode))
    {
	char *globstring;
	glob_t dirlist;
	globstring = (char *)malloc(strlen(path) + 3);
	if(!globstring)
	    assert_not_reached();
	sprintf(globstring, "%s/*", path);
	if(glob(globstring, GLOB_ERR, NULL, &dirlist) == 0)
	{
	    int i;
	    for(i = 0; i < dirlist.gl_pathc; i++)
	    {
		/*printf("DBG:move2trash %s\n",dirlist.gl_pathv[i]); */
		move2trash(dirlist.gl_pathv[i]);
	    }
	}
	g_free(globstring);globstring=NULL;
	globfree(&dirlist);
    }
#endif
    add2trash(path);
#ifdef DEBUG
	printf("DBG2:move2trash %s\n",path); 
#endif
    return;
}

G_MODULE_EXPORT
gboolean wasteit(char *path)
{
    gchar *directory;
    gchar *wastepath=NULL;
    gchar *wastename=NULL;
    
    if(!g_file_test(path,G_FILE_TEST_EXISTS)) {
	print_diagnostics("xfce/error",strerror(ENOENT)," :\n",path, "\n", NULL);
	return FALSE;
    }
    if(strlen(path) == 1) return FALSE;
    directory = g_path_get_dirname(path);
    wastepath=g_strconcat(directory,"/..Wastebasket",NULL);
    g_free(directory);directory=NULL;
    /*printf("DBG:wastepath=%s\n",wastepath); */
    if(access(wastepath, F_OK) != 0)
    {
	if(mkdir(wastepath, 0xFFFF) < 0){
	    print_diagnostics("xfce/error",strerror(errno)," :\n",wastepath, "\n", NULL);
	    g_free(wastepath);wastepath=NULL;
	    return FALSE;
	}

    }
    wastename=g_strconcat( wastepath,"/",strrchr(path, '/') + 1,NULL);
    /*printf("DBG:wastename=%s path=%s\n",wastename,path); */
    if(access(wastename, F_OK) == 0)
    {
	/* too harsh: if (!unlinkit(wastename)) return FALSE; */
	gchar *wastebackup=NULL;
	wastebackup=g_strconcat(wastepath,"/",
			new_name(wastepath, strrchr(wastename, '/') + 1),
			NULL);
	/*printf("DBG:wastebackup=%s\n",wastebackup); */
	if(rename(wastename, wastebackup) < 0){
	    print_diagnostics("xfce/error", strerror(errno)," :\n", wastename, " --> ", wastebackup,"\n", NULL);
	    g_free(wastebackup); 
	    g_free(wastename);
	    g_free(wastepath);
	    return FALSE;
	}
	if(rename(path, wastename) < 0){
	    print_diagnostics("xfce/error", strerror(errno)," :\n", path, " --> ", wastename,"\n", NULL);
	    g_free(wastebackup); 
	    g_free(wastename);
	    g_free(wastepath);
	    return FALSE;
	}
	/* ENABLE_AUTO_T is to disable (just to make things confusing...) */
	if(!(tree_details->preferences & ENABLE_AUTO_T)) move2trash(wastebackup);
    }
    else
    {
	if(rename(path, wastename) < 0){
	    print_diagnostics("xfce/error", strerror(errno)," :\n", path, " --> ",wastename,"\n", NULL);
	    g_free(wastename);
	    g_free(wastepath);
	    return FALSE;
	}
	if(!(tree_details->preferences & ENABLE_AUTO_T)) move2trash(wastename);
    }
    g_free(wastename);
    g_free(wastepath);
    return TRUE;
}



static void check_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_entry_t *en;
    GtkTreeRowReference *reference;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en || invalid_input) return;
     /*don't allow a remove of IS_ROOT_TYPE (for now)*/
    /*if(IS_ROOT_TYPE(en->type) ) return;*/
    if(!IS_PATH(en->type)&&!IS_NETDIR(en->subtype)&&!IS_NETFILE(en->subtype))
	return;
    if(strstr(en->path, "/..Wastebasket")||IS_TRASH_TYPE(en->type)||
      IS_NETDIR(en->subtype)||IS_NETFILE(en->subtype)){
	unlink_mode = TRUE;
	if (IS_NETDIR(en->subtype)||IS_NETFILE(en->subtype)){
	   gchar *server_pass=g_strdup(en->tag);
	   gchar *location=g_strdup(en->path);
	   if (!strchr(location+2,'/')) assert_not_reached();
	   strtok(strchr(location+2,'/')+1,"/");
	   /*printf("DBG:location=%s\n",location);*/
	   if (!location || !strlen(location)) assert_not_reached();
   	   if (!remote_location)remote_location=location;
	   else {
	     if (strcmp(remote_location,location)!=0)invalid_input=TRUE;
	     g_free(location);location=NULL;
	   }
   	   if (!remote_pass)remote_pass=server_pass;
	   else {
	     if (strcmp(remote_pass,server_pass)!=0)invalid_input=TRUE;
	     g_free(server_pass);server_pass=NULL;
	   }
	}
    }
    if (IS_PATH(en->type)&&remote_location) invalid_input=TRUE;
    remove_selectionOK++;
    reference = gtk_tree_row_reference_new(treemodel, path);
    remove_list = g_list_append(remove_list, reference);    
    return;
}

G_MODULE_EXPORT
GList *clear_remove_list(GList *list)
{
    GList *tmp = list;
    while(tmp)
    {
	if(tmp->data)
	{
	    GtkTreeRowReference *reference;
	    reference = (GtkTreeRowReference *) tmp->data;
	    gtk_tree_row_reference_free(reference);
	}
	tmp = tmp->next;
    }
    g_list_free(list);
    return NULL;

}

static void make_dialog(GtkTreeView * treeview, gboolean question)
{
    GtkTreeIter iter;
    tree_entry_t *en;
    gchar *mess=NULL;
    gchar *mess1=NULL;

    if(!remove_list)
	return;
    if(tree_details->remove)
	assert_not_reached();

    if(tree_details->stop) tree_details->stop = FALSE;
    hide_stop();
    tree_details->remove = create_remove();
    gtk_window_set_position(GTK_WINDOW(tree_details->remove), GTK_WIN_POS_MOUSE);

/*  g_signal_connect_object ( 
		  lookup_widget(tree_details->remove,"button203"),
		  "clicked",
                  G_CALLBACK (on_remove_stop_activate),
                  (gpointer)treeview, 0);*/
    g_signal_connect_object(lookup_widget(tree_details->remove, "cancelbutton"), "clicked", G_CALLBACK(on_remove_no_activate), (gpointer) treeview, 0);
    g_signal_connect_object(lookup_widget(tree_details->remove, "wastebutton"), "clicked", G_CALLBACK(on_waste_yes_activate), (gpointer) treeview, 0);
    g_signal_connect_object(lookup_widget(tree_details->remove, "removebutton"), "clicked", G_CALLBACK(on_remove_yes_activate), (gpointer) treeview, 0);
    g_signal_connect_object(lookup_widget(tree_details->remove, "togglebutton1"), "toggled", G_CALLBACK(on_remove_all_toggled), (gpointer) treeview, 0);

    g_signal_connect_object(tree_details->remove, "delete-event", G_CALLBACK(on_destroy_event), (gpointer) treeview, 0);
    g_signal_connect_object(tree_details->remove, "destroy-event", G_CALLBACK(on_destroy_event), (gpointer) treeview, 0);

    /* dialog specifics */
 
    /* deleting from a wastebasket forces unlink */
    if(unlink_mode) hideit(tree_details->remove, "wastebutton");
 
    if(tree_details->selectionOK < 2)
    {
	/*hideit(tree_details->remove,"button203"); */
	hideit(tree_details->remove, "togglebutton1");
    }
    if(question)
    {
	mess1=g_strdup(" ");
	hideit(tree_details->remove, "warning");
    }
    else
    {
	mess1=g_strconcat(" ",_("Try again?"),"\n",NULL);
	hideit(tree_details->remove, "question");
    }

    get_entry_from_reference(treeview,(GtkTreeRowReference *) remove_list->data, &iter, &en);
    
    /*if (is_removable(abreviate(en->path))){
	gtk_toggle_button_set_active((GtkToggleButton *) lookup_widget(tree_details->remove, "radiobutton2"), TRUE);
    }*/
    
    {
	gchar *t=g_strdup(en->path);
	if (IS_NETTHING(en->subtype) && !IS_SAMBA_SERVER(en->subtype))
		ascii_readable(t);
	
	
        mess=g_strconcat(mess1,abreviate(t),"\n",
			    "(",time_to_string(en->st->st_mtime)," ",
			    sizetag((off_t)en->st->st_size, -1),")",
			    NULL); 
	g_free(t);t=NULL;
    }

    {
      GdkPixbuf	*pb;
      GtkImage *image=(GtkImage *)lookup_widget (tree_details->remove, "adicon");
      pb = icon_tell(MEDIUM, "xfce/waste_basket_full");
      if (pb) {
	gtk_image_set_from_pixbuf (image, pb);
	g_object_unref (G_OBJECT (pb));
      }
    }
    gtk_label_set_text((GtkLabel *) 
		    lookup_widget(tree_details->remove,"label16"), 
		    _("Remove"));
   gtk_label_set_text((GtkLabel *) 
		    lookup_widget(tree_details->remove, "label20"), 
		    mess);
    g_free(mess);mess=NULL;
    g_free(mess1);mess1=NULL;
    gtk_widget_realize(tree_details->remove);
    /*gdk_window_set_decorations (
       tree_details->remove->window,
       GDK_DECOR_BORDER); */
    gtk_widget_show(tree_details->remove);
    if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"unlink")==0){
	  gtk_widget_grab_focus (lookup_widget(tree_details->remove,"removebutton"));	    
    }
    else if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"waste")==0){
	  gtk_widget_grab_focus (lookup_widget(tree_details->remove,"wastebutton"));	    
    }
    gtk_window_set_transient_for(GTK_WINDOW(tree_details->remove), GTK_WINDOW(tree_details->window));
    gtk_main();

}

static void do_remove(GtkWidget * widget)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = tree_details->treestuff[tree_id].treeview;
    GtkTreeSelection *selection = tree_details->treestuff[tree_id].selection;

    g_free(remote_location); remote_location=NULL;
    g_free(remote_pass); remote_pass=NULL;
    
    if(!set_load_wait()){
	return;
    }
    remove_selectionOK = FALSE;
    all = FALSE;
    unlink_mode = FALSE;
    invalid_input = FALSE;
    gtk_tree_selection_selected_foreach(selection, 
		    check_select, (gpointer) treeview);
    if (invalid_input){
	    remove_list=clear_remove_list(remove_list);
	    remove_selectionOK=0;
    }
    unset_load_wait();
    if(!remove_selectionOK)
    {
	print_status("xfce/warning,",strerror(EINVAL),NULL);
	return;
    }

    /*if (tree_details->selectionOK==1) {
	    tree_entry_t *en;
	    GtkTreeIter iter;
	    get_entry_from_reference(treeview, 
			    (GtkTreeRowReference *) remove_list->data, 
			    &iter, &en);	    
	    query_rm(en->path, NULL);
    	    remove_list = g_list_remove(remove_list, remove_list->data);
    }
    else */
    make_dialog(treeview, TRUE);
}

static void close_it(void)
{
    gtk_main_quit();
    gtk_widget_destroy(tree_details->remove);
    tree_details->remove = NULL;
}

/*****    dialog callbacks   *****/

static
gboolean on_destroy_event(GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
    close_it();
    return TRUE;
}


static void on_remove_no_activate(GtkButton * button, gpointer user_data)
{
    GtkWidget *check;
    GtkTreeView *treeview = (GtkTreeView *) user_data;
    GtkTreeRowReference *reference;

    /*printf("DBG:remove no\n"); */
    check = lookup_widget(tree_details->remove, "togglebutton1");
    all = gtk_toggle_button_get_active((GtkToggleButton *) check);
    close_it();

  loop:
    reference = (GtkTreeRowReference *) remove_list->data;
    remove_list = g_list_remove(remove_list, remove_list->data);
    gtk_tree_row_reference_free(reference);
    if(all && remove_list)
	goto loop;
    if(remove_list)
	make_dialog(treeview, TRUE);
    turn_on();
    

}


static void do_the_remove(GtkButton * button, gpointer user_data, gboolean unlink_mode)
{
    GList *tmp;
    GtkWidget *check;
    int method = WASTE;
    GtkTreeIter iter;
    tree_entry_t *en;
    gboolean result = FALSE;
    GtkTreeView *treeview = (GtkTreeView *) user_data;

    if(!set_load_wait())
	assert_not_reached();

    cancel_remove = FALSE;
    check = lookup_widget(tree_details->remove, "togglebutton1");
    all = gtk_toggle_button_get_active((GtkToggleButton *) check);

    close_it();
    if (unlink_mode) {
        print_status("xfce/warning", _("Removing"),"...", NULL);
	method = UNLINK;
    }
    else {
	method = WASTE;
    }



  loop:
    get_entry_from_reference(treeview, (GtkTreeRowReference *) remove_list->data, &iter, &en);
    switch (method)
    {
	case WASTE:
	    D(printf("DBG:remove WASTE %s\n",en->path);)
	    if(strstr(en->path, "..Wastebasket"))
	    {
#ifdef ENOTSUP
		errno = ENOTSUP;	/* Not supported message */
#else 
#ifdef EOPNOTSUPP
		errno = EOPNOTSUPP;
#else
		errno = ENODEV;
#endif
#endif
		result = FALSE;
	    }
	    else
		result = wasteit(en->path);
	    break;
	case UNLINK:
	    if (remote_location){
	      D(printf("DBG: schedule rm %s\n",en->path);)
	      result=TRUE; /* schedule ok */	  
	    }
	    else /* local path */
	    {
	      D(printf("DBG:remove UNLINK %s\n",en->path);)
	      show_stop();
	      result = unlinkit(en->path);
	    }
	    break;
	case SCHRED:
	    D(printf("DBG:remove SCHRED %s\n",en->path);)
	    result = schredit(en->path);
	    break;
	default:
	    assert_not_reached();
    }
    if(cancel_remove)
    {
	print_status("xfce/error",	strerror(ECANCELLED),NULL);
	unset_load_wait();
	/*FIXME: on code cleanup check validity of remove_list->data */
	remove_list = g_list_remove(remove_list, remove_list->data);
	hide_stop();
        turn_on();
	return;
    }

    if(!result && errno == ENOENT)
	result = TRUE;		/* duh */

    if(!result && !all)
    {
	unset_load_wait();
	make_dialog(treeview, FALSE);
        turn_on();
	return;
    }

    {
	GtkTreeRowReference *reference;
	reference = (GtkTreeRowReference *) remove_list->data;
    	if (result) remote_remove_list = g_list_append(remote_remove_list,reference); 
        remove_list = g_list_remove(remove_list, remove_list->data);
    }
    
    if(all && remove_list) goto loop;
    unset_load_wait();
    local_monitor(TRUE);
    if(remove_list) make_dialog(treeview, TRUE);
    hide_stop();
    
    if (remote_location){
      gchar *rmfile;
      
      D(printf("DBG: this here creates the rm command file...\n");)
      rmfile=CreateRmTmpList(treeview);
      if (!rmfile || !remote_pass){
	      print_diagnostics("xfce/error",strerror(EACCES),NULL);
	      if (rmfile) unlink(rmfile);
      }
      else {
            D(printf("DBG: this here does the SMB delete:%s \n",rmfile);)
	    /*FIXME: if files cannot be removed, then SMBrmFile should 
	     * remove them from the remote_remove_list.
	     * */
#ifdef USE_SMB_BRANCH
	     remote_remove_list=XF_SMBrmFile (treeview,remote_location,
			     remote_pass,rmfile,
	     		     remote_remove_list);
#endif
	    
	     unlink(rmfile);
    	     print_status("xfce/info", 
		    _("Command done"), NULL);
      }
      g_free(rmfile);
    } else print_status("xfce/info", 
		    _("Command done"), NULL);
 
    D(printf("DBG:    clean up remote_remove_list...\n");)
    /* local and net files, removed from tree */
    for (tmp=remote_remove_list;tmp;tmp=tmp->next){
	remove_it(treeview,(GtkTreeRowReference *) tmp->data);
    }
    
    remote_remove_list=clear_remove_list(remote_remove_list);
    turn_on();

    return;
}

static void on_remove_yes_activate(GtkButton * button, gpointer user_data)
{
    do_the_remove(button,user_data,TRUE);
    return;
}

static void on_waste_yes_activate(GtkButton * button, gpointer user_data)
{
    do_the_remove(button,user_data,FALSE);
    return;
}

/**************/

static char dlg_result;


static void on_single_rm_no_activate(GtkButton * button, gpointer user_data)
{
    dlg_result = DLG_NO;
    close_it();
}


static void on_single_rm_yes_activate(GtkButton * button, gpointer user_data)
{
    dlg_result = DLG_YES;
    waste = FALSE;
    close_it();
}

static void on_single_waste_yes_activate(GtkButton * button, gpointer user_data)
{
    dlg_result = DLG_YES;
    waste = TRUE;
    close_it();
}

static void make_single_rm_dialog(char *nfile, char *ofile, gboolean err)
{
    gchar *mess=NULL,*mess1=NULL;
    struct stat st;
    if(tree_details->remove) assert_not_reached();
    if (!nfile) assert_not_reached();

    waste = TRUE;
    tree_details->remove = create_remove();
    gtk_window_set_position(GTK_WINDOW(tree_details->remove), 
		    GTK_WIN_POS_MOUSE);

    g_signal_connect_object(lookup_widget(tree_details->remove, "cancelbutton"), 
		    "clicked", G_CALLBACK(on_single_rm_no_activate), 
		    NULL, 0);
    g_signal_connect_object(lookup_widget(tree_details->remove, "removebutton"), 
		    "clicked", G_CALLBACK(on_single_rm_yes_activate), 
		    NULL, 0);
    g_signal_connect_object(lookup_widget(tree_details->remove, "wastebutton"), 
		    "clicked", G_CALLBACK(on_single_waste_yes_activate), 
		    NULL, 0);

    g_signal_connect_object(tree_details->remove, "delete-event", 
		    G_CALLBACK(on_destroy_event), NULL, 
		    0);
    g_signal_connect_object(tree_details->remove, "destroy-event", 
		    G_CALLBACK(on_destroy_event), NULL, 
		    0);

    /* dialog specifics */

    if(err)
    {
	hideit(tree_details->remove, "question");	
	mess1=g_strconcat(" ",_("Try again?"),"\n",NULL);
	hideit(tree_details->remove, "question");
    } else {
	hideit(tree_details->remove, "warning");
	mess1=g_strdup(" ");
    }


    /* working in a wastebasket forces unlink */
    if(ofile && strstr(ofile,"../Wastebasket"))
    {
	hideit(tree_details->remove, "wastebutton");
    }
   
    {
      GdkPixbuf	*pb;
      GtkImage *image=(GtkImage *)lookup_widget (tree_details->remove, "adicon");
      pb = icon_tell(MEDIUM, "xfce/waste_basket_full");
      if (pb) {
	gtk_image_set_from_pixbuf (image, pb);
	g_object_unref (G_OBJECT (pb));
      }
    }

    
    lstat(nfile,&st);
   
    if (ofile){
       gtk_label_set_text((GtkLabel *) 
		    lookup_widget(tree_details->remove,"label22"), 
		    _("Overwrite"));
    } else {
       gtk_label_set_text((GtkLabel *) 
		    lookup_widget(tree_details->remove,"label22"), 
		    _("Remove"));
   
    }
    
       gtk_label_set_text((GtkLabel *) 
		    lookup_widget(tree_details->remove,"label16"), 
		    _("Remove"));
   
   
    mess=g_strconcat(mess1, abreviate(nfile),"\n",
			    "(",time_to_string(st.st_mtime)," ",
			    sizetag((off_t)st.st_size, -1),")",
			    NULL); 

    gtk_label_set_text((GtkLabel *) 
		    lookup_widget(tree_details->remove,"label20"), 
		    mess);
    
    g_free(mess);mess=NULL;
    g_free(mess1);mess1=NULL;
    gtk_widget_realize(tree_details->remove);
    gtk_widget_show(tree_details->remove);

    gtk_window_set_transient_for(GTK_WINDOW(tree_details->remove), 
		    GTK_WINDOW(tree_details->window));
    hideit(tree_details->remove, "togglebutton1");
    if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"unlink")==0){
	  gtk_widget_grab_focus (lookup_widget(tree_details->remove,"removebutton"));	    
    }
    else if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"waste")==0){
	  gtk_widget_grab_focus (lookup_widget(tree_details->remove,"wastebutton"));	    
    }
    gtk_main();
    return ;

}



G_MODULE_EXPORT
int query_rm(char *nfile, char *ofile,gboolean overwrite){	 
	gboolean err=FALSE;
    	dlg_result = DLG_NO;
try_again:
 	make_single_rm_dialog( nfile, ofile, err);
	if(dlg_result == DLG_YES)
	{
	    if(waste){
		if(!wasteit(nfile)) {
		        err=TRUE;
			goto try_again;
		}
	    } else if (!overwrite){
		if (unlink(nfile)<0) {
		        err=TRUE;
			goto try_again;
		}
	    }
	    return TRUE;
	}
	return FALSE;
}



/*****    global callbacks   *****/

static void on_remove_all_toggled(GtkToggleButton * togglebutton, gpointer user_data)
{
}

G_MODULE_EXPORT
void on_remove_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    do_remove((GtkWidget *) menuitem);

}

G_MODULE_EXPORT
void tb_delete(GtkWidget * w)
{
    /*printf("tb_delete\n");*/
     do_remove((GtkWidget *) w);
}
