/*
 *
 * the file generated by glade is x_glade_support.c
 *
 * THis one is edited to add the remove_pixmap_directory routine!
 *
 * 
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>

#include <gtk/gtk.h>
#include <gmodule.h>

#include "glade_support.h"
#include <libxfcegui4/xfce-icontheme.h>
#define DEBUG

G_MODULE_EXPORT
GtkWidget*
lookup_widget                          (GtkWidget       *widget,
                                        const gchar     *widget_name)
{
  GtkWidget *parent, *found_widget;

  for (;;)
    {
      if (GTK_IS_MENU (widget))
        parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
        parent = widget->parent;
      if (!parent)
        parent = g_object_get_data (G_OBJECT (widget), "GladeParentKey");
      if (parent == NULL)
        break;
      widget = parent;
    }

  found_widget = (GtkWidget*) g_object_get_data (G_OBJECT (widget),
                                                 widget_name);
#ifdef DEBUG
  if (!found_widget){
      /* OK not to be found (created on demand only):*/
    gboolean not_ok=TRUE;
    gchar **p,*q[]={ /*NULL,*/
	"sb_new_dir","sb_new_file","sb_properties",
        "sb_unscramble","sb_scramble","sb_rename","sb_touch",
        "sb_symlink","sb_duplicate","sb_print",
	"sb_go_home","sb_go_backward","sb_go_forward","sb_go_up",
	"sb_goto_jump",NULL};
    for (p=q;*p;p++) if (strcmp(*p,widget_name)==0) {
	    not_ok=FALSE;
	    break;
    }
    if (not_ok)
    g_warning ("Widget not found: %s", widget_name);
  }
#endif

  return found_widget;
}

static GList *pixmaps_directories = NULL;

/* Use this function to set the directory containing installed pixmaps. */
G_MODULE_EXPORT
void
add_pixmap_directory                   (const gchar     *directory)
{
  pixmaps_directories = g_list_prepend (pixmaps_directories,
                                        g_strdup (directory));
}

G_MODULE_EXPORT
void
clear_pixmap_directory (void)
{
  GList *tmp;
  for(tmp=pixmaps_directories;tmp;tmp=tmp->next){
	  g_free(tmp->data);
  }
  g_list_free(pixmaps_directories);
  pixmaps_directories=NULL;
}


/* This is an internally used function to find pixmap files. */
static gchar*
find_pixmap_file                       (const gchar     *filename)
{
    XfceIconTheme *icon_theme = xfce_icon_theme_get_for_screen(NULL);

   return  xfce_icon_theme_lookup (icon_theme, filename, 48);
#if 0
  GList *elem;

  /* We step through each of the pixmaps directory to find it. */
  elem = pixmaps_directories;
  while (elem)
    {
      gchar *pathname = g_strdup_printf ("%s%s%s", (gchar*)elem->data,
                                         G_DIR_SEPARATOR_S, filename);
      if (g_file_test (pathname, G_FILE_TEST_EXISTS))
        return pathname;
      g_free (pathname);
      elem = elem->next;
    }
  return NULL;
#endif
}

/* This is an internally used function to create pixmaps. */
G_MODULE_EXPORT
GtkWidget*
create_pixmap                          (GtkWidget       *widget,
                                        const gchar     *filename)
{
  gchar *pathname = NULL;
  GtkWidget *pixmap;

  if (!filename || !filename[0])
      return gtk_image_new ();

  pathname = find_pixmap_file (filename);

  if (!pathname)
    {
      g_warning ("%s :\n %s",strerror(ENOENT), filename);
      return gtk_image_new ();
    }

  pixmap = gtk_image_new_from_file (pathname);
  g_free (pathname);
  return pixmap;
}

/* This is an internally used function to create pixmaps. */
G_MODULE_EXPORT
GdkPixbuf*
create_pixbuf                          (const gchar     *filename)
{
  gchar *pathname = NULL;
  GdkPixbuf *pixbuf;
  GError *error = NULL;

  if (!filename || !filename[0])
      return NULL;

  pathname = find_pixmap_file (filename);

  if (!pathname)
    {
      g_warning ("%s :\n %s",strerror(ENOENT), filename);
      return NULL;
    }

  pixbuf = gdk_pixbuf_new_from_file (pathname, &error);
  if (!pixbuf)
    {
      fprintf (stderr, "Failed to load pixbuf file: %s: %s\n",
               pathname, error->message);
      g_error_free (error);
    }
  g_free (pathname);
  return pixbuf;
}

/* This is used to set ATK action descriptions. */
G_MODULE_EXPORT
void
glade_set_atk_action_description       (AtkAction       *action,
                                        const gchar     *action_name,
                                        const gchar     *description)
{
  gint n_actions, i;

  n_actions = atk_action_get_n_actions (action);
  for (i = 0; i < n_actions; i++)
    {
      if (!strcmp (atk_action_get_name (action, i), action_name))
        atk_action_set_description (action, i, description);
    }
}

