/*
 * 
 * copywrite 2003-4 under GNU/GPL which means what it means.
 * Edscott Wilson Garcia 
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*#define VERBOSE_OUTPUT*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <limits.h>

#include <dirent.h>
#include <fcntl.h>
#include <signal.h>
#include <time.h>
#include <utime.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
 
#include "glade_remove_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "cpy.h"

#include "entry.h"
#include "icons.h"
#include "misc.h"
#include "monitor.h"
#include "remove.h"
#include "tubo.h"
#include "uri.h"
#include "widgets.h"

/*#define DEBUG*/

#define MAX_LINE_SIZE (_POSIX_PATH_MAX*3)
#define CHILD_FILE_LENGTH 64


G_MODULE_EXPORT
gboolean waste = TRUE;
G_MODULE_EXPORT
gboolean force_override = FALSE;
/* this *must* be thread safe, (hence _POSIX_PATH_MAX) */
G_MODULE_EXPORT
char child_file [_POSIX_PATH_MAX];
G_MODULE_EXPORT
char dlg_result;
G_MODULE_EXPORT
time_t initial;

static gint stop_watch;
static int child_mode;
static int nitems;
static long long lastsizeT;
static long long sizeT;
static int  countT;
static int child_path_number;
static FILE *plaintmpfile;
static void *rw_fork_obj;
static time_t deltatime;

static int rwStderr(int n, void *data);
static int rwStdout(int n, void *data);
static void rwForkOver(pid_t pid);
static void ChildTransfer(gpointer data);
static void set_innerloop(gboolean state);

static void close_it(void)
{
    gtk_main_quit();
    gtk_widget_destroy(tree_details->remove);
    tree_details->remove = NULL;
}

static gboolean on_destroy_event(GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
    dlg_result = DLG_CANCEL;
    close_it();
    return TRUE;
}

static void on_copy_no_activate(GtkButton * button, gpointer user_data)
{
    GtkWidget *check;
    dlg_result = DLG_NO;
    check = lookup_widget(tree_details->remove,"togglebutton1");
    force_override = gtk_toggle_button_get_active((GtkToggleButton *) check);
    if (force_override) dlg_result = DLG_CANCEL;
    close_it();
}

static void on_copy_yes_activate(GtkButton * button, gpointer user_data)
{
    GtkWidget *check;
    dlg_result = DLG_YES;
    check = lookup_widget(tree_details->remove,"togglebutton1");
    force_override = gtk_toggle_button_get_active((GtkToggleButton *) check);
	waste = FALSE;

    close_it();
}
static void on_copywaste_yes_activate(GtkButton * button, gpointer user_data)
{
    GtkWidget *check;
    dlg_result = DLG_YES;
    check = lookup_widget(tree_details->remove,"togglebutton1");
    force_override = gtk_toggle_button_get_active((GtkToggleButton *) check);
	waste = TRUE;

    close_it();
}


static int make_overwrite_dialog(char *err, char *target, char *src)
{
    gchar *mess;
    struct stat st;
    if(tree_details->remove)
	assert_not_reached();

    waste = TRUE;
    tree_details->remove = create_remove();
    gtk_window_set_position(GTK_WINDOW(tree_details->remove), GTK_WIN_POS_MOUSE);

    g_signal_connect_object(lookup_widget(tree_details->remove,"cancelbutton"), "clicked", G_CALLBACK(on_copy_no_activate), NULL, 0);
    g_signal_connect_object(lookup_widget(tree_details->remove,"removebutton"), "clicked", G_CALLBACK(on_copy_yes_activate), NULL, 0);
    g_signal_connect_object(lookup_widget(tree_details->remove,"wastebutton"), "clicked", G_CALLBACK(on_copywaste_yes_activate), NULL, 0);

    g_signal_connect_object(tree_details->remove, "delete-event", G_CALLBACK(on_destroy_event), NULL, 0);
    g_signal_connect_object(tree_details->remove, "destroy-event", G_CALLBACK(on_destroy_event), NULL, 0);

    /* dialog specifics */
   
    if(err)
    {
	char mess[_POSIX_PATH_MAX];
	sprintf(mess, _("Try again (%s)?"), err);
	gtk_label_set_text((GtkLabel *) lookup_widget(tree_details->remove,"label16"), mess);
	hideit(tree_details->remove, "question");
    }
    else
    {
	gtk_label_set_text((GtkLabel *) lookup_widget(tree_details->remove,"label16"), _("Warning"));
	hideit(tree_details->remove, "warning");
    }

    /*gtk_label_set_text((GtkLabel *) lookup_widget(tree_details->remove,"label22"), _("Overwrite"));    */

    lstat(target,&st);
    if (src){
       struct stat s_st;
       lstat(src,&s_st);
       mess=g_strdup_printf(_("Overwrite %s\n(%s %s)\n with \n%s\n(%s %s)?"),
	       abreviate(target),time_to_string(st.st_mtime),sizetag((off_t)st.st_size, -1),
	       abreviate(src),time_to_string(s_st.st_mtime),sizetag((off_t)s_st.st_size,-1));

    } else {
       mess=g_strdup_printf("%s\n(%s %s)",
	       abreviate(target),time_to_string(st.st_mtime), sizetag((off_t)st.st_size, -1)); 
    }

    gtk_label_set_text((GtkLabel *) lookup_widget(tree_details->remove,"label20"), mess);
    g_free(mess);mess=NULL;
    {
      GdkPixbuf	*pb;
      GtkImage *image=(GtkImage *)lookup_widget(tree_details->remove,"adicon");
      pb = icon_tell(MEDIUM, "xfce/waste_basket_full");
      if (pb) {
	gtk_image_set_from_pixbuf (image, pb);
	g_object_unref (G_OBJECT (pb));
      }
    }

    gtk_widget_realize(tree_details->remove);
    gtk_widget_show(tree_details->remove);
    if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"unlink")==0){
	  gtk_widget_grab_focus (lookup_widget(tree_details->remove,"removebutton"));	    
    }
    else if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"waste")==0){
	  gtk_widget_grab_focus (lookup_widget(tree_details->remove,"wastebutton"));	    
    }

    gtk_window_set_transient_for(GTK_WINDOW(tree_details->remove), 
		    GTK_WINDOW(tree_details->window));
    
    if (strstr(target,"/..Wastebasket"))    {
	hideit(tree_details->remove, "wastebutton");
    }

    gtk_main();
    return dlg_result;
}






static void get_selection(GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    tree_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en && en->path) fprintf(plaintmpfile, "%d\t%s\t%s\n", TR_COPY, en->path, en->path);
    return;
}



static gchar *mktgpath(char *target_dir, char *source)
{
    gchar *name = g_path_get_basename(source);
    gchar *target = g_build_filename(target_dir,name,NULL);
    g_free(name);
    return target;
}

static int ok_input(char *target, tree_entry_t * s_en)
{
    struct stat tgt_stat;
    /*gboolean target_exists = TRUE;*/

    if(IS_XF_FIFO(s_en->type) || IS_XF_CHR(s_en->type) || IS_XF_BLK(s_en->type) || IS_XF_SOCK(s_en->type))
    {
        print_diagnostics("xfce/error", strerror(EBADF)," : ", s_en->path, " --> ", target,"\n", NULL);
        return (DLG_CONTINUE);
    }
    
    if(stat(target, &tgt_stat) < 0) return (DLG_CONTINUE);
    
/* inode determination */
    if (tgt_stat.st_ino == s_en->st->st_ino){
	print_diagnostics("xfce/error",strerror(EEXIST)," : ", s_en->path, " --> ", target,"\n", NULL);
	return (DLG_CONTINUE);
    }
    try_again:
    dlg_result = DLG_YES;
    warn_target_exists(target, s_en->path);
    if(dlg_result == DLG_YES && waste){
	if(!wasteit(target))
	{
	    /* error message set within wasteit() */
	    goto try_again;
	}
    }
    return dlg_result;
}

#if 0
static int error_continue(char *err, char *file)
{
    if(force_override)
    {
	print_diagnostics("xfce/error", err, " : ", file, "\n", NULL);
	dlg_result = DLG_CANCEL;
    }
    else
    {
	dlg_result = DLG_CANCEL;
	make_overwrite_dialog(err, file, NULL);
    }
    return dlg_result;
}
#endif


static void ChildSetup(void){
    lastsizeT=0;
    child_path_number = 0;
    sizeT = 0;
    deltatime = 100001;
}

static void ChildFreeSources(char **sources){
    int i;
    if (sources) for (i=0;sources[i];i++) g_free(sources[i]);
    g_free(sources);
}

static char **ChildGetSources(){
    FILE *tfile;
    char *line, *source, *target;
    char **sources;
    int i,type;
    gchar *tgt=NULL;
    
#ifdef DEBUG
    /*printf("subchild, countT=%d\n",countT);*/
#endif
    if (!countT) {
#ifdef DEBUG
	fprintf(stdout,"child:Nothing to transfer!\n"); 
#endif
	_exit(123);
    }
    if ((tfile = fopen(child_file, "r"))==NULL) {
        fprintf(stdout,"child:open: %s %s\n",strerror(errno),child_file); 
	_exit(123);
    }
    if ((line = (char *)malloc(MAX_LINE_SIZE))==NULL) _exit(123);
    memset((void *)line,0,MAX_LINE_SIZE);
    
    
    sources = (char **)malloc((countT+12)*sizeof(char *));   
    for (i=0;i<countT+12;i++)sources[i] = NULL;
    i=0;
    if (child_mode & TR_MOVE) sources[i++] = "mv";
    else if(child_mode & TR_LINK) {
	sources[i++] = "ln"; 
	sources[i++] = "-s"; 
	sources[i++] = "-v"; 
	
    } else { 
	sources[i++] = "cp"; 
	sources[i++] = "-p"; 
	sources[i++] = "-R";
	/* follow symlinks on command line? */
	sources[i++] = "-H";
    }
    
    sources[i++] = "-f";
    if (tree_details->preferences & VERBOSE) {
        sources[i++] = "-v";
    }
    
#ifdef DEBUG
    /*fprintf(stdout,"dbg:reading tmp file...\n"); */
#endif
    for (;!feof(tfile) && fgets(line, MAX_LINE_SIZE - 1, tfile);i++)
    {
#ifdef DEBUG
        /*fprintf(stdout,"dbg:line is = %s\n",line); */
#endif
	type = atoi(strtok(line, "\t"));
	source = strtok(NULL, "\n");
	target = strrchr(source, '\t') + 1;
	*(strrchr(source, '\t')) = 0;
	sources[i] = g_strdup(source);
	if (!tgt) {
	    if (child_mode & TR_DUPLICATE) tgt=g_strdup(target);
	    else tgt = g_path_get_dirname(target);
	}
#ifdef DEBUG
        /*fprintf(stdout,"dbg:tgt is = %s\n",tgt); */
#endif
    }
    fclose(tfile);
    g_free(line);
    sources[i++]=tgt;
    return sources;
}

static void ChildTransfer(gpointer data)
{
    char **arg;
    	
    ChildSetup();   


    /* child */
#ifdef DEBUG
    /*printf("child: grandchild continues\n");*/
#endif
    arg = ChildGetSources();
           

#if 0
#ifdef DEBUG
    {
    int j;
    fprintf(stdout, "child:OjO \n");
    for(j=0;arg[j];j++) fprintf(stdout, "child:> %s\n",arg[j]);
    /*fprintf(stdout, "\n");*/
    fflush(NULL);
    }
#endif
#endif
    

    execvp(arg[0],arg);
    
    printf("child:error on execvp()!\n");  
    ChildFreeSources(arg);
    _exit(123);
}

/* function to clean up the mess after child process
 * has been sent a SIGTERM. (Might a unlink target be 
 * good here?)
 * */
static void cpyForkCleanup(void)
{
    /* break inner gtk_main() loop */
#ifdef DEBUG
    fprintf(stderr,"dbg:call to innerloop from forkcleanup\n"); 
#endif
    set_innerloop(FALSE);
    /* unlink(fork_target); */
}

static gint watch_stop(gpointer data)
{
    time_t current=time(NULL);
    if (current - initial != deltatime) {
	gchar *g;
	deltatime = current - initial;
	g=g_strdup_printf("cp/mv %ld %s",(long)(deltatime),_("seconds"));
	print_status("xfce/warning",g,NULL);
	g_free(g);
    }
    if (!rw_fork_obj) return FALSE;
    if(tree_details->stop)
    {
	print_status("xfce/error",strerror(ECANCELLED),NULL);
	tree_details->stop = FALSE;
	hide_stop();
	cursor_reset();
	rw_fork_obj = TuboCancel(rw_fork_obj, cpyForkCleanup);
	return FALSE;
    }
    set_progress( -1, -1);
    return TRUE;
}

static void set_innerloop(gboolean state)
{
    static gboolean innerloop = FALSE;
    if(state == innerloop)
	return;
    innerloop = state;
    /*fprintf(stderr,"dbg:innerloop %s\n",(state)?"started":"terminated");fflush(NULL); */
    if(state){
	stop_watch = g_timeout_add_full(0,260, (GtkFunction) watch_stop, NULL,NULL);
       	gtk_main();
    }
    else {
	g_source_remove(stop_watch);
	gtk_main_quit();
    }
}

/* function to process stderr produced by child */
static int rwStderr(int n, void *data)
{
    char *line;

    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
#ifdef DEBUG
    fprintf(stderr, "child stderr:%s\n", line);
#endif
    if (strlen(line)==0 || line[0]=='\n') return TRUE;
    print_diagnostics("xfce/error", line, NULL);
    process_pending_gtk();
    return TRUE;
}


/* function to process stdout produced by child */
static int rwStdout(int n, void *data)
{
    char *line, *texto;

    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;


#ifdef DEBUG
    printf("dbg(rwStdout):%s",line);fflush(NULL); 
#endif

    /* only process child specific lines: */
    if(!strncmp(line, "child:", strlen("child:")) == 0)
    {
	if (strlen(line)==0 || line[0]=='\n') return TRUE;
	print_diagnostics("xfce/info", line, NULL);
	process_pending_gtk();
	return TRUE;
    }

    /* anything else is a process_error() and operation
     * should continue with a diagnostics message.  */
    strtok(line, ":");
    texto = strtok(NULL, "\n");
    print_diagnostics("xfce/warning", texto, "\n", NULL);
    process_pending_gtk();


    return TRUE;
}

/* function called when child is dead */
static void rwForkOver(pid_t pid)
{
    char secs[1024];
    rw_fork_obj = NULL;
#ifdef DEBUG
    fprintf(stderr,"dbg: call to innerloop from forkover()\n");fflush(NULL); 
#endif
    set_innerloop(FALSE);
    set_progress(-1, -1);
    sprintf(secs, _("Finished (%d/%d) : %ld seconds"), nitems, countT, (long)(time(NULL) - initial));
    print_status("xfce/info", secs, NULL);
    hide_stop();
    cursor_reset();
    tree_details->stop = FALSE;
}


/*****************************************************************************/
/**********************     exported symbols     *****************************/
/*****************************************************************************/


G_MODULE_EXPORT
gchar *PlainTmpList (GtkTreeView *treeview,GtkTreeSelection *selection)
{
    gchar *fname = randomTmpName(NULL);

    D(printf("DBG: fname=%s\n",(fname)?fname:"null");)
    if(!fname) return NULL;
    
    if((plaintmpfile = fopen(fname, "w")) == NULL){
    	D(printf("DBG: cannot open %s for write\n",(fname)?fname:"null");)
	g_free(fname);
	return NULL;
    }
    gtk_tree_selection_selected_foreach(selection, get_selection, (gpointer) treeview);
    /*    fprintf(tmpfile, "%d\t%s\t%s\n", TR_COPY, src, tgt);*/
    fclose(plaintmpfile);
    return fname;
}

G_MODULE_EXPORT
gchar *SimpleTmpList (char *tgt, char *src)
{
    gchar *fname = randomTmpName(NULL);
    FILE *tmpfile;

    D(printf("DBG: fname=%s\n",(fname)?fname:"null");)
    if(!fname) return NULL;
    
    if((tmpfile = fopen(fname, "w")) == NULL){
    	D(printf("DBG: cannot open %s for write\n",(fname)?fname:"null");)
	return NULL;
    }
    fprintf(tmpfile, "%d\t%s\t%s\n", TR_DUPLICATE, src, tgt);
    fclose(tmpfile);
    countT = nitems = 1;
    return fname;
}
G_MODULE_EXPORT
int warn_target_exists (char *target, char *src)
{
    if(force_override)
    {
	if(!waste){ 
	   return DLG_WASTE;
	} else return DLG_YES;
    }
    else
    {
	dlg_result = DLG_CANCEL;
	make_overwrite_dialog(NULL, target, src);
    }
    if (waste && dlg_result==DLG_YES) return DLG_WASTE;
    return dlg_result;
}

G_MODULE_EXPORT
char *CreateTmpList (GList * list, tree_entry_t * t_en)
{
    char *target = NULL;
    FILE *tmpfile;
    uri *u;
    static char *fname = NULL;
    tree_entry_t *s_en;

    countT = nitems = 0;
    if((fname = randomTmpName(NULL)) == NULL) return NULL;
    if((tmpfile = fopen(fname, "w")) == NULL) {
	g_free(fname);
	return NULL;
    }
    force_override = FALSE;
    for(; list != NULL; list = list->next)
    {
	int type = 0;
	SET_LOCAL_TYPE(type);
	u = list->data;
	s_en = stat_entry(u->url, type);
	/* entry new has stated path by now */
	if(!s_en) {
#ifdef DEBUG
	    fprintf(stderr,"DBG: ***warning*** s_en is NULL!\n"); 
#endif
	    continue;
	}

	target = mktgpath(t_en->path, s_en->path);
#ifdef DEBUG
	printf("DBG: target=%s\n",t_en->path);
#endif


	switch (ok_input(target, s_en))
	{
	    case DLG_NO:
		print_diagnostics(NULL, _("Omitting"), " :\n", s_en->path, "\n", NULL);
		nitems++;
		break;
	    case DLG_CANCEL:	/* dnd cancelled */
		print_diagnostics("xfce/warning", strerror(ECANCELLED), "\n", NULL);
	    case DLG_CANCEL_QUIET:	/* AUTOMATIC */
		destroy_entry(s_en);
		fclose(tmpfile);
		unlink(fname);
		g_free(target); target=NULL;
		return NULL;
	    case DLG_YES:
	    case DLG_CONTINUE:
	    default:
		nitems++;
		fprintf(tmpfile, "%d\t%s\t%s\n", u->type, s_en->path, target);
		break;
	}
	destroy_entry(s_en);
    }
    g_free(target); 
    fclose(tmpfile);
    if(!nitems)
    {
	unlink(fname);
	return NULL;
    }
    countT = nitems;
#ifdef DEBUG
    printf("tmp file is %s\n",fname);
#endif
    return fname;
}


G_MODULE_EXPORT
gboolean IndirectTransfer (int mode, char *tmpfile)
{

    if(CHILD_FILE_LENGTH < strlen(tmpfile) + 1) {
	printf("IndirectTransfer(): CHILD_FILE_LENGTH < strlen(tmpfile)\n");
	assert_not_reached();
    }
    strncpy(child_file, tmpfile, CHILD_FILE_LENGTH);
    child_file[CHILD_FILE_LENGTH - 1] = (char)0;

    child_mode = mode;


#ifdef DEBUG
    fprintf(stderr,"dbg:Total files to copy/move = %d\n",countT); 
    fprintf(stderr,"dbg:childfile is = %s\n",child_file); 
#endif

    initial = time(NULL);
    show_stop();
    cursor_wait();

    rw_fork_obj = Tubo(ChildTransfer, NULL, rwForkOver, NULL, rwStdout, rwStderr,0,FALSE);

    /* only parent continues from here */
#ifdef DEBUG
    fprintf(stderr,"dbg:call to innerloop from IndirectTransfer()\n"); 
#endif
    set_innerloop(TRUE);

    set_progress(countT, countT);

    return TRUE;
}



/**********************************************************************/

